/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.Cursor;
import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.CommonUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.results.ProfilingResultsDispatcher;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.coderegion.CodeRegionResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.CPUCCTProvider;
import org.netbeans.lib.profiler.results.cpu.CPUResultsDiff;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.MemoryCCTProvider;
import org.netbeans.lib.profiler.results.memory.SampledMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.SampledMemoryResultsSnapshot;
import org.netbeans.lib.profiler.ui.swing.ExportUtils;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ResultsListener;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.SnapshotsListener;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilerStorage;
import org.netbeans.modules.profiler.utilities.ProfilerUtils;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.windows.WindowManager;

public final class ResultsManager {
    private static final Logger LOGGER = Logger.getLogger(ResultsManager.class.getName());
    public static final String SNAPSHOT_EXTENSION = "nps";
    public static final String HEAPDUMP_EXTENSION = "hprof";
    public static final String STACKTRACES_SNAPSHOT_EXTENSION = "npss";
    static final String HEAPDUMP_PREFIX = "heapdump-";
    private static final String SNAPSHOT_PREFIX = "snapshot-";
    private static final long MINIMAL_TIMESTAMP = 946684800000L;
    private ArrayList<LoadedSnapshot> loadedSnapshots = new ArrayList();
    private File exportDir;
    private HashMap<FileObject, ProfilingSettings> settingsCache = new HashMap();
    private HashMap<FileObject, Integer> typeCache = new HashMap();
    private Window mainWindow;
    private boolean resultsAvailable = false;
    private Lookup.Result<SnapshotsListener> snapshotListeners;
    private Lookup.Result<ResultsListener> resultsListeners;
    private static final String HPROF_HEADER = "JAVA PROFILE 1.0";
    private static final long MIN_HPROF_SIZE = 0x100000L;

    private ResultsManager() {
        Lookup l = Lookup.getDefault();
        this.snapshotListeners = l.lookupResult(SnapshotsListener.class);
        this.resultsListeners = l.lookupResult(ResultsListener.class);
    }

    public static ResultsManager getDefault() {
        return Singleton.INSTANCE;
    }

    public String getDefaultSnapshotFileName(LoadedSnapshot ls) {
        return SNAPSHOT_PREFIX + ls.getSnapshot().getTimeTaken();
    }

    public String getSnapshotDisplayName(LoadedSnapshot ls) {
        String name;
        String string = name = ls.getFile() == null ? null : ls.getFile().getName();
        if (name == null) {
            name = this.getDefaultSnapshotFileName(ls);
        } else {
            int dotIndex = name.lastIndexOf(46);
            if (dotIndex > 0 && dotIndex <= name.length() - 2) {
                name = name.substring(0, dotIndex);
            }
        }
        return this.getSnapshotDisplayName(name, ls.getType());
    }

    public String getSnapshotDisplayName(String fileName, int snapshotType) {
        String displayName;
        block5: {
            if (fileName.startsWith(SNAPSHOT_PREFIX)) {
                String time = fileName.substring(SNAPSHOT_PREFIX.length(), fileName.length());
                try {
                    long timeStamp = Long.parseLong(time);
                    if (timeStamp > 946684800000L) {
                        displayName = StringUtils.formatUserDate((Date)new Date(timeStamp));
                        break block5;
                    }
                    displayName = fileName;
                }
                catch (NumberFormatException e) {
                    displayName = fileName;
                }
            } else {
                displayName = fileName;
            }
        }
        return displayName;
    }

    public String getDefaultHeapDumpFileName(long time) {
        return HEAPDUMP_PREFIX + time;
    }

    public String getHeapDumpDisplayName(String fileName) {
        String displayName;
        block5: {
            if (fileName.startsWith(HEAPDUMP_PREFIX)) {
                String time = fileName.substring(HEAPDUMP_PREFIX.length(), fileName.length());
                try {
                    long timeStamp = Long.parseLong(time);
                    if (timeStamp > 946684800000L) {
                        displayName = StringUtils.formatUserDate((Date)new Date(timeStamp));
                        break block5;
                    }
                    displayName = fileName;
                }
                catch (NumberFormatException e) {
                    displayName = fileName;
                }
            } else {
                displayName = fileName;
            }
        }
        return displayName;
    }

    public LoadedSnapshot[] getLoadedSnapshots() {
        return this.loadedSnapshots.toArray(new LoadedSnapshot[0]);
    }

    public LoadedSnapshot getSnapshotFromFileObject(FileObject fo) {
        LoadedSnapshot ls = this.findAlreadyLoadedSnapshot(fo);
        if (ls != null) {
            return ls;
        }
        try {
            return this.loadSnapshotFromFileObject(fo);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, null, e);
            return null;
        }
    }

    public ProfilingSettings getSnapshotSettings(FileObject fo) {
        ProfilingSettings settings = this.settingsCache.get(fo);
        if (settings == null && !this.settingsCache.containsKey(fo)) {
            settings = this.readSettingsFromFile(fo);
            this.settingsCache.put(fo, settings);
        }
        return settings;
    }

    public int getSnapshotType(FileObject fo) {
        Integer type = this.typeCache.get(fo);
        if (type == null) {
            type = this.readTypeFromFile(fo);
            this.typeCache.put(fo, type);
        }
        return type;
    }

    public void closeSnapshot(LoadedSnapshot ls) {
        if (ls != null) {
            this.loadedSnapshots.remove(ls);
            this.fireSnapshotRemoved(ls);
        }
    }

    public void compareSnapshots(FileObject snapshot1FO, FileObject snapshot2FO) {
        LoadedSnapshot s1 = null;
        LoadedSnapshot s2 = null;
        FileObject snapshotFO = snapshot1FO;
        try {
            s1 = this.findAlreadyLoadedSnapshot(snapshot1FO);
            if (s1 == null) {
                s1 = this.loadSnapshotImpl(snapshot1FO);
            }
            snapshotFO = snapshot2FO;
            s2 = this.findAlreadyLoadedSnapshot(snapshot2FO);
            if (s2 == null) {
                s2 = this.loadSnapshotFromFileObject(snapshot2FO);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, Bundle.ResultsManager_SnapshotLoadFailed(snapshotFO.getPath()), e);
            ProfilerDialogs.displayError((String)Bundle.ResultsManager_SnapshotLoadFailedMsg(snapshotFO.getNameExt(), e.getMessage()));
            return;
        }
        if (s1 != null && s2 != null) {
            this.compareSnapshots(s1, s2);
        } else {
            ProfilerDialogs.displayError((String)Bundle.ResultsManager_SnapshotsLoadFailedMsg());
        }
    }

    public ResultsSnapshot createDiffSnapshot(LoadedSnapshot s1, LoadedSnapshot s2) {
        ResultsSnapshot snap1 = s1.getSnapshot();
        ResultsSnapshot snap2 = s2.getSnapshot();
        CPUResultsDiff diff = null;
        if (snap1 instanceof SampledMemoryResultsSnapshot && snap2 instanceof SampledMemoryResultsSnapshot) {
            SampledMemoryResultsSnapshot sn1 = (SampledMemoryResultsSnapshot)snap1;
            SampledMemoryResultsSnapshot sn2 = (SampledMemoryResultsSnapshot)snap2;
            ResultsManager.checkObjectSizes(sn1.getClassNames(), sn1.getObjectsCounts(), sn1.getObjectsSizePerClass(), 1, sn2.getClassNames(), sn2.getObjectsCounts(), sn2.getObjectsSizePerClass(), 1);
            diff = new SampledMemoryResultsDiff((SampledMemoryResultsSnapshot)snap1, (SampledMemoryResultsSnapshot)snap2);
        } else if (snap1 instanceof AllocMemoryResultsSnapshot && snap2 instanceof AllocMemoryResultsSnapshot) {
            AllocMemoryResultsSnapshot sn1 = (AllocMemoryResultsSnapshot)snap1;
            AllocMemoryResultsSnapshot sn2 = (AllocMemoryResultsSnapshot)snap2;
            ResultsManager.checkObjectSizes(sn1.getClassNames(), sn1.getObjectsCounts(), sn1.getObjectsSizePerClass(), Integer.MAX_VALUE, sn2.getClassNames(), sn2.getObjectsCounts(), sn2.getObjectsSizePerClass(), Integer.MAX_VALUE);
            diff = new AllocMemoryResultsDiff((AllocMemoryResultsSnapshot)snap1, (AllocMemoryResultsSnapshot)snap2);
        } else if (snap1 instanceof LivenessMemoryResultsSnapshot && snap2 instanceof LivenessMemoryResultsSnapshot) {
            LivenessMemoryResultsSnapshot sn1 = (LivenessMemoryResultsSnapshot)snap1;
            LivenessMemoryResultsSnapshot sn2 = (LivenessMemoryResultsSnapshot)snap2;
            ResultsManager.checkObjectSizes(sn1.getClassNames(), sn1.getNTrackedLiveObjects(), sn1.getTrackedLiveObjectsSize(), 1, sn2.getClassNames(), sn2.getNTrackedLiveObjects(), sn2.getTrackedLiveObjectsSize(), 1);
            diff = new LivenessMemoryResultsDiff((LivenessMemoryResultsSnapshot)snap1, (LivenessMemoryResultsSnapshot)snap2);
        } else if (snap1 instanceof CPUResultsSnapshot && snap2 instanceof CPUResultsSnapshot) {
            diff = new CPUResultsDiff((CPUResultsSnapshot)snap1, (CPUResultsSnapshot)snap2);
        }
        return diff;
    }

    public void compareSnapshots(final LoadedSnapshot s1, final LoadedSnapshot s2) {
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                SnapshotResultsWindow srw = SnapshotResultsWindow.get(s1, 0, false);
                if (!srw.setRefSnapshot(s2)) {
                    ProfilerDialogs.displayError((String)Bundle.ResultsManager_CannotCompareSnapshotsMsg(s1.getFile().getName(), s2.getFile().getName()));
                } else {
                    srw.open();
                    srw.requestActive();
                }
            }
        });
    }

    static void checkObjectSizes(String[] names1, int[] counts1, long[] sizes1, int n1, String[] names2, int[] counts2, long[] sizes2, int n2) {
        long objsize2;
        String obj1 = "java.lang.Object";
        String obj2 = "java/lang/Object";
        int idx1 = -1;
        for (int i = 0; i < names1.length; ++i) {
            if (!obj1.equals(names1[i]) && !obj2.equals(names1[i])) continue;
            idx1 = i;
            break;
        }
        if (idx1 == -1 || counts1[idx1] == 0) {
            return;
        }
        int idx2 = -1;
        for (int i = 0; i < names2.length; ++i) {
            if (!obj1.equals(names2[i]) && !obj2.equals(names2[i])) continue;
            idx2 = i;
            break;
        }
        if (idx2 == -1 || counts2[idx2] == 0) {
            return;
        }
        long objsize1 = n1 == 1 ? sizes1[idx1] / (long)counts1[idx1] : 0L;
        long l = objsize2 = n2 == 1 ? sizes2[idx2] / (long)counts2[idx2] : 0L;
        if (objsize1 != objsize2) {
            ProfilerDialogs.displayWarningDNSA((String)Bundle.ResultsManager_DifferentObjectSize(), (String)Bundle.ResultsManager_CaptionWarning(), null, (String)"ResultsManager.checkObjectSizes", (boolean)false);
        }
    }

    public void deleteSnapshot(FileObject snapshotFile) {
        LoadedSnapshot ls = this.findLoadedSnapshot(FileUtil.toFile((FileObject)snapshotFile));
        try {
            snapshotFile.delete();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, Bundle.ResultsManager_SnapshotDeleteFailedMsg(e.getMessage()), e);
            return;
        }
        if (ls != null) {
            this.loadedSnapshots.remove(ls);
            this.fireSnapshotRemoved(ls);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void exportSnapshots(final FileObject[] selectedSnapshots) {
        assert (selectedSnapshots != null);
        assert (selectedSnapshots.length > 0);
        final String[] fileName = new String[1];
        final String[] fileExt = new String[1];
        final FileObject[] dir = new FileObject[1];
        if (selectedSnapshots.length == 1) {
            SelectedFile sf = this.selectSnapshotTargetFile(selectedSnapshots[0].getName(), selectedSnapshots[0].getExt().equals(HEAPDUMP_EXTENSION));
            if (sf == null || !this.checkFileExists(sf)) return;
            fileName[0] = sf.fileName;
            fileExt[0] = sf.fileExt;
            dir[0] = sf.folder;
        } else {
            JFileChooser chooser = new JFileChooser();
            if (this.exportDir != null) {
                chooser.setCurrentDirectory(this.exportDir);
            }
            chooser.setDialogTitle(Bundle.ResultsManager_SelectDirDialogCaption());
            chooser.setApproveButtonText(Bundle.ResultsManager_SaveButtonName());
            chooser.setFileSelectionMode(1);
            chooser.setMultiSelectionEnabled(false);
            if (chooser.showSaveDialog(WindowManager.getDefault().getMainWindow()) != 0) return;
            File file = chooser.getSelectedFile();
            if (!file.exists()) {
                if (!ProfilerDialogs.displayConfirmation((String)Bundle.ResultsManager_DirectoryDoesntExistMsg(), (String)Bundle.ResultsManager_DirectoryDoesntExistCaption())) {
                    return;
                }
                file.mkdir();
            }
            this.exportDir = file;
            dir[0] = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        }
        final ProgressHandle ph = ProgressHandle.createHandle((String)Bundle.MSG_SavingSnapshots());
        ph.setInitialDelay(500);
        ph.start();
        ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    for (int i = 0; i < selectedSnapshots.length; ++i) {
                        ResultsManager.this.exportSnapshot(selectedSnapshots[i], dir[0], fileName[0] != null ? fileName[0] : selectedSnapshots[i].getName(), fileExt[0] != null ? fileExt[0] : selectedSnapshots[i].getExt());
                    }
                }
                finally {
                    ph.finish();
                }
            }
        });
    }

    public LoadedSnapshot findLoadedSnapshot(ResultsSnapshot snapshot) {
        for (LoadedSnapshot ls : this.loadedSnapshots) {
            if (ls.getSnapshot() != snapshot) continue;
            return ls;
        }
        return null;
    }

    public LoadedSnapshot findLoadedSnapshot(File snapshotFile) {
        for (LoadedSnapshot ls : this.loadedSnapshots) {
            if (ls.getFile() == null || !ls.getFile().equals(snapshotFile)) continue;
            return ls;
        }
        return null;
    }

    public static boolean checkHprofFile(File file) {
        try {
            if (file.isFile() && file.canRead() && file.length() > 0x100000L) {
                byte[] prefix = new byte[HPROF_HEADER.length() + 4];
                RandomAccessFile raf = new RandomAccessFile(file, "r");
                raf.readFully(prefix);
                raf.close();
                if (new String(prefix).startsWith(HPROF_HEADER)) {
                    return true;
                }
            }
        }
        catch (FileNotFoundException ex) {
            return false;
        }
        catch (IOException ex) {
            return false;
        }
        return false;
    }

    public FileObject[] listSavedHeapdumps(Lookup.Provider project, File directory) {
        try {
            FileObject snapshotsFolder = null;
            snapshotsFolder = project == null && directory != null ? FileUtil.toFileObject((File)directory) : ProfilerStorage.getProjectFolder((Lookup.Provider)project, (boolean)false);
            if (snapshotsFolder == null) {
                return new FileObject[0];
            }
            snapshotsFolder.refresh();
            FileObject[] children = snapshotsFolder.getChildren();
            ArrayList<FileObject> files = new ArrayList<FileObject>();
            for (int i = 0; i < children.length; ++i) {
                FileObject child = children[i];
                if (!ResultsManager.checkHprofFile(FileUtil.toFile((FileObject)children[i]))) continue;
                files.add(child);
            }
            Collections.sort(files, new Comparator(){

                public int compare(Object o1, Object o2) {
                    FileObject f1 = (FileObject)o1;
                    FileObject f2 = (FileObject)o2;
                    return f1.getName().compareTo(f2.getName());
                }
            });
            FileObject[] ret = new FileObject[files.size()];
            files.toArray(ret);
            return ret;
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, Bundle.ResultsManager_ObtainSavedSnapshotsFailedMsg(e.getMessage()), e);
            return new FileObject[0];
        }
    }

    public FileObject[] listSavedSnapshots(Lookup.Provider project, File directory) {
        try {
            FileObject snapshotsFolder = null;
            snapshotsFolder = project == null && directory != null ? FileUtil.toFileObject((File)directory) : ProfilerStorage.getProjectFolder((Lookup.Provider)project, (boolean)false);
            if (snapshotsFolder == null) {
                return new FileObject[0];
            }
            snapshotsFolder.refresh();
            FileObject[] children = snapshotsFolder.getChildren();
            ArrayList<FileObject> files = new ArrayList<FileObject>();
            for (int i = 0; i < children.length; ++i) {
                FileObject child = children[i];
                if (!child.getExt().equalsIgnoreCase(SNAPSHOT_EXTENSION)) continue;
                files.add(child);
            }
            Collections.sort(files, new Comparator(){

                public int compare(Object o1, Object o2) {
                    FileObject f1 = (FileObject)o1;
                    FileObject f2 = (FileObject)o2;
                    return f1.getName().compareTo(f2.getName());
                }
            });
            FileObject[] ret = new FileObject[files.size()];
            files.toArray(ret);
            return ret;
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, Bundle.ResultsManager_ObtainSavedSnapshotsFailedMsg(e.getMessage()), e);
            return new FileObject[0];
        }
    }

    public boolean hasSnapshotsFor(Lookup.Provider project) {
        try {
            FileObject[] children;
            FileObject snapshotsFolder = ProfilerStorage.getProjectFolder((Lookup.Provider)project, (boolean)false);
            if (snapshotsFolder == null) {
                return false;
            }
            snapshotsFolder.refresh();
            for (FileObject child : children = snapshotsFolder.getChildren()) {
                if (child.getExt().equalsIgnoreCase(SNAPSHOT_EXTENSION)) {
                    return true;
                }
                if (!ResultsManager.checkHprofFile(FileUtil.toFile((FileObject)child))) continue;
                return true;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, Bundle.ResultsManager_ObtainSavedSnapshotsFailedMsg(e.getMessage()), e);
        }
        return false;
    }

    public int getSnapshotsCountFor(Lookup.Provider project) {
        int count = 0;
        try {
            FileObject[] children;
            FileObject snapshotsFolder = ProfilerStorage.getProjectFolder((Lookup.Provider)project, (boolean)false);
            if (snapshotsFolder == null) {
                return count;
            }
            snapshotsFolder.refresh();
            for (FileObject child : children = snapshotsFolder.getChildren()) {
                if (!child.getExt().equalsIgnoreCase(SNAPSHOT_EXTENSION) && !ResultsManager.checkHprofFile(FileUtil.toFile((FileObject)child))) continue;
                ++count;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, Bundle.ResultsManager_ObtainSavedSnapshotsFailedMsg(e.getMessage()), e);
        }
        return count;
    }

    public LoadedSnapshot loadSnapshot(FileObject selectedFile) {
        try {
            return this.loadSnapshotImpl(selectedFile);
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, Bundle.ResultsManager_SnapshotLoadFailed(selectedFile.getPath()), e);
            ProfilerDialogs.displayError((String)Bundle.ResultsManager_SnapshotLoadFailedMsg(selectedFile.getNameExt(), e.getMessage()));
            return null;
        }
    }

    public LoadedSnapshot[] loadSnapshots(FileObject[] selectedFiles) {
        LoadedSnapshot[] ret = new LoadedSnapshot[selectedFiles.length];
        for (int i = 0; i < selectedFiles.length; ++i) {
            try {
                if (selectedFiles[i] == null) continue;
                ret[i] = this.loadSnapshotImpl(selectedFiles[i]);
                continue;
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, Bundle.ResultsManager_SnapshotLoadFailed(selectedFiles[i].getPath()), e);
                ProfilerDialogs.displayError((String)Bundle.ResultsManager_SnapshotLoadFailedMsg(selectedFiles[i].getNameExt(), e.getMessage()));
            }
        }
        return ret;
    }

    public void openSnapshot(File snapshot) {
        File sf = FileUtil.normalizeFile((File)snapshot);
        FileObject snapshotFo = FileUtil.toFileObject((File)sf);
        this.openSnapshot(snapshotFo);
    }

    public void openSnapshot(FileObject snapshotFo) {
        try {
            DataObject snapshotDo = DataObject.find((FileObject)snapshotFo);
            OpenCookie open = (OpenCookie)snapshotDo.getCookie(OpenCookie.class);
            if (open != null) {
                open.open();
            }
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void openSnapshot(LoadedSnapshot ls) {
        this.openSnapshot(ls, -1, false);
    }

    public void openSnapshot(final LoadedSnapshot ls, final int sortingColumn, final boolean sortingOrder) {
        if (ls == null) {
            ProfilerDialogs.displayError((String)Bundle.ResultsManager_CannotOpenSnapshotMsg());
        } else {
            CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    SnapshotResultsWindow srw = SnapshotResultsWindow.get(ls, sortingColumn, sortingOrder);
                    srw.open();
                    srw.requestActive();
                }
            });
        }
    }

    public void openSnapshots(LoadedSnapshot[] loaded) {
        LoadedSnapshot loadedSnapshot = null;
        try {
            SnapshotResultsWindow srw = null;
            for (int i = 0; i < loaded.length; ++i) {
                loadedSnapshot = loaded[i];
                if (loaded[i] == null) continue;
                srw = SnapshotResultsWindow.get(loadedSnapshot);
                srw.open();
            }
            if (srw != null) {
                srw.requestActive();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, Bundle.ResultsManager_SnapshotLoadFailed(loadedSnapshot.getFile().getAbsoluteFile()), e);
            ProfilerDialogs.displayError((String)Bundle.ResultsManager_SnapshotLoadFailedMsg(loadedSnapshot.getFile().getName(), e.getMessage()));
        }
    }

    public LoadedSnapshot prepareSnapshot() {
        return this.prepareSnapshot(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoadedSnapshot prepareSnapshot(boolean reqeustData) {
        CodeRegionResultsSnapshot snapshot = null;
        if (!this.resultsAvailable()) {
            return null;
        }
        try {
            TargetAppRunner runner = Profiler.getDefault().getTargetAppRunner();
            ProfilerClient client = runner.getProfilerClient();
            int currentInstrType = client.getCurrentInstrType();
            try {
                switch (currentInstrType) {
                    case 5: 
                    case 6: 
                    case 7: {
                        snapshot = client.getMemoryProfilingResultsSnapshot(reqeustData);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        snapshot = client.getCPUProfilingResultsSnapshot(reqeustData);
                        break;
                    }
                    case 1: {
                        snapshot = client.getCodeRegionProfilingResultsSnapshot();
                    }
                }
            }
            catch (ClientUtils.TargetAppOrVMTerminated e1) {
                ProfilerDialogs.displayWarning((String)Bundle.ResultsManager_ProfiledAppTerminatedMsg());
                ProfilerLogger.log((String)e1.getMessage());
            }
            catch (CPUResultsSnapshot.NoDataAvailableException e2) {
                LOGGER.log(Level.SEVERE, Bundle.ResultsManager_DataNotAvailableMsg(), e2);
            }
            catch (OutOfMemoryError e) {
                try {
                    this.reset();
                    runner.resetTimers();
                }
                catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                    client.resetClientData();
                }
                LOGGER.log(Level.SEVERE, Bundle.ResultsManager_OutOfMemoryMsg(), e);
            }
        }
        finally {
            if (snapshot != null) {
                ProfilingSettings settings = new ProfilingSettings();
                Profiler.getDefault().getLastProfilingSettings().copySettingsInto(settings);
                settings.setSettingsName(Profiler.getDefault().getLastProfilingSettings().getSettingsName());
                Lookup.Provider profiledProject = NetBeansProfiler.getDefaultNB().getProfiledProject();
                return new LoadedSnapshot((ResultsSnapshot)snapshot, settings, null, profiledProject);
            }
        }
        return null;
    }

    public void reset() {
        ProfilingResultsDispatcher.getDefault().reset();
        this.resultsReset();
    }

    public boolean resultsAvailable() {
        return this.resultsAvailable;
    }

    public ExportUtils.Exportable createSnapshotExporter(final LoadedSnapshot snapshot) {
        return this.createSnapshotExporter(new SnapshotHandle(){

            @Override
            public LoadedSnapshot getSnapshot() {
                return snapshot;
            }
        });
    }

    public ExportUtils.Exportable createSnapshotExporter(final SnapshotHandle handle) {
        return new ExportUtils.Exportable(){

            public String getName() {
                return Bundle.ResultsManager_ExportSnapshotData();
            }

            public boolean isEnabled() {
                return true;
            }

            public ExportUtils.ExportProvider[] getProviders() {
                final LoadedSnapshot snapshot = handle.getSnapshot();
                return new ExportUtils.ExportProvider[]{new ExportUtils.AbstractNPSExportProvider(snapshot.getFile()){

                    protected void doExport(File targetFile) {
                        ResultsManager.this.exportSnapshot(snapshot, targetFile);
                    }
                }};
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exportSnapshot(LoadedSnapshot snapshot, File targetFile) {
        File sourceFile = snapshot.getFile();
        if (sourceFile != null) {
            try {
                Files.copy(sourceFile.toPath(), targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                return true;
            }
            catch (Throwable t) {
                LOGGER.log(Level.INFO, t.getMessage(), t);
                String msg = t.getLocalizedMessage().replace("<", "&lt;").replace(">", "&gt;");
                ProfilerDialogs.displayError((String)Bundle.ResultsManager_SnapshotExportFailedMsg(msg));
                return false;
            }
        }
        FileLock lock = null;
        FileObject target = null;
        FilterOutputStream dos = null;
        try {
            targetFile = FileUtil.normalizeFile((File)targetFile);
            target = targetFile.isFile() ? FileUtil.toFileObject((File)targetFile) : FileUtil.createData((File)targetFile);
            lock = target.lock();
            OutputStream os = target.getOutputStream(lock);
            BufferedOutputStream bos = new BufferedOutputStream(os);
            dos = new DataOutputStream(bos);
            snapshot.save((DataOutputStream)dos);
            dos.close();
        }
        catch (IOException e) {
            try {
                if (dos != null) {
                    dos.close();
                }
                if (lock != null) {
                    target.delete(lock);
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            ProfilerDialogs.displayError((String)Bundle.ResultsManager_SnapshotSaveFailedMsg(e.getMessage()));
            boolean e2 = false;
            return e2;
        }
        catch (OutOfMemoryError e) {
            try {
                if (dos != null) {
                    dos.close();
                }
                if (lock != null) {
                    target.delete(lock);
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            ProfilerDialogs.displayError((String)Bundle.ResultsManager_OutOfMemorySavingMsg());
            boolean bl = false;
            return bl;
        }
        finally {
            if (lock != null) {
                lock.releaseLock();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveSnapshot(LoadedSnapshot snapshot, FileObject profFile) {
        FileLock lock = null;
        FilterOutputStream dos = null;
        boolean isSaved = snapshot.isSaved();
        snapshot.setSaved(true);
        try {
            lock = profFile.lock();
            OutputStream os = profFile.getOutputStream(lock);
            BufferedOutputStream bos = new BufferedOutputStream(os);
            dos = new DataOutputStream(bos);
            snapshot.save((DataOutputStream)dos);
            dos.close();
            snapshot.setFile(FileUtil.toFile((FileObject)profFile));
            snapshot.setSaved(true);
            this.fireSnapshotSaved(snapshot);
        }
        catch (IOException e) {
            snapshot.setSaved(isSaved);
            try {
                if (dos != null) {
                    dos.close();
                }
                if (lock != null) {
                    profFile.delete(lock);
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            ProfilerDialogs.displayError((String)Bundle.ResultsManager_SnapshotSaveFailedMsg(e.getMessage()));
            boolean e2 = false;
            return e2;
        }
        catch (OutOfMemoryError e) {
            snapshot.setSaved(isSaved);
            try {
                if (dos != null) {
                    dos.close();
                }
                if (lock != null) {
                    profFile.delete(lock);
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            ProfilerDialogs.displayError((String)Bundle.ResultsManager_OutOfMemorySavingMsg());
            boolean bl = false;
            return bl;
        }
        finally {
            if (lock != null) {
                lock.releaseLock();
            }
        }
        return true;
    }

    public boolean saveSnapshot(LoadedSnapshot ls) {
        FileObject profFile = null;
        Lookup.Provider p = ls.getProject();
        FileObject saveDir = null;
        try {
            saveDir = ProfilerStorage.getProjectFolder((Lookup.Provider)p, (boolean)true);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, Bundle.ResultsManager_CantFindSnapshotLocationMsg(e.getMessage()), e);
            return false;
        }
        try {
            profFile = saveDir.createData(this.getDefaultSnapshotFileName(ls), SNAPSHOT_EXTENSION);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, Bundle.ResultsManager_SnapshotCreateInProjectFailedMsg(e.getMessage()), e);
            return false;
        }
        return this.saveSnapshot(ls, profFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoadedSnapshot takeSnapshot() {
        CommonUtils.runInEventDispatchThreadAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                ResultsManager.this.mainWindow = WindowManager.getDefault().getMainWindow();
            }
        });
        Cursor cursor = this.mainWindow.getCursor();
        this.mainWindow.setCursor(Cursor.getPredefinedCursor(3));
        try {
            LoadedSnapshot snapshot = this.prepareSnapshot();
            if (snapshot != null) {
                this.loadedSnapshots.add(snapshot);
                this.fireSnapshotTaken(snapshot);
                LoadedSnapshot loadedSnapshot = snapshot;
                return loadedSnapshot;
            }
        }
        finally {
            this.mainWindow.setCursor(cursor);
        }
        return null;
    }

    protected void fireResultsAvailable() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "fireResultsAvailable", new Exception());
        }
        if (this.resultsListeners.allClasses().isEmpty()) {
            return;
        }
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (ResultsListener rl : ResultsManager.this.resultsListeners.allInstances()) {
                    rl.resultsAvailable();
                }
            }
        });
    }

    protected void fireResultsReset() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "fireResultsReset", new Exception());
        }
        if (this.resultsListeners.allClasses().isEmpty()) {
            return;
        }
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (ResultsListener rl : ResultsManager.this.resultsListeners.allInstances()) {
                    rl.resultsReset();
                }
            }
        });
    }

    protected void fireSnapshotLoaded(final LoadedSnapshot snapshot) {
        if (this.snapshotListeners.allClasses().isEmpty()) {
            return;
        }
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (SnapshotsListener sl : ResultsManager.this.snapshotListeners.allInstances()) {
                    sl.snapshotLoaded(snapshot);
                }
            }
        });
    }

    protected void fireSnapshotRemoved(final LoadedSnapshot snapshot) {
        if (this.snapshotListeners.allClasses().isEmpty()) {
            return;
        }
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (SnapshotsListener sl : ResultsManager.this.snapshotListeners.allInstances()) {
                    sl.snapshotRemoved(snapshot);
                }
            }
        });
    }

    protected void fireSnapshotSaved(final LoadedSnapshot snapshot) {
        if (this.snapshotListeners.allClasses().isEmpty()) {
            return;
        }
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (SnapshotsListener sl : ResultsManager.this.snapshotListeners.allInstances()) {
                    sl.snapshotSaved(snapshot);
                }
            }
        });
    }

    protected void fireSnapshotTaken(final LoadedSnapshot snapshot) {
        if (this.snapshotListeners.allClasses().isEmpty()) {
            return;
        }
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (SnapshotsListener sl : ResultsManager.this.snapshotListeners.allInstances()) {
                    sl.snapshotTaken(snapshot);
                }
            }
        });
    }

    void resultsBecameAvailable() {
        if (Profiler.getDefault().getProfilingState() == 1) {
            return;
        }
        this.resultsAvailable = true;
        this.fireResultsAvailable();
    }

    void resultsReset() {
        this.resultsAvailable = false;
        this.fireResultsReset();
    }

    SelectedFile selectSnapshotTargetFile(String defaultName, final boolean heapdump) {
        String targetName;
        FileObject targetDir;
        String targetExt;
        JFileChooser chooser = new JFileChooser();
        if (this.exportDir != null) {
            chooser.setCurrentDirectory(this.exportDir);
        }
        chooser.setFileSelectionMode(2);
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle(Bundle.ResultsManager_SelectFileOrDirDialogCaption());
        chooser.setApproveButtonText(Bundle.ResultsManager_SaveButtonName());
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith("." + (heapdump ? ResultsManager.HEAPDUMP_EXTENSION : ResultsManager.SNAPSHOT_EXTENSION));
            }

            @Override
            public String getDescription() {
                if (heapdump) {
                    return Bundle.ResultsManager_ProfilerHeapdumpFileFilter(ResultsManager.HEAPDUMP_EXTENSION);
                }
                return Bundle.ResultsManager_ProfilerSnapshotFileFilter(ResultsManager.SNAPSHOT_EXTENSION);
            }
        });
        if (chooser.showSaveDialog(WindowManager.getDefault().getMainWindow()) != 0) {
            return null;
        }
        File file = chooser.getSelectedFile();
        String string = targetExt = heapdump ? HEAPDUMP_EXTENSION : SNAPSHOT_EXTENSION;
        if (file.isDirectory()) {
            this.exportDir = chooser.getCurrentDirectory();
            targetDir = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
            targetName = defaultName;
        } else {
            this.exportDir = chooser.getCurrentDirectory();
            targetDir = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)this.exportDir));
            String fName = file.getName();
            int idx = fName.lastIndexOf(46);
            if (idx == -1) {
                targetName = fName;
            } else if (heapdump || fName.endsWith("." + targetExt)) {
                targetName = fName.substring(0, idx);
                targetExt = fName.substring(idx + 1);
            } else {
                targetName = fName;
            }
        }
        return new SelectedFile(targetDir, targetName, targetExt);
    }

    private boolean checkFileExists(SelectedFile sf) {
        FileObject existingFile = sf.folder.getFileObject(sf.fileName, sf.fileExt);
        if (existingFile != null) {
            if (!ProfilerDialogs.displayConfirmation((String)Bundle.ResultsManager_OverwriteFileDialogMsg(sf.fileName + "." + sf.fileExt), (String)Bundle.ResultsManager_OverwriteFileDialogCaption())) {
                return false;
            }
            try {
                existingFile.delete();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, Bundle.ResultsManager_FileDeleteFailedMsg(e.getMessage()), e);
                return false;
            }
        }
        return true;
    }

    private void exportSnapshot(FileObject selectedSnapshot, FileObject targetFolder, String fileName, String fileExt) {
        if (this.checkFileExists(new SelectedFile(targetFolder, fileName, fileExt))) {
            try {
                FileUtil.copyFile((FileObject)selectedSnapshot, (FileObject)targetFolder, (String)fileName, (String)fileExt);
            }
            catch (Throwable t) {
                LOGGER.log(Level.INFO, t.getMessage(), t);
                String msg = t.getLocalizedMessage().replace("<", "&lt;").replace(">", "&gt;");
                ProfilerDialogs.displayError((String)Bundle.ResultsManager_SnapshotExportFailedMsg(msg));
            }
        }
    }

    private LoadedSnapshot findAlreadyLoadedSnapshot(FileObject selectedFile) {
        Iterator<LoadedSnapshot> it = this.loadedSnapshots.iterator();
        File f = FileUtil.toFile((FileObject)selectedFile);
        if (f == null) {
            return null;
        }
        while (it.hasNext()) {
            LoadedSnapshot ls = it.next();
            if (ls.getFile() == null || !ls.getFile().equals(f)) continue;
            return ls;
        }
        return null;
    }

    private Lookup.Provider findProjectForSnapshot(FileObject selectedFile) {
        return ProfilerStorage.getProjectFromFolder((FileObject)selectedFile.getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoadedSnapshot loadSnapshotFromFileObject(FileObject selectedFile) throws IOException {
        FilterInputStream dis = null;
        try {
            InputStream is = selectedFile.getInputStream();
            BufferedInputStream bis = new BufferedInputStream(is);
            dis = new DataInputStream(bis);
            LoadedSnapshot ls = LoadedSnapshot.loadSnapshot((DataInputStream)dis);
            if (ls != null) {
                ls.setFile(FileUtil.toFile((FileObject)selectedFile));
                ls.setProject(this.findProjectForSnapshot(selectedFile));
            }
            LoadedSnapshot loadedSnapshot = ls;
            return loadedSnapshot;
        }
        finally {
            if (dis != null) {
                dis.close();
            }
        }
    }

    private LoadedSnapshot loadSnapshotImpl(FileObject selectedFile) throws IOException {
        LoadedSnapshot ls = this.findAlreadyLoadedSnapshot(selectedFile);
        if (ls != null) {
            return ls;
        }
        ls = this.loadSnapshotFromFileObject(selectedFile);
        if (ls != null) {
            this.loadedSnapshots.add(ls);
            this.fireSnapshotLoaded(ls);
        }
        return ls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProfilingSettings readSettingsFromFile(FileObject fo) {
        LoadedSnapshot ls = this.findAlreadyLoadedSnapshot(fo);
        if (ls != null) {
            return ls.getSettings();
        }
        FilterInputStream dis = null;
        try {
            InputStream is = fo.getInputStream();
            BufferedInputStream bis = new BufferedInputStream(is);
            dis = new DataInputStream(bis);
            byte[] magicArray = new byte["nBpRoFiLeR".length()];
            int len = ((DataInputStream)dis).read(magicArray);
            if (len != "nBpRoFiLeR".length() || !"nBpRoFiLeR".equals(new String(magicArray))) {
                ProfilingSettings profilingSettings = null;
                return profilingSettings;
            }
            byte majorVersion = ((DataInputStream)dis).readByte();
            byte minorVersion = ((DataInputStream)dis).readByte();
            int type = ((DataInputStream)dis).readInt();
            int compressedDataLen = ((DataInputStream)dis).readInt();
            int uncompressedDataLen = ((DataInputStream)dis).readInt();
            if (((DataInputStream)dis).skipBytes(compressedDataLen) != compressedDataLen) {
                ProfilingSettings profilingSettings = null;
                return profilingSettings;
            }
            int settingsLen = ((DataInputStream)dis).readInt();
            byte[] settingsBytes = new byte[settingsLen];
            if (((DataInputStream)dis).read(settingsBytes) != settingsLen) {
                ProfilingSettings profilingSettings = null;
                return profilingSettings;
            }
            Properties props = new Properties();
            ProfilingSettings settings = new ProfilingSettings();
            ByteArrayInputStream bais2 = new ByteArrayInputStream(settingsBytes);
            BufferedInputStream bufBais2 = new BufferedInputStream(bais2);
            DataInputStream settingsDis = new DataInputStream(bufBais2);
            try {
                props.load(settingsDis);
            }
            catch (IOException e) {
                ProfilerLogger.log((Exception)e);
                ProfilingSettings profilingSettings = null;
                try {
                    if (dis != null) {
                        dis.close();
                    }
                }
                catch (IOException e2) {
                    ProfilerLogger.log((Exception)e2);
                }
                return profilingSettings;
            }
            finally {
                settingsDis.close();
            }
            settings.load((Map)props);
            ProfilingSettings profilingSettings = settings;
            return profilingSettings;
        }
        catch (Exception e) {
            ProfilerLogger.log((Exception)e);
            ProfilingSettings profilingSettings = null;
            return profilingSettings;
        }
        finally {
            try {
                if (dis != null) {
                    dis.close();
                }
            }
            catch (IOException e) {
                ProfilerLogger.log((Exception)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readTypeFromFile(FileObject fo) {
        LoadedSnapshot ls = this.findAlreadyLoadedSnapshot(fo);
        if (ls != null) {
            return ls.getType();
        }
        FilterInputStream dis = null;
        try {
            int type;
            InputStream is = fo.getInputStream();
            BufferedInputStream bis = new BufferedInputStream(is);
            dis = new DataInputStream(bis);
            byte[] magicArray = new byte["nBpRoFiLeR".length()];
            int len = ((DataInputStream)dis).read(magicArray);
            if (len != "nBpRoFiLeR".length() || !"nBpRoFiLeR".equals(new String(magicArray))) {
                int n = 0;
                return n;
            }
            byte majorVersion = ((DataInputStream)dis).readByte();
            byte minorVersion = ((DataInputStream)dis).readByte();
            int n = type = ((DataInputStream)dis).readInt();
            return n;
        }
        catch (Exception e) {
            int n = 0;
            return n;
        }
        finally {
            try {
                if (dis != null) {
                    dis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public static interface SnapshotHandle {
        public LoadedSnapshot getSnapshot();
    }

    public static final class ResultsMonitor
    implements CPUCCTProvider.Listener,
    MemoryCCTProvider.Listener {
        public void cctEstablished(RuntimeCCTNode runtimeCCTNode, boolean empty) {
            if (!empty) {
                ResultsManager rm = ResultsManager.getDefault();
                if (!rm.resultsAvailable() && !this.isSomeResultsAvailable()) {
                    return;
                }
                rm.resultsBecameAvailable();
            }
        }

        public void cctReset() {
            ResultsManager.getDefault().resultsReset();
        }

        private boolean isSomeResultsAvailable() {
            ProfilerClient client = Profiler.getDefault().getTargetAppRunner().getProfilerClient();
            int instrType = client.getCurrentInstrType();
            if (instrType == 3 || instrType == 4) {
                try {
                    client.getCPUProfilingResultsSnapshot(false);
                }
                catch (CPUResultsSnapshot.NoDataAvailableException ex) {
                    return false;
                }
                catch (ClientUtils.TargetAppOrVMTerminated ex) {
                    return false;
                }
            }
            return true;
        }
    }

    private static class Singleton {
        private static final ResultsManager INSTANCE = new ResultsManager();

        private Singleton() {
        }
    }

    static class SelectedFile {
        FileObject folder;
        String fileExt;
        String fileName;

        SelectedFile(FileObject folder, String fileName, String fileExt) {
            this.folder = folder;
            this.fileName = fileName;
            this.fileExt = fileExt;
        }
    }
}

