/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.apisupport;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.codehaus.plexus.util.IOUtil;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.spi.java.queries.AccessibilityQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class AccessQueryImpl
implements AccessibilityQueryImplementation {
    private final Project project;
    private WeakReference<List<Pattern>> ref;
    private PropertyChangeListener projectListener;
    private static final String MANIFEST_PATH = "src/main/nbm/manifest.mf";
    static final String ATTR_PUBLIC_PACKAGE = "OpenIDE-Module-Public-Packages";

    public AccessQueryImpl(Project prj) {
        this.project = prj;
    }

    @SuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean isPubliclyAccessible(FileObject pkg) {
        String path;
        FileObject srcdir = FileUtilities.convertStringToFileObject((String)((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).getMavenProject().getBuild().getSourceDirectory());
        if (srcdir != null && (path = FileUtil.getRelativePath((FileObject)srcdir, (FileObject)pkg)) != null) {
            String name = path.replace('/', '.');
            List<Pattern> pp = this.getPublicPackagesPatterns();
            return AccessQueryImpl.check(pp, name);
        }
        return null;
    }

    static boolean check(List<Pattern> patt, String value) {
        Pattern pattern;
        boolean matches = false;
        Iterator<Pattern> i$ = patt.iterator();
        while (i$.hasNext() && !(matches = (pattern = i$.next()).matcher(value).matches())) {
        }
        return matches;
    }

    synchronized List<Pattern> getPublicPackagesPatterns() {
        List patterns;
        if (this.projectListener == null) {
            this.projectListener = new PropertyChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("MavenProject".equals(evt.getPropertyName())) {
                        AccessQueryImpl accessQueryImpl = AccessQueryImpl.this;
                        synchronized (accessQueryImpl) {
                            AccessQueryImpl.this.ref = null;
                        }
                    }
                }
            };
            ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).addPropertyChangeListener(this.projectListener);
        }
        if (this.ref != null && (patterns = (List)this.ref.get()) != null) {
            return patterns;
        }
        List<Pattern> toRet = AccessQueryImpl.loadPublicPackagesPatterns(this.project);
        this.ref = new WeakReference<List<Pattern>>(toRet);
        return toRet;
    }

    static List<Pattern> prepareMavenPublicPackagesPatterns(String[] values) {
        ArrayList<Pattern> toRet = new ArrayList<Pattern>();
        for (String token : values) {
            token = token.trim();
            boolean recursive = false;
            if (token.endsWith(".*")) {
                token = token.substring(0, token.length() - ".*".length());
                recursive = true;
            }
            token = token.replace(".", "\\.");
            if (recursive) {
                token = token + ".*";
            }
            toRet.add(Pattern.compile(token));
        }
        return toRet;
    }

    static List<Pattern> prepareManifestPublicPackagesPatterns(String value) {
        ArrayList<Pattern> toRet = new ArrayList<Pattern>();
        if (value != null) {
            StringTokenizer tok = new StringTokenizer(value, " ,", false);
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                token = token.trim();
                boolean recursive = false;
                if (token.endsWith(".*")) {
                    token = token.substring(0, token.length() - ".*".length());
                    recursive = false;
                } else if (token.endsWith(".**")) {
                    token = token.substring(0, token.length() - ".**".length());
                    recursive = true;
                }
                token = token.replace(".", "\\.");
                if (recursive) {
                    token = token + ".*";
                }
                toRet.add(Pattern.compile(token));
            }
        }
        return toRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Pattern> loadPublicPackagesPatterns(Project project) {
        List<Object> toRet = new ArrayList();
        String[] params = PluginPropertyUtils.getPluginPropertyList((Project)project, (String)"org.codehaus.mojo", (String)"nbm-maven-plugin", (String)"publicPackages", (String)"publicPackage", (String)"manifest");
        if (params != null) {
            toRet = AccessQueryImpl.prepareMavenPublicPackagesPatterns(params);
        } else {
            FileObject obj = project.getProjectDirectory().getFileObject(MANIFEST_PATH);
            if (obj != null) {
                InputStream in = null;
                try {
                    in = obj.getInputStream();
                    Manifest man = new Manifest();
                    man.read(in);
                    String value = man.getMainAttributes().getValue(ATTR_PUBLIC_PACKAGE);
                    toRet = AccessQueryImpl.prepareManifestPublicPackagesPatterns(value);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    IOUtil.close((InputStream)in);
                }
            }
        }
        return toRet;
    }
}

