/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v3.filecache;

import com.mchange.v3.filecache.FileCacheKey;
import java.net.MalformedURLException;
import java.net.URL;

public class RelativePathFileCacheKey
implements FileCacheKey {
    final URL url;
    final String relPath;

    public RelativePathFileCacheKey(URL parentURL, String relPath) throws MalformedURLException, IllegalArgumentException {
        String trimmed = relPath.trim();
        if (parentURL == null || relPath == null) {
            throw new IllegalArgumentException("parentURL [" + parentURL + "] and relative path [" + relPath + "] must be non-null");
        }
        if (trimmed.length() == 0) {
            throw new IllegalArgumentException("relative path [" + relPath + "] must not be a blank string");
        }
        if (!trimmed.equals(relPath)) {
            throw new IllegalArgumentException("relative path [" + relPath + "] must not begin or end with whitespace.");
        }
        if (relPath.startsWith("/")) {
            throw new IllegalArgumentException("Path must be relative, '" + relPath + "' begins with '/'.");
        }
        this.url = new URL(parentURL, relPath);
        this.relPath = relPath;
    }

    public URL getURL() {
        return this.url;
    }

    public String getCacheFilePath() {
        return this.relPath;
    }

    public boolean equals(Object o) {
        if (o instanceof RelativePathFileCacheKey) {
            RelativePathFileCacheKey oo = (RelativePathFileCacheKey)o;
            return this.url.equals(oo.url) && this.relPath.equals(oo.relPath);
        }
        return false;
    }

    public int hashCode() {
        return this.url.hashCode() ^ this.relPath.hashCode();
    }
}

