/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.actions;

import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.CslActions;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.openide.util.Exceptions;

public class ToggleBlockCommentAction
extends BaseAction {
    static final long serialVersionUID = -1L;
    private static final String FORCE_COMMENT = "force-comment";
    private static final String FORCE_UNCOMMENT = "force-uncomment";

    public static ToggleBlockCommentAction create(Map<String, ?> attrs) {
        return new ToggleBlockCommentAction(attrs);
    }

    public ToggleBlockCommentAction(Map<String, ?> attrs) {
        super(null);
        if (attrs != null) {
            String actionName = (String)attrs.get("Name");
            if (actionName == null) {
                throw new IllegalArgumentException("Null Action.NAME attribute for action " + ((Object)((Object)this)).getClass());
            }
            this.putValue("Name", actionName);
        }
    }

    public void actionPerformed(ActionEvent evt, JTextComponent target) {
        final AtomicBoolean processedHere = new AtomicBoolean(false);
        if (target != null) {
            if (!(target.isEditable() && target.isEnabled() && target.getDocument() instanceof BaseDocument)) {
                target.getToolkit().beep();
                return;
            }
            final int caretOffset = Utilities.isSelectionShowing((JTextComponent)target) ? target.getSelectionStart() : target.getCaretPosition();
            final BaseDocument doc = (BaseDocument)target.getDocument();
            doc.runAtomic(new Runnable(){

                @Override
                public void run() {
                    ToggleBlockCommentAction.this.performCustomAction(doc, caretOffset, processedHere);
                }
            });
            if (!processedHere.get()) {
                this.performDefaultAction(evt, target);
            }
        }
    }

    private void performCustomAction(BaseDocument doc, int caretOffset, AtomicBoolean processedHere) {
        TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, caretOffset);
        if (ts != null) {
            ts.move(caretOffset);
            ts.moveNext();
            if (this.isAroundPhpComment(ts, caretOffset)) {
                processedHere.set(true);
            } else if (ts.token().id() != PHPTokenId.T_INLINE_HTML) {
                boolean newLineSomewhereBeforeCaretOffset = false;
                if (ToggleBlockCommentAction.isNewLineBeforeCaretOffset(ts, caretOffset)) {
                    newLineSomewhereBeforeCaretOffset = true;
                }
                while (!newLineSomewhereBeforeCaretOffset && ts.movePrevious() && ts.token().id() != PHPTokenId.PHP_OPENTAG) {
                    if (!ToggleBlockCommentAction.isNewLineBeforeCaretOffset(ts, caretOffset)) continue;
                    newLineSomewhereBeforeCaretOffset = true;
                }
                if (!newLineSomewhereBeforeCaretOffset && ts.token().id() == PHPTokenId.PHP_OPENTAG) {
                    processedHere.set(true);
                    int possibleChangeOffset = ts.offset() + ts.token().length();
                    int possibleWhitespaceLength = 0;
                    boolean possibleLineComment = false;
                    if (ts.moveNext() && ts.token().id() == PHPTokenId.PHP_LINE_COMMENT) {
                        possibleLineComment = true;
                    } else if (ts.token().id() == PHPTokenId.WHITESPACE) {
                        possibleWhitespaceLength = ts.token().length();
                        if (ts.moveNext() && ts.token().id() == PHPTokenId.PHP_LINE_COMMENT) {
                            possibleLineComment = true;
                        }
                    }
                    boolean lineComment = possibleLineComment;
                    int changeOffset = lineComment ? possibleChangeOffset + possibleWhitespaceLength : possibleChangeOffset;
                    int length = lineComment ? ts.offset() + ts.token().length() + ToggleBlockCommentAction.countForgoingWhitespaces(ts) - changeOffset : 0;
                    try {
                        if (!lineComment) {
                            if (this.forceDirection(true)) {
                                doc.insertString(changeOffset, " //", null);
                            }
                        } else if (this.forceDirection(false)) {
                            doc.remove(changeOffset, length);
                        }
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
    }

    private int findLastNewLineBeforeOffset(String text, int offset) {
        int result = -1;
        if (offset >= 0 && offset < text.length()) {
            String textUntilOffset = text.substring(0, offset);
            result = textUntilOffset.lastIndexOf("\n");
        }
        return result;
    }

    private void performDefaultAction(ActionEvent evt, JTextComponent target) {
        BaseAction action = (BaseAction)CslActions.createToggleBlockCommentAction();
        if (this.getValue(FORCE_COMMENT) != null) {
            action.putValue(FORCE_COMMENT, this.getValue(FORCE_COMMENT));
        }
        if (this.getValue(FORCE_UNCOMMENT) != null) {
            action.putValue(FORCE_UNCOMMENT, this.getValue(FORCE_UNCOMMENT));
        }
        action.actionPerformed(evt, target);
    }

    private boolean isAroundPhpComment(TokenSequence<PHPTokenId> ts, int caretOffset) {
        Token token = ts.token();
        boolean result = ToggleBlockCommentAction.isPhpComment((PHPTokenId)token.id());
        if (!result && PHPTokenId.WHITESPACE.equals(token.id()) && this.findLastNewLineBeforeOffset(token.text().toString(), caretOffset - ts.offset()) == -1 && ts.movePrevious()) {
            result = ToggleBlockCommentAction.isPhpComment((PHPTokenId)ts.token().id());
            ts.moveNext();
        }
        return result;
    }

    private static boolean isPhpComment(PHPTokenId tokenId) {
        return PHPTokenId.PHP_COMMENT.equals((Object)tokenId) || PHPTokenId.PHP_COMMENT_START.equals((Object)tokenId) || PHPTokenId.PHP_COMMENT_END.equals((Object)tokenId) || PHPTokenId.PHPDOC_COMMENT.equals((Object)tokenId) || PHPTokenId.PHPDOC_COMMENT_START.equals((Object)tokenId) || PHPTokenId.PHPDOC_COMMENT_END.equals((Object)tokenId);
    }

    private static int countForgoingWhitespaces(TokenSequence<PHPTokenId> tokenSequence) {
        int result = 0;
        tokenSequence.moveNext();
        String commentedText = tokenSequence.token().text().toString();
        for (int i = 0; i < commentedText.length() && Character.isWhitespace(commentedText.charAt(i)); ++i) {
            ++result;
        }
        tokenSequence.movePrevious();
        return result;
    }

    private static boolean isNewLineBeforeCaretOffset(TokenSequence<PHPTokenId> ts, int caretOffset) {
        boolean result = false;
        int indexOfNewLine = ts.token().text().toString().indexOf("\n");
        if (indexOfNewLine != -1) {
            int absoluteIndexOfNewLine = ts.offset() + indexOfNewLine;
            result = caretOffset > absoluteIndexOfNewLine;
        }
        return result;
    }

    private boolean forceDirection(boolean comment) {
        Object force;
        Object fComment = this.getValue(FORCE_COMMENT);
        Object fUncomment = this.getValue(FORCE_UNCOMMENT);
        Object object = force = comment ? fComment : fUncomment;
        if (force instanceof Boolean) {
            return (Boolean)force;
        }
        return fComment == null && fUncomment == null;
    }
}

