/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.elements;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.NamespaceElement;
import org.netbeans.modules.php.editor.api.elements.TraitElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.elements.FullyQualifiedElementImpl;
import org.netbeans.modules.php.editor.elements.IndexQueryImpl;
import org.netbeans.modules.php.editor.elements.PhpElementImpl;
import org.netbeans.modules.php.editor.elements.TypeElementImpl;
import org.netbeans.modules.php.editor.index.Signature;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.TraitDeclarationInfo;
import org.netbeans.modules.php.editor.parser.astnodes.TraitDeclaration;
import org.openide.util.Parameters;

public final class TraitElementImpl
extends TypeElementImpl
implements TraitElement {
    public static final String IDX_FIELD = "trait";
    private Collection<QualifiedName> usedTraits;

    private TraitElementImpl(QualifiedName qualifiedName, int offset, Collection<QualifiedName> usedTraits, String fileUrl, ElementQuery elementQuery, boolean isDeprecated) {
        super(qualifiedName, offset, Collections.emptySet(), Collections.emptySet(), 0, fileUrl, elementQuery, isDeprecated);
        this.usedTraits = usedTraits;
    }

    public static Set<TraitElement> fromSignature(IndexQueryImpl indexScopeQuery, IndexResult indexResult) {
        return TraitElementImpl.fromSignature((NameKind)NameKind.empty(), indexScopeQuery, indexResult);
    }

    private static TraitElement fromSignature(NameKind query, IndexQueryImpl indexScopeQuery, Signature signature) {
        Parameters.notNull((CharSequence)"query", (Object)query);
        TraitSignatureParser signParser = new TraitSignatureParser(signature);
        TraitElementImpl retval = null;
        if (TraitElementImpl.matchesQuery(query, signParser)) {
            retval = new TraitElementImpl(signParser.getQualifiedName(), signParser.getOffset(), signParser.getUsedTraits(), signParser.getFileUrl(), (ElementQuery)indexScopeQuery, signParser.isDeprecated());
        }
        return retval;
    }

    public static Set<TraitElement> fromSignature(NameKind query, IndexQueryImpl indexScopeQuery, IndexResult indexResult) {
        String[] values = indexResult.getValues(IDX_FIELD);
        HashSet<TraitElement> retval = values.length > 0 ? new HashSet<TraitElement>() : Collections.emptySet();
        for (String val : values) {
            TraitElement trait = TraitElementImpl.fromSignature(query, indexScopeQuery, Signature.get(val));
            if (trait == null) continue;
            retval.add(trait);
        }
        return retval;
    }

    public static TraitElement fromNode(NamespaceElement namespace, TraitDeclaration node, ElementQuery.File fileQuery) {
        Parameters.notNull((CharSequence)"node", (Object)node);
        Parameters.notNull((CharSequence)"fileQuery", (Object)fileQuery);
        TraitDeclarationInfo info = TraitDeclarationInfo.create(node);
        QualifiedName fullyQualifiedName = namespace != null ? namespace.getFullyQualifiedName() : QualifiedName.createForDefaultNamespaceName();
        return new TraitElementImpl(fullyQualifiedName.append(info.getName()), info.getRange().getStart(), info.getUsedTraits(), fileQuery.getURL().toExternalForm(), (ElementQuery)fileQuery, VariousUtils.isDeprecatedFromPHPDoc(fileQuery.getResult().getProgram(), node));
    }

    private static boolean matchesQuery(NameKind query, TraitSignatureParser signParser) {
        Parameters.notNull((CharSequence)"query", (Object)query);
        return query instanceof NameKind.Empty || query.matchesName(TraitElement.KIND, signParser.getQualifiedName());
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName().toLowerCase()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.getName()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.getOffset()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.getNamespaceName()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        if (!this.usedTraits.isEmpty()) {
            StringBuilder traitSb = new StringBuilder();
            for (QualifiedName usedTrait : this.usedTraits) {
                if (traitSb.length() > 0) {
                    traitSb.append((Object)PhpElementImpl.Separator.COMMA);
                }
                traitSb.append(usedTrait.toString());
            }
            sb.append((CharSequence)traitSb);
        }
        sb.append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.isDeprecated() ? 1 : 0).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.getFilenameUrl()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        return sb.toString();
    }

    @Override
    public PhpElementKind getPhpElementKind() {
        return KIND;
    }

    @Override
    public String asString(TypeElement.PrintAs as) {
        return this.getName();
    }

    @Override
    public Collection<QualifiedName> getUsedTraits() {
        return this.usedTraits;
    }

    private static class TraitSignatureParser {
        private final Signature signature;

        TraitSignatureParser(Signature signature) {
            this.signature = signature;
        }

        QualifiedName getQualifiedName() {
            return FullyQualifiedElementImpl.composeQualifiedName(this.signature.string(3), this.signature.string(1));
        }

        int getOffset() {
            return this.signature.integer(2);
        }

        private Collection<QualifiedName> getUsedTraits() {
            String[] traitNames;
            HashSet<QualifiedName> retval = new HashSet<QualifiedName>();
            String traits = this.signature.string(4);
            for (String trait : traitNames = traits.split(PhpElementImpl.Separator.COMMA.toString())) {
                retval.add(QualifiedName.create(trait));
            }
            return retval;
        }

        boolean isDeprecated() {
            return this.signature.integer(5) == 1;
        }

        String getFileUrl() {
            return this.signature.string(6);
        }
    }
}

