/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.ParameterInfo;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.elements.BaseFunctionElement;
import org.netbeans.modules.php.editor.api.elements.ClassElement;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.ParameterElement;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.Occurence;
import org.netbeans.modules.php.editor.model.OccurencesSupport;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.model.impl.ModelVisitor;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;

public class ParameterInfoSupport {
    private ModelVisitor modelVisitor;
    private int offset;
    private static final Collection<PHPTokenId> CTX_DELIMITERS = Arrays.asList(PHPTokenId.PHP_OPENTAG, PHPTokenId.PHP_SEMICOLON, PHPTokenId.PHP_CURLY_OPEN, PHPTokenId.PHP_CURLY_CLOSE, PHPTokenId.PHP_RETURN, PHPTokenId.PHP_OPERATOR, PHPTokenId.PHP_ECHO, PHPTokenId.PHP_EVAL, PHPTokenId.PHP_NEW, PHPTokenId.PHP_NOT, PHPTokenId.PHP_CASE, PHPTokenId.PHP_IF, PHPTokenId.PHP_ELSE, PHPTokenId.PHP_ELSEIF, PHPTokenId.PHP_PRINT, PHPTokenId.PHP_FOR, PHPTokenId.PHP_FOREACH, PHPTokenId.PHP_WHILE, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_LINE_COMMENT, PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING, PHPTokenId.PHP_ENCAPSED_AND_WHITESPACE);

    ParameterInfoSupport(ModelVisitor modelVisitor, int offset) {
        this.modelVisitor = modelVisitor;
        this.offset = offset;
    }

    public ParameterInfo getParameterInfo() {
        ParameterInfo retval = ParameterInfoSupport.parametersNodeImpl(this.offset, this.modelVisitor.getCompilationInfo());
        if (retval == ParameterInfo.NONE) {
            retval = this.parametersTokenImpl();
        }
        return retval;
    }

    private ParameterInfo parametersTokenImpl() {
        ModelElement element;
        String typeName;
        Stack<? extends ModelElement> elemenst;
        FileScope modelScope = this.modelVisitor.getFileScope();
        VariableScope nearestVariableScope = this.modelVisitor.getNearestVariableScope(this.offset);
        if (modelScope == null || nearestVariableScope == null) {
            return ParameterInfo.NONE;
        }
        TokenHierarchy tokenHierarchy = this.modelVisitor.getCompilationInfo().getSnapshot().getTokenHierarchy();
        TokenSequence<PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence(tokenHierarchy, this.offset);
        if (ParameterInfoSupport.moveToOffset(tokenSequence, this.offset)) {
            return ParameterInfo.NONE;
        }
        int commasCount = 0;
        int anchor = -1;
        State state = State.PARAMS;
        int leftBraces = 0;
        int rightBraces = 1;
        StringBuilder metaAll = new StringBuilder();
        block11: while (!state.equals((Object)State.INVALID) && !state.equals((Object)State.STOP) && tokenSequence.movePrevious() && ParameterInfoSupport.skipWhitespaces(tokenSequence)) {
            Token token = tokenSequence.token();
            if (!CTX_DELIMITERS.contains(token.id())) {
                switch (state) {
                    case METHOD: 
                    case START: {
                        State state2 = state = state.equals((Object)State.METHOD) ? State.STOP : State.INVALID;
                        if (ParameterInfoSupport.isReference((Token<PHPTokenId>)token)) {
                            metaAll.insert(0, "@mtd:");
                            state = State.REFERENCE;
                            continue block11;
                        }
                        if (ParameterInfoSupport.isStaticReference((Token<PHPTokenId>)token)) {
                            metaAll.insert(0, "@mtd:");
                            state = State.STATIC_REFERENCE;
                            continue block11;
                        }
                        if (!state.equals((Object)State.STOP)) continue block11;
                        metaAll.insert(0, "@fn:");
                        continue block11;
                    }
                    case REFERENCE: {
                        state = State.INVALID;
                        if (ParameterInfoSupport.isRightBracket((Token<PHPTokenId>)token)) {
                            ++rightBraces;
                            state = State.PARAMS;
                            continue block11;
                        }
                        if (ParameterInfoSupport.isString((Token<PHPTokenId>)token)) {
                            metaAll.insert(0, token.text().toString());
                            state = State.FIELD;
                            continue block11;
                        }
                        if (!ParameterInfoSupport.isVariable((Token<PHPTokenId>)token)) continue block11;
                        metaAll.insert(0, token.text().toString());
                        state = State.VARBASE;
                        continue block11;
                    }
                    case STATIC_REFERENCE: {
                        state = State.INVALID;
                        if (ParameterInfoSupport.isString((Token<PHPTokenId>)token)) {
                            metaAll.insert(0, token.text().toString());
                            state = State.CLASSNAME;
                            continue block11;
                        }
                        if (!ParameterInfoSupport.isSelf((Token<PHPTokenId>)token)) continue block11;
                        metaAll.insert(0, ParameterInfoSupport.buildStaticClassName(nearestVariableScope, token.text().toString()));
                        state = State.CLASSNAME;
                        continue block11;
                    }
                    case PARAMS: {
                        state = State.INVALID;
                        if (ParameterInfoSupport.isWhiteSpace((Token<PHPTokenId>)token)) {
                            state = State.PARAMS;
                        } else if (ParameterInfoSupport.isComma((Token<PHPTokenId>)token)) {
                            if (metaAll.length() == 0) {
                                ++commasCount;
                            }
                            state = State.PARAMS;
                        } else if (ParameterInfoSupport.isVariable((Token<PHPTokenId>)token)) {
                            state = State.PARAMS;
                        } else if (CTX_DELIMITERS.contains(token.id())) {
                            state = State.INVALID;
                        } else if (ParameterInfoSupport.isLeftBracket((Token<PHPTokenId>)token)) {
                            ++leftBraces;
                        } else if (ParameterInfoSupport.isRightBracket((Token<PHPTokenId>)token)) {
                            ++rightBraces;
                        } else {
                            state = State.PARAMS;
                        }
                        if (leftBraces != rightBraces) continue block11;
                        state = State.FUNCTION;
                        continue block11;
                    }
                    case FUNCTION: {
                        state = State.INVALID;
                        if (!ParameterInfoSupport.isString((Token<PHPTokenId>)token)) continue block11;
                        metaAll.insert(0, token.text().toString());
                        if (anchor == -1) {
                            anchor = tokenSequence.offset() + token.text().toString().length();
                        }
                        state = State.METHOD;
                        continue block11;
                    }
                    case FIELD: {
                        state = State.INVALID;
                        if (!ParameterInfoSupport.isReference((Token<PHPTokenId>)token)) continue block11;
                        metaAll.insert(0, "@fld:");
                        state = State.REFERENCE;
                        continue block11;
                    }
                    case VARBASE: {
                        if (ParameterInfoSupport.isStaticReference((Token<PHPTokenId>)token)) {
                            state = State.STATIC_REFERENCE;
                            continue block11;
                        }
                    }
                    case VARIABLE: {
                        metaAll.insert(0, "@var:");
                        state = State.STOP;
                        continue block11;
                    }
                    case CLASSNAME: {
                        state = State.STOP;
                        continue block11;
                    }
                }
                continue;
            }
            if (!state.equals((Object)State.METHOD)) continue;
            state = State.STOP;
            PHPTokenId id = (PHPTokenId)token.id();
            if (id != null && PHPTokenId.PHP_NEW.equals((Object)id)) {
                metaAll.insert(0, "@constuct:");
                break;
            }
            metaAll.insert(0, "@fn:");
            break;
        }
        if (state.equals((Object)State.STOP) && !(elemenst = VariousUtils.getElements(modelScope, nearestVariableScope, typeName = metaAll.toString(), this.offset)).isEmpty() && (element = elemenst.peek()) instanceof FunctionScope) {
            return new ParameterInfo(ParameterInfoSupport.toParamNames((FunctionScope)element), commasCount, anchor);
        }
        return ParameterInfo.NONE;
    }

    private static String buildStaticClassName(Scope scp, String staticClzName) {
        if (scp instanceof MethodScope) {
            MethodScope msi = (MethodScope)scp;
            ClassScope csi = (ClassScope)msi.getInScope();
            switch (staticClzName) {
                case "self": {
                    staticClzName = csi.getName();
                    break;
                }
                case "parent": {
                    ClassScope clzScope = ModelUtils.getFirst(csi.getSuperClasses());
                    if (clzScope == null) break;
                    staticClzName = clzScope.getName();
                    break;
                }
            }
        }
        return staticClzName;
    }

    private static boolean skipWhitespaces(TokenSequence<PHPTokenId> tokenSequence) {
        Token token = tokenSequence.token();
        while (token != null && ParameterInfoSupport.isWhiteSpace((Token<PHPTokenId>)token)) {
            boolean retval = tokenSequence.movePrevious();
            token = tokenSequence.token();
            if (retval) continue;
            return false;
        }
        return true;
    }

    private static boolean moveToOffset(TokenSequence<PHPTokenId> tokenSequence, int offset) {
        return tokenSequence == null || tokenSequence.move(offset) < 0;
    }

    private static boolean isDolar(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && "$".contentEquals(token.text());
    }

    private static boolean isLeftBracket(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && "(".contentEquals(token.text());
    }

    private static boolean isRightBracket(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && ")".contentEquals(token.text());
    }

    private static boolean isComma(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && ",".contentEquals(token.text());
    }

    private static boolean isReference(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_OBJECT_OPERATOR);
    }

    private static boolean isWhiteSpace(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.WHITESPACE);
    }

    private static boolean isStaticReference(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM);
    }

    private static boolean isVariable(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_VARIABLE);
    }

    private static boolean isSelf(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_SELF);
    }

    private static boolean isParent(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_PARENT);
    }

    private static boolean isString(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_STRING);
    }

    private static ParameterInfo parametersNodeImpl(final int caretOffset, final ParserResult info) {
        final ParameterInfo[] retval = new ParameterInfo[]{ParameterInfo.NONE};
        DefaultVisitor visitor = new DefaultVisitor(){

            @Override
            public void scan(ASTNode node) {
                OffsetRange range;
                if (node != null && (range = new OffsetRange(node.getStartOffset(), node.getEndOffset())).containsInclusive(caretOffset)) {
                    super.scan(node);
                }
            }

            @Override
            public void visit(ClassInstanceCreation node) {
                ASTNodeInfo<ClassInstanceCreation> nodeInfo = ASTNodeInfo.create(node);
                retval[0] = this.createParameterInfo(nodeInfo, node.ctorParams());
                super.visit(node);
            }

            @Override
            public void visit(FunctionInvocation node) {
                ASTNodeInfo<FunctionInvocation> nodeInfo = ASTNodeInfo.create(node);
                retval[0] = this.createParameterInfo(nodeInfo, node.getParameters());
                super.visit(node);
            }

            private ParameterInfo createParameterInfo(ASTNodeInfo nodeInfo, List<Expression> parameters) {
                Object node = nodeInfo.getOriginalNode();
                int anchor = nodeInfo.getRange().getEnd();
                OffsetRange offsetRange = new OffsetRange(anchor, ((ASTNode)node).getEndOffset());
                if (offsetRange.containsInclusive(caretOffset)) {
                    Collection<? extends PhpElement> allDeclarations;
                    int idx = 0;
                    for (int i = 0; i < parameters.size(); ++i) {
                        Expression expression = parameters.get(i);
                        offsetRange = new OffsetRange(expression.getStartOffset(), expression.getEndOffset());
                        if (offsetRange.containsInclusive(caretOffset)) {
                            idx = i;
                            continue;
                        }
                        offsetRange = new OffsetRange(expression.getEndOffset(), ((ASTNode)node).getEndOffset());
                        if (!offsetRange.containsInclusive(caretOffset)) continue;
                        idx = i + 1;
                    }
                    Model model = ((PHPParseResult)info).getModel();
                    OccurencesSupport occurencesSupport = model.getOccurencesSupport((nodeInfo.getRange().getStart() + anchor) / 2);
                    Occurence occurence = occurencesSupport.getOccurence();
                    if (occurence != null && (allDeclarations = occurence.getAllDeclarations()).size() > 0) {
                        boolean oneDeclaration;
                        PhpElement declaration = allDeclarations.iterator().next();
                        boolean bl = oneDeclaration = occurence.getAllDeclarations().size() == 1;
                        if (declaration instanceof FunctionScope && oneDeclaration) {
                            List paramNames = ParameterInfoSupport.toParamNames((FunctionScope)declaration);
                            return paramNames.isEmpty() ? ParameterInfo.NONE : new ParameterInfo(paramNames, idx, anchor);
                        }
                        if (declaration instanceof BaseFunctionElement && oneDeclaration) {
                            List paramNames = ParameterInfoSupport.toParamNames((BaseFunctionElement)declaration);
                            return paramNames.isEmpty() ? ParameterInfo.NONE : new ParameterInfo(paramNames, idx, anchor);
                        }
                        if (declaration instanceof ClassElement && oneDeclaration) {
                            List paramNames = ParameterInfoSupport.toParamNames((ClassElement)declaration);
                            return paramNames.isEmpty() ? ParameterInfo.NONE : new ParameterInfo(paramNames, idx, anchor);
                        }
                    }
                }
                return ParameterInfo.NONE;
            }
        };
        Program root = Utils.getRoot(info);
        if (root != null) {
            visitor.scan(root);
        }
        return retval[0];
    }

    @NonNull
    private static List<String> toParamNames(FunctionScope functionScope) {
        ArrayList<String> paramNames = new ArrayList<String>();
        List<? extends ParameterElement> parameters = functionScope.getParameters();
        for (ParameterElement parameterElement : parameters) {
            paramNames.add(parameterElement.asString(ParameterElement.OutputType.SHORTEN_DECLARATION));
        }
        return paramNames;
    }

    @CheckForNull
    private static List<String> toParamNames(BaseFunctionElement functionElement) {
        ArrayList<String> paramNames = new ArrayList<String>();
        List<ParameterElement> parameters = functionElement.getParameters();
        for (ParameterElement parameter : parameters) {
            paramNames.add(parameter.asString(ParameterElement.OutputType.SHORTEN_DECLARATION));
        }
        return paramNames;
    }

    @CheckForNull
    private static List<String> toParamNames(ClassElement clzElement) {
        ArrayList<String> paramNames = new ArrayList<String>();
        ElementQuery elementQuery = clzElement.getElementQuery();
        if (elementQuery instanceof ElementQuery.Index) {
            MethodElement constructor;
            ElementQuery.Index index = (ElementQuery.Index)elementQuery;
            Iterator<MethodElement> iterator = index.getConstructors(clzElement).iterator();
            MethodElement methodElement = constructor = iterator.hasNext() ? iterator.next() : null;
            if (constructor != null) {
                List parameters = constructor.getParameters();
                for (ParameterElement parameter : parameters) {
                    paramNames.add(parameter.asString(ParameterElement.OutputType.SHORTEN_DECLARATION));
                }
            }
        }
        return paramNames;
    }

    private static enum State {
        START,
        METHOD,
        INVALID,
        VARBASE,
        DOLAR,
        PARAMS,
        REFERENCE,
        STATIC_REFERENCE,
        FUNCTION,
        FIELD,
        VARIABLE,
        CLASSNAME,
        STOP;

    }
}

