/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeNode;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.UseStatement;
import org.netbeans.modules.php.editor.parser.astnodes.UseStatementPart;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;

public class UnusedUsesCollector
extends DefaultVisitor {
    private static final String NAMESPACE_SEPARATOR = "\\";
    private final PHPParseResult parserResult;
    private final Map<String, UnusedOffsetRanges> unusedUsesOffsetRanges;

    public UnusedUsesCollector(PHPParseResult parserResult) {
        assert (parserResult != null);
        this.parserResult = parserResult;
        this.unusedUsesOffsetRanges = new HashMap<String, UnusedOffsetRanges>();
    }

    public Collection<UnusedOffsetRanges> collect() {
        Program program = this.parserResult.getProgram();
        if (program != null) {
            program.accept(this);
        }
        return this.unusedUsesOffsetRanges.values();
    }

    @Override
    public void visit(Program program) {
        this.scan(program.getStatements());
        this.scan(program.getComments());
    }

    @Override
    public void visit(PHPDocTypeNode node) {
        QualifiedName typeName = QualifiedName.create(node.getValue());
        if (this.unusedUsesOffsetRanges.size() > 0 && !typeName.getKind().isFullyQualified()) {
            String firstSegmentName = typeName.getSegments().getFirst();
            this.processFirstSegmentName(firstSegmentName);
        }
    }

    @Override
    public void visit(NamespaceName node) {
        if (this.unusedUsesOffsetRanges.size() > 0 && !node.isGlobal()) {
            Identifier firstSegment = node.getSegments().get(0);
            String firstSegmentName = firstSegment.getName();
            this.processFirstSegmentName(firstSegmentName);
        }
    }

    private void processFirstSegmentName(String firstSegmentName) {
        HashSet<String> namesToRemove = new HashSet<String>();
        for (String name : this.unusedUsesOffsetRanges.keySet()) {
            QualifiedName qualifiedUseName = QualifiedName.create(name);
            if (!qualifiedUseName.getSegments().getLast().equals(firstSegmentName)) continue;
            namesToRemove.add(name);
        }
        for (String nameToRemove : namesToRemove) {
            this.unusedUsesOffsetRanges.remove(nameToRemove);
        }
    }

    @Override
    public void visit(UseStatement node) {
        List<UseStatementPart> parts = node.getParts();
        if (parts.size() == 1) {
            String correctName = this.getCorrectName(parts.get(0));
            OffsetRange offsetRange = new OffsetRange(node.getStartOffset(), node.getEndOffset());
            this.unusedUsesOffsetRanges.put(correctName, new UnusedOffsetRanges(offsetRange, offsetRange));
        } else {
            this.processUseStatementsParts(parts);
        }
    }

    private String getCorrectName(UseStatementPart useStatementPart) {
        String identifierName;
        Identifier alias = useStatementPart.getAlias();
        if (alias != null) {
            identifierName = alias.getName();
        } else {
            NamespaceName name = useStatementPart.getName();
            identifierName = CodeUtils.extractQualifiedName(name);
            if (name.isGlobal()) {
                identifierName = NAMESPACE_SEPARATOR + identifierName;
            }
        }
        return identifierName;
    }

    private void processUseStatementsParts(List<UseStatementPart> parts) {
        int lastStartOffset = 0;
        for (int i = 0; i < parts.size(); ++i) {
            UseStatementPart useStatementPart = parts.get(i);
            int endOffset = useStatementPart.getEndOffset();
            if (i == 0) {
                lastStartOffset = useStatementPart.getStartOffset();
                assert (i + 1 < parts.size());
                UseStatementPart nextPart = parts.get(i + 1);
                endOffset = nextPart.getStartOffset();
            }
            String correctName = this.getCorrectName(useStatementPart);
            OffsetRange rangeToVisualise = new OffsetRange(useStatementPart.getStartOffset(), useStatementPart.getEndOffset());
            OffsetRange rangeToReplace = new OffsetRange(lastStartOffset, endOffset);
            this.unusedUsesOffsetRanges.put(correctName, new UnusedOffsetRanges(rangeToVisualise, rangeToReplace));
            lastStartOffset = useStatementPart.getEndOffset();
        }
    }

    public static final class UnusedOffsetRanges {
        private final OffsetRange rangeToVisualise;
        private final OffsetRange rangeToReplace;

        private UnusedOffsetRanges(OffsetRange rangeToVisualise, OffsetRange rangeToReplace) {
            this.rangeToVisualise = rangeToVisualise;
            this.rangeToReplace = rangeToReplace;
        }

        public OffsetRange getRangeToVisualise() {
            return this.rangeToVisualise;
        }

        public OffsetRange getRangeToReplace() {
            return this.rangeToReplace;
        }
    }
}

