/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.UiUtils;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.NavUtils;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.ClassElement;
import org.netbeans.modules.php.editor.api.elements.ConstantElement;
import org.netbeans.modules.php.editor.api.elements.FullyQualifiedElement;
import org.netbeans.modules.php.editor.api.elements.FunctionElement;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.UseScope;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassName;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionName;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.StaticConstantAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultTreePathVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.netbeans.modules.php.editor.verification.SuggestionRule;
import org.netbeans.modules.php.editor.verification.VerificationUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class AddUseImportSuggestion
extends SuggestionRule {
    public String getId() {
        return "AddUse.Import.Rule";
    }

    public String getDescription() {
        return Bundle.AddUseImportRuleDesc();
    }

    public String getDisplayName() {
        return Bundle.AddUseImportRuleDispName();
    }

    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        BaseDocument doc;
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileObject fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileObject == null || CodeUtils.isPhp52(fileObject)) {
            return;
        }
        int caretOffset = this.getCaretOffset();
        OffsetRange lineBounds = VerificationUtils.createLineBounds(caretOffset, doc = context.doc);
        if (lineBounds.containsInclusive(caretOffset)) {
            CheckVisitor checkVisitor = new CheckVisitor(context, doc, lineBounds);
            phpParseResult.getProgram().accept(checkVisitor);
            hints.addAll(checkVisitor.getHints());
        }
    }

    private static boolean isClassName(ASTNode parentNode) {
        return parentNode instanceof ClassName || parentNode instanceof FormalParameter || parentNode instanceof StaticConstantAccess || parentNode instanceof StaticMethodInvocation || parentNode instanceof StaticFieldAccess || parentNode instanceof ClassDeclaration;
    }

    private static boolean isFunctionName(ASTNode parentNode) {
        return parentNode instanceof FunctionName;
    }

    static class ChangeNameFix
    implements HintFix {
        private final BaseDocument doc;
        private final ASTNode node;
        private final NamespaceScope scope;
        private final QualifiedName newName;
        private final QualifiedName oldName;

        public ChangeNameFix(BaseDocument doc, ASTNode node, NamespaceScope scope, QualifiedName newName, QualifiedName oldName) {
            this.doc = doc;
            this.newName = newName;
            this.oldName = oldName;
            this.scope = scope;
            this.node = node;
        }

        OffsetRange getOffsetRange() {
            return new OffsetRange(this.node.getStartOffset(), this.node.getEndOffset());
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean isSafe() {
            return true;
        }

        public String getDescription() {
            return Bundle.ChangeNameFix_Description(this.getGeneratedCode());
        }

        public void implement() throws Exception {
            int templateOffset = this.getOffset();
            EditList edits = new EditList(this.doc);
            edits.replace(templateOffset, this.oldName.toString().length(), this.getGeneratedCode(), true, 0);
            edits.apply();
            UiUtils.open((FileObject)this.scope.getFileObject(), (int)Utilities.getRowStart((BaseDocument)this.doc, (int)templateOffset));
        }

        private String getGeneratedCode() {
            return this.newName.toString();
        }

        private int getOffset() {
            return this.node.getStartOffset();
        }
    }

    static class AddImportFix
    implements HintFix {
        private final BaseDocument doc;
        private final NamespaceScope scope;
        private final QualifiedName importName;

        public AddImportFix(BaseDocument doc, NamespaceScope scope, QualifiedName importName) {
            this.doc = doc;
            this.importName = importName;
            this.scope = scope;
        }

        OffsetRange getOffsetRange() {
            return new OffsetRange(this.getOffset(), this.getOffset() + this.getGeneratedCode().length());
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean isSafe() {
            return true;
        }

        public String getDescription() {
            return Bundle.AddUseImportFix_Description(this.getGeneratedCode());
        }

        public void implement() throws Exception {
            int templateOffset = this.getOffset();
            EditList edits = new EditList(this.doc);
            edits.replace(templateOffset, 0, "\n" + this.getGeneratedCode(), true, 0);
            edits.apply();
            UiUtils.open((FileObject)this.scope.getFileObject(), (int)Utilities.getRowStart((BaseDocument)this.doc, (int)this.getOffsetRange().getEnd()));
        }

        private String getGeneratedCode() {
            return "use " + this.importName.toString() + ";";
        }

        private int getOffset() {
            try {
                return Utilities.getRowEnd((BaseDocument)this.doc, (int)this.getReferenceElement().getOffset());
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return 0;
            }
        }

        private ModelElement getReferenceElement() {
            Scope offsetElement = null;
            Collection<? extends UseScope> declaredUses = this.scope.getDeclaredUses();
            for (UseScope useScope : declaredUses) {
                if (offsetElement != null && offsetElement.getOffset() >= useScope.getOffset()) continue;
                offsetElement = useScope;
            }
            return offsetElement != null ? offsetElement : this.scope;
        }
    }

    private class CheckVisitor
    extends DefaultTreePathVisitor {
        private final BaseDocument doc;
        private final PHPRuleContext context;
        private final Collection<Hint> hints = new ArrayList<Hint>();
        private final OffsetRange lineBounds;

        CheckVisitor(PHPRuleContext context, BaseDocument doc, OffsetRange lineBounds) {
            this.doc = doc;
            this.lineBounds = lineBounds;
            this.context = context;
        }

        public Collection<Hint> getHints() {
            return this.hints;
        }

        @Override
        public void scan(ASTNode node) {
            if (node != null && VerificationUtils.isBefore(node.getStartOffset(), this.lineBounds.getEnd())) {
                super.scan(node);
            }
        }

        @Override
        public void visit(NamespaceName node) {
            if (this.lineBounds.containsInclusive(node.getStartOffset())) {
                QualifiedName nodeName;
                NamespaceDeclaration currenNamespace = null;
                List<ASTNode> path = this.getPath();
                ASTNode parentNode = path.get(0);
                for (ASTNode oneNode : path) {
                    if (!(oneNode instanceof NamespaceDeclaration)) continue;
                    currenNamespace = (NamespaceDeclaration)oneNode;
                }
                if (AddUseImportSuggestion.isFunctionName(parentNode)) {
                    nodeName = QualifiedName.create(node);
                    if (!nodeName.getKind().isFullyQualified()) {
                        Set<FunctionElement> functions = this.context.getIndex().getFunctions(NameKind.exact(nodeName));
                        for (FunctionElement indexedFunction : functions) {
                            this.addImportHints(indexedFunction, nodeName, currenNamespace, node);
                        }
                    }
                    super.visit(node);
                } else if (AddUseImportSuggestion.isClassName(parentNode)) {
                    nodeName = QualifiedName.create(node);
                    if (!nodeName.getKind().isFullyQualified()) {
                        Set<ClassElement> classes = this.context.getIndex().getClasses(NameKind.exact(nodeName));
                        for (ClassElement indexedClass : classes) {
                            this.addImportHints(indexedClass, nodeName, currenNamespace, node);
                        }
                    }
                    super.visit(node);
                } else {
                    nodeName = QualifiedName.create(node);
                    if (!nodeName.getKind().isFullyQualified()) {
                        Set<ConstantElement> constants = this.context.getIndex().getConstants(NameKind.exact(nodeName));
                        for (ConstantElement cnst : constants) {
                            this.addImportHints(cnst, nodeName, currenNamespace, node);
                        }
                    }
                    super.visit(node);
                }
            }
        }

        @Override
        public void visit(Scalar node) {
            if (this.lineBounds.containsInclusive(node.getStartOffset())) {
                QualifiedName nodeName;
                NamespaceDeclaration currenNamespace = null;
                for (ASTNode oneNode : this.getPath()) {
                    if (!(oneNode instanceof NamespaceDeclaration)) continue;
                    currenNamespace = (NamespaceDeclaration)oneNode;
                }
                String stringValue = node.getStringValue();
                if (stringValue != null && stringValue.trim().length() > 0 && node.getScalarType() == Scalar.Type.STRING && !NavUtils.isQuoted(stringValue) && !(nodeName = QualifiedName.create(stringValue)).getKind().isFullyQualified()) {
                    Set<ConstantElement> constants = this.context.getIndex().getConstants(NameKind.exact(nodeName));
                    for (ConstantElement cnst : constants) {
                        this.addImportHints(cnst, nodeName, currenNamespace, node);
                    }
                }
            }
            super.visit(node);
        }

        private void addImportHints(FullyQualifiedElement idxElement, QualifiedName nodeName, NamespaceDeclaration currenNamespace, ASTNode node) {
            QualifiedName indexedName = idxElement.getFullyQualifiedName();
            QualifiedName importName = QualifiedName.getPrefix(indexedName, nodeName, true);
            if (importName != null && this.context.fileScope != null) {
                Collection<? extends UseScope> declaredUses;
                List<UseScope> suitableUses;
                final String retvalStr = importName.toString();
                NamespaceScope currentScope = ModelUtils.getNamespaceScope(currenNamespace, this.context.fileScope);
                if (currentScope != null && (suitableUses = ModelUtils.filter(declaredUses = currentScope.getDeclaredUses(), new ModelUtils.ElementFilter<UseScope>(){

                    @Override
                    public boolean isAccepted(UseScope element) {
                        return element.getName().equalsIgnoreCase(retvalStr);
                    }
                })).isEmpty()) {
                    QualifiedName name;
                    if (idxElement instanceof ClassElement || !nodeName.getKind().isUnqualified()) {
                        AddImportFix importFix = new AddImportFix(this.doc, currentScope, importName);
                        this.hints.add(new Hint((Rule)AddUseImportSuggestion.this, importFix.getDescription(), this.context.parserResult.getSnapshot().getSource().getFileObject(), new OffsetRange(node.getStartOffset(), node.getEndOffset()), Collections.singletonList(importFix), 500));
                    }
                    if ((name = VariousUtils.getPreferredName(indexedName, currentScope)) != null) {
                        ChangeNameFix changeNameFix = new ChangeNameFix(this.doc, node, currentScope, name, nodeName);
                        this.hints.add(new Hint((Rule)AddUseImportSuggestion.this, changeNameFix.getDescription(), this.context.parserResult.getSnapshot().getSource().getFileObject(), new OffsetRange(node.getStartOffset(), node.getEndOffset()), Collections.singletonList(changeNameFix), 500));
                    }
                }
            }
        }
    }
}

