/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.BreakStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ContinueStatement;
import org.netbeans.modules.php.editor.parser.astnodes.DoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ForEachStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ForStatement;
import org.netbeans.modules.php.editor.parser.astnodes.SwitchStatement;
import org.netbeans.modules.php.editor.parser.astnodes.WhileStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultTreePathVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.netbeans.modules.php.editor.verification.UnhandledErrorRule;
import org.netbeans.modules.php.editor.verification.VerificationError;
import org.openide.filesystems.FileObject;

public class LoopOnlyKeywordsUnhandledError
extends UnhandledErrorRule {
    @Override
    public void invoke(PHPRuleContext context, List<Error> errors) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileObject fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileObject != null) {
            CheckVisitor checkVisitor = new CheckVisitor(fileObject);
            phpParseResult.getProgram().accept(checkVisitor);
            errors.addAll(checkVisitor.getErrors());
        }
    }

    public String getDisplayName() {
        return Bundle.LoopOnlyKeywordsDispName();
    }

    private static class LoopOnlyKeywordsError
    extends VerificationError {
        private static final String KEY = "Loop.Only.Keywors.Error";
        private final String nameOfKeyword;

        public LoopOnlyKeywordsError(FileObject fileObject, int startOffset, int endOffset, String nameOfKeyword) {
            super(fileObject, startOffset, endOffset);
            this.nameOfKeyword = nameOfKeyword;
        }

        public String getDisplayName() {
            return Bundle.LoopOnlyKeywordsDisp(this.nameOfKeyword);
        }

        public String getDescription() {
            return Bundle.LoopOnlyKeywordsDesc();
        }

        public String getKey() {
            return KEY;
        }
    }

    private static class CheckVisitor
    extends DefaultTreePathVisitor {
        private final FileObject fileObject;
        private static final String CONTINUE = "continue";
        private static final String BREAK = "break";
        private final List<VerificationError> errors = new ArrayList<VerificationError>();

        public CheckVisitor(FileObject fileObject) {
            this.fileObject = fileObject;
        }

        public Collection<VerificationError> getErrors() {
            return Collections.unmodifiableCollection(this.errors);
        }

        @Override
        public void visit(ContinueStatement node) {
            this.checkProperPath(node);
            super.visit(node);
        }

        @Override
        public void visit(BreakStatement node) {
            this.checkProperPath(node);
            super.visit(node);
        }

        private void checkProperPath(ASTNode node) {
            if (!this.isInProperControlStructure()) {
                this.createError(node);
            }
        }

        private boolean isInProperControlStructure() {
            boolean result = false;
            for (ASTNode node : this.getPath()) {
                if (!CheckVisitor.isProperStructure(node)) continue;
                result = true;
                break;
            }
            return result;
        }

        private static boolean isProperStructure(ASTNode node) {
            return node instanceof ForStatement || node instanceof ForEachStatement || node instanceof WhileStatement || node instanceof DoStatement || node instanceof SwitchStatement;
        }

        private void createError(ASTNode node) {
            this.errors.add(new LoopOnlyKeywordsError(this.fileObject, node.getStartOffset(), node.getEndOffset(), this.extractKeyword(node)));
        }

        private String extractKeyword(ASTNode node) {
            String result = "";
            if (node instanceof ContinueStatement) {
                result = CONTINUE;
            } else if (node instanceof BreakStatement) {
                result = BREAK;
            }
            return result;
        }
    }
}

