/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic;

import org.clang.basic.Diagnostic;
import org.clang.basic.DiagnosticMapping;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.SourceLocation;
import org.clang.basic.diag;
import org.clang.basic.impl.DiagnosticIDsStatics;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.type;
import org.llvm.adt.RefCountedBase;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.SmallVectorImplUInt;
import org.llvm.adt.aliases.SmallVectorUInt;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;

public class DiagnosticIDs
extends RefCountedBase<DiagnosticIDs>
implements Destructors.ClassWithDestructor {
    private diag.CustomDiagInfo CustomDiagInfo = null;

    public void $destroy() {
        if (this.CustomDiagInfo != null) {
            this.CustomDiagInfo.$destroy();
        }
    }

    public String toString() {
        return "DiagnosticIDs{" + this.CustomDiagInfo + '}';
    }

    public long getCustomDiagID(Level L, StringRef FormatString) {
        if (this.CustomDiagInfo == null) {
            this.CustomDiagInfo = new diag.CustomDiagInfo();
        }
        return this.CustomDiagInfo.getOrCreateDiagID(L, FormatString, this);
    }

    public StringRef getDescription(long DiagID) {
        DiagnosticIDsStatics.StaticDiagInfoRec Info2 = DiagnosticIDsStatics.GetDiagInfo(DiagID);
        if (Info2 != null) {
            return Info2.getDescription();
        }
        assert (this.CustomDiagInfo != null) : "Invalid CustomDiagInfo";
        return this.CustomDiagInfo.getDescription(DiagID);
    }

    public static Level toLevel(diag.Severity SV) {
        switch (SV) {
            case Ignored: {
                return Level.Ignored;
            }
            case Remark: {
                return Level.Remark;
            }
            case Warning: {
                return Level.Warning;
            }
            case Error: {
                return Level.Error;
            }
            case Fatal: {
                return Level.Fatal;
            }
        }
        throw new llvm_unreachable((CharSequence)"unexpected severity");
    }

    public static boolean isBuiltinWarningOrExtension(long DiagID) {
        return DiagID < 4720L && DiagnosticIDsStatics.getBuiltinDiagClass(DiagID) != 5;
    }

    public static boolean isDefaultMappingAsError(long DiagID) {
        if (DiagID >= 4720L) {
            return false;
        }
        return DiagnosticIDsStatics.GetDefaultDiagMapping(DiagID).getSeverity() == diag.Severity.Error;
    }

    public static boolean isBuiltinNote(int DiagID) {
        return DiagID < 4720 && DiagnosticIDsStatics.getBuiltinDiagClass(DiagID) == 1;
    }

    public static boolean isBuiltinExtensionDiag(long DiagID, bool.ref EnabledByDefault) {
        if (DiagID >= 4720L || DiagnosticIDsStatics.getBuiltinDiagClass(DiagID) != 4) {
            return false;
        }
        EnabledByDefault.$set(DiagnosticIDsStatics.GetDefaultDiagMapping(DiagID).getSeverity() != diag.Severity.Ignored);
        return true;
    }

    public static StringRef getWarningOptionForDiag(long DiagID) {
        DiagnosticIDsStatics.StaticDiagInfoRec Info2 = DiagnosticIDsStatics.GetDiagInfo(DiagID);
        if (Info2 != null) {
            return DiagnosticIDsStatics.OptionTable[(int)Info2.getOptionGroupIndex()].getName();
        }
        return new StringRef();
    }

    public static int getCategoryNumberForDiag(int DiagID) {
        DiagnosticIDsStatics.StaticDiagInfoRec Info2 = DiagnosticIDsStatics.GetDiagInfo(DiagID);
        if (Info2 != null) {
            return Info2.Category;
        }
        return 0;
    }

    public static int getNumberOfCategories() {
        return llvm.array_lengthof((Object[])DiagnosticIDsStatics.CategoryNameTable) - 1;
    }

    public static StringRef getCategoryNameFromID(long CategoryID) {
        if (CategoryID >= (long)DiagnosticIDs.getNumberOfCategories()) {
            return new StringRef();
        }
        return DiagnosticIDsStatics.CategoryNameTable[(int)CategoryID].getName();
    }

    public static boolean isARCDiagnostic(int DiagID) {
        int cat = DiagnosticIDs.getCategoryNumberForDiag(DiagID);
        return DiagnosticIDs.getCategoryNameFromID(cat).startswith((CharSequence)"ARC ");
    }

    public static SFINAEResponse getDiagnosticSFINAEResponse(int DiagID) {
        DiagnosticIDsStatics.StaticDiagInfoRec Info2 = DiagnosticIDsStatics.GetDiagInfo(DiagID);
        if (Info2 != null) {
            return Info2.SFINAE;
        }
        return SFINAEResponse.SFINAE_Report;
    }

    public boolean getDiagnosticsInGroup(diag.Flavor Flavor2, StringRef Group, SmallVectorImplUInt Diags) {
        type.ptr end_ptr = NativePointer.create_type$ptr((Object[])DiagnosticIDsStatics.OptionTable, (long)DiagnosticIDsStatics.OptionTableSize);
        type.ptr Found = (type.ptr)std.lower_bound((type.iterator)NativePointer.create_type$ptr((Object[])DiagnosticIDsStatics.OptionTable), (type.iterator)end_ptr, (Object)Group, (Native.ComparatorLower)DiagnosticIDsStatics.WarningOptionComparator);
        if (Found.$eq((Object)end_ptr) || llvm.$noteq_StringRef((StringRef)((DiagnosticIDsStatics.WarningOption)Found.$star()).getName(), (StringRef)Group)) {
            return true;
        }
        return DiagnosticIDsStatics.getDiagnosticsInGroup(Flavor2, (DiagnosticIDsStatics.WarningOption)Found.$star(), Diags);
    }

    public void getAllDiagnostics(diag.Flavor Flavor2, SmallVectorImplUInt Diags) {
        for (int i = 0; i != DiagnosticIDsStatics.StaticDiagInfoSize; ++i) {
            if (DiagnosticIDsStatics.StaticDiagInfo[i].getFlavor() != Flavor2) continue;
            Diags.push_back((long)DiagnosticIDsStatics.StaticDiagInfo[i].DiagID);
        }
    }

    public static StringRef getNearestWarningOption(StringRef Group) {
        StringRef Best = new StringRef();
        int BestDistance = Group.size() + 1;
        for (DiagnosticIDsStatics.WarningOption i : DiagnosticIDsStatics.OptionTable) {
            if (i.Members == '\u0000' && i.SubGroups == '\u0000') continue;
            int Distance = i.getName().edit_distance(Group, true, BestDistance);
            if (Distance == BestDistance) {
                Best.$assign(StringRef.EMPTY);
                continue;
            }
            if (Distance >= BestDistance) continue;
            Best.$assign(i.getName());
            BestDistance = Distance;
        }
        return Best;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringRef getNearestOption(diag.Flavor Flavor2, StringRef Group) {
        StringRef Best = new StringRef();
        int BestDistance = Group.size() + 1;
        int e = (int)DiagnosticIDsStatics.OptionTableSize;
        for (int i = 0; i != e; ++i) {
            SmallVectorUInt Diags = null;
            try {
                int Distance;
                if (DiagnosticIDsStatics.OptionTable[i].Members == '\u0000' && DiagnosticIDsStatics.OptionTable[i].SubGroups == '\u0000' || (Distance = DiagnosticIDsStatics.OptionTable[i].getName().edit_distance(Group, true, BestDistance)) > BestDistance || DiagnosticIDsStatics.getDiagnosticsInGroup(Flavor2, DiagnosticIDsStatics.OptionTable[i], (SmallVectorImplUInt)(Diags = new SmallVectorUInt(8, 0L))) || Diags.empty()) continue;
                if (Distance == BestDistance) {
                    Best.$assign(NativePointer.$((String)""));
                    continue;
                }
                if (Distance >= BestDistance) continue;
                Best.$assign(DiagnosticIDsStatics.OptionTable[i].getName());
                BestDistance = Distance;
                continue;
            }
            finally {
                if (Diags != null) {
                    Diags.$destroy();
                }
            }
        }
        return Best;
    }

    Level getDiagnosticLevel(long DiagID, SourceLocation Loc, DiagnosticsEngine Diag) {
        if (DiagID >= 4720L) {
            assert (this.CustomDiagInfo != null) : "Invalid CustomDiagInfo";
            return this.CustomDiagInfo.getLevel(DiagID);
        }
        long DiagClass = DiagnosticIDsStatics.getBuiltinDiagClass(DiagID);
        if (DiagClass == 1L) {
            return Level.Note;
        }
        return DiagnosticIDs.toLevel(this.getDiagnosticSeverity(DiagID, Loc, Diag));
    }

    diag.Severity getDiagnosticSeverity(long DiagID, SourceLocation Loc, DiagnosticsEngine Diag) {
        boolean ShowInSystemHeader;
        assert (DiagnosticIDsStatics.getBuiltinDiagClass(DiagID) != 1);
        diag.Severity Result = diag.Severity.Fatal;
        DiagnosticsEngine.DiagStatePoint Pos = Diag.GetDiagStatePointForLoc(Loc);
        DiagnosticsEngine.DiagState State = Pos.State;
        DiagnosticMapping Mapping2 = State.getOrAddMapping(DiagID);
        if (Mapping2.getSeverity() != diag.Severity.Uncomputed) {
            Result = Mapping2.getSeverity();
        }
        if (Diag.EnableAllWarnings && Result == diag.Severity.Ignored && !Mapping2.isUser() && DiagnosticIDsStatics.getBuiltinDiagClass(DiagID) != 2) {
            Result = diag.Severity.Warning;
        }
        bool.ref EnabledByDefault = NativePointer.create_bool$ref((boolean)false);
        boolean IsExtensionDiag = DiagnosticIDs.isBuiltinExtensionDiag(DiagID, EnabledByDefault);
        if (Diag.AllExtensionsSilenced != 0 && IsExtensionDiag && !EnabledByDefault.$deref()) {
            return diag.Severity.Ignored;
        }
        if (IsExtensionDiag && !Mapping2.isUser()) {
            Result = (diag.Severity)std.max((Enum)Result, (Enum)Diag.ExtBehavior);
        }
        if (Result == diag.Severity.Ignored) {
            return Result;
        }
        if (Result == diag.Severity.Warning && Diag.IgnoreAllWarnings) {
            return diag.Severity.Ignored;
        }
        if (Result == diag.Severity.Warning && Diag.WarningsAsErrors && !Mapping2.hasNoWarningAsError()) {
            Result = diag.Severity.Error;
        }
        if (Result == diag.Severity.Error && Diag.ErrorsAsFatal && !Mapping2.hasNoErrorAsFatal()) {
            Result = diag.Severity.Fatal;
        }
        boolean bl = ShowInSystemHeader = DiagnosticIDsStatics.GetDiagInfo(DiagID) == null || DiagnosticIDsStatics.GetDiagInfo((long)DiagID).WarnShowInSystemHeader;
        if (Diag.SuppressSystemWarnings && !ShowInSystemHeader && Loc.isValid() && Diag.getSourceManager().isInSystemHeader(Diag.getSourceManager().getExpansionLoc(Loc))) {
            return diag.Severity.Ignored;
        }
        return Result;
    }

    boolean ProcessDiag(DiagnosticsEngine Diag) {
        Diagnostic Info2 = new Diagnostic(Diag);
        assert (Diag.getClient() != null) : "DiagnosticClient not set!";
        long DiagID = Info2.getID();
        Level DiagLevel = this.getDiagnosticLevel(DiagID, Info2.getLocation(), Diag);
        if (DiagLevel.getValue() >= Level.Error.getValue()) {
            ++Diag.TrapNumErrorsOccurred;
            if (this.isUnrecoverable(DiagID)) {
                ++Diag.TrapNumUnrecoverableErrorsOccurred;
            }
        }
        if (Diag.SuppressAllDiagnostics) {
            return false;
        }
        if (DiagLevel != Level.Note) {
            if (Diag.LastDiagLevel == Level.Fatal) {
                Diag.FatalErrorOccurred = true;
            }
            Diag.LastDiagLevel = DiagLevel;
        }
        if (Diag.FatalErrorOccurred) {
            if (DiagLevel.getValue() >= Level.Error.getValue() && Diag.Client.IncludeInDiagnosticCounts()) {
                ++Diag.NumErrors;
            }
            return false;
        }
        if (DiagLevel == Level.Ignored || DiagLevel == Level.Note && Diag.LastDiagLevel == Level.Ignored) {
            return false;
        }
        if (DiagLevel.getValue() >= Level.Error.getValue()) {
            if (this.isUnrecoverable(DiagID)) {
                Diag.UnrecoverableErrorOccurred = true;
            }
            if (DiagnosticIDs.isDefaultMappingAsError(DiagID)) {
                Diag.UncompilableErrorOccurred = true;
            }
            Diag.ErrorOccurred = true;
            if (Diag.Client.IncludeInDiagnosticCounts()) {
                ++Diag.NumErrors;
            }
            if (Diag.ErrorLimit != 0 && Diag.NumErrors > Diag.ErrorLimit && DiagLevel == Level.Error) {
                Diag.SetDelayedDiagnostic(39);
                return false;
            }
        }
        this.EmitDiag(Diag, DiagLevel);
        return true;
    }

    void EmitDiag(DiagnosticsEngine Diag, Level DiagLevel) {
        Diagnostic Info2 = new Diagnostic(Diag);
        assert (DiagLevel != Level.Ignored) : "Cannot emit ignored diagnostics!";
        Diag.Client.HandleDiagnostic(DiagnosticsEngine.Level.valueOf(DiagLevel.getValue()), Info2);
        if (Diag.Client.IncludeInDiagnosticCounts() && DiagLevel == Level.Warning) {
            ++Diag.NumWarnings;
        }
        Diag.CurDiagID = -1L;
    }

    private boolean isUnrecoverable(long DiagID) {
        if (DiagID >= 4720L) {
            assert (this.CustomDiagInfo != null) : "Invalid CustomDiagInfo";
            return this.CustomDiagInfo.getLevel(DiagID).getValue() >= Level.Error.getValue();
        }
        if (DiagnosticIDsStatics.getBuiltinDiagClass(DiagID) < 5) {
            return false;
        }
        if (DiagID == 2985L || DiagID == 2986L) {
            return false;
        }
        return !DiagnosticIDs.isARCDiagnostic((int)DiagID);
    }

    public static final class SFINAEResponse
    extends Enum<SFINAEResponse> {
        public static final /* enum */ SFINAEResponse SFINAE_SubstitutionFailure = new SFINAEResponse(0);
        public static final /* enum */ SFINAEResponse SFINAE_Suppress = new SFINAEResponse(1);
        public static final /* enum */ SFINAEResponse SFINAE_Report = new SFINAEResponse(2);
        public static final /* enum */ SFINAEResponse SFINAE_AccessControl = new SFINAEResponse(3);
        private final int value;
        private static final /* synthetic */ SFINAEResponse[] $VALUES;

        public static SFINAEResponse[] values() {
            return (SFINAEResponse[])$VALUES.clone();
        }

        public static SFINAEResponse valueOf(String name) {
            return Enum.valueOf(SFINAEResponse.class, name);
        }

        public static SFINAEResponse valueOf(int val) {
            SFINAEResponse out;
            SFINAEResponse sFINAEResponse = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private SFINAEResponse(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new SFINAEResponse[]{SFINAE_SubstitutionFailure, SFINAE_Suppress, SFINAE_Report, SFINAE_AccessControl};
        }

        private static final class Values {
            private static final SFINAEResponse[] VALUES;
            private static final SFINAEResponse[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (SFINAEResponse kind : SFINAEResponse.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new SFINAEResponse[min < 0 ? 1 - min : 0];
                VALUES = new SFINAEResponse[max >= 0 ? 1 + max : 0];
                for (SFINAEResponse kind : SFINAEResponse.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((SFINAEResponse)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((SFINAEResponse)kind).value] = kind;
                }
            }
        }
    }

    public static final class Level
    extends Enum<Level> {
        public static final /* enum */ Level Ignored = new Level(0);
        public static final /* enum */ Level Note = new Level(Ignored.getValue() + 1);
        public static final /* enum */ Level Remark = new Level(Note.getValue() + 1);
        public static final /* enum */ Level Warning = new Level(Remark.getValue() + 1);
        public static final /* enum */ Level Error = new Level(Warning.getValue() + 1);
        public static final /* enum */ Level Fatal = new Level(Error.getValue() + 1);
        private final int value;
        private static final /* synthetic */ Level[] $VALUES;

        public static Level[] values() {
            return (Level[])$VALUES.clone();
        }

        public static Level valueOf(String name) {
            return Enum.valueOf(Level.class, name);
        }

        public static Level valueOf(int val) {
            Level out;
            Level level = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private Level(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new Level[]{Ignored, Note, Remark, Warning, Error, Fatal};
        }

        private static final class Values {
            private static final Level[] VALUES;
            private static final Level[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (Level kind : Level.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new Level[min < 0 ? 1 - min : 0];
                VALUES = new Level[max >= 0 ? 1 + max : 0];
                for (Level kind : Level.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((Level)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((Level)kind).value] = kind;
                }
            }
        }
    }
}

