/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic;

import org.clang.basic.ClankAliases;
import org.clang.basic.DirectoryEntry;
import org.clang.basic.FileEntry;
import org.clang.basic.FileManager;
import org.clang.basic.LangOptions;
import org.clang.basic.SourceLocation;
import org.clang.basic.impl.ModuleStatics;
import org.clang.basic.target.TargetInfo;
import org.clank.java.std;
import org.clank.java.stdimpl.aliases.StdVector;
import org.clank.java.stdimpl.aliases.StdVectorString;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.NativePointer;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.type;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.DenseMapInfo;
import org.llvm.adt.DenseMapInfoObject;
import org.llvm.adt.PointerUnion;
import org.llvm.adt.SmallSetVector;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.DenseSet;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.aliases.StringMapConstIteratorUInt;
import org.llvm.adt.aliases.StringMapIteratorUInt;
import org.llvm.adt.aliases.StringMapUInt;
import org.llvm.support.MallocAllocator;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.raw_ostream;

public class Module
implements Destructors.ClassWithDestructor {
    public static final DenseMapInfo<Module> DenseMapInfo = new DenseMapInfoObject((Object)new Module(), (Object)new Module());
    public std.string Name;
    public SourceLocation DefinitionLoc;
    public Module Parent;
    private static final DenseMapInfo<Module> DenseMapInfoModule = new DenseMapInfoObject((Object)new Module(), (Object)new Module());
    public DirectoryEntry Directory;
    public PointerUnion<DirectoryEntry, FileEntry> Umbrella;
    private std.vector<Module> SubModules;
    private StringMapUInt<MallocAllocator> SubModuleIndex;
    private FileEntry ASTFile;
    private SmallSetVector<FileEntry> TopHeaders;
    private std.vectorString TopHeaderNames;
    private DenseSet<Module> VisibleModulesCache;
    public static int NumHeaderKinds = HeaderKind.HK_Excluded.getValue() + 1;
    public SmallVector<Header>[] Headers = new SmallVector[5];
    public SmallVector<UnresolvedHeaderDirective> MissingHeaders;
    public SmallVector<Requirement> Requirements;
    public boolean IsMissingRequirement;
    public boolean IsAvailable;
    public boolean IsFromModuleFile;
    public boolean IsFramework;
    public boolean IsExplicit;
    public boolean IsSystem;
    public boolean IsExternC;
    public boolean IsInferred;
    public boolean InferSubmodules;
    public boolean InferExplicitSubmodules;
    public boolean InferExportWildcard;
    public boolean ConfigMacrosExhaustive;
    public NameVisibilityKind NameVisibility;
    public SourceLocation MacroVisibilityLoc;
    public SourceLocation InferredSubmoduleLoc;
    public SmallVector<Module> Imports;
    public SmallVector<ADTAliases.PointerInt2Pair<Module>> Exports;
    public SmallVector<UnresolvedExportDecl> UnresolvedExports;
    public SmallVector<Module> DirectUses;
    public SmallVector<ClankAliases.ModuleId> UnresolvedDirectUses;
    public SmallVector<LinkLibrary> LinkLibraries;
    public std.vectorString ConfigMacros;
    public std.vector<UnresolvedConflict> UnresolvedConflicts;
    public std.vector<Conflict> Conflicts;

    public Module() {
    }

    public Module(StringRef Name, SourceLocation DefinitionLoc, Module Parent, boolean IsFramework, boolean IsExplicit) {
        this.Name = new std.string(Name.$basic_string());
        this.DefinitionLoc = new SourceLocation(DefinitionLoc);
        this.Parent = Parent;
        this.Directory = null;
        this.Umbrella = new PointerUnion();
        this.SubModules = new std.vector((Object)null);
        this.SubModuleIndex = new StringMapUInt(0L);
        this.ASTFile = null;
        this.TopHeaders = new SmallSetVector(2L, (Object)null);
        this.TopHeaderNames = new std.vectorString(std.string.EMPTY);
        this.VisibleModulesCache = new DenseSet(DenseMapInfoModule);
        this.Headers = new SmallVector[5];
        this.MissingHeaders = new SmallVector(null);
        this.Requirements = new SmallVector(2, (Object)new Requirement());
        this.IsMissingRequirement = false;
        this.IsAvailable = true;
        this.IsFromModuleFile = false;
        this.IsFramework = IsFramework;
        this.IsExplicit = IsExplicit;
        this.IsSystem = false;
        this.IsExternC = false;
        this.IsInferred = false;
        this.InferSubmodules = false;
        this.InferExplicitSubmodules = false;
        this.InferExportWildcard = false;
        this.ConfigMacrosExhaustive = false;
        this.NameVisibility = NameVisibilityKind.Hidden;
        this.MacroVisibilityLoc = new SourceLocation();
        this.InferredSubmoduleLoc = new SourceLocation();
        this.Imports = new SmallVector(2, (Object)null);
        this.Exports = new SmallVector(2, (Object)new ADTAliases.PointerInt2Pair());
        this.UnresolvedExports = new SmallVector(2, (Object)new UnresolvedExportDecl());
        this.DirectUses = new SmallVector(2, (Object)null);
        this.UnresolvedDirectUses = new SmallVector(2, (Object)new ClankAliases.ModuleId());
        this.LinkLibraries = new SmallVector(2, (Object)new LinkLibrary());
        this.ConfigMacros = new std.vectorString(new std.string());
        this.UnresolvedConflicts = new std.vector((Object)new UnresolvedConflict());
        this.Conflicts = new std.vector((Object)new Conflict());
        if (Parent != null) {
            if (!Parent.isAvailable()) {
                this.IsAvailable = false;
            }
            if (Parent.IsSystem) {
                this.IsSystem = true;
            }
            if (Parent.IsExternC) {
                this.IsExternC = true;
            }
            this.IsMissingRequirement = Parent.IsMissingRequirement;
            Parent.SubModuleIndex.GetOrCreateValue((StringRef)Name).second = Parent.SubModules.size();
            Parent.SubModules.push_back((Object)this);
        }
    }

    public void $destroy() {
        StdVector.iterator<Module> I = this.submodule_begin();
        StdVector.iterator<Module> IEnd = this.submodule_end();
        while (std.$noteq___normal_iterator(I, IEnd)) {
            if (I.$star() != null) {
                ((Module)I.$star()).$destroy();
            }
            I.$preInc();
        }
        this.Conflicts.$destroy();
        this.UnresolvedConflicts.$destroy();
        this.ConfigMacros.$destroy();
        this.LinkLibraries.$destroy();
        this.UnresolvedDirectUses.$destroy();
        this.DirectUses.$destroy();
        this.UnresolvedExports.$destroy();
        this.Exports.$destroy();
        this.Imports.$destroy();
        this.Requirements.$destroy();
        this.MissingHeaders.$destroy();
        this.Headers = null;
        this.VisibleModulesCache.$destroy();
        this.TopHeaderNames.$destroy();
        this.TopHeaders.$destroy();
        this.SubModuleIndex.$destroy();
        this.SubModules.$destroy();
        this.Name.$destroy();
    }

    public boolean isAvailable() {
        return this.IsAvailable;
    }

    public boolean isAvailable(LangOptions LangOpts, TargetInfo Target, std.pairTypeBool<std.string> Req, UnresolvedHeaderDirective MissingHeader) {
        if (this.IsAvailable) {
            return true;
        }
        Module Current = this;
        while (Current != null) {
            if (!Current.MissingHeaders.empty()) {
                MissingHeader.$assign((UnresolvedHeaderDirective)Current.MissingHeaders.front());
                return false;
            }
            long N = Current.Requirements.size();
            for (long I = 0L; I != N; ++I) {
                if (ModuleStatics.hasFeature(new StringRef((std.string)((Requirement)((Object)Current.Requirements.$at((long)I))).first), LangOpts, Target) == ((Requirement)((Object)Current.Requirements.$at((long)I))).second) continue;
                Req.$assign((std.pairTypeBool)Current.Requirements.$at(I));
                return false;
            }
            Current = Current.Parent;
        }
        throw new llvm_unreachable((CharSequence)"could not find a reason why module is unavailable");
    }

    public boolean isSubModule() {
        return this.Parent != null;
    }

    public boolean isSubModuleOf(Module Other) {
        Module This = this;
        do {
            if (This != Other) continue;
            return true;
        } while ((This = This.Parent) != null);
        return false;
    }

    public boolean isPartOfFramework() {
        Module Mod = this;
        while (Mod != null) {
            if (Mod.IsFramework) {
                return true;
            }
            Mod = Mod.Parent;
        }
        return false;
    }

    public boolean isSubFramework() {
        return this.IsFramework && this.Parent != null && this.Parent.isPartOfFramework();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public std.string getFullModuleName() {
        SmallVector Names = null;
        std.string Result = null;
        try {
            Names = new SmallVector(2, (Object)new StringRef());
            Module M = this;
            while (M != null) {
                Names.push_back((Object)new StringRef(M.Name));
                M = M.Parent;
            }
            Result = new std.string();
            std.reverse_iterator I = Names.rbegin();
            std.reverse_iterator IEnd = Names.rend();
            while (ADTAliases.$noteq_reverse_iterator((abstract_iterator)I, (abstract_iterator)IEnd)) {
                if (!Result.empty()) {
                    Result.$addassign(NativePointer.$((char)'.'));
                }
                llvm.$addassign_str_StringRef((std.string)Result, (StringRef)new StringRef((StringRef)I.$star()));
                I.$preInc();
            }
            std.string string2 = new std.string(Result);
            return string2;
        }
        finally {
            if (Result != null) {
                Result.$destroy();
            }
            if (Names != null) {
                Names.$destroy();
            }
        }
    }

    public Module getTopLevelModule() {
        Module Result = this;
        while (Result.Parent != null) {
            Result = Result.Parent;
        }
        return Result;
    }

    public StringRef getTopLevelModuleName() {
        return new StringRef(this.getTopLevelModule().Name);
    }

    public FileEntry getASTFile() {
        return this.getTopLevelModule().ASTFile;
    }

    public void setASTFile(FileEntry File2) {
        assert (File2 == null || this.getASTFile() == null || this.getASTFile() == File2) : "file path changed";
        this.getTopLevelModule().ASTFile = File2;
    }

    public DirectoryEntry getUmbrellaDir() {
        FileEntry Header2 = this.getUmbrellaHeader();
        if (Header2 != null) {
            return Header2.getDir();
        }
        return (DirectoryEntry)this.Umbrella.dyn_cast(DirectoryEntry.class);
    }

    public FileEntry getUmbrellaHeader() {
        return (FileEntry)this.Umbrella.dyn_cast(FileEntry.class);
    }

    public boolean hasUmbrellaDir() {
        return this.Umbrella.$boolean() && this.Umbrella.is(DirectoryEntry.class) != 0;
    }

    public void addTopHeader(FileEntry File2) {
        assert (File2 != null);
        this.TopHeaders.insert((Object)File2);
    }

    public void addTopHeaderFilename(StringRef Filename) {
        this.TopHeaderNames.push_back(Filename.$basic_string());
    }

    public ArrayRef<FileEntry> getTopHeaders(FileManager FileMgr) {
        if (!this.TopHeaderNames.empty()) {
            StdVectorString.iterator I = this.TopHeaderNames.begin();
            StdVectorString.iterator E = this.TopHeaderNames.end();
            while (std.$noteq___normal_iterator((StdVectorString.iterator)I, (StdVectorString.iterator)E)) {
                FileEntry FE = FileMgr.getFile(new StringRef(I.$star()));
                if (FE != null) {
                    this.TopHeaders.insert((Object)FE);
                }
                I.$preInc();
            }
            this.TopHeaderNames.clear();
        }
        return llvm.makeArrayRef((type.iterator)this.TopHeaders.begin(), (type.iterator)this.TopHeaders.end());
    }

    public void addRequirement(StringRef Feature2, boolean RequiredState, LangOptions LangOpts, TargetInfo Target) {
        this.Requirements.push_back((Object)new Requirement(Feature2.$basic_string(), RequiredState));
        if (ModuleStatics.hasFeature(new StringRef(Feature2), LangOpts, Target) == RequiredState) {
            return;
        }
        this.markUnavailable(true);
    }

    public void markUnavailable() {
        this.markUnavailable(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markUnavailable(boolean MissingRequirement) {
        SmallVector Stack = null;
        try {
            if (!this.IsAvailable) {
                return;
            }
            Stack = new SmallVector(2, (Object)null);
            Stack.push_back((Object)this);
            while (!Stack.empty()) {
                Module Current = (Module)Stack.back();
                Stack.pop_back();
                if (!Current.IsAvailable) continue;
                Current.IsAvailable = false;
                Current.IsMissingRequirement |= MissingRequirement;
                StdVector.iterator<Module> Sub = Current.submodule_begin();
                StdVector.iterator<Module> SubEnd = Current.submodule_end();
                while (std.$noteq___normal_iterator(Sub, SubEnd)) {
                    if (((Module)Sub.$star()).IsAvailable) {
                        Stack.push_back(Sub.$star());
                    }
                    Sub.$preInc();
                }
            }
        }
        finally {
            if (Stack != null) {
                Stack.$destroy();
            }
        }
    }

    public Module findSubmodule(StringRef Name) {
        StringMapIteratorUInt Pos = this.SubModuleIndex.find(Name);
        if (Pos.$eq((StringMapConstIteratorUInt)this.SubModuleIndex.end())) {
            return null;
        }
        return (Module)this.SubModules.$at(Pos.$arrow().getValue());
    }

    public boolean isModuleVisible(Module M) {
        if (this.VisibleModulesCache.empty()) {
            this.buildVisibleModulesCache();
        }
        return this.VisibleModulesCache.count((Object)M);
    }

    public StdVector.iterator<Module> submodule_begin() {
        return this.SubModules.begin();
    }

    public StdVector.iterator<Module> submodule_end() {
        return this.SubModules.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getExportedModules(SmallVectorImpl<Module> Exported) {
        SmallVector WildcardRestrictions = null;
        try {
            Module Mod;
            long I;
            StdVector.iterator I2 = this.SubModules.begin();
            StdVector.iterator E = this.SubModules.end();
            while (std.$noteq___normal_iterator((StdVector.iterator)I2, (StdVector.iterator)E)) {
                Module Mod2 = (Module)I2.$star();
                if (!Mod2.IsExplicit) {
                    Exported.push_back((Object)Mod2);
                }
                I2.$preInc();
            }
            boolean AnyWildcard = false;
            boolean UnrestrictedWildcard = false;
            WildcardRestrictions = new SmallVector(4, (Object)null);
            long N = this.Exports.size();
            for (I = 0L; I != N; ++I) {
                Mod = (Module)((ADTAliases.PointerInt2Pair)this.Exports.$at(I)).getPointer();
                if (((ADTAliases.PointerInt2Pair)this.Exports.$at(I)).getInt() == 0) {
                    Exported.push_back((Object)Mod);
                    continue;
                }
                AnyWildcard = true;
                if (UnrestrictedWildcard) continue;
                Module Restriction = (Module)((ADTAliases.PointerInt2Pair)this.Exports.$at(I)).getPointer();
                if (Restriction != null) {
                    WildcardRestrictions.push_back((Object)Restriction);
                    continue;
                }
                WildcardRestrictions.clear();
                UnrestrictedWildcard = true;
            }
            if (!AnyWildcard) {
                return;
            }
            N = this.Imports.size();
            for (I = 0L; I != N; ++I) {
                Mod = (Module)this.Imports.$at(I);
                boolean Acceptable = UnrestrictedWildcard;
                if (!Acceptable) {
                    long NR = WildcardRestrictions.size();
                    for (long R = 0L; R != NR; ++R) {
                        Module Restriction = (Module)WildcardRestrictions.$at(R);
                        if (Mod != Restriction && !Mod.isSubModuleOf(Restriction)) continue;
                        Acceptable = true;
                        break;
                    }
                }
                if (!Acceptable) continue;
                Exported.push_back((Object)Mod);
            }
        }
        finally {
            if (WildcardRestrictions != null) {
                WildcardRestrictions.$destroy();
            }
        }
    }

    public static StringRef getModuleInputBufferName() {
        return new StringRef(NativePointer.$((String)"<module-includes>"));
    }

    public void print(raw_ostream OS) {
        this.print(OS, 0L);
    }

    public void print(raw_ostream OS, long Indent) {
        long I;
        class Anonymous {
            public StringRef Prefix;
            public HeaderKind Kind;

            public Anonymous(StringRef Prefix, HeaderKind Kind2) {
                this.Prefix = Prefix;
                this.Kind = Kind2;
            }

            public String toString() {
                return "Prefix=" + this.Prefix + ", Kind=" + (Object)((Object)this.Kind);
            }
        }
        Anonymous[] Kinds;
        FileEntry UmbrellaHeader;
        long N;
        OS.indent(Indent);
        if (this.IsFramework) {
            OS.$out(NativePointer.$((String)"framework "));
        }
        if (this.IsExplicit) {
            OS.$out(NativePointer.$((String)"explicit "));
        }
        OS.$out(NativePointer.$((String)"module ")).$out(this.Name);
        if (this.IsSystem || this.IsExternC) {
            OS.indent(Indent + 2L);
            if (this.IsSystem) {
                OS.$out(NativePointer.$((String)" [system]"));
            }
            if (this.IsExternC) {
                OS.$out(NativePointer.$((String)" [extern_c]"));
            }
        }
        OS.$out(NativePointer.$((String)" {\n"));
        if (!this.Requirements.empty()) {
            OS.indent(Indent + 2L);
            OS.$out(NativePointer.$((String)"requires "));
            N = this.Requirements.size();
            for (long I2 = 0L; I2 != N; ++I2) {
                if (I2 != 0L) {
                    OS.$out(NativePointer.$((String)", "));
                }
                if (!((Requirement)((Object)this.Requirements.$at((long)I2))).second) {
                    OS.$out(NativePointer.$((String)"!"));
                }
                OS.$out((std.string)((Requirement)((Object)this.Requirements.$at((long)I2))).first);
            }
            OS.$out(NativePointer.$((String)"\n"));
        }
        if ((UmbrellaHeader = this.getUmbrellaHeader()) != null) {
            OS.indent(Indent + 2L);
            OS.$out(NativePointer.$((String)"umbrella header \""));
            OS.write_escaped(new StringRef(UmbrellaHeader.getName()));
            OS.$out(NativePointer.$((String)"\"\n"));
        } else {
            Anonymous[] UmbrellaDir = this.getUmbrellaDir();
            if (UmbrellaDir != null) {
                OS.indent(Indent + 2L);
                OS.$out(NativePointer.$((String)"umbrella \""));
                OS.write_escaped(new StringRef(UmbrellaDir.getName(), UmbrellaDir.getNameLen()));
                OS.$out(NativePointer.$((String)"\"\n"));
            }
        }
        if (!this.ConfigMacros.empty() || this.ConfigMacrosExhaustive) {
            OS.indent(Indent + 2L);
            OS.$out(NativePointer.$((String)"config_macros "));
            if (this.ConfigMacrosExhaustive) {
                OS.$out(NativePointer.$((String)"[exhaustive]"));
            }
            N = this.ConfigMacros.size();
            for (long I3 = 0L; I3 != N; ++I3) {
                if (I3 != 0L) {
                    OS.$out(NativePointer.$((String)", "));
                }
                OS.$out(this.ConfigMacros.$at(I3));
            }
            OS.$out(NativePointer.$((String)"\n"));
        }
        for (Anonymous K : Kinds = new Anonymous[]{new Anonymous(new StringRef((CharSequence)""), HeaderKind.HK_Normal), new Anonymous(new StringRef((CharSequence)"textual "), HeaderKind.HK_Textual), new Anonymous(new StringRef((CharSequence)"private "), HeaderKind.HK_Private), new Anonymous(new StringRef((CharSequence)"private textual "), HeaderKind.HK_PrivateTextual), new Anonymous(new StringRef((CharSequence)"exclude "), HeaderKind.HK_Excluded)}) {
            for (Header H : this.Headers[K.Kind.getValue()]) {
                OS.indent(Indent + 2L);
                OS.$out(new StringRef(K.Prefix)).$out(NativePointer.$((String)"header \""));
                OS.write_escaped(new StringRef(H.NameAsWritten));
                OS.$out(NativePointer.$((String)"\"\n"));
            }
        }
        StdVector.iterator<Module> MI = this.submodule_begin();
        StdVector.iterator<Module> MIEnd = this.submodule_end();
        while (std.$noteq___normal_iterator(MI, MIEnd)) {
            if (!((Module)MI.$star()).IsInferred || ((Module)MI.$star()).IsFramework) {
                ((Module)MI.$star()).print(OS, Indent + 2L);
            }
            MI.$preInc();
        }
        long N2 = this.Exports.size();
        for (I = 0L; I != N2; ++I) {
            OS.indent(Indent + 2L);
            OS.$out(NativePointer.$((String)"export "));
            Module Restriction = (Module)((ADTAliases.PointerInt2Pair)this.Exports.$at(I)).getPointer();
            if (Restriction != null) {
                OS.$out(Restriction.getFullModuleName());
                if (((ADTAliases.PointerInt2Pair)this.Exports.$at(I)).getInt() != 0) {
                    OS.$out((CharSequence)".*");
                }
            } else {
                OS.$out(NativePointer.$((String)"*"));
            }
            OS.$out(NativePointer.$((String)"\n"));
        }
        N2 = this.UnresolvedExports.size();
        for (I = 0L; I != N2; ++I) {
            OS.indent(Indent + 2L);
            OS.$out(NativePointer.$((String)"export "));
            ModuleStatics.printModuleId(OS, ((UnresolvedExportDecl)this.UnresolvedExports.$at((long)I)).Id);
            if (((UnresolvedExportDecl)this.UnresolvedExports.$at((long)I)).Wildcard) {
                if (((UnresolvedExportDecl)this.UnresolvedExports.$at((long)I)).Id.empty()) {
                    OS.$out(NativePointer.$((String)"*"));
                } else {
                    OS.$out(NativePointer.$((String)".*"));
                }
            }
            OS.$out(NativePointer.$((String)"\n"));
        }
        N2 = this.DirectUses.size();
        for (I = 0L; I != N2; ++I) {
            OS.indent(Indent + 2L);
            OS.$out(NativePointer.$((String)"use "));
            OS.$out(((Module)this.DirectUses.$at(I)).getFullModuleName());
            OS.$out(NativePointer.$((String)"\n"));
        }
        N2 = this.UnresolvedDirectUses.size();
        for (I = 0L; I != N2; ++I) {
            OS.indent(Indent + 2L);
            OS.$out(NativePointer.$((String)"use "));
            ModuleStatics.printModuleId(OS, (ClankAliases.ModuleId)((Object)this.UnresolvedDirectUses.$at(I)));
            OS.$out(NativePointer.$((String)"\n"));
        }
        N2 = this.LinkLibraries.size();
        for (I = 0L; I != N2; ++I) {
            OS.indent(Indent + 2L);
            OS.$out(NativePointer.$((String)"link "));
            if (((LinkLibrary)this.LinkLibraries.$at((long)I)).IsFramework) {
                OS.$out(NativePointer.$((String)"framework "));
            }
            OS.$out(NativePointer.$((String)"\""));
            OS.write_escaped(new StringRef(((LinkLibrary)this.LinkLibraries.$at((long)I)).Library));
            OS.$out(NativePointer.$((String)"\""));
        }
        N2 = this.UnresolvedConflicts.size();
        for (I = 0L; I != N2; ++I) {
            OS.indent(Indent + 2L);
            OS.$out(NativePointer.$((String)"conflict "));
            ModuleStatics.printModuleId(OS, ((UnresolvedConflict)this.UnresolvedConflicts.$at((long)I)).Id);
            OS.$out(NativePointer.$((String)", \""));
            OS.write_escaped(new StringRef(((UnresolvedConflict)this.UnresolvedConflicts.$at((long)I)).Message));
            OS.$out(NativePointer.$((String)"\"\n"));
        }
        N2 = this.Conflicts.size();
        for (I = 0L; I != N2; ++I) {
            OS.indent(Indent + 2L);
            OS.$out(NativePointer.$((String)"conflict "));
            OS.$out(((Conflict)this.Conflicts.$at((long)I)).Other.getFullModuleName());
            OS.$out(NativePointer.$((String)", \""));
            OS.write_escaped(new StringRef(((Conflict)this.Conflicts.$at((long)I)).Message));
            OS.$out(NativePointer.$((String)"\"\n"));
        }
        if (this.InferSubmodules) {
            OS.indent(Indent + 2L);
            if (this.InferExplicitSubmodules) {
                OS.$out(NativePointer.$((String)"explicit "));
            }
            OS.$out(NativePointer.$((String)"module * {\n"));
            if (this.InferExportWildcard) {
                OS.indent(Indent + 4L);
                OS.$out(NativePointer.$((String)"export *\n"));
            }
            OS.indent(Indent + 2L);
            OS.$out(NativePointer.$((String)"}\n"));
        }
        OS.indent(Indent);
        OS.$out(NativePointer.$((String)"}\n"));
    }

    public void dump() {
        this.print(llvm.errs());
    }

    private void buildVisibleModulesCache() {
        SmallVector Stack = null;
        try {
            assert (this.VisibleModulesCache.empty()) : "cache does not need building";
            this.VisibleModulesCache.insert((Object)this);
            Stack = new SmallVector(16, (type.iterator)this.Imports.begin(), (type.iterator)this.Imports.end(), (Object)null);
            while (!Stack.empty()) {
                Module CurrModule = (Module)Stack.pop_back_val();
                if (!this.VisibleModulesCache.insert((Object)CurrModule).second) continue;
                CurrModule.getExportedModules((SmallVectorImpl<Module>)Stack);
            }
        }
        finally {
            if (Stack != null) {
                Stack.$destroy();
            }
        }
    }

    public String toString() {
        return "Name=" + this.Name + ", DefinitionLoc=" + this.DefinitionLoc + ", Parent=" + this.Parent + ", Directory=" + this.Directory + ", Umbrella=" + this.Umbrella + ", SubModules=" + this.SubModules + ", SubModuleIndex=" + this.SubModuleIndex + ", ASTFile=" + this.ASTFile + ", TopHeaders=" + this.TopHeaders + ", TopHeaderNames=" + this.TopHeaderNames + ", VisibleModulesCache=" + this.VisibleModulesCache + ", Headers=" + this.Headers + ", MissingHeaders=" + this.MissingHeaders + ", Requirements=" + this.Requirements + ", IsMissingRequirement=" + this.IsMissingRequirement + ", IsAvailable=" + this.IsAvailable + ", IsFromModuleFile=" + this.IsFromModuleFile + ", IsFramework=" + this.IsFramework + ", IsExplicit=" + this.IsExplicit + ", IsSystem=" + this.IsSystem + ", IsExternC=" + this.IsExternC + ", IsInferred=" + this.IsInferred + ", InferSubmodules=" + this.InferSubmodules + ", InferExplicitSubmodules=" + this.InferExplicitSubmodules + ", InferExportWildcard=" + this.InferExportWildcard + ", ConfigMacrosExhaustive=" + this.ConfigMacrosExhaustive + ", NameVisibility=" + (Object)((Object)this.NameVisibility) + ", MacroVisibilityLoc=" + this.MacroVisibilityLoc + ", InferredSubmoduleLoc=" + this.InferredSubmoduleLoc + ", Imports=" + this.Imports + ", Exports=" + this.Exports + ", UnresolvedExports=" + this.UnresolvedExports + ", DirectUses=" + this.DirectUses + ", UnresolvedDirectUses=" + this.UnresolvedDirectUses + ", LinkLibraries=" + this.LinkLibraries + ", ConfigMacros=" + this.ConfigMacros + ", UnresolvedConflicts=" + this.UnresolvedConflicts + ", Conflicts=" + this.Conflicts;
    }

    public static class Conflict
    implements Destructors.ClassWithDestructor {
        public Module Other;
        public std.string Message;

        public void $destroy() {
            this.Message.$destroy();
        }

        public String toString() {
            return "Other=" + this.Other + ", Message=" + this.Message;
        }
    }

    public static class UnresolvedConflict
    implements Destructors.ClassWithDestructor {
        public ClankAliases.ModuleId Id;
        public std.string Message;

        public void $destroy() {
            this.Message.$destroy();
            this.Id.$destroy();
        }

        public String toString() {
            return "Id=" + (Object)((Object)this.Id) + ", Message=" + this.Message;
        }
    }

    public static class LinkLibrary
    implements Destructors.ClassWithDestructor {
        public std.string Library;
        public boolean IsFramework;

        public LinkLibrary() {
            this.Library = new std.string();
            this.IsFramework = false;
        }

        public LinkLibrary(std.string Library, boolean IsFramework) {
            this.Library = new std.string(Library);
            this.IsFramework = IsFramework;
        }

        public void $destroy() {
            this.Library.$destroy();
        }

        public String toString() {
            return "Library=" + this.Library + ", IsFramework=" + this.IsFramework;
        }
    }

    public static class UnresolvedExportDecl {
        public SourceLocation ExportLoc;
        public ClankAliases.ModuleId Id;
        public boolean Wildcard;

        public UnresolvedExportDecl(SourceLocation ExportLoc, ClankAliases.ModuleId Id, boolean Wildcard) {
            this.ExportLoc = new SourceLocation(ExportLoc);
            this.Id = Id;
            this.Wildcard = Wildcard;
        }

        public UnresolvedExportDecl() {
            this.ExportLoc = new SourceLocation();
            this.Id = new ClankAliases.ModuleId();
            this.Wildcard = false;
        }

        public String toString() {
            return "ExportLoc=" + this.ExportLoc + ", Id=" + (Object)((Object)this.Id) + ", Wildcard=" + this.Wildcard;
        }
    }

    public static final class NameVisibilityKind
    extends Enum<NameVisibilityKind> {
        public static final /* enum */ NameVisibilityKind Hidden = new NameVisibilityKind(0L);
        public static final /* enum */ NameVisibilityKind MacrosVisible = new NameVisibilityKind(Hidden.getValue() + 1);
        public static final /* enum */ NameVisibilityKind AllVisible = new NameVisibilityKind(MacrosVisible.getValue() + 1);
        private final int value;
        private static final /* synthetic */ NameVisibilityKind[] $VALUES;

        public static NameVisibilityKind[] values() {
            return (NameVisibilityKind[])$VALUES.clone();
        }

        public static NameVisibilityKind valueOf(String name) {
            return Enum.valueOf(NameVisibilityKind.class, name);
        }

        public static NameVisibilityKind valueOf(int val) {
            NameVisibilityKind out;
            NameVisibilityKind nameVisibilityKind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private NameVisibilityKind(long val) {
            this.value = (int)val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new NameVisibilityKind[]{Hidden, MacrosVisible, AllVisible};
        }

        private static final class Values {
            private static final NameVisibilityKind[] VALUES;
            private static final NameVisibilityKind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (NameVisibilityKind kind : NameVisibilityKind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new NameVisibilityKind[min < 0 ? 1 - min : 0];
                VALUES = new NameVisibilityKind[max >= 0 ? 1 + max : 0];
                for (NameVisibilityKind kind : NameVisibilityKind.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((NameVisibilityKind)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((NameVisibilityKind)kind).value] = kind;
                }
            }
        }
    }

    public final class Requirement
    extends std.pairTypeBool<std.string> {
        private Requirement() {
            super((Object)new std.string(), false);
        }

        public Requirement(std.string first, boolean second) {
            super((Object)first, second);
        }

        public std.pairTypeBool<std.string> clone() {
            return new Requirement((std.string)this.first, this.second);
        }
    }

    public static class UnresolvedHeaderDirective
    implements Destructors.ClassWithDestructor {
        public SourceLocation FileNameLoc;
        public std.string FileName;
        public boolean IsUmbrella;

        public UnresolvedHeaderDirective $assign(UnresolvedHeaderDirective $Prm0) {
            this.FileNameLoc.$assign($Prm0.FileNameLoc);
            this.FileName.$assign($Prm0.FileName);
            this.IsUmbrella = $Prm0.IsUmbrella;
            return this;
        }

        public void $destroy() {
            this.FileName.$destroy();
        }

        public String toString() {
            return "FileNameLoc=" + this.FileNameLoc + ", FileName=" + this.FileName + ", IsUmbrella=" + this.IsUmbrella;
        }
    }

    public static class Header
    implements Destructors.ClassWithDestructor {
        public std.string NameAsWritten;
        public FileEntry Entry;

        public Header() {
        }

        public Header(std.string NameAsWritten, FileEntry Entry2) {
            this.NameAsWritten = NameAsWritten;
            this.Entry = Entry2;
        }

        public Header(Header $Prm0) {
            this.NameAsWritten = new std.string($Prm0.NameAsWritten);
            this.Entry = $Prm0.Entry;
        }

        public Header(JavaDifferentiators.Move _dparam, Header $Prm0) {
            this.NameAsWritten = new std.string(JavaDifferentiators.Move.INSTANCE, $Prm0.NameAsWritten);
            this.Entry = $Prm0.Entry;
        }

        public void $destroy() {
            this.NameAsWritten.$destroy();
        }

        public String toString() {
            return "NameAsWritten=" + this.NameAsWritten + ", Entry=" + this.Entry;
        }
    }

    public static final class HeaderKind
    extends Enum<HeaderKind> {
        public static final /* enum */ HeaderKind HK_Normal = new HeaderKind(0L);
        public static final /* enum */ HeaderKind HK_Textual = new HeaderKind(HK_Normal.getValue() + 1);
        public static final /* enum */ HeaderKind HK_Private = new HeaderKind(HK_Textual.getValue() + 1);
        public static final /* enum */ HeaderKind HK_PrivateTextual = new HeaderKind(HK_Private.getValue() + 1);
        public static final /* enum */ HeaderKind HK_Excluded = new HeaderKind(HK_PrivateTextual.getValue() + 1);
        private final int value;
        private static final /* synthetic */ HeaderKind[] $VALUES;

        public static HeaderKind[] values() {
            return (HeaderKind[])$VALUES.clone();
        }

        public static HeaderKind valueOf(String name) {
            return Enum.valueOf(HeaderKind.class, name);
        }

        public static HeaderKind valueOf(int val) {
            HeaderKind out;
            HeaderKind headerKind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private HeaderKind(long val) {
            this.value = (int)val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new HeaderKind[]{HK_Normal, HK_Textual, HK_Private, HK_PrivateTextual, HK_Excluded};
        }

        private static final class Values {
            private static final HeaderKind[] VALUES;
            private static final HeaderKind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (HeaderKind kind : HeaderKind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new HeaderKind[min < 0 ? 1 - min : 0];
                VALUES = new HeaderKind[max >= 0 ? 1 + max : 0];
                for (HeaderKind kind : HeaderKind.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((HeaderKind)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((HeaderKind)kind).value] = kind;
                }
            }
        }
    }
}

