/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic;

import org.clang.basic.ClangGlobals;
import org.clang.basic.PresumedLoc;
import org.clang.basic.SourceManager;
import org.clank.java.std;
import org.clank.support.Casts;
import org.clank.support.Native;
import org.clank.support.NativeTrace;
import org.clank.support.NativeType;
import org.clank.support.Unsigned;
import org.clank.support.void;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;
import org.llvm.support.raw_string_ostream;

public class SourceLocation
implements Native.NativePOD<SourceLocation>,
NativeType.SizeofCapable {
    private int ID;
    private static final int MacroIDBit = Integer.MIN_VALUE;
    private static long instances = 0L;

    public SourceLocation() {
        this(0);
    }

    protected SourceLocation(int UINT_Encoding) {
        this.ID = UINT_Encoding;
        SourceLocation.trackInstance();
    }

    public boolean isFileID() {
        return SourceLocation.isFileID(this.ID);
    }

    public static boolean isFileID(int rawID) {
        return (rawID & Integer.MIN_VALUE) == 0;
    }

    public boolean isMacroID() {
        return SourceLocation.isMacroID(this.ID);
    }

    public static boolean isMacroID(int rawID) {
        return (rawID & Integer.MIN_VALUE) != 0;
    }

    public boolean isValid() {
        return this.ID != 0;
    }

    public static boolean isValid(int rawID) {
        return rawID != 0;
    }

    public boolean isInvalid() {
        return this.ID == 0;
    }

    public static boolean isInvalid(int rawID) {
        return rawID == 0;
    }

    long getOffset() {
        return SourceLocation.getOffset(this.ID);
    }

    public static int getOffset(int rawID) {
        return rawID & Integer.MAX_VALUE;
    }

    static SourceLocation getFileLoc(long ID2) {
        assert ((ID2 & Integer.MIN_VALUE) == 0L) : "Ran out of source locations!";
        SourceLocation L = new SourceLocation();
        L.ID = Unsigned.long2uint((long)ID2);
        return L;
    }

    static int getRawFileLoc(long ID2) {
        assert ((ID2 & Integer.MIN_VALUE) == 0L) : "Ran out of source locations!";
        return Unsigned.long2uint((long)ID2);
    }

    static SourceLocation getMacroLoc(long ID2) {
        assert ((ID2 & Integer.MIN_VALUE) == 0L) : "Ran out of source locations!";
        SourceLocation L = new SourceLocation();
        L.ID = Integer.MIN_VALUE | Unsigned.long2uint((long)ID2);
        return L;
    }

    static int getRawMacroLoc(long ID2) {
        assert ((ID2 & Integer.MIN_VALUE) == 0L) : "Ran out of source locations!";
        return Integer.MIN_VALUE | Unsigned.long2uint((long)ID2);
    }

    public SourceLocation getLocWithOffset(long Offset) {
        assert ((this.getOffset() + Offset & Integer.MIN_VALUE) == 0L) : "offset overflow";
        SourceLocation L = new SourceLocation();
        assert ((long)Unsigned.long2uint((long)(Unsigned.uint2long((int)this.ID) + Offset)) == (long)this.ID + Offset);
        L.ID = this.ID + (int)Offset;
        return L;
    }

    public int getRawLocWithOffset(long Offset) {
        return SourceLocation.getRawLocWithOffset(this.ID, Offset);
    }

    public static int getRawLocWithOffset(int rawID, long Offset) {
        assert (((long)SourceLocation.getOffset(rawID) + Offset & Integer.MIN_VALUE) == 0L) : "offset overflow";
        assert ((long)Unsigned.long2uint((long)(Unsigned.uint2long((int)rawID) + Offset)) == (long)rawID + Offset);
        return rawID + (int)Offset;
    }

    public static int getRawLocWithOffset(int rawID, int Offset) {
        assert ((SourceLocation.getOffset(rawID) + Offset & Integer.MIN_VALUE) == 0) : "offset overflow";
        assert (Unsigned.long2uint((long)(Unsigned.uint2long((int)rawID) + (long)Offset)) == rawID + Offset);
        return rawID + Offset;
    }

    public long getRawEncoding() {
        return Unsigned.uint2long((int)this.ID);
    }

    public int getRawEncodingUInt() {
        return this.ID;
    }

    public static SourceLocation getFromRawEncoding(long Encoding) {
        assert (Unsigned.uint2long((int)Unsigned.long2uint((long)Encoding)) == Encoding) : Long.toHexString(Encoding);
        return new SourceLocation((int)Encoding);
    }

    public static int getInvalid() {
        return 0;
    }

    public static SourceLocation getFromRawEncoding(int UINT_Encoding) {
        return new SourceLocation(UINT_Encoding);
    }

    public void.ptr getPtrEncoding() {
        return (void.ptr)Casts.static_cast((Object)this.getRawEncoding(), void.ptr.class);
    }

    public static SourceLocation getFromPtrEncoding(void.ptr Encoding) {
        return SourceLocation.getFromRawEncoding((Integer)Casts.static_cast((Object)Encoding, Integer.class));
    }

    public void print(raw_ostream OS, SourceManager SM) {
        if (!this.isValid()) {
            OS.$out((CharSequence)"<invalid loc>");
            return;
        }
        if (this.isFileID()) {
            PresumedLoc PLoc = SM.getPresumedLoc(this);
            if (PLoc.isInvalid()) {
                OS.$out((CharSequence)"<invalid>");
                return;
            }
            OS.$out(PLoc.getFilename()).$out(':').$out(PLoc.getLine()).$out(':').$out(PLoc.getColumn());
            return;
        }
        SM.getExpansionLoc(this).print(OS, SM);
        OS.$out((CharSequence)" <Spelling=");
        SM.getSpellingLoc(this).print(OS, SM);
        OS.$out('>');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public std.string printToString(SourceManager SM) {
        std.string S = null;
        raw_string_ostream OS = null;
        try {
            S = new std.string();
            OS = new raw_string_ostream(S);
            this.print((raw_ostream)OS, SM);
            std.string string2 = OS.str();
            return string2;
        }
        finally {
            if (OS != null) {
                OS.$destroy();
            }
            if (S != null) {
                S.$destroy();
            }
        }
    }

    public void dump(SourceManager SM) {
        this.dump(SM, llvm.errs());
    }

    public void dump(SourceManager SM, raw_ostream OS) {
        this.print(OS, SM);
    }

    public SourceLocation(SourceLocation $Prm0) {
        this($Prm0.ID);
    }

    public SourceLocation $assign(SourceLocation $Prm0) {
        this.ID = $Prm0.ID;
        return this;
    }

    public SourceLocation $assign(int $Prm0) {
        this.ID = $Prm0;
        return this;
    }

    public SourceLocation $assignMove(SourceLocation $Prm0) {
        this.ID = $Prm0.ID;
        return this;
    }

    public SourceLocation $assignMove(int $Prm0) {
        this.ID = $Prm0;
        return this;
    }

    public String toString() {
        if (this.isInvalid()) {
            return "INVALID";
        }
        return (this.isMacroID() ? "[M:" : "[F:") + this.getOffset() + "]";
    }

    public SourceLocation clone() {
        return new SourceLocation(this);
    }

    public boolean $noteq(SourceLocation other) {
        return ClangGlobals.$noteq_SourceLocation(this, other);
    }

    public boolean $eq(SourceLocation other) {
        return ClangGlobals.$eq_SourceLocation(this, other);
    }

    public long $sizeof() {
        return SourceLocation.$sizeof_SourceLocation();
    }

    public static int $sizeof_SourceLocation() {
        return NativeType.BYTES_IN_JAVA_OBJECT_HEADER + 4;
    }

    private static void trackInstance() {
        if (NativeTrace.STATISTICS) {
            ++instances;
        }
    }

    public static void clearStatistics() {
        instances = 0L;
    }

    public static void PrintStats(raw_ostream out) {
        out.$out((CharSequence)String.format("%22s created:\t", SourceLocation.class.getSimpleName())).$out((CharSequence)NativeTrace.formatNumber((long)instances)).$out((CharSequence)".\n");
    }
}

