/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.impl;

import org.clang.basic.OpenMPClauseKind;
import org.clang.basic.OpenMPDefaultClauseKind;
import org.clang.basic.OpenMPDirectiveKind;
import org.clang.basic.OpenMPProcBindClauseKind;
import org.clang.basic.OpenMPScheduleClauseKind;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitch;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;

public final class OpenMPKindsClangGlobals {
    public static OpenMPDirectiveKind getOpenMPDirectiveKind(StringRef Str) {
        return (OpenMPDirectiveKind)((Object)new StringSwitch(Str).Case((CharSequence)"threadprivate", (Object)OpenMPDirectiveKind.OMPD_threadprivate).Case((CharSequence)"parallel", (Object)OpenMPDirectiveKind.OMPD_parallel).Case((CharSequence)"task", (Object)OpenMPDirectiveKind.OMPD_task).Case((CharSequence)"simd", (Object)OpenMPDirectiveKind.OMPD_simd).Case((CharSequence)"for", (Object)OpenMPDirectiveKind.OMPD_for).Case((CharSequence)"sections", (Object)OpenMPDirectiveKind.OMPD_sections).Case((CharSequence)"section", (Object)OpenMPDirectiveKind.OMPD_section).Case((CharSequence)"single", (Object)OpenMPDirectiveKind.OMPD_single).Case((CharSequence)"master", (Object)OpenMPDirectiveKind.OMPD_master).Case((CharSequence)"critical", (Object)OpenMPDirectiveKind.OMPD_critical).Case((CharSequence)"taskyield", (Object)OpenMPDirectiveKind.OMPD_taskyield).Case((CharSequence)"barrier", (Object)OpenMPDirectiveKind.OMPD_barrier).Case((CharSequence)"taskwait", (Object)OpenMPDirectiveKind.OMPD_taskwait).Case((CharSequence)"flush", (Object)OpenMPDirectiveKind.OMPD_flush).Case((CharSequence)"ordered", (Object)OpenMPDirectiveKind.OMPD_ordered).Case((CharSequence)"atomic", (Object)OpenMPDirectiveKind.OMPD_atomic).Case((CharSequence)"target", (Object)OpenMPDirectiveKind.OMPD_target).Case((CharSequence)"teams", (Object)OpenMPDirectiveKind.OMPD_teams).Case((CharSequence)"parallel for", (Object)OpenMPDirectiveKind.OMPD_parallel_for).Case((CharSequence)"parallel for simd", (Object)OpenMPDirectiveKind.OMPD_parallel_for_simd).Case((CharSequence)"parallel sections", (Object)OpenMPDirectiveKind.OMPD_parallel_sections).Case((CharSequence)"for simd", (Object)OpenMPDirectiveKind.OMPD_for_simd).Default((Object)OpenMPDirectiveKind.OMPD_unknown));
    }

    public static char.ptr getOpenMPDirectiveName(OpenMPDirectiveKind Kind2) {
        assert (Kind2.getValue() <= OpenMPDirectiveKind.OMPD_unknown.getValue());
        switch (Kind2) {
            case OMPD_unknown: {
                return NativePointer.$((String)"unknown");
            }
            case OMPD_threadprivate: {
                return NativePointer.$((String)"threadprivate");
            }
            case OMPD_parallel: {
                return NativePointer.$((String)"parallel");
            }
            case OMPD_task: {
                return NativePointer.$((String)"task");
            }
            case OMPD_simd: {
                return NativePointer.$((String)"simd");
            }
            case OMPD_for: {
                return NativePointer.$((String)"for");
            }
            case OMPD_sections: {
                return NativePointer.$((String)"sections");
            }
            case OMPD_section: {
                return NativePointer.$((String)"section");
            }
            case OMPD_single: {
                return NativePointer.$((String)"single");
            }
            case OMPD_master: {
                return NativePointer.$((String)"master");
            }
            case OMPD_critical: {
                return NativePointer.$((String)"critical");
            }
            case OMPD_taskyield: {
                return NativePointer.$((String)"taskyield");
            }
            case OMPD_barrier: {
                return NativePointer.$((String)"barrier");
            }
            case OMPD_taskwait: {
                return NativePointer.$((String)"taskwait");
            }
            case OMPD_flush: {
                return NativePointer.$((String)"flush");
            }
            case OMPD_ordered: {
                return NativePointer.$((String)"ordered");
            }
            case OMPD_atomic: {
                return NativePointer.$((String)"atomic");
            }
            case OMPD_target: {
                return NativePointer.$((String)"target");
            }
            case OMPD_teams: {
                return NativePointer.$((String)"teams");
            }
            case OMPD_parallel_for: {
                return NativePointer.$((String)"parallel for");
            }
            case OMPD_parallel_for_simd: {
                return NativePointer.$((String)"parallel for simd");
            }
            case OMPD_parallel_sections: {
                return NativePointer.$((String)"parallel sections");
            }
            case OMPD_for_simd: {
                return NativePointer.$((String)"for simd");
            }
        }
        throw new llvm_unreachable((CharSequence)"Invalid OpenMP directive kind");
    }

    public static OpenMPClauseKind getOpenMPClauseKind(StringRef Str) {
        if (llvm.$eq_StringRef((StringRef)Str, (StringRef)new StringRef(NativePointer.$((String)"flush")))) {
            return OpenMPClauseKind.OMPC_unknown;
        }
        return (OpenMPClauseKind)((Object)new StringSwitch(Str).Case((CharSequence)"if", (Object)OpenMPClauseKind.OMPC_if).Case((CharSequence)"final", (Object)OpenMPClauseKind.OMPC_final).Case((CharSequence)"num_threads", (Object)OpenMPClauseKind.OMPC_num_threads).Case((CharSequence)"safelen", (Object)OpenMPClauseKind.OMPC_safelen).Case((CharSequence)"collapse", (Object)OpenMPClauseKind.OMPC_collapse).Case((CharSequence)"default", (Object)OpenMPClauseKind.OMPC_default).Case((CharSequence)"private", (Object)OpenMPClauseKind.OMPC_private).Case((CharSequence)"firstprivate", (Object)OpenMPClauseKind.OMPC_firstprivate).Case((CharSequence)"lastprivate", (Object)OpenMPClauseKind.OMPC_lastprivate).Case((CharSequence)"shared", (Object)OpenMPClauseKind.OMPC_shared).Case((CharSequence)"reduction", (Object)OpenMPClauseKind.OMPC_reduction).Case((CharSequence)"linear", (Object)OpenMPClauseKind.OMPC_linear).Case((CharSequence)"aligned", (Object)OpenMPClauseKind.OMPC_aligned).Case((CharSequence)"copyin", (Object)OpenMPClauseKind.OMPC_copyin).Case((CharSequence)"copyprivate", (Object)OpenMPClauseKind.OMPC_copyprivate).Case((CharSequence)"proc_bind", (Object)OpenMPClauseKind.OMPC_proc_bind).Case((CharSequence)"schedule", (Object)OpenMPClauseKind.OMPC_schedule).Case((CharSequence)"ordered", (Object)OpenMPClauseKind.OMPC_ordered).Case((CharSequence)"nowait", (Object)OpenMPClauseKind.OMPC_nowait).Case((CharSequence)"untied", (Object)OpenMPClauseKind.OMPC_untied).Case((CharSequence)"mergeable", (Object)OpenMPClauseKind.OMPC_mergeable).Case((CharSequence)"flush", (Object)OpenMPClauseKind.OMPC_flush).Case((CharSequence)"read", (Object)OpenMPClauseKind.OMPC_read).Case((CharSequence)"write", (Object)OpenMPClauseKind.OMPC_write).Case((CharSequence)"update", (Object)OpenMPClauseKind.OMPC_update).Case((CharSequence)"capture", (Object)OpenMPClauseKind.OMPC_capture).Case((CharSequence)"seq_cst", (Object)OpenMPClauseKind.OMPC_seq_cst).Default((Object)OpenMPClauseKind.OMPC_unknown));
    }

    public static char.ptr getOpenMPClauseName(OpenMPClauseKind Kind2) {
        assert (Kind2.getValue() <= OpenMPClauseKind.OMPC_unknown.getValue());
        switch (Kind2) {
            case OMPC_unknown: {
                return NativePointer.$((String)"unknown");
            }
            case OMPC_if: {
                return NativePointer.$((String)"if");
            }
            case OMPC_final: {
                return NativePointer.$((String)"final");
            }
            case OMPC_num_threads: {
                return NativePointer.$((String)"num_threads");
            }
            case OMPC_safelen: {
                return NativePointer.$((String)"safelen");
            }
            case OMPC_collapse: {
                return NativePointer.$((String)"collapse");
            }
            case OMPC_default: {
                return NativePointer.$((String)"default");
            }
            case OMPC_private: {
                return NativePointer.$((String)"private");
            }
            case OMPC_firstprivate: {
                return NativePointer.$((String)"firstprivate");
            }
            case OMPC_lastprivate: {
                return NativePointer.$((String)"lastprivate");
            }
            case OMPC_shared: {
                return NativePointer.$((String)"shared");
            }
            case OMPC_reduction: {
                return NativePointer.$((String)"reduction");
            }
            case OMPC_linear: {
                return NativePointer.$((String)"linear");
            }
            case OMPC_aligned: {
                return NativePointer.$((String)"aligned");
            }
            case OMPC_copyin: {
                return NativePointer.$((String)"copyin");
            }
            case OMPC_copyprivate: {
                return NativePointer.$((String)"copyprivate");
            }
            case OMPC_proc_bind: {
                return NativePointer.$((String)"proc_bind");
            }
            case OMPC_schedule: {
                return NativePointer.$((String)"schedule");
            }
            case OMPC_ordered: {
                return NativePointer.$((String)"ordered");
            }
            case OMPC_nowait: {
                return NativePointer.$((String)"nowait");
            }
            case OMPC_untied: {
                return NativePointer.$((String)"untied");
            }
            case OMPC_mergeable: {
                return NativePointer.$((String)"mergeable");
            }
            case OMPC_flush: {
                return NativePointer.$((String)"flush");
            }
            case OMPC_read: {
                return NativePointer.$((String)"read");
            }
            case OMPC_write: {
                return NativePointer.$((String)"write");
            }
            case OMPC_update: {
                return NativePointer.$((String)"update");
            }
            case OMPC_capture: {
                return NativePointer.$((String)"capture");
            }
            case OMPC_seq_cst: {
                return NativePointer.$((String)"seq_cst");
            }
            case OMPC_threadprivate: {
                return NativePointer.$((String)"threadprivate or thread local");
            }
        }
        throw new llvm_unreachable((CharSequence)"Invalid OpenMP clause kind");
    }

    public static long getOpenMPSimpleClauseType(OpenMPClauseKind Kind2, StringRef Str) {
        switch (Kind2) {
            case OMPC_default: {
                return ((OpenMPDefaultClauseKind)((Object)new StringSwitch(Str).Case((CharSequence)"none", (Object)OpenMPDefaultClauseKind.OMPC_DEFAULT_none).Case((CharSequence)"shared", (Object)OpenMPDefaultClauseKind.OMPC_DEFAULT_shared).Default((Object)OpenMPDefaultClauseKind.OMPC_DEFAULT_unknown))).getValue();
            }
            case OMPC_proc_bind: {
                return ((OpenMPProcBindClauseKind)((Object)new StringSwitch(Str).Case((CharSequence)"master", (Object)OpenMPProcBindClauseKind.OMPC_PROC_BIND_master).Case((CharSequence)"close", (Object)OpenMPProcBindClauseKind.OMPC_PROC_BIND_close).Case((CharSequence)"spread", (Object)OpenMPProcBindClauseKind.OMPC_PROC_BIND_spread).Default((Object)OpenMPProcBindClauseKind.OMPC_PROC_BIND_unknown))).getValue();
            }
            case OMPC_schedule: {
                return ((OpenMPScheduleClauseKind)((Object)new StringSwitch(Str).Case((CharSequence)"static", (Object)OpenMPScheduleClauseKind.OMPC_SCHEDULE_static).Case((CharSequence)"dynamic", (Object)OpenMPScheduleClauseKind.OMPC_SCHEDULE_dynamic).Case((CharSequence)"guided", (Object)OpenMPScheduleClauseKind.OMPC_SCHEDULE_guided).Case((CharSequence)"auto", (Object)OpenMPScheduleClauseKind.OMPC_SCHEDULE_auto).Case((CharSequence)"runtime", (Object)OpenMPScheduleClauseKind.OMPC_SCHEDULE_runtime).Default((Object)OpenMPScheduleClauseKind.OMPC_SCHEDULE_unknown))).getValue();
            }
        }
        throw new llvm_unreachable((CharSequence)"Invalid OpenMP simple clause kind");
    }

    public static char.ptr getOpenMPSimpleClauseTypeName(OpenMPClauseKind Kind2, long Type2) {
        switch (Kind2) {
            case OMPC_default: {
                switch (OpenMPDefaultClauseKind.valueOf((int)Type2)) {
                    case OMPC_DEFAULT_unknown: {
                        return NativePointer.$((String)"unknown");
                    }
                    case OMPC_DEFAULT_none: {
                        return NativePointer.$((String)"none");
                    }
                    case OMPC_DEFAULT_shared: {
                        return NativePointer.$((String)"shared");
                    }
                }
                throw new llvm_unreachable((CharSequence)"Invalid OpenMP 'default' clause type");
            }
            case OMPC_proc_bind: {
                switch (OpenMPProcBindClauseKind.valueOf((int)Type2)) {
                    case OMPC_PROC_BIND_unknown: {
                        return NativePointer.$((String)"unknown");
                    }
                    case OMPC_PROC_BIND_master: {
                        return NativePointer.$((String)"master");
                    }
                    case OMPC_PROC_BIND_close: {
                        return NativePointer.$((String)"close");
                    }
                    case OMPC_PROC_BIND_spread: {
                        return NativePointer.$((String)"spread");
                    }
                }
                throw new llvm_unreachable((CharSequence)"Invalid OpenMP 'proc_bind' clause type");
            }
            case OMPC_schedule: {
                switch (OpenMPScheduleClauseKind.valueOf((int)Type2)) {
                    case OMPC_SCHEDULE_unknown: {
                        return NativePointer.$((String)"unknown");
                    }
                    case OMPC_SCHEDULE_static: {
                        return NativePointer.$((String)"static");
                    }
                    case OMPC_SCHEDULE_dynamic: {
                        return NativePointer.$((String)"dynamic");
                    }
                    case OMPC_SCHEDULE_guided: {
                        return NativePointer.$((String)"guided");
                    }
                    case OMPC_SCHEDULE_auto: {
                        return NativePointer.$((String)"auto");
                    }
                    case OMPC_SCHEDULE_runtime: {
                        return NativePointer.$((String)"runtime");
                    }
                }
                throw new llvm_unreachable((CharSequence)"Invalid OpenMP 'schedule' clause type");
            }
        }
        throw new llvm_unreachable((CharSequence)"Invalid OpenMP simple clause kind");
    }

    public static boolean isAllowedClauseForDirective(OpenMPDirectiveKind DKind, OpenMPClauseKind CKind) {
        assert (DKind.getValue() <= OpenMPDirectiveKind.OMPD_unknown.getValue());
        assert (CKind.getValue() <= OpenMPClauseKind.OMPC_unknown.getValue());
        switch (DKind) {
            case OMPD_parallel: {
                switch (CKind) {
                    case OMPC_if: {
                        return true;
                    }
                    case OMPC_num_threads: {
                        return true;
                    }
                    case OMPC_default: {
                        return true;
                    }
                    case OMPC_proc_bind: {
                        return true;
                    }
                    case OMPC_private: {
                        return true;
                    }
                    case OMPC_firstprivate: {
                        return true;
                    }
                    case OMPC_shared: {
                        return true;
                    }
                    case OMPC_reduction: {
                        return true;
                    }
                    case OMPC_copyin: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_simd: {
                switch (CKind) {
                    case OMPC_private: {
                        return true;
                    }
                    case OMPC_lastprivate: {
                        return true;
                    }
                    case OMPC_linear: {
                        return true;
                    }
                    case OMPC_aligned: {
                        return true;
                    }
                    case OMPC_safelen: {
                        return true;
                    }
                    case OMPC_collapse: {
                        return true;
                    }
                    case OMPC_reduction: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_for: {
                switch (CKind) {
                    case OMPC_private: {
                        return true;
                    }
                    case OMPC_lastprivate: {
                        return true;
                    }
                    case OMPC_firstprivate: {
                        return true;
                    }
                    case OMPC_reduction: {
                        return true;
                    }
                    case OMPC_collapse: {
                        return true;
                    }
                    case OMPC_schedule: {
                        return true;
                    }
                    case OMPC_ordered: {
                        return true;
                    }
                    case OMPC_nowait: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_for_simd: {
                switch (CKind) {
                    case OMPC_private: {
                        return true;
                    }
                    case OMPC_firstprivate: {
                        return true;
                    }
                    case OMPC_lastprivate: {
                        return true;
                    }
                    case OMPC_reduction: {
                        return true;
                    }
                    case OMPC_schedule: {
                        return true;
                    }
                    case OMPC_collapse: {
                        return true;
                    }
                    case OMPC_nowait: {
                        return true;
                    }
                    case OMPC_safelen: {
                        return true;
                    }
                    case OMPC_linear: {
                        return true;
                    }
                    case OMPC_aligned: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_sections: {
                switch (CKind) {
                    case OMPC_private: {
                        return true;
                    }
                    case OMPC_lastprivate: {
                        return true;
                    }
                    case OMPC_firstprivate: {
                        return true;
                    }
                    case OMPC_reduction: {
                        return true;
                    }
                    case OMPC_nowait: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_single: {
                switch (CKind) {
                    case OMPC_private: {
                        return true;
                    }
                    case OMPC_firstprivate: {
                        return true;
                    }
                    case OMPC_copyprivate: {
                        return true;
                    }
                    case OMPC_nowait: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_parallel_for: {
                switch (CKind) {
                    case OMPC_if: {
                        return true;
                    }
                    case OMPC_num_threads: {
                        return true;
                    }
                    case OMPC_default: {
                        return true;
                    }
                    case OMPC_proc_bind: {
                        return true;
                    }
                    case OMPC_private: {
                        return true;
                    }
                    case OMPC_firstprivate: {
                        return true;
                    }
                    case OMPC_shared: {
                        return true;
                    }
                    case OMPC_reduction: {
                        return true;
                    }
                    case OMPC_copyin: {
                        return true;
                    }
                    case OMPC_lastprivate: {
                        return true;
                    }
                    case OMPC_collapse: {
                        return true;
                    }
                    case OMPC_schedule: {
                        return true;
                    }
                    case OMPC_ordered: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_parallel_for_simd: {
                switch (CKind) {
                    case OMPC_if: {
                        return true;
                    }
                    case OMPC_num_threads: {
                        return true;
                    }
                    case OMPC_default: {
                        return true;
                    }
                    case OMPC_proc_bind: {
                        return true;
                    }
                    case OMPC_private: {
                        return true;
                    }
                    case OMPC_firstprivate: {
                        return true;
                    }
                    case OMPC_shared: {
                        return true;
                    }
                    case OMPC_reduction: {
                        return true;
                    }
                    case OMPC_copyin: {
                        return true;
                    }
                    case OMPC_lastprivate: {
                        return true;
                    }
                    case OMPC_collapse: {
                        return true;
                    }
                    case OMPC_schedule: {
                        return true;
                    }
                    case OMPC_safelen: {
                        return true;
                    }
                    case OMPC_linear: {
                        return true;
                    }
                    case OMPC_aligned: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_parallel_sections: {
                switch (CKind) {
                    case OMPC_if: {
                        return true;
                    }
                    case OMPC_num_threads: {
                        return true;
                    }
                    case OMPC_default: {
                        return true;
                    }
                    case OMPC_proc_bind: {
                        return true;
                    }
                    case OMPC_private: {
                        return true;
                    }
                    case OMPC_firstprivate: {
                        return true;
                    }
                    case OMPC_shared: {
                        return true;
                    }
                    case OMPC_reduction: {
                        return true;
                    }
                    case OMPC_copyin: {
                        return true;
                    }
                    case OMPC_lastprivate: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_task: {
                switch (CKind) {
                    case OMPC_if: {
                        return true;
                    }
                    case OMPC_final: {
                        return true;
                    }
                    case OMPC_default: {
                        return true;
                    }
                    case OMPC_private: {
                        return true;
                    }
                    case OMPC_firstprivate: {
                        return true;
                    }
                    case OMPC_shared: {
                        return true;
                    }
                    case OMPC_untied: {
                        return true;
                    }
                    case OMPC_mergeable: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_flush: {
                return CKind == OpenMPClauseKind.OMPC_flush;
            }
            case OMPD_atomic: {
                switch (CKind) {
                    case OMPC_read: {
                        return true;
                    }
                    case OMPC_write: {
                        return true;
                    }
                    case OMPC_update: {
                        return true;
                    }
                    case OMPC_capture: {
                        return true;
                    }
                    case OMPC_seq_cst: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_target: {
                switch (CKind) {
                    case OMPC_if: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_teams: {
                switch (CKind) {
                    case OMPC_default: {
                        return true;
                    }
                    case OMPC_private: {
                        return true;
                    }
                    case OMPC_firstprivate: {
                        return true;
                    }
                    case OMPC_shared: {
                        return true;
                    }
                    case OMPC_reduction: {
                        return true;
                    }
                }
                break;
            }
        }
        return false;
    }

    public static boolean isOpenMPLoopDirective(OpenMPDirectiveKind DKind) {
        return DKind == OpenMPDirectiveKind.OMPD_simd || DKind == OpenMPDirectiveKind.OMPD_for || DKind == OpenMPDirectiveKind.OMPD_for_simd || DKind == OpenMPDirectiveKind.OMPD_parallel_for || DKind == OpenMPDirectiveKind.OMPD_parallel_for_simd;
    }

    public static boolean isOpenMPWorksharingDirective(OpenMPDirectiveKind DKind) {
        return DKind == OpenMPDirectiveKind.OMPD_for || DKind == OpenMPDirectiveKind.OMPD_for_simd || DKind == OpenMPDirectiveKind.OMPD_sections || DKind == OpenMPDirectiveKind.OMPD_section || DKind == OpenMPDirectiveKind.OMPD_single || DKind == OpenMPDirectiveKind.OMPD_parallel_for || DKind == OpenMPDirectiveKind.OMPD_parallel_for_simd || DKind == OpenMPDirectiveKind.OMPD_parallel_sections;
    }

    public static boolean isOpenMPParallelDirective(OpenMPDirectiveKind DKind) {
        return DKind == OpenMPDirectiveKind.OMPD_parallel || DKind == OpenMPDirectiveKind.OMPD_parallel_for || DKind == OpenMPDirectiveKind.OMPD_parallel_for_simd || DKind == OpenMPDirectiveKind.OMPD_parallel_sections;
    }

    public static boolean isOpenMPTeamsDirective(OpenMPDirectiveKind DKind) {
        return DKind == OpenMPDirectiveKind.OMPD_teams;
    }

    public static boolean isOpenMPSimdDirective(OpenMPDirectiveKind DKind) {
        return DKind == OpenMPDirectiveKind.OMPD_simd || DKind == OpenMPDirectiveKind.OMPD_for_simd || DKind == OpenMPDirectiveKind.OMPD_parallel_for_simd;
    }

    public static boolean isOpenMPPrivate(OpenMPClauseKind Kind2) {
        return Kind2 == OpenMPClauseKind.OMPC_private || Kind2 == OpenMPClauseKind.OMPC_firstprivate || Kind2 == OpenMPClauseKind.OMPC_lastprivate || Kind2 == OpenMPClauseKind.OMPC_linear || Kind2 == OpenMPClauseKind.OMPC_reduction;
    }

    public static boolean isOpenMPThreadPrivate(OpenMPClauseKind Kind2) {
        return Kind2 == OpenMPClauseKind.OMPC_threadprivate || Kind2 == OpenMPClauseKind.OMPC_copyin;
    }
}

