/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.target;

public class NeonTypeFlags {
    public static final int EltTypeMask = 15;
    public static final int UnsignedFlag = 16;
    public static final int QuadFlag = 32;
    private long Flags;

    public NeonTypeFlags(long F) {
        this.Flags = F;
    }

    public NeonTypeFlags(EltType ET, boolean IsUnsigned, boolean IsQuad) {
        this.Flags = ET.getValue();
        if (IsUnsigned) {
            this.Flags |= 0x10L;
        }
        if (IsQuad) {
            this.Flags |= 0x20L;
        }
    }

    public EltType getEltType() {
        return EltType.valueOf((int)(this.Flags & 0xFL));
    }

    public boolean isPoly() {
        EltType ET = this.getEltType();
        return ET == EltType.Poly8 || ET == EltType.Poly16;
    }

    public boolean isUnsigned() {
        return (this.Flags & 0x10L) != 0L;
    }

    public boolean isQuad() {
        return (this.Flags & 0x20L) != 0L;
    }

    public NeonTypeFlags(NeonTypeFlags $Prm0) {
        this.Flags = $Prm0.Flags;
    }

    public String toString() {
        return "Flags=" + this.Flags;
    }

    public static final class EltType
    extends Enum<EltType> {
        public static final /* enum */ EltType Int8 = new EltType(0L);
        public static final /* enum */ EltType Int16 = new EltType(Int8.getValue() + 1);
        public static final /* enum */ EltType Int32 = new EltType(Int16.getValue() + 1);
        public static final /* enum */ EltType Int64 = new EltType(Int32.getValue() + 1);
        public static final /* enum */ EltType Poly8 = new EltType(Int64.getValue() + 1);
        public static final /* enum */ EltType Poly16 = new EltType(Poly8.getValue() + 1);
        public static final /* enum */ EltType Poly64 = new EltType(Poly16.getValue() + 1);
        public static final /* enum */ EltType Poly128 = new EltType(Poly64.getValue() + 1);
        public static final /* enum */ EltType Float16 = new EltType(Poly128.getValue() + 1);
        public static final /* enum */ EltType Float32 = new EltType(Float16.getValue() + 1);
        public static final /* enum */ EltType Float64 = new EltType(Float32.getValue() + 1);
        private final int value;
        private static final /* synthetic */ EltType[] $VALUES;

        public static EltType[] values() {
            return (EltType[])$VALUES.clone();
        }

        public static EltType valueOf(String name) {
            return Enum.valueOf(EltType.class, name);
        }

        public static EltType valueOf(int val) {
            EltType out;
            EltType eltType = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private EltType(long val) {
            this.value = (int)val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new EltType[]{Int8, Int16, Int32, Int64, Poly8, Poly16, Poly64, Poly128, Float16, Float32, Float64};
        }

        private static final class Values {
            private static final EltType[] VALUES;
            private static final EltType[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (EltType kind : EltType.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new EltType[min < 0 ? 1 - min : 0];
                VALUES = new EltType[max >= 0 ? 1 + max : 0];
                for (EltType kind : EltType.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((EltType)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((EltType)kind).value] = kind;
                }
            }
        }
    }
}

