/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.target;

import org.clang.basic.Builtin;
import org.clang.basic.CallingConv;
import org.clang.basic.ClangGlobals;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.LangAS;
import org.clang.basic.LangOptions;
import org.clang.basic.MacroBuilder;
import org.clang.basic.VersionTuple;
import org.clang.basic.impl.TargetInfoStatics;
import org.clang.basic.target.TargetCXXABI;
import org.clang.basic.target.TargetOptions;
import org.clang.basic.target.impl.TargetsStatics;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.clank.support.aliases.int;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.llvm.adt.APFloat;
import org.llvm.adt.RefCountedBase;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.StringMapBool;
import org.llvm.adt.aliases.StringMapConstIteratorBool;
import org.llvm.adt.aliases.StringMapIteratorBool;
import org.llvm.support.fltSemantics;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;

public abstract class TargetInfo
extends RefCountedBase<TargetInfo>
implements Destructors.ClassWithDestructor {
    private std_ptr.shared_ptr<TargetOptions> TargetOpts;
    private Triple Triple;
    protected boolean BigEndian;
    protected boolean TLSSupported;
    protected boolean NoAsmVariants;
    protected short PointerWidth;
    protected short PointerAlign;
    protected short BoolWidth;
    protected short BoolAlign;
    protected short IntWidth;
    protected short IntAlign;
    protected short HalfWidth;
    protected short HalfAlign;
    protected short FloatWidth;
    protected short FloatAlign;
    protected short DoubleWidth;
    protected short DoubleAlign;
    protected short LongDoubleWidth;
    protected short LongDoubleAlign;
    protected short LargeArrayMinWidth;
    protected short LargeArrayAlign;
    protected short LongWidth;
    protected short LongAlign;
    protected short LongLongWidth;
    protected short LongLongAlign;
    protected short SuitableAlign;
    protected short MinGlobalAlign;
    protected short MaxAtomicPromoteWidth;
    protected short MaxAtomicInlineWidth;
    protected char MaxVectorAlign;
    protected char.ptr DescriptionString;
    protected char.ptr UserLabelPrefix;
    protected char.ptr MCountName;
    protected fltSemantics HalfFormat;
    protected fltSemantics FloatFormat;
    protected fltSemantics DoubleFormat;
    protected fltSemantics LongDoubleFormat;
    protected short RegParmMax;
    protected short SSERegParmMax;
    protected TargetCXXABI TheCXXABI;
    protected LangAS.Map AddrSpaceMap;
    protected StringRef PlatformName;
    protected VersionTuple PlatformMinVersion;
    protected boolean HasAlignMac68kSupport;
    protected byte RealTypeUsesObjCFPRet;
    protected boolean ComplexLongDoubleUsesFP2Ret;
    protected IntType SizeType;
    protected IntType IntMaxType;
    protected IntType PtrDiffType;
    protected IntType IntPtrType;
    protected IntType WCharType;
    protected IntType WIntType;
    protected IntType Char16Type;
    protected IntType Char32Type;
    protected IntType Int64Type;
    protected IntType SigAtomicType;
    protected IntType ProcessIDType;
    protected boolean UseSignedCharForObjCBool;
    protected boolean UseBitFieldTypeAlignment;
    protected boolean UseZeroLengthBitfieldAlignment;
    protected int ZeroLengthBitfieldBoundary;
    protected boolean UseAddrSpaceMapMangling;

    protected TargetInfo(Triple T) {
        this.TargetOpts = new std_ptr.shared_ptr();
        this.Triple = new Triple(T);
        this.TheCXXABI = new TargetCXXABI();
        this.PlatformName = new StringRef();
        this.PlatformMinVersion = new VersionTuple();
        this.BigEndian = true;
        this.TLSSupported = true;
        this.NoAsmVariants = false;
        this.PointerAlign = (short)32;
        this.PointerWidth = (short)32;
        this.BoolAlign = (short)8;
        this.BoolWidth = (short)8;
        this.IntAlign = (short)32;
        this.IntWidth = (short)32;
        this.LongAlign = (short)32;
        this.LongWidth = (short)32;
        this.LongLongAlign = (short)64;
        this.LongLongWidth = (short)64;
        this.SuitableAlign = (short)64;
        this.MinGlobalAlign = 0;
        this.HalfWidth = (short)16;
        this.HalfAlign = (short)16;
        this.FloatWidth = (short)32;
        this.FloatAlign = (short)32;
        this.DoubleWidth = (short)64;
        this.DoubleAlign = (short)64;
        this.LongDoubleWidth = (short)64;
        this.LongDoubleAlign = (short)64;
        this.LargeArrayMinWidth = 0;
        this.LargeArrayAlign = 0;
        this.MaxAtomicInlineWidth = 0;
        this.MaxAtomicPromoteWidth = 0;
        this.MaxVectorAlign = '\u0000';
        this.SizeType = IntType.UnsignedLong;
        this.PtrDiffType = IntType.SignedLong;
        this.IntMaxType = IntType.SignedLongLong;
        this.IntPtrType = IntType.SignedLong;
        this.WCharType = IntType.SignedInt;
        this.WIntType = IntType.SignedInt;
        this.Char16Type = IntType.UnsignedShort;
        this.Char32Type = IntType.UnsignedInt;
        this.Int64Type = IntType.SignedLongLong;
        this.SigAtomicType = IntType.SignedInt;
        this.ProcessIDType = IntType.SignedInt;
        this.UseSignedCharForObjCBool = true;
        this.UseBitFieldTypeAlignment = true;
        this.UseZeroLengthBitfieldAlignment = false;
        this.ZeroLengthBitfieldBoundary = 0;
        this.HalfFormat = APFloat.IEEEhalf;
        this.FloatFormat = APFloat.IEEEsingle;
        this.DoubleFormat = APFloat.IEEEdouble;
        this.LongDoubleFormat = APFloat.IEEEdouble;
        this.DescriptionString = null;
        this.UserLabelPrefix = NativePointer.$((String)"_");
        this.MCountName = NativePointer.$((String)"mcount");
        this.RegParmMax = 0;
        this.SSERegParmMax = 0;
        this.HasAlignMac68kSupport = false;
        this.RealTypeUsesObjCFPRet = 0;
        this.ComplexLongDoubleUsesFP2Ret = false;
        this.AddrSpaceMap = (LangAS.Map)Native.$tryClone((Object)TargetInfoStatics.DefaultAddrSpaceMap);
        this.UseAddrSpaceMapMangling = false;
        this.PlatformName.$assign(NativePointer.$((String)"unknown"));
        this.PlatformMinVersion.$assign(new VersionTuple());
    }

    protected <T> TargetInfo(Class<T> cl, Triple T) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TargetInfo CreateTargetInfo(DiagnosticsEngine Diags, std_ptr.shared_ptr<TargetOptions> Opts) {
        Triple Triple2 = null;
        std_ptr.unique_ptr Target = null;
        StringMapBool Features = null;
        try {
            TargetInfo targetInfo;
            Triple2 = new Triple(new Twine(((TargetOptions)Opts.$arrow()).Triple));
            Target = new std_ptr.unique_ptr((Object)TargetsStatics.AllocateTarget(Triple2));
            if (!Target.$boolean()) {
                ClangGlobals.$out_DiagnosticBuilder_StringRef(Diags.Report(29L), new StringRef(Triple2.str())).$destroy();
                TargetInfo targetInfo2 = null;
                return targetInfo2;
            }
            if (!((TargetOptions)Opts.$arrow()).CPU.empty() && !((TargetInfo)((Object)Target.$arrow())).setCPU(((TargetOptions)Opts.$arrow()).CPU)) {
                ClangGlobals.$out_DiagnosticBuilder_StringRef(Diags.Report(27L), new StringRef(((TargetOptions)Opts.$arrow()).CPU)).$destroy();
                TargetInfo targetInfo3 = null;
                return targetInfo3;
            }
            if (!((TargetOptions)Opts.$arrow()).ABI.empty() && !((TargetInfo)((Object)Target.$arrow())).setABI(((TargetOptions)Opts.$arrow()).ABI)) {
                ClangGlobals.$out_DiagnosticBuilder_StringRef(Diags.Report(26L), new StringRef(((TargetOptions)Opts.$arrow()).ABI)).$destroy();
                TargetInfo targetInfo4 = null;
                return targetInfo4;
            }
            if (!((TargetOptions)Opts.$arrow()).FPMath.empty() && !((TargetInfo)((Object)Target.$arrow())).setFPMath(new StringRef(((TargetOptions)Opts.$arrow()).FPMath))) {
                ClangGlobals.$out_DiagnosticBuilder_StringRef(Diags.Report(28L), new StringRef(((TargetOptions)Opts.$arrow()).FPMath)).$destroy();
                TargetInfo targetInfo5 = null;
                return targetInfo5;
            }
            Features = new StringMapBool(false);
            ((TargetInfo)((Object)Target.$arrow())).getDefaultFeatures(Features);
            int N = ((TargetOptions)Opts.$arrow()).FeaturesAsWritten.size();
            for (int I = 0; I < N; ++I) {
                char.ptr Name = Native.$tryClone((char.ptr)((TargetOptions)Opts.$arrow()).FeaturesAsWritten.$at(I).c_str());
                boolean Enabled = Name.$at(0) == NativePointer.$((char)'+');
                ((TargetInfo)((Object)Target.$arrow())).setFeatureEnabled(Features, new StringRef((char.ptr)Name.$add(1)), Enabled);
            }
            ((TargetOptions)Opts.$arrow()).Features.clear();
            StringMapIteratorBool it = Features.begin();
            StringMapIteratorBool ie = Features.end();
            while (it.$noteq((StringMapConstIteratorBool)ie)) {
                ((TargetOptions)Opts.$arrow()).Features.push_back(std.$plus_T_str((Object)(it.$arrow().second ? NativePointer.$((String)"+") : NativePointer.$((String)"-")), (std.string)it.$arrow().first().str()));
                it.$preInc();
            }
            if (!((TargetInfo)((Object)Target.$arrow())).handleTargetFeatures(((TargetOptions)Opts.$arrow()).Features, Diags)) {
                targetInfo = null;
                return targetInfo;
            }
            targetInfo = (TargetInfo)((Object)Target.release());
            return targetInfo;
        }
        finally {
            if (Features != null) {
                Features.$destroy();
            }
            if (Target != null) {
                Target.$destroy();
            }
            if (Triple2 != null) {
                Triple2.$destroy();
            }
        }
    }

    public void $destroy() {
    }

    public TargetOptions getTargetOpts() {
        assert (this.TargetOpts.$boolean()) : "Missing target options";
        return (TargetOptions)this.TargetOpts.$star();
    }

    public IntType getSizeType() {
        return this.SizeType;
    }

    public IntType getIntMaxType() {
        return this.IntMaxType;
    }

    public IntType getUIntMaxType() {
        return TargetInfo.getCorrespondingUnsignedType(this.IntMaxType);
    }

    public IntType getPtrDiffType(int AddrSpace) {
        return AddrSpace == 0 ? this.PtrDiffType : this.getPtrDiffTypeV(AddrSpace);
    }

    public IntType getIntPtrType() {
        return this.IntPtrType;
    }

    public IntType getUIntPtrType() {
        return TargetInfo.getCorrespondingUnsignedType(this.IntPtrType);
    }

    public IntType getWCharType() {
        return this.WCharType;
    }

    public IntType getWIntType() {
        return this.WIntType;
    }

    public IntType getChar16Type() {
        return this.Char16Type;
    }

    public IntType getChar32Type() {
        return this.Char32Type;
    }

    public IntType getInt64Type() {
        return this.Int64Type;
    }

    public IntType getUInt64Type() {
        return TargetInfo.getCorrespondingUnsignedType(this.Int64Type);
    }

    public IntType getSigAtomicType() {
        return this.SigAtomicType;
    }

    public IntType getProcessIDType() {
        return this.ProcessIDType;
    }

    public static IntType getCorrespondingUnsignedType(IntType T) {
        switch (T) {
            case SignedChar: {
                return IntType.UnsignedChar;
            }
            case SignedShort: {
                return IntType.UnsignedShort;
            }
            case SignedInt: {
                return IntType.UnsignedInt;
            }
            case SignedLong: {
                return IntType.UnsignedLong;
            }
            case SignedLongLong: {
                return IntType.UnsignedLongLong;
            }
        }
        throw new llvm_unreachable((CharSequence)"Unexpected signed integer type");
    }

    public int getTypeWidth(IntType T) {
        switch (T) {
            default: {
                throw new llvm_unreachable((CharSequence)"not an integer!");
            }
            case SignedChar: 
            case UnsignedChar: {
                return this.getCharWidth();
            }
            case SignedShort: 
            case UnsignedShort: {
                return this.getShortWidth();
            }
            case SignedInt: 
            case UnsignedInt: {
                return this.getIntWidth();
            }
            case SignedLong: 
            case UnsignedLong: {
                return this.getLongWidth();
            }
            case SignedLongLong: 
            case UnsignedLongLong: 
        }
        return this.getLongLongWidth();
    }

    public IntType getIntTypeByWidth(int BitWidth, boolean IsSigned) {
        if (this.getCharWidth() == BitWidth) {
            return IsSigned ? IntType.SignedChar : IntType.UnsignedChar;
        }
        if (this.getShortWidth() == BitWidth) {
            return IsSigned ? IntType.SignedShort : IntType.UnsignedShort;
        }
        if (this.getIntWidth() == BitWidth) {
            return IsSigned ? IntType.SignedInt : IntType.UnsignedInt;
        }
        if (this.getLongWidth() == BitWidth) {
            return IsSigned ? IntType.SignedLong : IntType.UnsignedLong;
        }
        if (this.getLongLongWidth() == BitWidth) {
            return IsSigned ? IntType.SignedLongLong : IntType.UnsignedLongLong;
        }
        return IntType.NoInt;
    }

    public IntType getLeastIntTypeByWidth(int BitWidth, boolean IsSigned) {
        if (this.getCharWidth() >= BitWidth) {
            return IsSigned ? IntType.SignedChar : IntType.UnsignedChar;
        }
        if (this.getShortWidth() >= BitWidth) {
            return IsSigned ? IntType.SignedShort : IntType.UnsignedShort;
        }
        if (this.getIntWidth() >= BitWidth) {
            return IsSigned ? IntType.SignedInt : IntType.UnsignedInt;
        }
        if (this.getLongWidth() >= BitWidth) {
            return IsSigned ? IntType.SignedLong : IntType.UnsignedLong;
        }
        if (this.getLongLongWidth() >= BitWidth) {
            return IsSigned ? IntType.SignedLongLong : IntType.UnsignedLongLong;
        }
        return IntType.NoInt;
    }

    public RealType getRealTypeByWidth(int BitWidth) {
        if (this.getFloatWidth() == BitWidth) {
            return RealType.Float;
        }
        if (this.getDoubleWidth() == BitWidth) {
            return RealType.Double;
        }
        switch (BitWidth) {
            case 96: {
                if (this.getLongDoubleFormat() != APFloat.x87DoubleExtended) break;
                return RealType.LongDouble;
            }
            case 128: {
                if (this.getLongDoubleFormat() != APFloat.PPCDoubleDouble && this.getLongDoubleFormat() != APFloat.IEEEquad) break;
                return RealType.LongDouble;
            }
        }
        return RealType.NoFloat;
    }

    public int getTypeAlign(IntType T) {
        switch (T) {
            default: {
                throw new llvm_unreachable((CharSequence)"not an integer!");
            }
            case SignedChar: 
            case UnsignedChar: {
                return this.getCharAlign();
            }
            case SignedShort: 
            case UnsignedShort: {
                return this.getShortAlign();
            }
            case SignedInt: 
            case UnsignedInt: {
                return this.getIntAlign();
            }
            case SignedLong: 
            case UnsignedLong: {
                return this.getLongAlign();
            }
            case SignedLongLong: 
            case UnsignedLongLong: 
        }
        return this.getLongLongAlign();
    }

    public static boolean isTypeSigned(IntType T) {
        switch (T) {
            default: {
                throw new llvm_unreachable((CharSequence)"not an integer!");
            }
            case SignedChar: 
            case SignedShort: 
            case SignedInt: 
            case SignedLong: 
            case SignedLongLong: {
                return true;
            }
            case UnsignedChar: 
            case UnsignedShort: 
            case UnsignedInt: 
            case UnsignedLong: 
            case UnsignedLongLong: 
        }
        return false;
    }

    public int getPointerWidth(int AddrSpace) {
        return AddrSpace == 0 ? this.PointerWidth : this.getPointerWidthV(AddrSpace);
    }

    public int getPointerAlign(int AddrSpace) {
        return AddrSpace == 0 ? this.PointerAlign : this.getPointerAlignV(AddrSpace);
    }

    public int getBoolWidth() {
        return this.BoolWidth;
    }

    public int getBoolAlign() {
        return this.BoolAlign;
    }

    public int getCharWidth() {
        return 8;
    }

    public int getCharAlign() {
        return 8;
    }

    public int getShortWidth() {
        return 16;
    }

    public int getShortAlign() {
        return 16;
    }

    public int getIntWidth() {
        return this.IntWidth;
    }

    public int getIntAlign() {
        return this.IntAlign;
    }

    public int getLongWidth() {
        return this.LongWidth;
    }

    public int getLongAlign() {
        return this.LongAlign;
    }

    public int getLongLongWidth() {
        return this.LongLongWidth;
    }

    public int getLongLongAlign() {
        return this.LongLongAlign;
    }

    public boolean hasInt128Type() {
        return this.getPointerWidth(0) >= 64;
    }

    public int getSuitableAlign() {
        return this.SuitableAlign;
    }

    public int getMinGlobalAlign() {
        return this.MinGlobalAlign;
    }

    public int getWCharWidth() {
        return this.getTypeWidth(this.WCharType);
    }

    public int getWCharAlign() {
        return this.getTypeAlign(this.WCharType);
    }

    public int getChar16Width() {
        return this.getTypeWidth(this.Char16Type);
    }

    public int getChar16Align() {
        return this.getTypeAlign(this.Char16Type);
    }

    public int getChar32Width() {
        return this.getTypeWidth(this.Char32Type);
    }

    public int getChar32Align() {
        return this.getTypeAlign(this.Char32Type);
    }

    public int getHalfWidth() {
        return this.HalfWidth;
    }

    public int getHalfAlign() {
        return this.HalfAlign;
    }

    public fltSemantics getHalfFormat() {
        return this.HalfFormat;
    }

    public int getFloatWidth() {
        return this.FloatWidth;
    }

    public int getFloatAlign() {
        return this.FloatAlign;
    }

    public fltSemantics getFloatFormat() {
        return this.FloatFormat;
    }

    public int getDoubleWidth() {
        return this.DoubleWidth;
    }

    public int getDoubleAlign() {
        return this.DoubleAlign;
    }

    public fltSemantics getDoubleFormat() {
        return this.DoubleFormat;
    }

    public int getLongDoubleWidth() {
        return this.LongDoubleWidth;
    }

    public int getLongDoubleAlign() {
        return this.LongDoubleAlign;
    }

    public fltSemantics getLongDoubleFormat() {
        return this.LongDoubleFormat;
    }

    public int getFloatEvalMethod() {
        return 0;
    }

    public int getLargeArrayMinWidth() {
        return this.LargeArrayMinWidth;
    }

    public int getLargeArrayAlign() {
        return this.LargeArrayAlign;
    }

    public int getMaxAtomicPromoteWidth() {
        return this.MaxAtomicPromoteWidth;
    }

    public int getMaxAtomicInlineWidth() {
        return this.MaxAtomicInlineWidth;
    }

    public boolean hasBuiltinAtomic(int AtomicSizeInBits, int AlignmentInBits) {
        return AtomicSizeInBits <= AlignmentInBits && AtomicSizeInBits <= this.getMaxAtomicInlineWidth() && (AtomicSizeInBits <= this.getCharWidth() || llvm.isPowerOf2_64((long)(AtomicSizeInBits / this.getCharWidth())));
    }

    public int getMaxVectorAlign() {
        return this.MaxVectorAlign;
    }

    public int getIntMaxTWidth() {
        return this.getTypeWidth(this.IntMaxType);
    }

    public int getUnwindWordWidth() {
        return this.getPointerWidth(0);
    }

    public int getRegisterWidth() {
        return this.PointerWidth;
    }

    public char.ptr getUserLabelPrefix() {
        return this.UserLabelPrefix;
    }

    public char.ptr getMCountName() {
        return this.MCountName;
    }

    public boolean useSignedCharForObjCBool() {
        return this.UseSignedCharForObjCBool;
    }

    public void noSignedCharForObjCBool() {
        this.UseSignedCharForObjCBool = false;
    }

    public boolean useBitFieldTypeAlignment() {
        return this.UseBitFieldTypeAlignment;
    }

    public boolean useZeroLengthBitfieldAlignment() {
        return this.UseZeroLengthBitfieldAlignment;
    }

    public int getZeroLengthBitfieldBoundary() {
        return this.ZeroLengthBitfieldBoundary;
    }

    public boolean hasAlignMac68kSupport() {
        return this.HasAlignMac68kSupport;
    }

    public static char.ptr getTypeName(IntType T) {
        switch (T) {
            default: {
                throw new llvm_unreachable((CharSequence)"not an integer!");
            }
            case SignedChar: {
                return NativePointer.$((String)"signed char");
            }
            case UnsignedChar: {
                return NativePointer.$((String)"unsigned char");
            }
            case SignedShort: {
                return NativePointer.$((String)"short");
            }
            case UnsignedShort: {
                return NativePointer.$((String)"unsigned short");
            }
            case SignedInt: {
                return NativePointer.$((String)"int");
            }
            case UnsignedInt: {
                return NativePointer.$((String)"unsigned int");
            }
            case SignedLong: {
                return NativePointer.$((String)"long int");
            }
            case UnsignedLong: {
                return NativePointer.$((String)"long unsigned int");
            }
            case SignedLongLong: {
                return NativePointer.$((String)"long long int");
            }
            case UnsignedLongLong: 
        }
        return NativePointer.$((String)"long long unsigned int");
    }

    public char.ptr getTypeConstantSuffix(IntType T) {
        switch (T) {
            default: {
                throw new llvm_unreachable((CharSequence)"not an integer!");
            }
            case SignedChar: 
            case SignedShort: 
            case SignedInt: {
                return NativePointer.$((String)"");
            }
            case SignedLong: {
                return NativePointer.$((String)"L");
            }
            case SignedLongLong: {
                return NativePointer.$((String)"LL");
            }
            case UnsignedChar: {
                if (this.getCharWidth() < this.getIntWidth()) {
                    return NativePointer.$((String)"");
                }
            }
            case UnsignedShort: {
                if (this.getShortWidth() < this.getIntWidth()) {
                    return NativePointer.$((String)"");
                }
            }
            case UnsignedInt: {
                return NativePointer.$((String)"U");
            }
            case UnsignedLong: {
                return NativePointer.$((String)"UL");
            }
            case UnsignedLongLong: 
        }
        return NativePointer.$((String)"ULL");
    }

    public static char.ptr getTypeFormatModifier(IntType T) {
        switch (T) {
            default: {
                throw new llvm_unreachable((CharSequence)"not an integer!");
            }
            case SignedChar: 
            case UnsignedChar: {
                return NativePointer.$((String)"hh");
            }
            case SignedShort: 
            case UnsignedShort: {
                return NativePointer.$((String)"h");
            }
            case SignedInt: 
            case UnsignedInt: {
                return NativePointer.$((String)"");
            }
            case SignedLong: 
            case UnsignedLong: {
                return NativePointer.$((String)"l");
            }
            case SignedLongLong: 
            case UnsignedLongLong: 
        }
        return NativePointer.$((String)"ll");
    }

    public boolean useObjCFPRetForRealType(RealType T) {
        return (this.RealTypeUsesObjCFPRet & 1 << T.getValue()) != 0;
    }

    public boolean useObjCFP2RetForComplexLongDouble() {
        return this.ComplexLongDoubleUsesFP2Ret;
    }

    public boolean useAddressSpaceMapMangling() {
        return this.UseAddrSpaceMapMangling;
    }

    public abstract void getTargetDefines(LangOptions var1, MacroBuilder var2);

    public abstract void getTargetBuiltins(type.ref<Builtin.Info[]> var1, uint.ref var2);

    public boolean isCLZForZeroUndef() {
        return true;
    }

    public abstract BuiltinVaListKind getBuiltinVaListKind();

    static StringRef removeGCCRegisterPrefix(StringRef Name) {
        if (Name.$at(0) == 37 || Name.$at(0) == 35) {
            Name = Name.substr(1);
        }
        return Name;
    }

    public boolean isValidClobber(StringRef Name) {
        return this.isValidGCCRegisterName(Name) || llvm.$eq_StringRef((StringRef)Name, (StringRef)new StringRef(NativePointer.$((String)"memory"))) || llvm.$eq_StringRef((StringRef)Name, (StringRef)new StringRef(NativePointer.$((String)"cc")));
    }

    public boolean isValidGCCRegisterName(StringRef Name) {
        int.ref n;
        if (Name.empty()) {
            return false;
        }
        type.ref Names = NativePointer.create_type$ref(null);
        uint.ref NumNames = NativePointer.create_uint$ref();
        Name.$assign(TargetInfo.removeGCCRegisterPrefix(Name));
        if (Name.empty()) {
            return false;
        }
        this.getGCCRegNames((type.ref<CharSequence[]>)Names, NumNames);
        if (ClangGlobals.isDigit(Name.$at(0)) && !Name.getAsInteger(0, n = NativePointer.create_int$ref())) {
            return n.$deref() >= 0 && (long)n.$deref() < NumNames.$deref();
        }
        int i = 0;
        while ((long)i < NumNames.$deref()) {
            if (llvm.$eq_StringRef((StringRef)Name, (StringRef)new StringRef(((CharSequence[])Names.$deref())[i]))) {
                return true;
            }
            ++i;
        }
        type.ref AddlNames = NativePointer.create_type$ref(null);
        uint.ptr.single NumAddlNames = new uint.ptr.single(0L);
        this.getGCCAddlRegNames((type.ref<AddlRegName[]>)AddlNames, (uint.ref)NumAddlNames);
        int i2 = 0;
        while ((long)i2 < NumAddlNames.$deref()) {
            for (int j = 0; j < llvm.array_lengthof((Object[])((AddlRegName[])AddlNames.$deref())[i2].Names) && ((AddlRegName[])AddlNames.$deref())[i2].Names[j] != null; ++j) {
                if (!llvm.$eq_StringRef((StringRef)new StringRef(((AddlRegName[])AddlNames.$deref())[i2].Names[j]), (StringRef)Name) || (long)((AddlRegName[])AddlNames.$deref())[i2].RegNum >= NumNames.$deref()) continue;
                return true;
            }
            ++i2;
        }
        type.ref Aliases = NativePointer.create_type$ref(null);
        uint.ptr.single NumAliases = new uint.ptr.single(0L);
        this.getGCCRegAliases((type.ref<GCCRegAlias[]>)Aliases, (uint.ref)NumAliases);
        int i3 = 0;
        while ((long)i3 < NumAliases.$deref()) {
            for (int j = 0; j < llvm.array_lengthof((Object[])((GCCRegAlias[])Aliases.$deref())[i3].Aliases) && ((GCCRegAlias[])Aliases.$deref())[i3].Aliases[j] != null; ++j) {
                if (!llvm.$eq_StringRef((StringRef)new StringRef(((GCCRegAlias[])Aliases.$deref())[i3].Aliases[j]), (StringRef)Name)) continue;
                return true;
            }
            ++i3;
        }
        return false;
    }

    public StringRef getNormalizedGCCRegisterName(StringRef Name) {
        int.ref n;
        assert (this.isValidGCCRegisterName(Name)) : "Invalid register passed in";
        Name.$assign(TargetInfo.removeGCCRegisterPrefix(Name));
        type.ref Names = NativePointer.create_type$ref(null);
        uint.ref NumNames = NativePointer.create_uint$ref();
        this.getGCCRegNames((type.ref<CharSequence[]>)Names, NumNames);
        if (ClangGlobals.isDigit(Name.$at(0)) && !Name.getAsInteger(0, n = NativePointer.create_int$ref())) {
            assert (n.$deref() >= 0 && (long)n.$deref() < NumNames.$deref()) : "Out of bounds register number!";
            return new StringRef(((CharSequence[])Names.$deref())[n.$deref()]);
        }
        type.ref AddlNames = NativePointer.create_type$ref(null);
        uint.ref NumAddlNames = NativePointer.create_uint$ref();
        this.getGCCAddlRegNames((type.ref<AddlRegName[]>)AddlNames, NumAddlNames);
        int i = 0;
        while ((long)i < NumAddlNames.$deref()) {
            for (int j = 0; j < llvm.array_lengthof((Object[])((AddlRegName[])AddlNames.$deref())[i].Names) && ((AddlRegName[])AddlNames.$deref())[i].Names[j] != null; ++j) {
                if (!llvm.$eq_StringRef((StringRef)new StringRef(((AddlRegName[])AddlNames.$deref())[i].Names[j]), (StringRef)Name) || (long)((AddlRegName[])AddlNames.$deref())[i].RegNum >= NumNames.$deref()) continue;
                return Name;
            }
            ++i;
        }
        type.ref Aliases = NativePointer.create_type$ref(null);
        uint.ref NumAliases = NativePointer.create_uint$ref();
        this.getGCCRegAliases((type.ref<GCCRegAlias[]>)Aliases, NumAliases);
        int i2 = 0;
        while ((long)i2 < NumAliases.$deref()) {
            for (int j = 0; j < llvm.array_lengthof((Object[])((GCCRegAlias[])Aliases.$deref())[i2].Aliases) && ((GCCRegAlias[])Aliases.$deref())[i2].Aliases[j] != null; ++j) {
                if (!llvm.$eq_StringRef((StringRef)new StringRef(((GCCRegAlias[])Aliases.$deref())[i2].Aliases[j]), (StringRef)Name)) continue;
                return new StringRef(((GCCRegAlias[])Aliases.$deref())[i2].Register);
            }
            ++i2;
        }
        return Name;
    }

    public boolean validateOutputConstraint(ConstraintInfo Info2) {
        char.ptr Name = Native.$tryClone((char.ptr)Info2.getConstraintStr().c_str());
        if (Name.$star() != NativePointer.$((char)'=') && Name.$star() != NativePointer.$((char)'+')) {
            return false;
        }
        if (Name.$star() == NativePointer.$((char)'+')) {
            Info2.setIsReadWrite();
        }
        Name.$postInc();
        while (Name.$star() != 0) {
            switch (Name.$star()) {
                default: {
                    if (this.validateAsmConstraint(Name, Info2)) break;
                    return false;
                }
                case 38: {
                    Info2.setEarlyClobber();
                    break;
                }
                case 37: {
                    break;
                }
                case 114: {
                    Info2.setAllowsRegister();
                    break;
                }
                case 60: 
                case 62: 
                case 86: 
                case 109: 
                case 111: {
                    Info2.setAllowsMemory();
                    break;
                }
                case 88: 
                case 103: {
                    Info2.setAllowsRegister();
                    Info2.setAllowsMemory();
                    break;
                }
                case 44: {
                    if (Name.$at(1) != NativePointer.$((char)'=') && Name.$at(1) != NativePointer.$((char)'+')) break;
                    Name.$postInc();
                    break;
                }
                case 35: {
                    while (Name.$at(1) != 0 && Name.$at(1) != NativePointer.$((char)',')) {
                        Name.$postInc();
                    }
                    break;
                }
                case 33: 
                case 42: 
                case 63: 
            }
            Name.$postInc();
        }
        if (Info2.earlyClobber() && Info2.isReadWrite() && !Info2.allowsRegister()) {
            return false;
        }
        return Info2.allowsMemory() || Info2.allowsRegister();
    }

    public boolean validateOutputSize(StringRef $Prm0, int $Prm1) {
        return true;
    }

    public boolean validateInputSize(StringRef $Prm0, int $Prm1) {
        return true;
    }

    public boolean validateConstraintModifier(StringRef $Prm0, byte $Prm1, int $Prm2, std.string $Prm3) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resolveSymbolicName(char.ptr Name, ConstraintInfo[] OutputConstraints, int NumOutputs, uint.ref Index) {
        std.string SymbolicName = null;
        try {
            assert (Name.$star() == 91) : "Symbolic name did not start with '['";
            Name.$postInc();
            char.ptr Start = Native.$tryClone((char.ptr)Name);
            while (Name.$star() != 0 && Name.$star() != NativePointer.$((char)']')) {
                Name.$postInc();
            }
            if (Name.$star() == 0) {
                boolean bl = false;
                return bl;
            }
            SymbolicName = new std.string(Start, Name.$sub((abstract_iterator)Start));
            Index.$set(0L);
            while (Index.$deref() != (long)NumOutputs) {
                if (std.$eq_str((std.string)SymbolicName, (std.string)OutputConstraints[(int)Index.$deref()].getName())) {
                    boolean bl = true;
                    return bl;
                }
                Index.$set(Index.$deref() + 1L);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (SymbolicName != null) {
                SymbolicName.$destroy();
            }
        }
    }

    public std.string convertConstraint(char.ptr Constraint) {
        if (Constraint.$star() == NativePointer.$((char)'p')) {
            return new std.string(NativePointer.$((String)"r"));
        }
        return new std.string(1, Constraint.$star());
    }

    public abstract char.ptr getClobbers();

    public Triple getTriple() {
        return this.Triple;
    }

    public char.ptr getTargetDescription() {
        assert (this.DescriptionString != null);
        return this.DescriptionString;
    }

    public boolean hasProtectedVisibility() {
        return true;
    }

    public std.string isValidSectionSpecifier(StringRef SR) {
        return new std.string(NativePointer.$((String)""));
    }

    public void adjust(LangOptions Opts) {
    }

    public void getDefaultFeatures(StringMapBool Features) {
    }

    public StringRef getABI() {
        return new StringRef();
    }

    public TargetCXXABI getCXXABI() {
        return this.TheCXXABI;
    }

    public boolean setCPU(std.string Name) {
        return false;
    }

    public boolean setABI(std.string Name) {
        return false;
    }

    public boolean setFPMath(StringRef Name) {
        return false;
    }

    public boolean setCXXABI(StringRef name) {
        TargetCXXABI ABI = new TargetCXXABI();
        if (!ABI.tryParse(name)) {
            return false;
        }
        return this.setCXXABI(ABI);
    }

    public boolean setCXXABI(TargetCXXABI ABI) {
        this.TheCXXABI.$assign(ABI);
        return true;
    }

    public void setFeatureEnabled(StringMapBool Features, StringRef Name, boolean Enabled) {
        Features.GetOrCreateValue(Name).setValue(Enabled);
    }

    public boolean handleTargetFeatures(std.vectorString Features, DiagnosticsEngine Diags) {
        return true;
    }

    public boolean hasFeature(StringRef Feature2) {
        return false;
    }

    public int getRegParmMax() {
        assert (this.RegParmMax < 7) : "RegParmMax value is larger than AST can handle";
        return this.RegParmMax;
    }

    public boolean isTLSSupported() {
        return this.TLSSupported;
    }

    public boolean hasNoAsmVariants() {
        return this.NoAsmVariants;
    }

    public int getEHDataRegisterNumber(int RegNo) {
        return -1;
    }

    public char.ptr getStaticInitSectionSpecifier() {
        return null;
    }

    public LangAS.Map getAddressSpaceMap() {
        return this.AddrSpaceMap;
    }

    public StringRef getPlatformName() {
        return this.PlatformName;
    }

    public VersionTuple getPlatformMinVersion() {
        return this.PlatformMinVersion;
    }

    public boolean isBigEndian() {
        return this.BigEndian;
    }

    public CallingConv getDefaultCallingConv(CallingConvMethodType MT) {
        return CallingConv.CC_C;
    }

    public CallingConvCheckResult checkCallingConvention(CallingConv CC) {
        switch (CC) {
            default: {
                return CallingConvCheckResult.CCCR_Warning;
            }
            case CC_C: 
        }
        return CallingConvCheckResult.CCCR_OK;
    }

    protected int getPointerWidthV(int AddrSpace) {
        return this.PointerWidth;
    }

    protected int getPointerAlignV(int AddrSpace) {
        return this.PointerAlign;
    }

    protected IntType getPtrDiffTypeV(int AddrSpace) {
        return this.PtrDiffType;
    }

    public abstract void getGCCRegNames(type.ref<CharSequence[]> var1, uint.ref var2);

    public abstract void getGCCRegAliases(type.ref<GCCRegAlias[]> var1, uint.ref var2);

    protected void getGCCAddlRegNames(type.ref<AddlRegName[]> Addl, uint.ref NumAddl) {
        Addl.$set(null);
        NumAddl.$set(0L);
    }

    public abstract boolean validateAsmConstraint(char.ptr var1, ConstraintInfo var2);

    public static void addMinGWDefines(LangOptions Opts, MacroBuilder Builder) {
        Builder.defineMacro(new Twine(NativePointer.$((String)"__MSVCRT__")));
        Builder.defineMacro(new Twine(NativePointer.$((String)"__MINGW32__")));
        if (Opts.MicrosoftExt) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__declspec")), new Twine(NativePointer.$((String)"__declspec")));
        } else {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__declspec(a)")), new Twine(NativePointer.$((String)"__attribute__((a))")));
        }
        if (!Opts.MicrosoftExt) {
            char.ptr[] CCs;
            for (char.ptr CC : CCs = new char.ptr[]{NativePointer.$((String)"cdecl"), NativePointer.$((String)"stdcall"), NativePointer.$((String)"fastcall"), NativePointer.$((String)"thiscall"), NativePointer.$((String)"pascal")}) {
                std.string GCCSpelling = new std.string(NativePointer.$((String)"__attribute__((__"));
                GCCSpelling.$addassign(CC);
                GCCSpelling.$addassign(NativePointer.$((String)"__))"));
                Builder.defineMacro(llvm.$plus_Twine((Twine)new Twine(NativePointer.$((String)"_")), (Twine)new Twine(CC)), new Twine(GCCSpelling));
                Builder.defineMacro(llvm.$plus_Twine((Twine)new Twine(NativePointer.$((String)"__")), (Twine)new Twine(CC)), new Twine(GCCSpelling));
            }
        }
    }

    public String toString() {
        return "TargetOpts=" + this.TargetOpts + ", Triple=" + this.Triple + ", BigEndian=" + this.BigEndian + ", TLSSupported=" + this.TLSSupported + ", NoAsmVariants=" + this.NoAsmVariants + ", PointerWidth=" + this.PointerWidth + ", PointerAlign=" + this.PointerAlign + ", BoolWidth=" + this.BoolWidth + ", BoolAlign=" + this.BoolAlign + ", IntWidth=" + this.IntWidth + ", IntAlign=" + this.IntAlign + ", HalfWidth=" + this.HalfWidth + ", HalfAlign=" + this.HalfAlign + ", FloatWidth=" + this.FloatWidth + ", FloatAlign=" + this.FloatAlign + ", DoubleWidth=" + this.DoubleWidth + ", DoubleAlign=" + this.DoubleAlign + ", LongDoubleWidth=" + this.LongDoubleWidth + ", LongDoubleAlign=" + this.LongDoubleAlign + ", LargeArrayMinWidth=" + this.LargeArrayMinWidth + ", LargeArrayAlign=" + this.LargeArrayAlign + ", LongWidth=" + this.LongWidth + ", LongAlign=" + this.LongAlign + ", LongLongWidth=" + this.LongLongWidth + ", LongLongAlign=" + this.LongLongAlign + ", SuitableAlign=" + this.SuitableAlign + ", MinGlobalAlign=" + this.MinGlobalAlign + ", MaxAtomicPromoteWidth=" + this.MaxAtomicPromoteWidth + ", MaxAtomicInlineWidth=" + this.MaxAtomicInlineWidth + ", MaxVectorAlign=" + this.MaxVectorAlign + ", DescriptionString=" + this.DescriptionString + ", UserLabelPrefix=" + this.UserLabelPrefix + ", MCountName=" + this.MCountName + ", HalfFormat=" + this.HalfFormat + ", FloatFormat=" + this.FloatFormat + ", DoubleFormat=" + this.DoubleFormat + ", LongDoubleFormat=" + this.LongDoubleFormat + ", RegParmMax=" + this.RegParmMax + ", SSERegParmMax=" + this.SSERegParmMax + ", TheCXXABI=" + this.TheCXXABI + ", AddrSpaceMap=" + this.AddrSpaceMap + ", PlatformName=" + this.PlatformName + ", PlatformMinVersion=" + this.PlatformMinVersion + ", HasAlignMac68kSupport=" + this.HasAlignMac68kSupport + ", RealTypeUsesObjCFPRet=" + this.RealTypeUsesObjCFPRet + ", ComplexLongDoubleUsesFP2Ret=" + this.ComplexLongDoubleUsesFP2Ret + ", SizeType=" + (Object)((Object)this.SizeType) + ", IntMaxType=" + (Object)((Object)this.IntMaxType) + ", PtrDiffType=" + (Object)((Object)this.PtrDiffType) + ", IntPtrType=" + (Object)((Object)this.IntPtrType) + ", WCharType=" + (Object)((Object)this.WCharType) + ", WIntType=" + (Object)((Object)this.WIntType) + ", Char16Type=" + (Object)((Object)this.Char16Type) + ", Char32Type=" + (Object)((Object)this.Char32Type) + ", Int64Type=" + (Object)((Object)this.Int64Type) + ", SigAtomicType=" + (Object)((Object)this.SigAtomicType) + ", ProcessIDType=" + (Object)((Object)this.ProcessIDType) + ", UseSignedCharForObjCBool=" + this.UseSignedCharForObjCBool + ", UseBitFieldTypeAlignment=" + this.UseBitFieldTypeAlignment + ", UseZeroLengthBitfieldAlignment=" + this.UseZeroLengthBitfieldAlignment + ", ZeroLengthBitfieldBoundary=" + this.ZeroLengthBitfieldBoundary + ", UseAddrSpaceMapMangling=" + this.UseAddrSpaceMapMangling + super.toString();
    }

    public static final class CallingConvCheckResult
    extends Enum<CallingConvCheckResult> {
        public static final /* enum */ CallingConvCheckResult CCCR_OK = new CallingConvCheckResult(0);
        public static final /* enum */ CallingConvCheckResult CCCR_Warning = new CallingConvCheckResult(CCCR_OK.getValue() + 1);
        private final int value;
        private static final /* synthetic */ CallingConvCheckResult[] $VALUES;

        public static CallingConvCheckResult[] values() {
            return (CallingConvCheckResult[])$VALUES.clone();
        }

        public static CallingConvCheckResult valueOf(String name) {
            return Enum.valueOf(CallingConvCheckResult.class, name);
        }

        public static CallingConvCheckResult valueOf(int val) {
            CallingConvCheckResult out;
            CallingConvCheckResult callingConvCheckResult = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private CallingConvCheckResult(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new CallingConvCheckResult[]{CCCR_OK, CCCR_Warning};
        }

        private static final class Values {
            private static final CallingConvCheckResult[] VALUES;
            private static final CallingConvCheckResult[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (CallingConvCheckResult kind : CallingConvCheckResult.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new CallingConvCheckResult[min < 0 ? 1 - min : 0];
                VALUES = new CallingConvCheckResult[max >= 0 ? 1 + max : 0];
                for (CallingConvCheckResult kind : CallingConvCheckResult.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((CallingConvCheckResult)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((CallingConvCheckResult)kind).value] = kind;
                }
            }
        }
    }

    public static final class CallingConvMethodType
    extends Enum<CallingConvMethodType> {
        public static final /* enum */ CallingConvMethodType CCMT_Unknown = new CallingConvMethodType(0);
        public static final /* enum */ CallingConvMethodType CCMT_Member = new CallingConvMethodType(CCMT_Unknown.getValue() + 1);
        public static final /* enum */ CallingConvMethodType CCMT_NonMember = new CallingConvMethodType(CCMT_Member.getValue() + 1);
        private final int value;
        private static final /* synthetic */ CallingConvMethodType[] $VALUES;

        public static CallingConvMethodType[] values() {
            return (CallingConvMethodType[])$VALUES.clone();
        }

        public static CallingConvMethodType valueOf(String name) {
            return Enum.valueOf(CallingConvMethodType.class, name);
        }

        public static CallingConvMethodType valueOf(int val) {
            CallingConvMethodType out;
            CallingConvMethodType callingConvMethodType = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private CallingConvMethodType(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new CallingConvMethodType[]{CCMT_Unknown, CCMT_Member, CCMT_NonMember};
        }

        private static final class Values {
            private static final CallingConvMethodType[] VALUES;
            private static final CallingConvMethodType[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (CallingConvMethodType kind : CallingConvMethodType.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new CallingConvMethodType[min < 0 ? 1 - min : 0];
                VALUES = new CallingConvMethodType[max >= 0 ? 1 + max : 0];
                for (CallingConvMethodType kind : CallingConvMethodType.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((CallingConvMethodType)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((CallingConvMethodType)kind).value] = kind;
                }
            }
        }
    }

    public static class AddlRegName {
        public char.ptr[] Names = new char.ptr[5];
        public int RegNum;

        public AddlRegName(CharSequence[] Names, int i) {
            int len = Math.min(this.Names.length, Names.length);
            for (int j = 0; j < len; ++j) {
                this.Names[j] = NativePointer.create_char$ptr((CharSequence)Names[j]);
            }
            this.RegNum = i;
        }

        public AddlRegName(char.ptr[] Names, int i) {
            NativePointer.copy$Object((Object[])Names, (int)0, (Object[])this.Names, (int)0, (int)Names.length);
            this.RegNum = i;
        }

        public String toString() {
            return "Names=" + this.Names + ", RegNum=" + this.RegNum;
        }
    }

    public static class GCCRegAlias {
        public char.ptr[] Aliases = new char.ptr[5];
        public char.ptr Register;

        public GCCRegAlias(CharSequence[] Aliases, CharSequence Register) {
            this.Register = NativePointer.create_char$ptr((CharSequence)Register);
            int len = Math.min(this.Aliases.length, Aliases.length);
            for (int i = 0; i < len; ++i) {
                this.Aliases[i] = NativePointer.create_char$ptr((CharSequence)Aliases[i]);
            }
        }

        public GCCRegAlias(char.ptr[] Aliases, char.ptr Register) {
            this.Register = Register;
            NativePointer.copy$Object((Object[])Aliases, (int)0, (Object[])this.Aliases, (int)0, (int)Aliases.length);
        }

        public String toString() {
            return "Aliases=" + this.Aliases + ", Register=" + this.Register;
        }
    }

    public static class ConstraintInfo
    implements Destructors.ClassWithDestructor {
        public static final int CI_None = 0;
        public static final int CI_AllowsMemory = 1;
        public static final int CI_AllowsRegister = 2;
        public static final int CI_ReadWrite = 4;
        public static final int CI_HasMatchingInput = 8;
        public static final int CI_ImmediateConstant = 16;
        public static final int CI_EarlyClobber = 32;
        public int Flags;
        public int TiedOperand;
        public Unnamed_struct1 ImmRange;
        public std.string ConstraintStr;
        public std.string Name;

        public ConstraintInfo(StringRef ConstraintStr, StringRef Name) {
            this.Flags = 0;
            this.TiedOperand = -1;
            this.ImmRange = new Unnamed_struct1();
            this.ConstraintStr = new std.string(ConstraintStr.str());
            this.Name = new std.string(Name.str());
            this.ImmRange.Max = 0;
            this.ImmRange.Min = 0;
        }

        public std.string getConstraintStr() {
            return this.ConstraintStr;
        }

        public std.string getName() {
            return this.Name;
        }

        public boolean isReadWrite() {
            return (this.Flags & 4) != 0;
        }

        public boolean earlyClobber() {
            return (this.Flags & 0x20) != 0;
        }

        public boolean allowsRegister() {
            return (this.Flags & 2) != 0;
        }

        public boolean allowsMemory() {
            return (this.Flags & 1) != 0;
        }

        public boolean hasMatchingInput() {
            return (this.Flags & 8) != 0;
        }

        public boolean hasTiedOperand() {
            return this.TiedOperand != -1;
        }

        public int getTiedOperand() {
            assert (this.hasTiedOperand()) : "Has no tied operand!";
            return this.TiedOperand;
        }

        public boolean requiresImmediateConstant() {
            return (this.Flags & 0x10) != 0;
        }

        public int getImmConstantMin() {
            return this.ImmRange.Min;
        }

        public int getImmConstantMax() {
            return this.ImmRange.Max;
        }

        public void setIsReadWrite() {
            this.Flags |= 4;
        }

        public void setEarlyClobber() {
            this.Flags |= 0x20;
        }

        public void setAllowsMemory() {
            this.Flags |= 1;
        }

        public void setAllowsRegister() {
            this.Flags |= 2;
        }

        public void setHasMatchingInput() {
            this.Flags |= 8;
        }

        public void setRequiresImmediate(int Min, int Max) {
            this.Flags |= 0x10;
            this.ImmRange.Min = Min;
            this.ImmRange.Max = Max;
        }

        public void setTiedOperand(int N, ConstraintInfo Output) {
            Output.setHasMatchingInput();
            this.Flags = Output.Flags;
            this.TiedOperand = N;
        }

        public ConstraintInfo(ConstraintInfo $Prm0) {
            this.Flags = $Prm0.Flags;
            this.TiedOperand = $Prm0.TiedOperand;
            this.ImmRange = new Unnamed_struct1($Prm0.ImmRange);
            this.ConstraintStr = new std.string($Prm0.ConstraintStr);
            this.Name = new std.string($Prm0.Name);
        }

        public void $destroy() {
            this.Name.$destroy();
            this.ConstraintStr.$destroy();
        }

        public String toString() {
            return "Flags=" + this.Flags + ", TiedOperand=" + this.TiedOperand + ", ImmRange=" + this.ImmRange + ", ConstraintStr=" + this.ConstraintStr + ", Name=" + this.Name;
        }

        public static class Unnamed_struct1 {
            public int Min;
            public int Max;

            public Unnamed_struct1(Unnamed_struct1 $Prm0) {
                this.Min = $Prm0.Min;
                this.Max = $Prm0.Max;
            }

            public Unnamed_struct1() {
            }

            public String toString() {
                return "Min=" + this.Min + ", Max=" + this.Max;
            }
        }
    }

    public static final class BuiltinVaListKind
    extends Enum<BuiltinVaListKind> {
        public static final /* enum */ BuiltinVaListKind CharPtrBuiltinVaList = new BuiltinVaListKind(0);
        public static final /* enum */ BuiltinVaListKind VoidPtrBuiltinVaList = new BuiltinVaListKind(CharPtrBuiltinVaList.getValue() + 1);
        public static final /* enum */ BuiltinVaListKind AArch64ABIBuiltinVaList = new BuiltinVaListKind(VoidPtrBuiltinVaList.getValue() + 1);
        public static final /* enum */ BuiltinVaListKind PNaClABIBuiltinVaList = new BuiltinVaListKind(AArch64ABIBuiltinVaList.getValue() + 1);
        public static final /* enum */ BuiltinVaListKind PowerABIBuiltinVaList = new BuiltinVaListKind(PNaClABIBuiltinVaList.getValue() + 1);
        public static final /* enum */ BuiltinVaListKind X86_64ABIBuiltinVaList = new BuiltinVaListKind(PowerABIBuiltinVaList.getValue() + 1);
        public static final /* enum */ BuiltinVaListKind AAPCSABIBuiltinVaList = new BuiltinVaListKind(X86_64ABIBuiltinVaList.getValue() + 1);
        public static final /* enum */ BuiltinVaListKind SystemZBuiltinVaList = new BuiltinVaListKind(AAPCSABIBuiltinVaList.getValue() + 1);
        private final int value;
        private static final /* synthetic */ BuiltinVaListKind[] $VALUES;

        public static BuiltinVaListKind[] values() {
            return (BuiltinVaListKind[])$VALUES.clone();
        }

        public static BuiltinVaListKind valueOf(String name) {
            return Enum.valueOf(BuiltinVaListKind.class, name);
        }

        public static BuiltinVaListKind valueOf(int val) {
            BuiltinVaListKind out;
            BuiltinVaListKind builtinVaListKind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private BuiltinVaListKind(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new BuiltinVaListKind[]{CharPtrBuiltinVaList, VoidPtrBuiltinVaList, AArch64ABIBuiltinVaList, PNaClABIBuiltinVaList, PowerABIBuiltinVaList, X86_64ABIBuiltinVaList, AAPCSABIBuiltinVaList, SystemZBuiltinVaList};
        }

        private static final class Values {
            private static final BuiltinVaListKind[] VALUES;
            private static final BuiltinVaListKind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (BuiltinVaListKind kind : BuiltinVaListKind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new BuiltinVaListKind[min < 0 ? 1 - min : 0];
                VALUES = new BuiltinVaListKind[max >= 0 ? 1 + max : 0];
                for (BuiltinVaListKind kind : BuiltinVaListKind.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((BuiltinVaListKind)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((BuiltinVaListKind)kind).value] = kind;
                }
            }
        }
    }

    public static final class RealType
    extends Enum<RealType> {
        public static final /* enum */ RealType NoFloat = new RealType(255);
        public static final /* enum */ RealType Float = new RealType(0);
        public static final /* enum */ RealType Double = new RealType(Float.getValue() + 1);
        public static final /* enum */ RealType LongDouble = new RealType(Double.getValue() + 1);
        private final int value;
        private static final /* synthetic */ RealType[] $VALUES;

        public static RealType[] values() {
            return (RealType[])$VALUES.clone();
        }

        public static RealType valueOf(String name) {
            return Enum.valueOf(RealType.class, name);
        }

        public static RealType valueOf(int val) {
            RealType out;
            RealType realType = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private RealType(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new RealType[]{NoFloat, Float, Double, LongDouble};
        }

        private static final class Values {
            private static final RealType[] VALUES;
            private static final RealType[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (RealType kind : RealType.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new RealType[min < 0 ? 1 - min : 0];
                VALUES = new RealType[max >= 0 ? 1 + max : 0];
                for (RealType kind : RealType.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((RealType)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((RealType)kind).value] = kind;
                }
            }
        }
    }

    public static final class IntType
    extends Enum<IntType> {
        public static final /* enum */ IntType NoInt = new IntType(0);
        public static final /* enum */ IntType SignedChar = new IntType(NoInt.getValue() + 1);
        public static final /* enum */ IntType UnsignedChar = new IntType(SignedChar.getValue() + 1);
        public static final /* enum */ IntType SignedShort = new IntType(UnsignedChar.getValue() + 1);
        public static final /* enum */ IntType UnsignedShort = new IntType(SignedShort.getValue() + 1);
        public static final /* enum */ IntType SignedInt = new IntType(UnsignedShort.getValue() + 1);
        public static final /* enum */ IntType UnsignedInt = new IntType(SignedInt.getValue() + 1);
        public static final /* enum */ IntType SignedLong = new IntType(UnsignedInt.getValue() + 1);
        public static final /* enum */ IntType UnsignedLong = new IntType(SignedLong.getValue() + 1);
        public static final /* enum */ IntType SignedLongLong = new IntType(UnsignedLong.getValue() + 1);
        public static final /* enum */ IntType UnsignedLongLong = new IntType(SignedLongLong.getValue() + 1);
        private final int value;
        private static final /* synthetic */ IntType[] $VALUES;

        public static IntType[] values() {
            return (IntType[])$VALUES.clone();
        }

        public static IntType valueOf(String name) {
            return Enum.valueOf(IntType.class, name);
        }

        public static IntType valueOf(int val) {
            IntType out;
            IntType intType = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private IntType(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new IntType[]{NoInt, SignedChar, UnsignedChar, SignedShort, UnsignedShort, SignedInt, UnsignedInt, SignedLong, UnsignedLong, SignedLongLong, UnsignedLongLong};
        }

        private static final class Values {
            private static final IntType[] VALUES;
            private static final IntType[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (IntType kind : IntType.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new IntType[min < 0 ? 1 - min : 0];
                VALUES = new IntType[max >= 0 ? 1 + max : 0];
                for (IntType kind : IntType.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((IntType)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((IntType)kind).value] = kind;
                }
            }
        }
    }
}

