/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.target.impl;

import org.clang.basic.LangOptions;
import org.clang.basic.MacroBuilder;
import org.clang.basic.target.TargetInfo;
import org.clang.basic.target.impl.MipsTargetInfoBase;
import org.clank.java.std;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.llvm.adt.APFloat;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;

public abstract class Mips64TargetInfoBase
extends MipsTargetInfoBase {
    private static final TargetInfo.GCCRegAlias[] GCCRegAliases = new TargetInfo.GCCRegAlias[]{new TargetInfo.GCCRegAlias(new char.ptr[]{NativePointer.$((String)"at")}, NativePointer.$((String)"$1")), new TargetInfo.GCCRegAlias(new char.ptr[]{NativePointer.$((String)"v0")}, NativePointer.$((String)"$2")), new TargetInfo.GCCRegAlias(new char.ptr[]{NativePointer.$((String)"v1")}, NativePointer.$((String)"$3")), new TargetInfo.GCCRegAlias(new char.ptr[]{NativePointer.$((String)"a0")}, NativePointer.$((String)"$4")), new TargetInfo.GCCRegAlias(new char.ptr[]{NativePointer.$((String)"a1")}, NativePointer.$((String)"$5")), new TargetInfo.GCCRegAlias(new char.ptr[]{NativePointer.$((String)"a2")}, NativePointer.$((String)"$6")), new TargetInfo.GCCRegAlias(new char.ptr[]{NativePointer.$((String)"a3")}, NativePointer.$((String)"$7")), new TargetInfo.GCCRegAlias(new char.ptr[]{NativePointer.$((String)"a4")}, NativePointer.$((String)"$8")), new TargetInfo.GCCRegAlias(new char.ptr[]{NativePointer.$((String)"a5")}, NativePointer.$((String)"$9")), new TargetInfo.GCCRegAlias(new char.ptr[]{NativePointer.$((String)"a6")}, NativePointer.$((String)"$10")), new TargetInfo.GCCRegAlias(new char.ptr[]{NativePointer.$((String)"a7")}, NativePointer.$((String)"$11")), new TargetInfo.GCCRegAlias(new char.ptr[]{NativePointer.$((String)"t0")}, NativePointer.$((String)"$12")), new TargetInfo.GCCRegAlias(new char.ptr[]{NativePointer.$((String)"t1")}, NativePointer.$((String)"$13")), new TargetInfo.GCCRegAlias(new char.ptr[]{NativePointer.$((String)"t2")}, NativePointer.$((String)"$14")), new TargetInfo.GCCRegAlias(new char.ptr[]{NativePointer.$((String)"t3")}, NativePointer.$((String)"$15")), new TargetInfo.GCCRegAlias(new char.ptr[]{NativePointer.$((String)"s0")}, NativePointer.$((String)"$16")), new TargetInfo.GCCRegAlias(new char.ptr[]{NativePointer.$((String)"s1")}, NativePointer.$((String)"$17")), new TargetInfo.GCCRegAlias(new char.ptr[]{NativePointer.$((String)"s2")}, NativePointer.$((String)"$18")), new TargetInfo.GCCRegAlias(new char.ptr[]{NativePointer.$((String)"s3")}, NativePointer.$((String)"$19")), new TargetInfo.GCCRegAlias(new char.ptr[]{NativePointer.$((String)"s4")}, NativePointer.$((String)"$20")), new TargetInfo.GCCRegAlias(new char.ptr[]{NativePointer.$((String)"s5")}, NativePointer.$((String)"$21")), new TargetInfo.GCCRegAlias(new char.ptr[]{NativePointer.$((String)"s6")}, NativePointer.$((String)"$22")), new TargetInfo.GCCRegAlias(new char.ptr[]{NativePointer.$((String)"s7")}, NativePointer.$((String)"$23")), new TargetInfo.GCCRegAlias(new char.ptr[]{NativePointer.$((String)"t8")}, NativePointer.$((String)"$24")), new TargetInfo.GCCRegAlias(new char.ptr[]{NativePointer.$((String)"t9")}, NativePointer.$((String)"$25")), new TargetInfo.GCCRegAlias(new char.ptr[]{NativePointer.$((String)"k0")}, NativePointer.$((String)"$26")), new TargetInfo.GCCRegAlias(new char.ptr[]{NativePointer.$((String)"k1")}, NativePointer.$((String)"$27")), new TargetInfo.GCCRegAlias(new char.ptr[]{NativePointer.$((String)"gp")}, NativePointer.$((String)"$28")), new TargetInfo.GCCRegAlias(new char.ptr[]{NativePointer.$((String)"sp"), NativePointer.$((String)"$sp")}, NativePointer.$((String)"$29")), new TargetInfo.GCCRegAlias(new char.ptr[]{NativePointer.$((String)"fp"), NativePointer.$((String)"$fp")}, NativePointer.$((String)"$30")), new TargetInfo.GCCRegAlias(new char.ptr[]{NativePointer.$((String)"ra")}, NativePointer.$((String)"$31"))};

    public Mips64TargetInfoBase(Triple _Triple) {
        super(_Triple, new std.string((CharSequence)"n64"), new std.string((CharSequence)"mips64r2"));
        this.LongDoubleAlign = (short)128;
        this.LongDoubleWidth = (short)128;
        this.LongDoubleFormat = APFloat.IEEEquad;
        if (this.getTriple().getOS() == Triple.OSType.FreeBSD) {
            this.LongDoubleAlign = (short)64;
            this.LongDoubleWidth = (short)64;
            this.LongDoubleFormat = APFloat.IEEEdouble;
        }
        this.setN64ABITypes();
        this.SuitableAlign = (short)128;
        this.MaxAtomicInlineWidth = (short)64;
        this.MaxAtomicPromoteWidth = (short)64;
    }

    public void setN64ABITypes() {
        this.LongAlign = (short)64;
        this.LongWidth = (short)64;
        this.PointerAlign = (short)64;
        this.PointerWidth = (short)64;
        this.SizeType = TargetInfo.IntType.UnsignedLong;
        this.PtrDiffType = TargetInfo.IntType.SignedLong;
        this.IntMaxType = this.Int64Type = TargetInfo.IntType.SignedLong;
    }

    public void setN32ABITypes() {
        this.LongAlign = (short)32;
        this.LongWidth = (short)32;
        this.PointerAlign = (short)32;
        this.PointerWidth = (short)32;
        this.SizeType = TargetInfo.IntType.UnsignedInt;
        this.PtrDiffType = TargetInfo.IntType.SignedInt;
        this.IntMaxType = this.Int64Type = TargetInfo.IntType.SignedLongLong;
    }

    @Override
    public boolean setABI(std.string Name) {
        if (std.$eq_str_T((std.string)Name, (char.iterator)NativePointer.$((String)"n32"))) {
            this.setN32ABITypes();
            this.ABI.$assign(Name);
            return true;
        }
        if (std.$eq_str_T((std.string)Name, (char.iterator)NativePointer.$((String)"n64"))) {
            this.setN64ABITypes();
            this.ABI.$assign(Name);
            return true;
        }
        return false;
    }

    @Override
    public void getTargetDefines(LangOptions Opts, MacroBuilder Builder) {
        super.getTargetDefines(Opts, Builder);
        Builder.defineMacro(new Twine(NativePointer.$((String)"__mips")), new Twine(NativePointer.$((String)"64")));
        Builder.defineMacro(new Twine(NativePointer.$((String)"__mips64")));
        Builder.defineMacro(new Twine(NativePointer.$((String)"__mips64__")));
        Builder.defineMacro(new Twine(NativePointer.$((String)"_MIPS_ISA")), new Twine(NativePointer.$((String)"_MIPS_ISA_MIPS64")));
        std.string CPUStr = this.getCPU();
        if (std.$eq_str_T((std.string)CPUStr, (char.iterator)NativePointer.$((String)"mips64"))) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__mips_isa_rev")), new Twine(NativePointer.$((String)"1")));
        } else if (std.$eq_str_T((std.string)CPUStr, (char.iterator)NativePointer.$((String)"mips64r2"))) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__mips_isa_rev")), new Twine(NativePointer.$((String)"2")));
        } else if (std.$eq_str_T((std.string)CPUStr, (char.iterator)NativePointer.$((String)"mips64r6"))) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__mips_isa_rev")), new Twine(NativePointer.$((String)"6")));
        }
        if (std.$eq_str_T((std.string)this.ABI, (char.iterator)NativePointer.$((String)"n32"))) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__mips_n32")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"_ABIN32")), new Twine(NativePointer.$((String)"2")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"_MIPS_SIM")), new Twine(NativePointer.$((String)"_ABIN32")));
        } else if (std.$eq_str_T((std.string)this.ABI, (char.iterator)NativePointer.$((String)"n64"))) {
            Builder.defineMacro(new Twine(NativePointer.$((String)"__mips_n64")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"_ABI64")), new Twine(NativePointer.$((String)"3")));
            Builder.defineMacro(new Twine(NativePointer.$((String)"_MIPS_SIM")), new Twine(NativePointer.$((String)"_ABI64")));
        } else {
            throw new llvm_unreachable((CharSequence)"Invalid ABI for Mips64.");
        }
    }

    @Override
    public void getGCCRegAliases(type.ref<TargetInfo.GCCRegAlias[]> Aliases, uint.ref NumAliases) {
        Aliases.$set((Object)GCCRegAliases);
        NumAliases.$set((long)llvm.array_lengthof((Object[])GCCRegAliases));
    }

    @Override
    public boolean hasInt128Type() {
        return true;
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }
}

