/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.target.impl;

import org.clang.basic.target.TargetInfo;
import org.clang.basic.target.impl.PPCTargetInfo;
import org.clank.java.std;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.llvm.adt.APFloat;
import org.llvm.adt.Triple;

public class PPC64TargetInfo
extends PPCTargetInfo {
    public PPC64TargetInfo(Triple _Triple) {
        super(_Triple);
        this.PointerAlign = (short)64;
        this.PointerWidth = (short)64;
        this.LongAlign = (short)64;
        this.LongWidth = (short)64;
        this.IntMaxType = TargetInfo.IntType.SignedLong;
        this.Int64Type = TargetInfo.IntType.SignedLong;
        if (_Triple.getArch() == Triple.ArchType.ppc64le) {
            this.DescriptionString = NativePointer.$((String)"e-m:e-i64:64-n32:64");
            this.ABI.$assign(NativePointer.$((String)"elfv2"));
        } else {
            this.DescriptionString = NativePointer.$((String)"E-m:e-i64:64-n32:64");
            this.ABI.$assign(NativePointer.$((String)"elfv1"));
        }
        switch (this.getTriple().getOS()) {
            case FreeBSD: {
                this.LongDoubleAlign = (short)64;
                this.LongDoubleWidth = (short)64;
                this.LongDoubleFormat = APFloat.IEEEdouble;
                break;
            }
            case NetBSD: {
                this.IntMaxType = TargetInfo.IntType.SignedLongLong;
                this.Int64Type = TargetInfo.IntType.SignedLongLong;
                break;
            }
        }
        this.MaxAtomicInlineWidth = (short)64;
        this.MaxAtomicPromoteWidth = (short)64;
    }

    @Override
    public TargetInfo.BuiltinVaListKind getBuiltinVaListKind() {
        return TargetInfo.BuiltinVaListKind.CharPtrBuiltinVaList;
    }

    @Override
    public boolean setABI(std.string Name) {
        if (std.$eq_str_T((std.string)Name, (char.iterator)NativePointer.$((String)"elfv1")) || std.$eq_str_T((std.string)Name, (char.iterator)NativePointer.$((String)"elfv2"))) {
            this.ABI.$assign(Name);
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }
}

