/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.nodejs.editor;

import java.util.Arrays;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.javascript2.editor.api.lexer.JsTokenId;
import org.netbeans.modules.javascript2.editor.api.lexer.LexUtilities;
import org.netbeans.modules.javascript2.nodejs.editor.NodeJsUtils;

public enum NodeJsContext {
    MODULE_PATH,
    ASSIGN_LISTENER,
    AFTER_ASSIGNMENT,
    GLOBAL,
    UNKNOWN;


    public static NodeJsContext findContext(TokenSequence<? extends JsTokenId> ts, int offset) {
        ts.move(offset);
        if (ts.moveNext() || ts.movePrevious()) {
            Token token = ts.token();
            JsTokenId tokenId = (JsTokenId)token.id();
            if (tokenId == JsTokenId.STRING || tokenId == JsTokenId.STRING_END) {
                token = LexUtilities.findPrevious(ts, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.EOL, JsTokenId.BLOCK_COMMENT, JsTokenId.LINE_COMMENT, JsTokenId.STRING_BEGIN, JsTokenId.STRING, JsTokenId.STRING_END, JsTokenId.OPERATOR_COMMA));
                tokenId = (JsTokenId)token.id();
                if (tokenId == JsTokenId.BRACKET_LEFT_PAREN && ts.movePrevious() && (tokenId = (JsTokenId)(token = LexUtilities.findPrevious(ts, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.BLOCK_COMMENT))).id()) == JsTokenId.IDENTIFIER) {
                    if (NodeJsUtils.REQUIRE_METHOD_NAME.equals(token.text().toString())) {
                        return MODULE_PATH;
                    }
                    if (NodeJsUtils.ON_METHOD_NAME.equals(token.text().toString())) {
                        return ASSIGN_LISTENER;
                    }
                }
            } else {
                if ((tokenId == JsTokenId.EOL || tokenId == JsTokenId.OPERATOR_SEMICOLON || tokenId == JsTokenId.OPERATOR_ASSIGNMENT || tokenId == JsTokenId.WHITESPACE || tokenId == JsTokenId.IDENTIFIER || tokenId == JsTokenId.BRACKET_LEFT_CURLY) && ts.movePrevious()) {
                    token = LexUtilities.findPrevious(ts, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.BLOCK_COMMENT, JsTokenId.EOL));
                    tokenId = (JsTokenId)token.id();
                }
                if (tokenId.isKeyword() && ts.offset() == offset) {
                    return GLOBAL;
                }
                if (!ts.movePrevious()) {
                    return GLOBAL;
                }
                if (tokenId == JsTokenId.IDENTIFIER && NodeJsUtils.REQUIRE_METHOD_NAME.startsWith(token.text().toString())) {
                    token = LexUtilities.findPrevious(ts, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.BLOCK_COMMENT, JsTokenId.EOL));
                    tokenId = (JsTokenId)token.id();
                    if (!ts.movePrevious()) {
                        return GLOBAL;
                    }
                }
                if (tokenId == JsTokenId.OPERATOR_ASSIGNMENT) {
                    return AFTER_ASSIGNMENT;
                }
                if (tokenId == JsTokenId.OPERATOR_SEMICOLON || tokenId == JsTokenId.BRACKET_LEFT_CURLY || tokenId == JsTokenId.BRACKET_RIGHT_CURLY) {
                    return GLOBAL;
                }
            }
        }
        return UNKNOWN;
    }

    public static String getEventEmiterName(TokenSequence<? extends JsTokenId> ts, int offset) {
        if (NodeJsContext.findContext(ts, offset) == ASSIGN_LISTENER && ts.movePrevious() && ts.token().id() == JsTokenId.OPERATOR_DOT && ts.movePrevious() && ts.token().id() == JsTokenId.IDENTIFIER) {
            return ts.token().text().toString();
        }
        return null;
    }
}

