/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.nodejs.editor;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.netbeans.modules.javascript2.nodejs.editor.NodeJsDataProvider;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;

public class NodeJsUtils {
    public static String REQUIRE_METHOD_NAME = "require";
    public static String ON_METHOD_NAME = "on";
    public static String NODE_MODULES_NAME = "node_modules";
    public static String PACKAGE_NAME = "package";
    public static String INDEX_NAME = "index";
    public static String FAKE_OBJECT_NAME_PREFIX = "nm$_";
    public static String NODEJS_NAME = "NodeJS";
    public static String JS_EXT = "js";
    public static String JSON_EXT = "json";
    public static String NODE_EXT = "node";
    private static String MAIN_FIELD = "main";
    private static final String SLASH = "/";
    public static final String EXPORTS = "exports";
    public static final String MODULE = "module";
    public static final String PROTOTYPE = "prototype";
    private static final String NODEJS_ICON_PATH = "org/netbeans/modules/javascript2/nodejs/resources/nodeJs16.png";
    private static ImageIcon NODEJS_ICON = null;

    public static ImageIcon getNodeJsIcon() {
        if (NODEJS_ICON == null) {
            NODEJS_ICON = new ImageIcon(ImageUtilities.loadImage((String)NODEJS_ICON_PATH));
        }
        return NODEJS_ICON;
    }

    public static FileObject findModuleFile(FileObject fromModule, String modulePath) {
        if (modulePath == null || modulePath.isEmpty()) {
            return null;
        }
        char firstChar = modulePath.charAt(0);
        FileObject resultFO = null;
        if (firstChar == '/') {
            File file = new File(modulePath);
            if (file.exists()) {
                resultFO = FileUtil.toFileObject((File)file);
            }
            if (resultFO != null && !resultFO.isFolder()) {
                return resultFO;
            }
            return null;
        }
        if (firstChar == '.') {
            resultFO = NodeJsUtils.findModuleAsFile(fromModule, modulePath);
            if (resultFO == null) {
                resultFO = NodeJsUtils.findModuleAsFolder(fromModule, modulePath);
            }
            if (resultFO != null) {
                return NODE_EXT.equals(resultFO.getExt()) ? null : resultFO;
            }
        }
        if ((resultFO = NodeJsUtils.findNodeModule(fromModule, modulePath)) != null) {
            return NODE_EXT.equals(resultFO.getExt()) ? null : resultFO;
        }
        return null;
    }

    private static FileObject findModuleAsFile(FileObject fromModule, String module) {
        FileObject parentFO;
        FileObject fileObject = parentFO = fromModule.isFolder() ? fromModule : fromModule.getParent();
        if (parentFO != null) {
            FileObject resultFO = parentFO.getFileObject(module);
            if (resultFO != null && !resultFO.isFolder()) {
                return resultFO;
            }
            resultFO = parentFO.getFileObject(module + '.' + JS_EXT);
            if (resultFO != null && !resultFO.isFolder()) {
                return resultFO;
            }
            resultFO = parentFO.getFileObject(module + '.' + JSON_EXT);
            if (resultFO != null && !resultFO.isFolder()) {
                return resultFO;
            }
            resultFO = parentFO.getFileObject(module + '.' + NODE_EXT);
            if (resultFO != null && !resultFO.isFolder()) {
                return resultFO;
            }
        }
        return null;
    }

    private static FileObject findModuleAsFolder(FileObject fromModule, String module) {
        FileObject parentFO;
        FileObject fileObject = parentFO = fromModule.isFolder() ? fromModule : fromModule.getParent();
        if (parentFO == null) {
            return null;
        }
        FileObject moduleFolderFO = parentFO.getFileObject(module);
        if (moduleFolderFO != null && moduleFolderFO.isFolder()) {
            String valueOfMain;
            FileObject packageFO = moduleFolderFO.getFileObject(PACKAGE_NAME + '.' + JSON_EXT);
            FileObject resultFO = null;
            if (packageFO != null && !packageFO.isFolder() && (valueOfMain = NodeJsUtils.getValueOfMain(packageFO)) != null && (resultFO = NodeJsUtils.findModuleAsFile(packageFO, valueOfMain)) != null) {
                return resultFO;
            }
            resultFO = parentFO.getFileObject(module + SLASH + INDEX_NAME + '.' + JS_EXT);
            if (resultFO != null && !resultFO.isFolder()) {
                return resultFO;
            }
            resultFO = parentFO.getFileObject(module + SLASH + INDEX_NAME + '.' + NODE_EXT);
            if (resultFO != null && !resultFO.isFolder()) {
                return resultFO;
            }
        }
        return null;
    }

    private static FileObject findNodeModule(FileObject fromModule, String module) {
        FileObject parentFolder;
        FileObject runtimeModule = NodeJsUtils.getRuntimeModuleFile(fromModule, module);
        if (runtimeModule != null) {
            return runtimeModule;
        }
        FileObject fileObject = parentFolder = fromModule.isFolder() ? fromModule : fromModule.getParent();
        while (parentFolder != null) {
            FileObject nodeModulesFO = parentFolder.getFileObject(NODE_MODULES_NAME);
            if (nodeModulesFO != null) {
                FileObject resultFO = NodeJsUtils.findModuleAsFile(nodeModulesFO, module);
                if (resultFO == null) {
                    resultFO = NodeJsUtils.findModuleAsFolder(nodeModulesFO, module);
                }
                if (resultFO != null) {
                    return resultFO;
                }
            }
            parentFolder = parentFolder.getParent();
        }
        return null;
    }

    private static FileObject getRuntimeModuleFile(FileObject fromModule, String module) {
        FileObject runtime = NodeJsDataProvider.getDefault(fromModule).getFolderWithRuntimeSources();
        FileObject result = null;
        if (runtime != null && runtime.isFolder()) {
            result = runtime.getFileObject(module, "js");
        }
        return result;
    }

    private static String getValueOfMain(FileObject file) {
        Object main;
        JSONObject root;
        String content = NodeJsUtils.loadFileContent(file);
        String value = null;
        if (content != null && !content.isEmpty() && (root = (JSONObject)JSONValue.parse((String)content)) != null && (main = root.get((Object)MAIN_FIELD)) != null && main instanceof String) {
            value = (String)main;
        }
        return value;
    }

    public static String loadFileContent(FileObject file) {
        Object r = null;
        try {
            DataObject dobj = DataObject.find((FileObject)file);
            EditorCookie ec = (EditorCookie)dobj.getLookup().lookup(EditorCookie.class);
            if (ec == null) {
                return null;
            }
            final StyledDocument document = ec.openDocument();
            final AtomicReference docContentRef = new AtomicReference();
            final AtomicReference bleRef = new AtomicReference();
            document.render(new Runnable(){

                @Override
                public void run() {
                    try {
                        docContentRef.set(document.getText(0, document.getLength()));
                    }
                    catch (BadLocationException ex) {
                        bleRef.set(ex);
                    }
                }
            });
            if (bleRef.get() != null) {
                return null;
            }
            return (String)docContentRef.get();
        }
        catch (FileNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return "";
    }

    public static String getModuleName(String modulePath) {
        String name = modulePath;
        if (name.indexOf(47) > -1) {
            name = name.substring(name.lastIndexOf(47) + 1);
        }
        if (name.indexOf(46) > -1) {
            name = name.substring(0, name.lastIndexOf(46));
        }
        return name;
    }

    public static String writeFilePathForDocWindow(FileObject fo) {
        String path = fo.getPath();
        String[] parts = path.split(SLASH);
        StringBuilder sb = new StringBuilder();
        sb.append("<pre>");
        int length = 0;
        for (String part : parts) {
            if (length + part.length() > 50) {
                sb.append("\n    ");
                length = 4;
            }
            sb.append(part).append('/');
            length += part.length() + 1;
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("</pre>");
        return sb.toString();
    }
}

