/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.nodejs.editor.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.javascript2.editor.api.FrameworksUtils;
import org.netbeans.modules.javascript2.editor.model.DeclarationScope;
import org.netbeans.modules.javascript2.editor.model.JsObject;
import org.netbeans.modules.javascript2.editor.model.TypeUsage;
import org.netbeans.modules.javascript2.editor.spi.model.ModelElementFactory;
import org.netbeans.modules.javascript2.editor.spi.model.ObjectInterceptor;
import org.netbeans.modules.javascript2.nodejs.editor.NodeJsUtils;

public class NodeJsObjectInterceptor
implements ObjectInterceptor {
    public void interceptGlobal(JsObject global, ModelElementFactory factory) {
        JsObject module;
        JsObject exports = global.getProperty("exports");
        if (exports == null && (module = global.getProperty("module")) != null) {
            exports = module.getProperty("exports");
        }
        if (exports != null && exports.getProperties().size() == 0) {
            for (JsObject variable : global.getProperties().values()) {
                Collection assignments = variable.getAssignments();
                boolean isThis = false;
                for (TypeUsage type : assignments) {
                    if (!"exports".equals(type.getType())) continue;
                    isThis = true;
                    break;
                }
                if (!isThis) continue;
                variable.clearAssignments();
                for (TypeUsage type : assignments) {
                    if ("exports".equals(type.getType())) continue;
                    variable.addAssignment(type, type.getOffset());
                }
                exports = factory.newReference(exports.getName(), variable, true, true);
                exports.getParent().addProperty(exports.getName(), exports);
                break;
            }
        }
        if (exports != null) {
            module = factory.newFunction((DeclarationScope)global, global, NodeJsUtils.FAKE_OBJECT_NAME_PREFIX + global.getName(), (Collection)Collections.EMPTY_LIST, global.getOffsetRange(), null);
            module.setAnonymous(true);
            global.addProperty(module.getName(), module);
            ((DeclarationScope)global).addDeclaredScope((DeclarationScope)module);
            ArrayList properties = new ArrayList(global.getProperties().values());
            for (JsObject property : properties) {
                String propertyName = property.getName();
                if (!property.isDeclared() && !"module".equals(propertyName) && !"exports".equals(propertyName) || module.getName().equals(propertyName)) continue;
                global.moveProperty(property.getName(), module);
                if (!property.isDeclared()) continue;
                Set modifiers = property.getModifiers();
                modifiers.remove(Modifier.PUBLIC);
                modifiers.add(Modifier.PRIVATE);
            }
            DeclarationScope globalScope = (DeclarationScope)global;
            ArrayList childrenScopesCopy = new ArrayList(globalScope.getChildrenScopes());
            for (DeclarationScope movedScope : childrenScopesCopy) {
                if (movedScope.equals(module)) continue;
                FrameworksUtils.changeDeclarationScope((JsObject)((JsObject)movedScope), (DeclarationScope)module);
            }
        }
    }
}

