/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.zend;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.base.input.InputProcessor;
import org.netbeans.api.extexecution.base.input.InputProcessors;
import org.netbeans.api.extexecution.base.input.LineProcessor;
import org.netbeans.modules.php.api.executable.InvalidPhpExecutableException;
import org.netbeans.modules.php.api.executable.PhpExecutable;
import org.netbeans.modules.php.api.executable.PhpExecutableValidator;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.spi.framework.commands.FrameworkCommand;
import org.netbeans.modules.php.zend.Bundle;
import org.netbeans.modules.php.zend.ZendPhpFrameworkProvider;
import org.netbeans.modules.php.zend.commands.ZendCommand;
import org.netbeans.modules.php.zend.ui.options.ZendOptions;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;

public final class ZendScript {
    private static final Logger LOGGER = Logger.getLogger(ZendScript.class.getName());
    public static final String SCRIPT_NAME = "zf";
    public static final String SCRIPT_NAME_LONG = "zf" + FileUtils.getScriptExtension((boolean)true);
    public static final String OPTIONS_ID = "Zend";
    public static final String OPTIONS_SUB_PATH = "FrameworksAndTools/Zend";
    static final String COMMANDS_SEPARATOR = ":NB:";
    private static final String ENV_INCLUDE_PATH_PREPEND = "ZEND_TOOL_INCLUDE_PATH_PREPEND";
    private static final Map<String, String> ENVIRONMENT_VARIABLES;
    private static final String HELP_COMMAND = "?";
    private static final List<String> INIT_PROJECT_COMMAND;
    private static final List<String> CREATE_CONFIG_COMMAND;
    private static final List<String> ENABLE_CONFIG_COMMAND;
    private static final List<String> SHOW_COMMANDS_COMMAND;
    private static final String COMMANDS_PROVIDER_REL_PATH = "zend/NetBeansCommandsProvider.php";
    private static final File COMMANDS_PROVIDER;
    private final String zendPath;

    private ZendScript(String zendPath) {
        this.zendPath = zendPath;
    }

    public static ZendScript getDefault() throws InvalidPhpExecutableException {
        return ZendScript.getCustom(ZendOptions.getInstance().getZend());
    }

    public static ZendScript getCustom(String zendPath) throws InvalidPhpExecutableException {
        String error = ZendScript.validate(zendPath);
        if (error != null) {
            throw new InvalidPhpExecutableException(error);
        }
        return new ZendScript(zendPath);
    }

    public static String validate(String zendPath) {
        return PhpExecutableValidator.validateCommand((String)zendPath, (String)Bundle.ZendScript_script_label());
    }

    public static String getOptionsPath() {
        return "org-netbeans-modules-php-project-ui-options-PHPOptionsCategory/FrameworksAndTools/" + ZendScript.getOptionsSubPath();
    }

    public static String getOptionsSubPath() {
        return OPTIONS_SUB_PATH;
    }

    public String getHelp(PhpModule phpModule, List<String> parameters) {
        assert (!EventQueue.isDispatchThread());
        assert (phpModule != null);
        ArrayList<String> allParameters = new ArrayList<String>(parameters);
        allParameters.add(HELP_COMMAND);
        HelpLineProcessor lineProcessor = new HelpLineProcessor();
        Future result = this.createPhpExecutable().workDir(FileUtil.toFile((FileObject)phpModule.getSourceDirectory())).displayName(this.getDisplayName(phpModule)).additionalParameters(allParameters).run(this.getSilentDescriptor(), this.getOutProcessorFactory(lineProcessor));
        if (result == null) {
            return "";
        }
        try {
            result.get();
        }
        catch (CancellationException ex) {
        }
        catch (ExecutionException ex) {
            UiUtils.processExecutionException((ExecutionException)ex, (String)ZendScript.getOptionsSubPath());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        return lineProcessor.getHelp();
    }

    public void registerNetBeansProvider() {
        ExecutionDescriptor descriptor = this.getDescriptor(null);
        try {
            Future result = this.createPhpExecutable().displayName(this.getDisplayName()).additionalParameters(CREATE_CONFIG_COMMAND).run(descriptor);
            if (result != null) {
                result.get();
            }
            descriptor = descriptor.noReset(true);
            result = this.createPhpExecutable().displayName(this.getDisplayName()).additionalParameters(ENABLE_CONFIG_COMMAND).run(descriptor);
            if (result != null) {
                result.get();
            }
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ZendScript.class, (String)"MSG_ProviderRegistrationInfo"), 1));
        }
        catch (CancellationException ex) {
        }
        catch (ExecutionException ex) {
            UiUtils.processExecutionException((ExecutionException)ex, (String)ZendScript.getOptionsSubPath());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public boolean initProject(PhpModule phpModule) {
        try {
            File sources = FileUtil.toFile((FileObject)phpModule.getSourceDirectory());
            Future result = this.createPhpExecutable().workDir(sources).displayName(this.getDisplayName(phpModule)).additionalParameters(INIT_PROJECT_COMMAND).warnUser(false).run(this.getDescriptor(null));
            if (result != null) {
                result.get();
                FileUtil.refreshFor((File[])new File[]{sources});
            }
        }
        catch (CancellationException ex) {
        }
        catch (ExecutionException ex) {
            UiUtils.processExecutionException((ExecutionException)ex, (String)ZendScript.getOptionsSubPath());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        return ZendPhpFrameworkProvider.getInstance().isInPhpModule(phpModule);
    }

    public List<FrameworkCommand> getCommands(PhpModule phpModule) {
        CommandsLineProcessor lineProcessor = new CommandsLineProcessor(phpModule);
        Future task = this.createPhpExecutable().workDir(FileUtil.toFile((FileObject)phpModule.getSourceDirectory())).additionalParameters(SHOW_COMMANDS_COMMAND).run(this.getSilentDescriptor(), this.getOutProcessorFactory(lineProcessor));
        try {
            List<FrameworkCommand> freshCommands;
            if (task != null && (Integer)task.get() == 0 && !(freshCommands = lineProcessor.getCommands()).isEmpty()) {
                return freshCommands;
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        this.runCommand(phpModule, SHOW_COMMANDS_COMMAND, null);
        NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)Bundle.ZendScript_noCommands_registerProvider(), 0);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) == NotifyDescriptor.YES_OPTION) {
            this.registerNetBeansProvider();
        }
        return null;
    }

    public void runCommand(PhpModule phpModule, List<String> parameters, Runnable postExecution) {
        this.createPhpExecutable().workDir(FileUtil.toFile((FileObject)phpModule.getSourceDirectory())).displayName(this.getDisplayName(phpModule)).additionalParameters(parameters).run(this.getDescriptor(postExecution));
    }

    private PhpExecutable createPhpExecutable() {
        return new PhpExecutable(this.zendPath).viaPhpInterpreter(false).viaAutodetection(false).environmentVariables(ENVIRONMENT_VARIABLES);
    }

    private ExecutionDescriptor getDescriptor(Runnable postExecution) {
        return PhpExecutable.DEFAULT_EXECUTION_DESCRIPTOR.optionsPath(ZendScript.getOptionsPath()).inputVisible(false).postExecution(postExecution);
    }

    private ExecutionDescriptor getSilentDescriptor() {
        return new ExecutionDescriptor().inputOutput(InputOutput.NULL);
    }

    private ExecutionDescriptor.InputProcessorFactory2 getOutProcessorFactory(final LineProcessor lineProcessor) {
        return new ExecutionDescriptor.InputProcessorFactory2(){

            public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                return InputProcessors.ansiStripping((InputProcessor)InputProcessors.bridge((LineProcessor)lineProcessor));
            }
        };
    }

    private String getDisplayName(PhpModule phpModule) {
        return Bundle.ZendScript_command_title(phpModule.getDisplayName());
    }

    private String getDisplayName() {
        return Bundle.ZendScript_command_title_pure();
    }

    static {
        INIT_PROJECT_COMMAND = Arrays.asList("create", "project", ".");
        CREATE_CONFIG_COMMAND = Arrays.asList("create", "config");
        ENABLE_CONFIG_COMMAND = Arrays.asList("enable", "config.provider", "NetBeansCommandsProvider");
        SHOW_COMMANDS_COMMAND = Arrays.asList("show", "nb-commands", COMMANDS_SEPARATOR);
        File commandsProvider = null;
        try {
            commandsProvider = FileUtil.normalizeFile((File)InstalledFileLocator.getDefault().locate(COMMANDS_PROVIDER_REL_PATH, "org.netbeans.modules.php.zend", false).getCanonicalFile());
            if (commandsProvider == null || !commandsProvider.isFile()) {
                throw new IllegalStateException("Could not locate file zend/NetBeansCommandsProvider.php");
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Could not locate file zend/NetBeansCommandsProvider.php", ex);
        }
        COMMANDS_PROVIDER = commandsProvider;
        ENVIRONMENT_VARIABLES = Collections.singletonMap(ENV_INCLUDE_PATH_PREPEND, COMMANDS_PROVIDER.getParentFile().getAbsolutePath());
    }

    static final class CommandsLineProcessor
    implements LineProcessor {
        private final PhpModule phpModule;
        private final List<FrameworkCommand> commands = new LinkedList<FrameworkCommand>();

        public CommandsLineProcessor(PhpModule phpModule) {
            this.phpModule = phpModule;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processLine(String line) {
            if (!StringUtils.hasText((String)line)) {
                return;
            }
            if (!line.contains(ZendScript.COMMANDS_SEPARATOR)) {
                return;
            }
            String trimmed = line.trim();
            List exploded = StringUtils.explode((String)trimmed, (String)ZendScript.COMMANDS_SEPARATOR);
            assert (exploded.size() > 0);
            String command = (String)exploded.get(0);
            String description = "";
            if (exploded.size() > 1) {
                description = (String)exploded.get(1);
            }
            List<FrameworkCommand> list = this.commands;
            synchronized (list) {
                this.commands.add(new ZendCommand(this.phpModule, StringUtils.explode((String)command, (String)" ").toArray(new String[0]), description, command));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<FrameworkCommand> getCommands() {
            ArrayList<FrameworkCommand> copy;
            List<FrameworkCommand> list = this.commands;
            synchronized (list) {
                copy = new ArrayList<FrameworkCommand>(this.commands);
            }
            return copy;
        }

        public void close() {
        }

        public void reset() {
        }
    }

    static class HelpLineProcessor
    implements LineProcessor {
        private final StringBuilder buffer = new StringBuilder(2000);

        HelpLineProcessor() {
        }

        public void processLine(String line) {
            this.buffer.append(line);
            this.buffer.append("\n");
        }

        public void reset() {
        }

        public void close() {
        }

        public String getHelp() {
            return this.buffer.toString().trim() + "\n";
        }
    }
}

