/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.branch;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import java.util.MissingResourceException;
import java.util.concurrent.Callable;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.branch.BranchSelector;
import org.netbeans.modules.mercurial.ui.branch.Bundle;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class SwitchToBranchAction
extends ContextAction {
    public static final String PREF_KEY_RECENT_BRANCHES = "recentlySwitchedBranches";

    @Override
    protected boolean enable(Node[] nodes) {
        return HgUtils.isFromHgRepository(HgUtils.getCurrentContext(nodes));
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_SwitchBranch";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext ctx = HgUtils.getCurrentContext(nodes);
        File[] roots = HgUtils.getActionRoots(ctx);
        if (roots == null || roots.length == 0) {
            return;
        }
        File root = Mercurial.getInstance().getRepositoryRoot(roots[0]);
        BranchSelector switchBranch = new BranchSelector(root);
        JCheckBox forcedUpdateChxBox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)forcedUpdateChxBox, (String)NbBundle.getMessage(SwitchToBranchAction.class, (String)"SwitchTo.forcedUpdateChxBox.text"));
        JPanel optionsPanel = new JPanel(new BorderLayout());
        optionsPanel.add((Component)forcedUpdateChxBox, "North");
        optionsPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        switchBranch.setOptionsPanel(optionsPanel, null);
        JButton okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)okButton, (String)NbBundle.getMessage(BranchSelector.class, (String)"CTL_SwitchToForm_Action_SwitchTo"));
        okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BranchSelector.class, (String)"ACSD_SwitchToForm_Action_SwitchTo"));
        okButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BranchSelector.class, (String)"ACSN_SwitchToForm_Action_SwitchTo"));
        okButton.setEnabled(false);
        if (!switchBranch.showDialog(okButton, NbBundle.getMessage(BranchSelector.class, (String)"CTL_SwitchToDialog", (Object)root.getName()), NbBundle.getMessage(SwitchToBranchAction.class, (String)"SwitchToPanel.infoLabel.text"))) {
            return;
        }
        String revStr = switchBranch.getBranchName();
        if (revStr == null) {
            return;
        }
        boolean doForcedUpdate = forcedUpdateChxBox.isSelected();
        this.doSwitch(root, revStr, doForcedUpdate, ctx);
    }

    public void doSwitch(final File root, final String revStr, final boolean doForcedUpdate, final VCSContext ctx) throws MissingResourceException {
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
        HgProgressSupport support = new HgProgressSupport(){

            @Override
            public void perform() {
                final OutputLogger logger = this.getLogger();
                try {
                    logger.outputInRed(NbBundle.getMessage(SwitchToBranchAction.class, (String)"MSG_SWITCH_TITLE"));
                    logger.outputInRed(NbBundle.getMessage(SwitchToBranchAction.class, (String)"MSG_SWITCH_TITLE_SEP"));
                    logger.output(NbBundle.getMessage(SwitchToBranchAction.class, (String)"MSG_SWITCH_INFO_SEP", (Object)revStr, (Object)root.getAbsolutePath()));
                    HgUtils.runWithoutIndexing(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            List<String> list = HgCommand.doUpdateAll(root, doForcedUpdate, revStr);
                            Utils.insert((Preferences)NbPreferences.forModule(SwitchToBranchAction.class), (String)(SwitchToBranchAction.PREF_KEY_RECENT_BRANCHES + root.getAbsolutePath()), (String)revStr, (int)5);
                            if (list != null && !list.isEmpty()) {
                                if (!HgCommand.isNoUpdates(list.get(0))) {
                                    HgUtils.notifyUpdatedFiles(root, list);
                                    HgUtils.forceStatusRefreshProject(ctx);
                                }
                                logger.output(list);
                                logger.output("");
                            }
                            return null;
                        }
                    }, root);
                }
                catch (HgException.HgCommandCanceledException ex) {
                }
                catch (HgException ex) {
                    HgUtils.notifyException(ex);
                }
                logger.outputInRed(NbBundle.getMessage(SwitchToBranchAction.class, (String)"MSG_SWITCH_DONE"));
                logger.output("");
            }
        };
        support.start(rp, root, NbBundle.getMessage(SwitchToBranchAction.class, (String)"MSG_SwitchBranch_Progress", (Object)revStr));
    }

    public static class KnownBranchAction
    extends AbstractAction {
        private final VCSContext ctx;
        private final String branchName;

        public KnownBranchAction(String recentBranch, VCSContext ctx) {
            super(Bundle.SwitchToBranchAction_KnownBranchAction_name(recentBranch));
            this.branchName = recentBranch;
            this.ctx = ctx;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File[] roots = HgUtils.getActionRoots(this.ctx);
            if (roots != null && roots.length > 0) {
                File root = Mercurial.getInstance().getRepositoryRoot(roots[0]);
                ((SwitchToBranchAction)SystemAction.get(SwitchToBranchAction.class)).doSwitch(root, this.branchName, false, this.ctx);
            }
        }
    }
}

