/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.queues;

import java.awt.EventQueue;
import java.io.File;
import java.util.List;
import java.util.MissingResourceException;
import java.util.concurrent.Callable;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.queues.Bundle;
import org.netbeans.modules.mercurial.ui.queues.FailedPatchResolver;
import org.netbeans.modules.mercurial.ui.queues.GoToPatch;
import org.netbeans.modules.mercurial.ui.queues.QPatch;
import org.netbeans.modules.mercurial.ui.queues.QUtils;
import org.netbeans.modules.mercurial.ui.queues.Queue;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class QGoToPatchAction
extends ContextAction {
    @Override
    protected boolean enable(Node[] nodes) {
        return HgUtils.isFromHgRepository(HgUtils.getCurrentContext(nodes));
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_QGoToPatch";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext ctx = HgUtils.getCurrentContext(nodes);
        File[] roots = HgUtils.getActionRoots(ctx);
        if (roots == null || roots.length == 0) {
            return;
        }
        final File root = Mercurial.getInstance().getRepositoryRoot(roots[0]);
        Utils.post((Runnable)new Runnable(){

            @Override
            public void run() {
                if (QUtils.isMQEnabledExtension(root)) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GoToPatch goToPatch = new GoToPatch(root);
                            if (goToPatch.showDialog()) {
                                if (goToPatch.isPopAllSelected()) {
                                    QGoToPatchAction.this.goToPatch(root, null, null);
                                } else if (goToPatch.getSelectedQueue() != null) {
                                    Queue q = goToPatch.getSelectedQueue();
                                    QGoToPatchAction.this.goToPatch(root, q.getName(), null);
                                } else if (goToPatch.getSelectedPatch() != null) {
                                    QPatch patch = goToPatch.getSelectedPatch();
                                    QGoToPatchAction.this.goToPatch(root, patch.getQueue().isActive() ? null : patch.getQueue().getName(), patch.getId());
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    public void goToPatch(final File root, final String queueName, final String patchName) {
        new HgProgressSupport(){

            @Override
            protected void perform() {
                final OutputLogger logger = this.getLogger();
                try {
                    logger.outputInRed(NbBundle.getMessage(QGoToPatchAction.class, (String)"MSG_GOTO_TITLE"));
                    logger.outputInRed(NbBundle.getMessage(QGoToPatchAction.class, (String)"MSG_GOTO_TITLE_SEP"));
                    if (!HgUtils.runWithoutIndexing(new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            if (patchName == null || queueName != null) {
                                QGoToPatchAction.this.popAllPatches(root, logger);
                            }
                            if (this.isCanceled()) {
                                return false;
                            }
                            if (queueName != null) {
                                logger.output(Bundle.MSG_SwitchingQueue(root.getAbsolutePath(), queueName));
                                HgCommand.qSwitchQueue(root, queueName, logger);
                            }
                            if (this.isCanceled()) {
                                return false;
                            }
                            if (patchName != null) {
                                logger.output(NbBundle.getMessage(QGoToPatchAction.class, (String)"MSG_GOTO_INFO_SEP", (Object)patchName, (Object)root.getAbsolutePath()));
                                QGoToPatchAction.this.applyPatch(root, patchName, logger);
                            }
                            return true;
                        }
                    }, root).booleanValue()) {
                        logger.outputInRed(NbBundle.getMessage(QGoToPatchAction.class, (String)"MSG_GOTO_DONE"));
                        logger.output("");
                        return;
                    }
                    Mercurial.getInstance().historyChanged(root);
                    HgLogMessage parent = HgCommand.getParents(root, null, null).get(0);
                    logger.output("");
                    HgUtils.logHgLog(parent, logger);
                    logger.outputInRed(NbBundle.getMessage(QGoToPatchAction.class, (String)"MSG_GOTO_DONE"));
                    logger.output("");
                }
                catch (HgException.HgCommandCanceledException ex) {
                }
                catch (HgException ex) {
                    HgUtils.notifyException(ex);
                }
            }
        }.start(Mercurial.getInstance().getRequestProcessor(root), root, NbBundle.getMessage(QGoToPatchAction.class, (String)"LBL_QGoToPatchAction.progress"));
    }

    public void applyPatch(File repository, String patchName, OutputLogger logger) throws HgException {
        List<String> output = HgCommand.qGoToPatch(repository, patchName, logger);
        FailedPatchResolver resolver = new FailedPatchResolver(repository, output, logger);
        resolver.resolveFailure();
        logger.output(output);
    }

    public void popAllPatches(File repository, OutputLogger logger) throws HgException, MissingResourceException {
        logger.output(NbBundle.getMessage(QGoToPatchAction.class, (String)"MSG_GOTO_EMPTY_INFO_SEP", (Object)repository.getAbsolutePath()));
        HgCommand.qPopPatches(repository, null, logger);
    }
}

