/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.api.util.ShellScriptRunner;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Utilities;

public class PathUtils {
    private PathUtils() {
    }

    public static String getPathFromSymlink(String path, ExecutionEnvironment execEnv) {
        try {
            int pos;
            NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder(execEnv);
            npb.setExecutable("/bin/ls").setArguments("-l", path).redirectError();
            NativeProcess process = npb.call();
            BufferedReader br = ProcessUtils.getReader(process.getInputStream(), execEnv.isRemote());
            String line = br.readLine();
            br.close();
            if (line != null && (pos = line.indexOf("->")) > 0) {
                return line.substring(pos + 2).trim();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static String getExePath(long pid, ExecutionEnvironment execEnv) {
        if (pid > 0L) {
            String procdir = "/proc/" + Long.toString(pid);
            String path = PathUtils.getPathFromSymlink(procdir + "/path/a.out", execEnv);
            if (path == null) {
                path = PathUtils.getPathFromSymlink(procdir + "/exe", execEnv);
            }
            if (path != null && path.length() > 0) {
                return path;
            }
            path = PathUtils.getExePath_(pid, execEnv);
            return path;
        }
        return null;
    }

    private static String getExePath_(long pid, ExecutionEnvironment execEnv) {
        return PathUtils.run_("exepath.sh", pid, execEnv);
    }

    private static String getCwdPath_(long pid, ExecutionEnvironment execEnv) {
        return PathUtils.run_("cwdpath.sh", pid, execEnv);
    }

    private static String run_(String scriptName, long pid, ExecutionEnvironment execEnv) {
        try {
            InstalledFileLocator fl = InstalledFileLocator.getDefault();
            File localScript = fl.locate("bin/nativeexecution/" + scriptName, "org.netbeans.modules.nativeexecution", false);
            if (localScript == null) {
                return null;
            }
            ShellScriptRunner.BufferedLineProcessor bufferedLineProcessor = new ShellScriptRunner.BufferedLineProcessor();
            ShellScriptRunner scriptRunner = new ShellScriptRunner(execEnv, Utilities.toURI((File)localScript), (LineProcessor)bufferedLineProcessor);
            scriptRunner.setArguments(pid + "");
            int execute = scriptRunner.execute();
            if (execute != 0) {
                return null;
            }
            return bufferedLineProcessor.getAsString();
        }
        catch (IOException ex) {
        }
        catch (ConnectionManager.CancellationException ex) {
            // empty catch block
        }
        return null;
    }

    public static String getCwdPath(long pid, ExecutionEnvironment execEnv) {
        if (pid > 0L) {
            String procdir = "/proc/" + Long.toString(pid);
            String path = PathUtils.getPathFromSymlink(procdir + "/cwd", execEnv);
            if (path != null && path.length() > 0) {
                return path;
            }
            path = PathUtils.getCwdPath_(pid, execEnv);
            return path;
        }
        return null;
    }
}

