/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.jsch;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.jsch.ConnectingProgressHandle;
import org.netbeans.modules.nativeexecution.jsch.JSchChannelsSupport;
import org.netbeans.modules.nativeexecution.support.Authentication;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.NativeTaskExecutorService;
import org.netbeans.modules.nativeexecution.support.ui.AuthTypeSelectorDlg;
import org.openide.util.Cancellable;
import org.openide.util.RequestProcessor;

public final class JSchConnectionTask
implements Cancellable {
    private static final RequestProcessor connectorThread = new RequestProcessor("ConnectionManager queue", 1);
    private static final int SOCKET_CREATION_TIMEOUT = Integer.getInteger("socket.connection.timeout", 10000);
    private static final java.util.logging.Logger log = Logger.getInstance();
    private final JSch jsch;
    private final ExecutionEnvironment env;
    private final Object resultLock = new Object();
    private Future<Result> result = null;
    private volatile boolean cancelled;

    public JSchConnectionTask(JSch jsch, ExecutionEnvironment env) {
        this.jsch = jsch;
        this.env = env;
        this.cancelled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.resultLock;
        synchronized (object) {
            if (this.result == null) {
                this.result = connectorThread.submit((Callable)new Callable<Result>(){

                    @Override
                    public Result call() throws Exception {
                        return JSchConnectionTask.this.connect();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result connect() throws Exception {
        ConnectingProgressHandle.startHandle(this.env, this);
        try {
            try {
                this.env.prepareForConnection();
            }
            catch (Throwable th) {
                Result result = new Result(null, new Problem(ProblemType.ENV_PREPARE_ERROR, th));
                ConnectingProgressHandle.stopHandle(this.env);
                return result;
            }
            if (this.cancelled) {
                Result th = new Result(null, new Problem(ProblemType.CONNECTION_CANCELLED));
                return th;
            }
            if (!this.isReachable()) {
                if (this.cancelled) {
                    Result th = new Result(null, new Problem(ProblemType.CONNECTION_CANCELLED));
                    return th;
                }
                Result th = new Result(null, new Problem(ProblemType.HOST_UNREACHABLE));
                return th;
            }
            if (this.cancelled) {
                Result th = new Result(null, new Problem(ProblemType.CONNECTION_CANCELLED));
                return th;
            }
            if (!JSchConnectionTask.initJsch(this.env)) {
                Result th = new Result(null, new Problem(ProblemType.CONNECTION_CANCELLED));
                return th;
            }
            JSchChannelsSupport cs = new JSchChannelsSupport(this.jsch, this.env);
            try {
                cs.connect();
            }
            catch (InterruptedException ex) {
                this.cancelled = true;
            }
            if (this.cancelled) {
                Result result = new Result(null, new Problem(ProblemType.CONNECTION_CANCELLED));
                return result;
            }
            Result result = new Result(cs, null);
            return result;
        }
        catch (JSchException e) {
            log.log(Level.FINE, "JSchException connecting to " + this.env, e);
            if (e.getMessage().equals("Auth cancel")) {
                Result result = new Result(null, new Problem(ProblemType.CONNECTION_CANCELLED));
                return result;
            }
            if (e.getMessage().contains("java.net.SocketTimeoutException") || e.getMessage().contains("timeout")) {
                Result result = new Result(null, new Problem(ProblemType.CONNECTION_TIMEOUT, e));
                return result;
            }
            Result result = new Result(null, new Problem(ProblemType.CONNECTION_FAILED, e));
            return result;
        }
        catch (CancellationException ex) {
            log.log(Level.FINE, "CancellationException", ex);
            Result result = new Result(null, new Problem(ProblemType.CONNECTION_CANCELLED));
            return result;
        }
        catch (Throwable th) {
            Result result = new Result(null, new Problem(ProblemType.CONNECTION_FAILED, th));
            return result;
        }
        finally {
            ConnectingProgressHandle.stopHandle(this.env);
        }
    }

    private static boolean initJsch(ExecutionEnvironment env) {
        Authentication auth = Authentication.getFor(env);
        if (!auth.isDefined()) {
            AuthTypeSelectorDlg dlg = new AuthTypeSelectorDlg();
            if (!dlg.initAuthentication(auth)) {
                return false;
            }
        } else {
            auth.apply();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem getProblem() throws InterruptedException, ExecutionException {
        Future<Result> r;
        Object object = this.resultLock;
        synchronized (object) {
            r = this.result;
        }
        if (r == null) {
            throw new IllegalStateException("Not started yet");
        }
        return r.get().problem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSchChannelsSupport getResult() throws InterruptedException, ExecutionException {
        Future<Result> r;
        Object object = this.resultLock;
        synchronized (object) {
            r = this.result;
        }
        if (r == null) {
            throw new IllegalStateException("Not started yet");
        }
        return r.get().cs;
    }

    private boolean isReachable() throws IOException {
        Callable<Boolean> checker = new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                InetSocketAddress addressToConnect = new InetSocketAddress(JSchConnectionTask.this.env.getHostAddress(), JSchConnectionTask.this.env.getSSHPort());
                try (Socket socket = new Socket();){
                    socket.connect(addressToConnect, SOCKET_CREATION_TIMEOUT);
                }
                return true;
            }
        };
        Future<Boolean> task = NativeTaskExecutorService.submit(checker, "Host " + this.env.getHost() + " availability test");
        while (!this.cancelled && !task.isDone()) {
            try {
                task.get(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ex) {
            }
            catch (ExecutionException ex) {
            }
            catch (TimeoutException ex) {}
        }
        boolean result = false;
        if (task.isDone()) {
            try {
                result = task.get();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean cancel() {
        this.cancelled = true;
        return true;
    }

    private static boolean isUnitTestMode() {
        return Boolean.getBoolean("cnd.mode.unittest");
    }

    private static final class Result {
        public final JSchChannelsSupport cs;
        public final Problem problem;

        public Result(JSchChannelsSupport cs, Problem problem) {
            this.cs = cs;
            this.problem = problem;
            if (problem != null && JSchConnectionTask.isUnitTestMode()) {
                new Exception("That's just a trace: connection failed: " + (Object)((Object)problem.type), problem.cause).printStackTrace(System.err);
            }
        }
    }

    public static enum ProblemType {
        ENV_PREPARE_ERROR,
        AUTH_FAIL,
        HOST_UNREACHABLE,
        CONNECTION_CANCELLED,
        CONNECTION_FAILED,
        CONNECTION_TIMEOUT;

    }

    public static final class Problem {
        public final ProblemType type;
        public final Throwable cause;

        public Problem(ProblemType type) {
            this(type, null);
        }

        public Problem(ProblemType type, Throwable cause) {
            this.type = type;
            this.cause = cause;
        }
    }
}

