/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.openide.util.Exceptions;

public final class EnvWriter {
    public static final Collection<String> wellKnownVars = Collections.unmodifiableList(Arrays.asList("LANG", "LC_COLLATE", "LC_CTYPE", "LC_MESSAGES", "LC_MONETARY", "LC_NUMERIC", "LC_TIME", "TMPDIR", "PATH", "LD_LIBRARY_PATH", "LD_PRELOAD"));
    private final OutputStreamWriter writer;

    public EnvWriter(OutputStream os, boolean remote) {
        OutputStreamWriter w = null;
        if (remote) {
            try {
                String charSet = ProcessUtils.getRemoteCharSet();
                if (Charset.isSupported(charSet)) {
                    w = new OutputStreamWriter(os, charSet);
                }
            }
            catch (UnsupportedEncodingException ex) {
                // empty catch block
            }
        }
        if (w == null) {
            w = new OutputStreamWriter(os);
        }
        this.writer = w;
    }

    public static byte[] getBytes(String str, boolean remote) {
        String charSet;
        if (remote && Charset.isSupported(charSet = ProcessUtils.getRemoteCharSet())) {
            try {
                return str.getBytes(charSet);
            }
            catch (UnsupportedEncodingException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return str.getBytes();
    }

    public EnvWriter(OutputStreamWriter writer) {
        this.writer = writer;
    }

    public void write(MacroMap env) throws IOException {
        if (!env.isEmpty()) {
            String value = null;
            Pattern pattern = Pattern.compile("[A-Z0-9_]+");
            for (String name : env.getExportVariablesSet()) {
                if (!pattern.matcher(name.toUpperCase(Locale.ENGLISH)).matches()) {
                    Logger.getInstance().log(Level.WARNING, "Will not pass environment variable named {0} as it contains non alpha-numeric characters", name);
                    continue;
                }
                value = env.get(name);
                if (value == null) continue;
                if (value.indexOf(34) >= 0) {
                    value = value.replace("\"", "\\\"");
                }
                this.writer.write(name + "=\"" + value + "\" && export " + name + "\n");
            }
            this.writer.flush();
        }
    }
}

