/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support.filesearch.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.filesearch.FileSearchParams;
import org.netbeans.modules.nativeexecution.support.filesearch.FileSearcher;

public final class LocalFileSearcherImpl
implements FileSearcher {
    private static final java.util.logging.Logger log = Logger.getInstance();

    @Override
    public final String searchFile(FileSearchParams fileSearchParams) {
        ExecutionEnvironment execEnv = fileSearchParams.getExecEnv();
        if (!execEnv.isLocal()) {
            return null;
        }
        log.log(Level.FINE, "File Searching Task: {0}...", fileSearchParams.toString());
        ArrayList<String> sp = new ArrayList<String>(fileSearchParams.getSearchPaths());
        if (fileSearchParams.isSearchInUserPaths()) {
            try {
                Map<String, String> environment = HostInfoUtils.getHostInfo(execEnv).getEnvironment();
                String path = null;
                if (environment.containsKey("Path")) {
                    path = environment.get("Path");
                } else if (environment.containsKey("PATH")) {
                    path = environment.get("PATH");
                }
                if (path != null) {
                    sp.addAll(Arrays.asList(path.split(File.pathSeparator)));
                }
            }
            catch (IOException ex) {
            }
            catch (ConnectionManager.CancellationException ex) {
                // empty catch block
            }
        }
        String file = fileSearchParams.getFilename();
        for (String path : sp) {
            try {
                File f = new File(path, file);
                log.log(Level.FINE, "   Test ''{0}''", f.toString());
                if (!f.canRead()) continue;
                log.log(Level.FINE, "   FOUND ''{0}''", f.toString());
                return f.getCanonicalPath();
            }
            catch (Throwable th) {
                log.log(Level.FINE, "Execption in LocalFileSearcherImpl:", th);
            }
        }
        return null;
    }
}

