/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support.ui.api;

import java.awt.AWTKeyStroke;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.modules.nativeexecution.support.ui.Completable;
import org.netbeans.modules.nativeexecution.support.ui.CompletionPopup;
import org.netbeans.modules.nativeexecution.support.ui.api.AutocompletionProvider;
import org.openide.util.RequestProcessor;

public final class FileSelectorField
extends JTextField
implements Completable,
PopupMenuListener {
    private static final RequestProcessor rp = new RequestProcessor("FileSelectorField", 3);
    private final AtomicReference<CompletionTask> currentTask;
    private boolean listenersInactive = false;
    private AutocompletionProvider provider;
    private CompletionPopup popup;

    public FileSelectorField() {
        this((AutocompletionProvider)null);
    }

    public FileSelectorField(AutocompletionProvider provider) {
        this.provider = provider;
        this.currentTask = new AtomicReference();
        this.getDocument().addDocumentListener(new DocumentListener(){

            private void doUpdate() {
                if (!FileSelectorField.this.listenersInactive) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            FileSelectorField.this.updateCompletions();
                        }
                    });
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.doUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.doUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                int keyCode = evt.getKeyCode();
                if ((keyCode == 39 && FileSelectorField.this.isAtLastPosition() || keyCode == 9) && (FileSelectorField.this.popup == null || !FileSelectorField.this.popup.isShowing())) {
                    FileSelectorField.this.updateCompletions();
                }
            }
        });
    }

    private void updateCompletions() {
        if (this.provider == null) {
            return;
        }
        if (!this.isFocusOwner()) {
            return;
        }
        if (this.popup == null) {
            this.popup = new CompletionPopup(this);
            this.popup.addPopupMenuListener(this);
        }
        String text = this.getText();
        int pos = this.getCaretPosition();
        String textToComplete = text.substring(0, Math.min(text.length(), pos));
        CompletionTask newTask = new CompletionTask(textToComplete);
        CompletionTask old = this.currentTask.getAndSet(newTask);
        if (old != null) {
            old.cancel();
        }
        rp.post((Runnable)newTask);
        this.popup.setWaiting();
        if (!this.popup.isShowing()) {
            this.popup.showPopup(this, 0, this.getHeight() - 2);
        }
    }

    private boolean isAtLastPosition() {
        return this.getCaretPosition() >= this.getDocument().getLength() - 1;
    }

    public void setAutocompletionProvider(AutocompletionProvider provider) {
        this.provider = provider;
    }

    @Override
    public boolean completeWith(String completion) {
        String orig = this.getText().substring(0, this.getCaretPosition());
        String newValue = orig.startsWith("/") || orig.startsWith(".") || orig.startsWith("~") ? orig.substring(0, orig.lastIndexOf(47) + 1) + completion : completion;
        boolean updateCompletions = newValue.endsWith("/");
        this.setText(newValue, updateCompletions);
        return updateCompletions;
    }

    public void setText(String text, boolean updateCompletions) {
        if (updateCompletions) {
            super.setText(text);
        } else {
            this.listenersInactive = true;
            super.setText(text);
            this.listenersInactive = false;
        }
    }

    private void setTabTraversalEnabled(boolean enabled) {
        Set<AWTKeyStroke> tKeys = this.getFocusTraversalKeys(0);
        HashSet<AWTKeyStroke> newTKeys = new HashSet<AWTKeyStroke>(tKeys);
        if (enabled) {
            newTKeys.add(AWTKeyStroke.getAWTKeyStroke(9, 0));
        } else {
            newTKeys.remove(AWTKeyStroke.getAWTKeyStroke(9, 0));
        }
        this.setFocusTraversalKeys(0, newTKeys);
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.setTabTraversalEnabled(false);
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        this.setTabTraversalEnabled(true);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    private class CompletionTask
    implements Runnable {
        private volatile boolean cancelled;
        private final String textToComplete;

        public CompletionTask(String textToComplete) {
            this.textToComplete = textToComplete;
        }

        void cancel() {
            this.cancelled = true;
        }

        @Override
        public void run() {
            final List<String> result = FileSelectorField.this.provider.autocomplete(this.textToComplete);
            if (!this.cancelled) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FileSelectorField.this.popup.setOptionsList(result);
                    }
                });
            }
        }
    }
}

