/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger;

import org.netbeans.modules.cnd.debugger.common2.debugger.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.Thread;

public class Frame {
    protected NativeDebugger debugger;
    protected boolean range_of_hidden;
    protected boolean current;
    protected String func;
    protected String loadobj;
    protected String loadobj_base;
    protected String args;
    protected String source;
    protected String lineno;
    protected String frameno;
    protected String pc;
    protected boolean optimized;
    protected boolean attr_user_call;
    protected int attr_sig;
    protected String attr_signame;
    public boolean more;
    private String signal = null;
    protected Thread thread = null;

    public Frame(NativeDebugger debugger, Thread thread) {
        this.debugger = debugger;
        this.thread = thread;
    }

    public boolean isSpecial() {
        return this.range_of_hidden || this.attr_user_call || this.more || this.attr_sig != 0;
    }

    public boolean isSignalHandler() {
        return this.attr_sig != 0;
    }

    public boolean isUserCall() {
        return this.attr_user_call;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public void setCurrent(boolean b) {
        this.current = b;
    }

    public boolean isHidden() {
        return this.range_of_hidden;
    }

    public boolean hasDebuggingInfo() {
        return this.source != null && this.source.length() != 0;
    }

    public void setFunc(String f) {
        this.func = f;
    }

    public String getFunc() {
        return this.func;
    }

    public String getLineNo() {
        return this.lineno;
    }

    public String getSource() {
        return this.source;
    }

    public String getLocationName() {
        if (this.range_of_hidden) {
            return "---- " + Catalog.get("MSG_HIDDDEN_FRAMES") + " ----";
        }
        if (this.attr_user_call) {
            return "---- " + Catalog.get("MSG_DEBUGGER_CALL") + " ----";
        }
        if (this.attr_sig != 0) {
            return "---- " + Catalog.format("MSG_SIGNAL_HANDLER", this.attr_signame, this.attr_sig) + " ----";
        }
        if (this.func == null) {
            return "?()";
        }
        if (this.args == null) {
            if (this.more) {
                return this.func;
            }
            return this.func + "(?)";
        }
        return this.func + this.args;
    }

    public String getFullPath() {
        return null;
    }

    public String getLocation() {
        if (this.isSpecial()) {
            return "";
        }
        if (!this.hasDebuggingInfo()) {
            return "";
        }
        return this.source + ":" + this.lineno;
    }

    public String getNumber() {
        if (this.isHidden()) {
            return "";
        }
        if (this.isSpecial()) {
            return "";
        }
        return this.frameno;
    }

    public String getOptimized() {
        if (this.isSpecial()) {
            return "";
        }
        if (this.hasDebuggingInfo()) {
            if (this.optimized) {
                return "-g/-O";
            }
            return "-g";
        }
        return "no -g";
    }

    public String getLoadObj() {
        if (this.isSpecial()) {
            if (this.more) {
                return Catalog.get("MSG_MORE_FRAME");
            }
            return "";
        }
        return this.loadobj;
    }

    public String getLoadObjBase() {
        if (this.isSpecial()) {
            return "";
        }
        return this.loadobj_base;
    }

    public String getCurrentPC() {
        if (this.isSpecial()) {
            return "";
        }
        return this.pc;
    }

    public String getSignal() {
        if (this.signal == null) {
            this.signal = this.attr_signame != null ? this.attr_signame : "";
        }
        return this.signal;
    }

    public Thread getThread() {
        return this.thread;
    }
}

