/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.actions;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineCapability;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineDescriptor;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineType;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Host;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class ExecutableProjectPanel
extends JPanel {
    private static final RequestProcessor RP = new RequestProcessor("ExecutableProjectPanel", 1);
    private final JButton actionButton;
    private boolean noproject;
    private final EngineDescriptor debuggerType;
    private static Project lastSelectedProject = null;
    private JLabel errorLabel;
    private JTextField executableField;
    private JLabel executableLabel;
    private JComboBox projectComboBox;
    private JLabel projectLabel;
    private ResourceBundle bundle;

    public ExecutableProjectPanel(JButton actionButton, EngineDescriptor debuggerType) {
        this.actionButton = actionButton;
        this.debuggerType = debuggerType;
        this.initialize();
    }

    private void initialize() {
        this.initComponents();
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.initGui();
        this.projectComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    ExecutableProjectPanel.this.projectChanged();
                }
            }
        });
    }

    private void projectChanged() {
        MakeConfiguration conf;
        Project selectedProject = this.getSelectedProject();
        if (selectedProject != null && (conf = ConfigurationSupport.getProjectActiveConfiguration((Lookup.Provider)selectedProject)) != null) {
            EngineType projectDebuggerType = NativeDebuggerManager.debuggerType((Configuration)conf);
            if (this.debuggerType.getType() != projectDebuggerType) {
                this.setError("ERROR_WRONG_FAMILY", false);
                return;
            }
        }
        this.clearError();
    }

    public String getExecutablePath() {
        return this.executableField.getText();
    }

    public void setExecutablePath(String hostName, String path) {
        this.executableField.setText(path);
        this.setSelectedProjectByPath(hostName, path);
    }

    private void initComponents() {
        this.executableLabel = new JLabel();
        this.executableField = new JTextField();
        this.projectLabel = new JLabel();
        this.projectComboBox = new JComboBox();
        this.errorLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.executableLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common2/debugger/actions/Bundle").getString("EXECUTABLE_MN").charAt(0));
        this.executableLabel.setLabelFor(this.executableField);
        this.executableLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common2/debugger/actions/Bundle").getString("EXECUTABLE_LBL"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 8, 0);
        this.add((Component)this.executableLabel, gridBagConstraints);
        this.executableField.setEditable(false);
        this.executableField.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common2/debugger/actions/Bundle").getString("ProgramPathname"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 4, 8, 0);
        this.add((Component)this.executableField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 4, 8, 0);
        this.projectLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common2/debugger/actions/Bundle").getString("ASSOCIATED_PROJECT_MN").charAt(0));
        this.projectLabel.setLabelFor(this.projectComboBox);
        this.projectLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common2/debugger/actions/Bundle").getString("ASSOCIATED_PROJECT_LBL"));
        Catalog.setAccessibleDescription(this.projectComboBox, "ACSD_Project");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        if (!NativeDebuggerManager.isStandalone() && !NativeDebuggerManager.isPL()) {
            this.add((Component)this.projectLabel, gridBagConstraints);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 6, 0);
        if (!NativeDebuggerManager.isStandalone() && !NativeDebuggerManager.isPL()) {
            this.add((Component)this.projectComboBox, gridBagConstraints);
        }
        this.errorLabel.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.errorLabel, gridBagConstraints);
    }

    public static void fillProjectsCombo(JComboBox comboBox, Project selectedProject) {
        if (selectedProject == null) {
            selectedProject = OpenProjects.getDefault().getMainProject();
        }
        for (Project proj : OpenProjects.getDefault().getOpenProjects()) {
            if (proj.getLookup().lookup(ConfigurationDescriptorProvider.class) == null) continue;
            ProjectInformation pinfo = ProjectUtils.getInformation((Project)proj);
            ProjectCBItem pi = new ProjectCBItem(pinfo);
            comboBox.addItem(pi);
            if (selectedProject == null || proj != selectedProject) continue;
            comboBox.setSelectedItem(pi);
        }
    }

    public void initGui() {
        this.projectComboBox.removeAllItems();
        this.projectComboBox.addItem(this.getString("NO_PROJECT"));
        this.projectComboBox.addItem(this.getString("NEW_PROJECT"));
        ExecutableProjectPanel.fillProjectsCombo(this.projectComboBox, lastSelectedProject);
        this.executableField.setText("");
    }

    public boolean validateExecutablePath() {
        String exePath = this.getExecutablePath().trim();
        if (!this.debuggerType.hasCapability(EngineCapability.DERIVE_EXECUTABLE) && IpeUtils.isEmpty(exePath)) {
            this.setError("ERROR_NEED_EXEC", true);
            return false;
        }
        File exeFile = new File(exePath);
        if (!exeFile.exists()) {
            this.setError("ERROR_DONTEXIST", true);
            return false;
        }
        if (exeFile.isDirectory()) {
            this.setError("ERROR_NOTAEXEFILE", true);
            return false;
        }
        FileObject fo = FileUtil.toFileObject((File)exeFile);
        if (fo == null) {
            this.setError("ERROR_NOTAEXEFILE", true);
            return false;
        }
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)fo);
        }
        catch (Exception e) {
            this.setError("ERROR_DONTEXIST", true);
            return false;
        }
        if (!MIMENames.isBinary((String)IpeUtils.getMime(dataObject))) {
            this.setError("ERROR_NOTAEXEFILE", true);
            return false;
        }
        this.clearError();
        return true;
    }

    public void setError(String errorMsg, boolean disable) {
        this.errorLabel.setText(this.getString(errorMsg));
        if (disable) {
            this.projectComboBox.setEnabled(false);
        }
        if (this.actionButton != null) {
            this.actionButton.setEnabled(false);
        }
    }

    @Override
    public void setEnabled(boolean val) {
        this.executableField.setEnabled(val);
        this.projectComboBox.setEnabled(val);
    }

    private void clearError() {
        this.errorLabel.setText(" ");
        this.projectComboBox.setEnabled(true);
        if (this.actionButton != null) {
            this.actionButton.setEnabled(true);
        }
    }

    public Project getSelectedProject() {
        Object selectedItem = this.projectComboBox.getSelectedItem();
        if (selectedItem instanceof ProjectCBItem) {
            this.noproject = false;
            return ((ProjectCBItem)selectedItem).getProject();
        }
        this.noproject = this.projectComboBox.getSelectedIndex() == 0;
        return null;
    }

    String getSelectedProjectPath() {
        Project prj = this.getSelectedProject();
        return prj != null ? prj.getProjectDirectory().getPath() : "";
    }

    void setSelectedProjectByPath(final String hostName, final String path) {
        if (path == null || path.length() == 0) {
            this.projectComboBox.setSelectedIndex(0);
            return;
        }
        this.projectComboBox.setEnabled(false);
        RP.post(new Runnable(){

            @Override
            public void run() {
                final ProjectCBItem prj = ExecutableProjectPanel.this.getProjectByPath(hostName, path);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (prj != null) {
                            ExecutableProjectPanel.this.projectComboBox.setSelectedItem(prj);
                        } else {
                            ExecutableProjectPanel.this.projectComboBox.setSelectedIndex(0);
                        }
                        ExecutableProjectPanel.this.projectComboBox.setEnabled(true);
                    }
                });
            }
        });
    }

    boolean containsProjectWithPath(String hostName, String path) {
        return this.getProjectByPath(hostName, path) != null;
    }

    private ProjectCBItem getProjectByPath(String hostName, String path) {
        boolean isRemote;
        ExecutionEnvironment executionEnvironment = Host.byName(hostName).executionEnvironment();
        FileSystem fs = FileSystemProvider.getFileSystem((ExecutionEnvironment)executionEnvironment);
        FileObject f = null;
        Project prj = null;
        int pos = -1;
        while (!((f = CndFileUtils.toFileObject((FileSystem)fs, (CharSequence)((pos = path.indexOf(" ", pos + 1)) == -1 ? path : path.substring(0, pos)))) != null && f.isValid() && (prj = FileOwnerQuery.getOwner((FileObject)f)) != null || pos == -1)) {
        }
        for (int i = 0; i < this.projectComboBox.getModel().getSize(); ++i) {
            Object item = this.projectComboBox.getModel().getElementAt(i);
            if (!(item instanceof ProjectCBItem) || !((ProjectCBItem)item).getProject().equals(prj)) continue;
            return (ProjectCBItem)item;
        }
        boolean bl = isRemote = executionEnvironment.isRemote() && ConnectionManager.getInstance().isConnectedTo(executionEnvironment);
        if (!isRemote) {
            return null;
        }
        PathMap map = HostInfoProvider.getMapper((ExecutionEnvironment)executionEnvironment);
        String filePath = map.getLocalPath(path);
        if (filePath == null) {
            return null;
        }
        while (!((f = CndFileUtils.toFileObject((FileSystem)FileSystemProvider.getFileSystem((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal()), (CharSequence)filePath)) != null && f.isValid() && (prj = FileOwnerQuery.getOwner((FileObject)f)) != null || (filePath = CndPathUtilities.getDirName((String)filePath)) == null)) {
        }
        if (f == null) {
            return null;
        }
        for (int i = 0; i < this.projectComboBox.getModel().getSize(); ++i) {
            Object item = this.projectComboBox.getModel().getElementAt(i);
            if (!(item instanceof ProjectCBItem) || !((ProjectCBItem)item).getProject().equals(prj)) continue;
            return (ProjectCBItem)item;
        }
        return null;
    }

    private String getString(String s) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle(ExecutableProjectPanel.class);
        }
        return this.bundle.getString(s);
    }

    public boolean asynchronous() {
        return false;
    }

    public void setLastSelectedProject(Project l) {
        lastSelectedProject = l;
    }

    public boolean getNoProject() {
        return this.noproject;
    }

    public class ExecutableValidateListener
    implements DocumentListener {
        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (ExecutableProjectPanel.this.validateExecutablePath()) {
                // empty if block
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            if (ExecutableProjectPanel.this.validateExecutablePath()) {
                // empty if block
            }
        }
    }

    public static class ProjectCBItem {
        private ProjectInformation pinfo;

        public ProjectCBItem(ProjectInformation pinfo) {
            this.pinfo = pinfo;
        }

        public String toString() {
            return this.pinfo.getDisplayName();
        }

        public Project getProject() {
            return this.pinfo.getProject();
        }

        public ProjectInformation getProjectInformation() {
            return this.pinfo;
        }
    }
}

