/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.concurrent;

import java.util.LinkedList;
import java.util.Queue;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.ListenableFutureCallback;

public class ListenableFutureCallbackRegistry<T> {
    private final Queue<ListenableFutureCallback<? super T>> callbacks = new LinkedList<ListenableFutureCallback<? super T>>();
    private State state = State.NEW;
    private Object result = null;
    private final Object mutex = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCallback(ListenableFutureCallback<? super T> callback) {
        Assert.notNull(callback, "'callback' must not be null");
        Object object = this.mutex;
        synchronized (object) {
            switch (this.state) {
                case NEW: {
                    this.callbacks.add(callback);
                    break;
                }
                case SUCCESS: {
                    callback.onSuccess(this.result);
                    break;
                }
                case FAILURE: {
                    callback.onFailure((Throwable)this.result);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void success(T result) {
        Object object = this.mutex;
        synchronized (object) {
            this.state = State.SUCCESS;
            this.result = result;
            while (!this.callbacks.isEmpty()) {
                this.callbacks.poll().onSuccess(result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failure(Throwable t) {
        Object object = this.mutex;
        synchronized (object) {
            this.state = State.FAILURE;
            this.result = t;
            while (!this.callbacks.isEmpty()) {
                this.callbacks.poll().onFailure(t);
            }
        }
    }

    private static enum State {
        NEW,
        SUCCESS,
        FAILURE;

    }
}

