/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.codegen;

import java.awt.Dialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmConstructor;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.services.CsmCacheManager;
import org.netbeans.modules.cnd.api.model.services.CsmInheritanceUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.ui.ElementNode;
import org.netbeans.modules.cnd.refactoring.api.CsmContext;
import org.netbeans.modules.cnd.refactoring.codegen.ui.ConstructorPanel;
import org.netbeans.modules.cnd.refactoring.support.GeneratorUtils;
import org.netbeans.modules.cnd.utils.ui.UIGesturesSupport;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Pair;

public class ConstructorGenerator
implements CodeGenerator {
    private final JTextComponent component;
    private final ElementNode.Description constructorDescription;
    private final ElementNode.Description fieldsDescription;
    private final CsmContext contextPath;
    private final CsmClass type;

    private ConstructorGenerator(JTextComponent component, CsmContext path, CsmClass type, ElementNode.Description constructorDescription, ElementNode.Description fieldsDescription) {
        this.component = component;
        this.constructorDescription = constructorDescription;
        this.fieldsDescription = fieldsDescription;
        this.contextPath = path;
        this.type = type;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ConstructorGenerator.class, (String)"LBL_constructor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke() {
        UIGesturesSupport.submit((String)"USG_CND_REFACTORING", (Object[])new Object[]{"GENERATE", "CONSTRUCTOR"});
        if (this.constructorDescription != null || this.fieldsDescription != null) {
            ConstructorPanel panel = new ConstructorPanel(this.constructorDescription, this.fieldsDescription);
            DialogDescriptor dialogDescriptor = GeneratorUtils.createDialogDescriptor(panel, NbBundle.getMessage(ConstructorGenerator.class, (String)"LBL_generate_constructor"));
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            try {
                dialog.setVisible(true);
            }
            catch (Throwable th) {
                if (!(th.getCause() instanceof InterruptedException)) {
                    throw new RuntimeException(th);
                }
                dialogDescriptor.setValue(DialogDescriptor.CANCEL_OPTION);
            }
            finally {
                dialog.dispose();
            }
            if (dialogDescriptor.getValue() != dialogDescriptor.getDefaultValue()) {
                return;
            }
            GeneratorUtils.generateConstructor(this.contextPath, this.type, panel.getInheritedConstructors(), panel.getVariablesToInitialize());
        }
    }

    public static class Factory
    implements CodeGenerator.Factory {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<? extends CodeGenerator> create(Lookup context) {
            ArrayList<ConstructorGenerator> ret = new ArrayList<ConstructorGenerator>();
            JTextComponent component = (JTextComponent)context.lookup(JTextComponent.class);
            CsmContext path = (CsmContext)context.lookup(CsmContext.class);
            if (component == null || path == null) {
                return ret;
            }
            CsmClass typeElement = path.getEnclosingClass();
            if (typeElement == null) {
                return ret;
            }
            List<CsmObject> pathList = path.getPath();
            CsmObject last = pathList.get(pathList.size() - 1);
            if (!CsmKindUtilities.isClass((CsmObject)last) && !CsmKindUtilities.isField((CsmObject)last)) {
                return ret;
            }
            CsmOffsetable objectUnderOffset = path.getObjectUnderOffset();
            ArrayList<Pair<CsmField, Inited>> fields = new ArrayList<Pair<CsmField, Inited>>();
            ArrayList<CsmConstructor> constructors = new ArrayList<CsmConstructor>();
            LinkedHashMap inheritedConstructors = new LinkedHashMap();
            CsmCacheManager.enter();
            try {
                for (CsmInheritance csmInheritance : typeElement.getBaseClasses()) {
                    CsmClass baseClass = CsmInheritanceUtilities.getCsmClass((CsmInheritance)csmInheritance);
                    if (baseClass == null) continue;
                    ArrayList<CsmConstructor> list = new ArrayList<CsmConstructor>();
                    for (CsmMember member : baseClass.getMembers()) {
                        if (!CsmKindUtilities.isConstructor((CsmObject)member) || !CsmInheritanceUtilities.matchVisibility((CsmMember)member, (CsmVisibility)CsmVisibility.PROTECTED) || this.isCopyConstructor(baseClass, (CsmConstructor)member)) continue;
                        list.add((CsmConstructor)member);
                    }
                    if (list.isEmpty()) continue;
                    inheritedConstructors.put(baseClass, list);
                }
                GeneratorUtils.scanForFieldsAndConstructors(typeElement, fields, constructors);
            }
            finally {
                CsmCacheManager.leave();
            }
            ElementNode.Description constructorDescription = null;
            if (!inheritedConstructors.isEmpty()) {
                ArrayList<ElementNode.Description> baseClassesDescriptions = new ArrayList<ElementNode.Description>();
                for (Map.Entry entry : inheritedConstructors.entrySet()) {
                    ArrayList<ElementNode.Description> arrayList = new ArrayList<ElementNode.Description>();
                    for (CsmConstructor c : (List)entry.getValue()) {
                        arrayList.add(ElementNode.Description.create((CsmObject)c, null, (boolean)true, (boolean)false));
                    }
                    baseClassesDescriptions.add(ElementNode.Description.create((CsmObject)((CsmObject)entry.getKey()), arrayList, (boolean)false, (boolean)false));
                }
                constructorDescription = ElementNode.Description.create((CsmObject)typeElement, baseClassesDescriptions, (boolean)false, (boolean)false);
            }
            ElementNode.Description fieldsDescription = null;
            if (!fields.isEmpty()) {
                ArrayList<ElementNode.Description> fieldDescriptions = new ArrayList<ElementNode.Description>();
                for (Pair pair : fields) {
                    switch ((Inited)((Object)pair.second())) {
                        case must: {
                            fieldDescriptions.add(ElementNode.Description.create((CsmObject)((CsmObject)pair.first()), null, (boolean)true, (boolean)true));
                            break;
                        }
                        case may: {
                            fieldDescriptions.add(ElementNode.Description.create((CsmObject)((CsmObject)pair.first()), null, (boolean)true, (boolean)((CsmField)pair.first()).equals(objectUnderOffset)));
                            break;
                        }
                        case cannot: {
                            fieldDescriptions.add(ElementNode.Description.create((CsmObject)((CsmObject)pair.first()), null, (boolean)false, (boolean)false));
                        }
                    }
                }
                fieldsDescription = ElementNode.Description.create((CsmObject)typeElement, Collections.singletonList(ElementNode.Description.create((CsmObject)typeElement, fieldDescriptions, (boolean)false, (boolean)false)), (boolean)false, (boolean)false);
            }
            if (constructorDescription != null || fieldsDescription != null) {
                ret.add(new ConstructorGenerator(component, path, typeElement, constructorDescription, fieldsDescription));
            }
            return ret;
        }

        private boolean isCopyConstructor(CsmClass cls, CsmConstructor constructor) {
            CsmParameter p;
            CsmType paramType;
            Collection parameters = constructor.getParameters();
            return parameters.size() == 1 && (paramType = (p = (CsmParameter)parameters.iterator().next()).getType()).isReference() && cls.equals(paramType.getClassifier());
        }
    }

    public static enum Inited {
        must,
        may,
        cannot;

    }
}

