/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.Project;
import org.netbeans.cnd.api.lexer.DoxygenTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmConstructor;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectRegistry;
import org.netbeans.modules.cnd.modelutil.CsmDisplayUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.refactoring.spi.CsmRefactoringNameProvider;
import org.netbeans.modules.cnd.refactoring.support.ModificationResult;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionRef;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class CsmRefactoringUtils {
    public static final String USG_CND_REFACTORING = "USG_CND_REFACTORING";
    public static final String GENERATE_TRACKING = "GENERATE";
    public static final String FROM_EDITOR_TRACKING = "FROM_EDITOR";
    private static final Lookup.Result<CsmRefactoringNameProvider> renameProviders = Lookup.getDefault().lookupResult(CsmRefactoringNameProvider.class);

    private CsmRefactoringUtils() {
    }

    public static boolean isElementInOpenProject(CsmFile csmFile) {
        if (csmFile == null) {
            return false;
        }
        Object p = csmFile.getProject().getPlatformProject();
        if (p != null) {
            for (NativeProject prj : NativeProjectRegistry.getDefault().getOpenProjects()) {
                if (!prj.equals(p)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isRefactorable(FileObject fo) {
        return fo == null || FileUtil.getArchiveFile((FileObject)fo) == null && fo.canWrite();
    }

    public static CsmObject convertToCsmObjectIfNeeded(CsmObject referencedObject) {
        CsmFunction decl;
        if (CsmKindUtilities.isInclude((CsmObject)referencedObject)) {
            referencedObject = ((CsmInclude)referencedObject).getIncludeFile();
        } else if (CsmKindUtilities.isFunctionDefinition((CsmObject)referencedObject) && (decl = CsmBaseUtilities.getFunctionDeclaration((CsmFunction)((CsmFunction)referencedObject))) != null) {
            referencedObject = decl;
        }
        return referencedObject;
    }

    public static Collection<CsmProject> getContextCsmProjects(CsmObject contextObject) {
        HashSet<CsmProject> prjs = new HashSet<CsmProject>();
        CsmFile contextFile = null;
        if (CsmKindUtilities.isOffsetable((Object)contextObject)) {
            contextFile = ((CsmOffsetable)contextObject).getContainingFile();
        } else if (CsmKindUtilities.isFile((CsmObject)contextObject)) {
            contextFile = (CsmFile)contextObject;
        }
        CsmProject csmProject = null;
        if (contextFile != null) {
            csmProject = contextFile.getProject();
            prjs.add(csmProject);
        } else if (CsmKindUtilities.isNamespace((Object)contextObject)) {
            prjs.add(((CsmNamespace)contextObject).getProject());
        }
        return prjs;
    }

    public static void waitParsedAllProjects() {
        for (CsmProject prj : CsmModelAccessor.getModel().projects()) {
            prj.waitParse();
        }
    }

    public static Collection<CsmProject> getRelatedCsmProjects(CsmObject origObject, CsmProject p) {
        Collection<Object> out = Collections.emptyList();
        if (p != null) {
            out = Collections.singleton(p);
        } else {
            Collection all = CsmModelAccessor.getModel().projects();
            out = new HashSet(all);
        }
        return out;
    }

    public static Collection<Project> getContextProjects(CsmObject contextObject) {
        Collection<CsmProject> csmProjects = CsmRefactoringUtils.getContextCsmProjects(contextObject);
        ArrayList<Project> out = new ArrayList<Project>();
        for (CsmProject csmProject : csmProjects) {
            if (csmProject == null) continue;
            Object o = csmProject.getPlatformProject();
            if (o instanceof NativeProject) {
                o = ((NativeProject)o).getProject();
            }
            if (!(o instanceof Project)) continue;
            out.add((Project)o);
        }
        return out;
    }

    public static CsmObject getReferencedElement(CsmObject csmObject) {
        if (csmObject instanceof CsmReference) {
            return CsmRefactoringUtils.getReferencedElement(((CsmReference)csmObject).getReferencedObject());
        }
        return csmObject;
    }

    public static String getReplaceText(CsmReference ref, String newName, AbstractRefactoring refactoring) {
        for (CsmRefactoringNameProvider provider : renameProviders.allInstances()) {
            String newText = provider.getReplaceText(ref, newName, refactoring);
            if (newText == null) continue;
            newName = newText;
        }
        return newName;
    }

    public static String getReplaceDescription(CsmReference ref, AbstractRefactoring refactoring) {
        for (CsmRefactoringNameProvider provider : renameProviders.allInstances()) {
            String descr = provider.getReplaceDescription(ref, refactoring);
            if (descr == null) continue;
            return descr;
        }
        return CsmRefactoringUtils.getReplaceDescription(ref, ref.getText().toString());
    }

    private static String getReplaceDescription(CsmReference ref, String targetName) {
        boolean decl = CsmReferenceResolver.getDefault().isKindOf(ref, EnumSet.of(CsmReferenceKind.DECLARATION, CsmReferenceKind.DEFINITION));
        String out = NbBundle.getMessage(CsmRefactoringUtils.class, (String)(decl ? "UpdateDeclRef" : "UpdateRef"), (Object)targetName);
        return out;
    }

    public static String getSimpleText(CsmObject element) {
        String text = "";
        if (element != null) {
            if (CsmKindUtilities.isFile((CsmObject)element)) {
                text = CsmUtilities.getFileObject((CsmFile)((CsmFile)element)).getName();
            } else if (CsmKindUtilities.isNamedElement((CsmObject)element)) {
                text = ((CsmNamedElement)element).getName().toString();
            } else if (CsmKindUtilities.isStatement((CsmObject)element)) {
                text = ((CsmStatement)element).getText().toString();
            } else if (CsmKindUtilities.isOffsetable((Object)element)) {
                text = ((CsmOffsetable)element).getText().toString();
            }
            if (text.startsWith("~")) {
                text = text.substring(1);
            }
            for (CsmRefactoringNameProvider provider : renameProviders.allInstances()) {
                String newName = provider.getRefactoredName(element, text);
                if (newName == null) continue;
                text = newName;
            }
        }
        return text;
    }

    public static ModificationResult.Difference rename(int startOffset, int endOffset, CloneableEditorSupport ces, String oldName, String newName, String descr) {
        assert (oldName != null);
        assert (newName != null);
        PositionRef startPos = ces.createPositionRef(startOffset, Position.Bias.Forward);
        PositionRef endPos = ces.createPositionRef(endOffset, Position.Bias.Backward);
        ModificationResult.Difference diff = new ModificationResult.Difference(ModificationResult.Difference.Kind.CHANGE, startPos, endPos, oldName, newName, descr);
        return diff;
    }

    public static FileObject getFileObject(CsmObject object) {
        CsmFile container = null;
        if (CsmKindUtilities.isFile((CsmObject)object)) {
            container = (CsmFile)object;
        } else if (CsmKindUtilities.isOffsetable((Object)object)) {
            container = ((CsmOffsetable)object).getContainingFile();
        }
        return container == null ? null : CsmUtilities.getFileObject((CsmFile)container);
    }

    public static CsmObject findContextObject(Lookup lookup) {
        CsmObject file = null;
        CsmObject out = null;
        Collection coll = lookup.lookupAll(CsmObject.class);
        for (CsmObject obj : coll) {
            if (CsmKindUtilities.isFile((CsmObject)obj)) {
                file = (CsmFile)obj;
                continue;
            }
            out = obj;
            break;
        }
        if (out == null) {
            Node node;
            CsmUID uid = (CsmUID)lookup.lookup(CsmUID.class);
            if (uid != null) {
                out = (CsmObject)uid.getObject();
            }
            if (out == null && (node = (Node)lookup.lookup(Node.class)) != null) {
                out = CsmReferenceResolver.getDefault().findReference(node);
            }
        }
        if (out == null) {
            out = file;
        }
        return out;
    }

    public static <T extends CsmObject> CsmUID<T> getHandler(T element) {
        return element == null ? null : UIDs.get(element);
    }

    public static <T> T getObject(CsmUID<T> handler) {
        return (T)(handler == null ? null : handler.getObject());
    }

    public static boolean isSupportedReference(CsmObject ref) {
        return ref != null;
    }

    public static String getHtml(CsmObject obj) {
        if (CsmKindUtilities.isOffsetable((Object)obj)) {
            return CsmRefactoringUtils.getHtml((CsmOffsetable)obj);
        }
        if (CsmKindUtilities.isFile((CsmObject)obj)) {
            return CsmDisplayUtilities.htmlize((CharSequence)((CsmFile)obj).getName().toString());
        }
        return obj.toString();
    }

    public static CsmFile getCsmFile(CsmObject csmObject) {
        if (CsmKindUtilities.isFile((CsmObject)csmObject)) {
            return (CsmFile)csmObject;
        }
        if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
            return ((CsmOffsetable)csmObject).getContainingFile();
        }
        return null;
    }

    public static Collection<CsmFunction> getConstructors(CsmClass cls) {
        ArrayList<CsmFunction> out = new ArrayList<CsmFunction>();
        CsmSelect.CsmFilterBuilder filterBuilder = CsmSelect.getFilterBuilder();
        CsmSelect.CsmFilter filter = filterBuilder.createCompoundFilter(CsmSelect.FUNCTION_KIND_FILTER, filterBuilder.createNameFilter(cls.getName(), true, true, false));
        Iterator classMembers = CsmSelect.getClassMembers((CsmClass)cls, (CsmSelect.CsmFilter)filter);
        while (classMembers.hasNext()) {
            CsmMember csmMember = (CsmMember)classMembers.next();
            if (!CsmKindUtilities.isConstructor((CsmObject)csmMember)) continue;
            out.add((CsmFunction)((CsmConstructor)csmMember));
        }
        return out;
    }

    public static CsmObject getEnclosingElement(CsmObject decl) {
        assert (decl != null);
        if (CsmKindUtilities.isOffsetable((Object)decl)) {
            return CsmRefactoringUtils.findInnerFileObject((CsmOffsetable)decl);
        }
        return null;
    }

    static boolean isLangContainerFeature(CsmObject obj) {
        assert (obj != null);
        return CsmKindUtilities.isFunction((CsmObject)obj) || CsmKindUtilities.isClass((CsmObject)obj) || CsmKindUtilities.isEnum((CsmObject)obj) || CsmKindUtilities.isNamespaceDefinition((CsmObject)obj) || CsmKindUtilities.isFile((CsmObject)obj);
    }

    private static String getHtml(CsmOffsetable obj) {
        StyledDocument d;
        CsmFile csmFile = obj.getContainingFile();
        CloneableEditorSupport ces = CsmUtilities.findCloneableEditorSupport((CsmFile)csmFile);
        BaseDocument doc = null;
        String displayText = null;
        if (ces != null && (d = CsmUtilities.openDocument((CloneableEditorSupport)ces)) instanceof BaseDocument) {
            doc = (BaseDocument)d;
        }
        if (doc != null) {
            try {
                int stOffset = obj.getStartOffset();
                int endOffset = obj.getEndOffset();
                int endLineOffset = 1;
                if (CsmKindUtilities.isNamespaceDefinition((CsmObject)obj) || CsmKindUtilities.isEnum((CsmObject)obj)) {
                    endOffset = stOffset;
                    endLineOffset = 0;
                } else if (CsmKindUtilities.isFunctionDefinition((CsmObject)obj)) {
                    endOffset = ((CsmFunctionDefinition)obj).getBody().getStartOffset() - 1;
                } else if (CsmKindUtilities.isClass((CsmObject)obj)) {
                    endOffset = ((CsmClass)obj).getLeftBracketOffset() - 1;
                }
                int startLine = LineDocumentUtils.getLineFirstNonWhitespace((LineDocument)doc, (int)stOffset);
                int endLine = LineDocumentUtils.getLineLastNonWhitespace((LineDocument)doc, (int)endOffset) + endLineOffset;
                displayText = CsmDisplayUtilities.getLineHtml((int)startLine, (int)endLine, (int)-1, (int)-1, (BaseDocument)doc);
            }
            catch (BadLocationException ex) {
                // empty catch block
            }
        }
        if (displayText == null) {
            displayText = CsmDisplayUtilities.htmlize((CharSequence)obj.getText().toString());
        }
        return displayText;
    }

    private static boolean isInObject(CsmObject obj, int offset) {
        if (!CsmKindUtilities.isOffsetable((Object)obj)) {
            return false;
        }
        CsmOffsetable offs = (CsmOffsetable)obj;
        return offs.getStartOffset() <= offset && offset <= offs.getEndOffset();
    }

    public static boolean isBeforeObject(CsmObject obj, int offset) {
        if (!CsmKindUtilities.isOffsetable((Object)obj)) {
            return false;
        }
        CsmOffsetable offs = (CsmOffsetable)obj;
        return offset < offs.getStartOffset();
    }

    public static CsmObject findInnerFileObject(CsmFile file, int offset) {
        assert (file != null) : "can't be null file in findInnerFileObject";
        CsmSelect.CsmFilter filter = CsmSelect.getFilterBuilder().createOffsetFilter(offset);
        CsmDeclaration lastObject = CsmRefactoringUtils.findInnerDeclaration(CsmSelect.getDeclarations((CsmFile)file, (CsmSelect.CsmFilter)filter), offset);
        return lastObject;
    }

    private static CsmDeclaration findInnerDeclaration(Iterator<? extends CsmDeclaration> it, int offset) {
        CsmDeclaration innerDecl = null;
        if (it != null) {
            while (it.hasNext()) {
                CsmDeclaration decl = it.next();
                assert (decl != null) : "can't be null declaration";
                if (CsmRefactoringUtils.isInObject((CsmObject)decl, offset) && CsmRefactoringUtils.isLangContainerFeature((CsmObject)decl)) {
                    innerDecl = CsmRefactoringUtils.findInnerDeclaration(decl, offset);
                    if (innerDecl != null) {
                        return innerDecl;
                    }
                    return decl;
                }
                if (!CsmRefactoringUtils.isBeforeObject((CsmObject)decl, offset)) continue;
                break;
            }
        }
        return innerDecl;
    }

    private static CsmDeclaration findInnerDeclaration(CsmDeclaration outDecl, int offset) {
        assert (CsmRefactoringUtils.isInObject((CsmObject)outDecl, offset)) : "must be in outDecl object!";
        Iterator it = null;
        if (CsmKindUtilities.isNamespace((Object)outDecl)) {
            CsmNamespace ns = (CsmNamespace)outDecl;
            it = ns.getDeclarations().iterator();
        } else if (CsmKindUtilities.isNamespaceDefinition((CsmObject)outDecl)) {
            it = ((CsmNamespaceDefinition)outDecl).getDeclarations().iterator();
        } else if (CsmKindUtilities.isClass((CsmObject)outDecl)) {
            CsmClass cl = (CsmClass)outDecl;
            it = cl.getMembers().iterator();
        } else if (CsmKindUtilities.isEnum((CsmObject)outDecl)) {
            CsmEnum en = (CsmEnum)outDecl;
            it = en.getEnumerators().iterator();
        }
        return CsmRefactoringUtils.findInnerDeclaration(it, offset);
    }

    private static CsmObject findInnerFileObject(CsmOffsetable csmOffsetable) {
        CsmObject obj;
        int offset;
        CsmFile containingFile = csmOffsetable.getContainingFile();
        if (containingFile != null && (offset = csmOffsetable.getStartOffset()) > 0 && (obj = CsmRefactoringUtils.findInnerFileObject(containingFile, offset - 1)) != null) {
            if (CsmKindUtilities.isOffsetable((Object)obj) && ((CsmOffsetable)obj).getEndOffset() < offset) {
                return containingFile;
            }
            return obj;
        }
        return containingFile;
    }

    public static Collection<CsmReference> getComments(final CsmFile file, final String text) {
        final ArrayList<CsmReference> comments = new ArrayList<CsmReference>();
        final Document doc = CsmUtilities.getDocument((CsmFile)file);
        if (doc != null) {
            doc.render(new Runnable(){

                @Override
                public void run() {
                    TokenHierarchy hi = TokenHierarchy.get((Document)doc);
                    TokenSequence ts = hi.tokenSequence();
                    while (ts.moveNext()) {
                        TokenSequence te;
                        Token token = ts.token();
                        if (!"comment".equals(token.id().primaryCategory()) || (te = ts.embedded()) == null) continue;
                        while (te.moveNext()) {
                            Token commentToken = te.token();
                            if (commentToken.id() != DoxygenTokenId.IDENT || !text.contentEquals(commentToken.text())) continue;
                            int offset = commentToken.offset(hi);
                            comments.add(new CsmCommentReferenceImpl(text, offset, offset + commentToken.length(), file));
                        }
                    }
                }
            });
        }
        return comments;
    }

    private static class CsmCommentReferenceImpl
    implements CsmReference {
        private final CharSequence label;
        private final CsmFile file;
        private final int startOffset;
        private final int endOffset;

        public CsmCommentReferenceImpl(CharSequence label, int startOffset, int endOffset, CsmFile file) {
            this.label = label;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.file = file;
        }

        public CsmReferenceKind getKind() {
            return CsmReferenceKind.COMMENT;
        }

        public CsmObject getReferencedObject() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public CsmObject getOwner() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public CsmObject getClosestTopLevelObject() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public CsmFile getContainingFile() {
            return this.file;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public CsmOffsetable.Position getStartPosition() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public CsmOffsetable.Position getEndPosition() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public CharSequence getText() {
            return this.label;
        }

        public String toString() {
            return "" + this.label + "[" + this.getKind() + "] ";
        }
    }

    public static final class CsmRefactoringNameProviderImpl
    implements CsmRefactoringNameProvider {
        @Override
        public String getRefactoredName(CsmObject object, String current) {
            return null;
        }

        @Override
        public String getReplaceText(CsmReference ref, String newText, AbstractRefactoring refactoring) {
            String out = null;
            CsmObject referencedObject = ref.getReferencedObject();
            if (CsmKindUtilities.isFile((CsmObject)referencedObject)) {
                String fileNameExt;
                String oldText;
                int lastIndexOf;
                CsmObject owner = ref.getOwner();
                assert (CsmKindUtilities.isInclude((CsmObject)owner)) : "include directive is expected " + owner;
                FileObject file = CsmUtilities.getFileObject((CsmFile)((CsmFile)referencedObject));
                if (file != null && (lastIndexOf = (oldText = ref.getText().toString()).lastIndexOf(fileNameExt = file.getNameExt())) > 0) {
                    String fileName = file.getName();
                    out = oldText.substring(0, lastIndexOf) + newText + oldText.substring(lastIndexOf + fileName.length());
                }
            }
            return out;
        }

        @Override
        public String getReplaceDescription(CsmReference ref, AbstractRefactoring refactoring) {
            String out = null;
            CsmObject referencedObject = ref.getReferencedObject();
            if (CsmKindUtilities.isFile((CsmObject)referencedObject)) {
                String oldText = ref.getText().toString();
                return NbBundle.getMessage(CsmRefactoringUtils.class, (String)"UpdateInclude", (Object)oldText);
            }
            return out;
        }
    }
}

