/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.ui;

import java.text.MessageFormat;
import java.util.List;
import java.util.Vector;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.refactoring.api.ChangeParametersRefactoring;
import org.netbeans.modules.cnd.refactoring.api.CsmContext;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.refactoring.ui.ChangeParametersPanel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ChangeParametersUI
implements RefactoringUI {
    private final CsmObject selectedElement;
    private final CsmContext editorContext;
    private ChangeParametersPanel panel;
    private final ChangeParametersRefactoring refactoring;

    private ChangeParametersUI(CsmObject selectedElement, CsmContext editorContext) {
        this.refactoring = new ChangeParametersRefactoring(selectedElement, editorContext);
        this.selectedElement = selectedElement;
        this.editorContext = editorContext;
    }

    public static ChangeParametersUI create(CsmObject selectedElement, CsmContext editorContext) {
        return new ChangeParametersUI(selectedElement, editorContext);
    }

    public String getDescription() {
        String msg = NbBundle.getMessage(ChangeParametersUI.class, (String)"DSC_ChangeParsRootNode");
        String name = CsmRefactoringUtils.getSimpleText(this.selectedElement);
        boolean isConstructor = CsmKindUtilities.isConstructor((CsmObject)this.selectedElement);
        return new MessageFormat(msg).format(new Object[]{name, NbBundle.getMessage(ChangeParametersUI.class, (String)("DSC_ChangeParsRootNode" + (isConstructor ? "Constr" : "Method"))), this.panel.genDeclarationString()});
    }

    public CustomRefactoringPanel getPanel(ChangeListener parent) {
        if (this.panel == null) {
            this.panel = new ChangeParametersPanel(this.selectedElement, this.editorContext, parent);
        }
        return this.panel;
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public boolean isQuery() {
        return false;
    }

    private Problem setParameters(boolean checkOnly) {
        Vector<Vector> data = this.panel.getTableModel().getDataVector();
        ChangeParametersRefactoring.ParameterInfo[] paramList = new ChangeParametersRefactoring.ParameterInfo[data.size()];
        int counter = 0;
        Problem problem = null;
        for (List list : data) {
            int origIndex = (Integer)list.get(3);
            CharSequence name = (CharSequence)list.get(0);
            CharSequence type = (CharSequence)list.get(1);
            CharSequence defaultVal = (CharSequence)list.get(2);
            paramList[counter++] = new ChangeParametersRefactoring.ParameterInfo(origIndex, name, type, defaultVal);
        }
        CsmVisibility visibility = this.panel.getModifier();
        this.refactoring.setParameterInfo(paramList);
        this.refactoring.setVisibility(visibility);
        this.refactoring.setUseDefaultValueOnlyInFunctionDeclaration(this.panel.isUseDefaultValueOnlyInFunctionDeclaration());
        problem = checkOnly ? this.refactoring.fastCheckParameters() : this.refactoring.checkParameters();
        return problem;
    }

    public String getName() {
        return NbBundle.getMessage(ChangeParametersUI.class, (String)"LBL_ChangeMethodSignature");
    }

    public Problem checkParameters() {
        return this.setParameters(true);
    }

    public Problem setParameters() {
        return this.setParameters(false);
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("ChangeFunctionParameters");
    }
}

