/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.actions;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.debugger.jpda.actions.ActionsSynchronizer;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ui.JavaUtils;
import org.netbeans.modules.debugger.jpda.ui.actions.ToggleMethodFieldBreakpointAction;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ToggleBreakpointActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener {
    private RequestProcessor RP = new RequestProcessor(ToggleBreakpointActionProvider.class.getName());
    private JPDADebugger debugger;
    private volatile int postedLineNumber = -1;
    private volatile String postedUrl = null;

    public ToggleBreakpointActionProvider() {
        EditorContextBridge.getContext().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public ToggleBreakpointActionProvider(ContextProvider lookupProvider) {
        this.debugger = (JPDADebugger)lookupProvider.lookupFirst(null, JPDADebugger.class);
        this.debugger.addPropertyChangeListener("state", (PropertyChangeListener)this);
        EditorContextBridge.getContext().addPropertyChangeListener((PropertyChangeListener)this);
    }

    private void destroy() {
        this.debugger.removePropertyChangeListener("state", (PropertyChangeListener)this);
        EditorContextBridge.getContext().removePropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        FileObject fo;
        String url = EditorContextBridge.getContext().getCurrentURL();
        try {
            fo = URLMapper.findFileObject((URL)new URL(url));
        }
        catch (MalformedURLException muex) {
            fo = null;
        }
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, EditorContextBridge.getContext().getCurrentLineNumber() >= 0 && fo != null && "text/x-java".equals(fo.getMIMEType()));
        if (this.debugger != null && this.debugger.getState() == 4) {
            this.destroy();
        }
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_TOGGLE_BREAKPOINT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAction(Object action) {
        ActionsSynchronizer as;
        JPDADebugger dbg = this.debugger;
        if (dbg == null) {
            dbg = ToggleMethodFieldBreakpointAction.getCurrentDebugger();
        }
        ActionsSynchronizer actionsSynchronizer = as = dbg != null ? ActionsSynchronizer.get((JPDADebugger)dbg) : null;
        if (as != null) {
            as.actionStarts(action);
        }
        try {
            this.doTheAction(action);
        }
        finally {
            if (as != null) {
                as.actionEnds(action);
            }
        }
    }

    private void doTheAction(Object action) {
        int lineNumber;
        DebuggerManager d = DebuggerManager.getDebuggerManager();
        String url = this.postedUrl;
        if (url == null) {
            url = EditorContextBridge.getContext().getCurrentURL();
        }
        if ((lineNumber = this.postedLineNumber) == -1) {
            lineNumber = EditorContextBridge.getContext().getCurrentLineNumber();
        }
        if ("".equals(url.trim())) {
            return;
        }
        LineBreakpoint lb = ToggleBreakpointActionProvider.findBreakpoint(url, lineNumber);
        if (lb != null) {
            d.removeBreakpoint((Breakpoint)lb);
            return;
        }
        JEditorPane[] editorPane = new JEditorPane[1];
        int adjustedLineNumber = this.checkLineBreakability(url, lineNumber, editorPane);
        if (adjustedLineNumber != lineNumber) {
            if (adjustedLineNumber == -1 || ToggleBreakpointActionProvider.findBreakpoint(url, adjustedLineNumber) != null) {
                Toolkit.getDefaultToolkit().beep();
                if (editorPane[0] != null) {
                    Utilities.setStatusText((JTextComponent)editorPane[0], (String)"");
                    String msg = NbBundle.getMessage(ToggleBreakpointActionProvider.class, (String)"CTL_Cannot_Toggle_Breakpoint");
                    Utilities.setStatusText((JTextComponent)editorPane[0], (String)msg);
                }
                return;
            }
            if (editorPane[0] != null) {
                Utilities.setStatusText((JTextComponent)editorPane[0], (String)"");
                String msg = NbBundle.getMessage(ToggleBreakpointActionProvider.class, (String)"CTL_Breakpoint_Position_Adjusted");
                Utilities.setStatusText((JTextComponent)editorPane[0], (String)msg);
            }
            lineNumber = adjustedLineNumber;
        }
        lb = LineBreakpoint.create((String)url, (int)lineNumber);
        lb.setPrintText(NbBundle.getMessage(ToggleBreakpointActionProvider.class, (String)"CTL_Line_Breakpoint_Print_Text"));
        d.addBreakpoint((Breakpoint)lb);
    }

    public void postAction(final Object action, final Runnable actionPerformedNotifier) {
        EditorContext context = EditorContextBridge.getContext();
        this.postedLineNumber = context.getCurrentLineNumber();
        this.postedUrl = context.getCurrentURL();
        JPDADebugger dbg = this.debugger;
        if (dbg == null) {
            dbg = ToggleMethodFieldBreakpointAction.getCurrentDebugger();
        }
        if (dbg != null) {
            ActionsSynchronizer.get((JPDADebugger)dbg).actionScheduled(action);
        }
        this.RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ToggleBreakpointActionProvider.this.doAction(action);
                }
                finally {
                    ToggleBreakpointActionProvider.this.postedLineNumber = -1;
                    ToggleBreakpointActionProvider.this.postedUrl = null;
                    actionPerformedNotifier.run();
                }
            }
        });
    }

    private int checkLineBreakability(String url, int lineNumber, final JEditorPane[] editorPane) {
        int[] result;
        block23: {
            int rowEndOffset;
            FileObject fileObj = null;
            try {
                fileObj = URLMapper.findFileObject((URL)new URL(url));
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            if (fileObj == null) {
                return lineNumber;
            }
            DataObject dobj = null;
            try {
                dobj = DataObject.find((FileObject)fileObj);
            }
            catch (DataObjectNotFoundException ex) {
                // empty catch block
            }
            if (dobj == null) {
                return lineNumber;
            }
            final EditorCookie ec = (EditorCookie)dobj.getLookup().lookup(EditorCookie.class);
            if (ec == null) {
                return lineNumber;
            }
            final BaseDocument doc = (BaseDocument)ec.getDocument();
            if (doc == null) {
                return lineNumber;
            }
            final int rowStartOffset = Utilities.getRowStartFromLineOffset((BaseDocument)doc, (int)(lineNumber - 1));
            try {
                rowEndOffset = Utilities.getRowEnd((BaseDocument)doc, (int)rowStartOffset);
            }
            catch (BadLocationException ex) {
                return lineNumber;
            }
            JavaSource js = JavaSource.forFileObject((FileObject)fileObj);
            if (js == null) {
                return lineNumber;
            }
            if (SwingUtilities.isEventDispatchThread()) {
                JEditorPane[] openedPanes = ec.getOpenedPanes();
                if (openedPanes != null && openedPanes.length > 0) {
                    editorPane[0] = openedPanes[0];
                }
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            JEditorPane[] openedPanes = ec.getOpenedPanes();
                            if (openedPanes != null && openedPanes.length > 0) {
                                editorPane[0] = openedPanes[0];
                            }
                        }
                    });
                }
                catch (InvocationTargetException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            result = new int[]{lineNumber};
            try {
                Future<Void> scanFinished = JavaUtils.runWhenScanFinishedReallyLazy(js, (Task<CompilationController>)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController ci) throws Exception {
                        if (ci.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                            ErrorManager.getDefault().log(16, "Unable to resolve " + ci.getFileObject() + " to phase " + JavaSource.Phase.RESOLVED + ", current phase = " + ci.getPhase() + "\nDiagnostics = " + ci.getDiagnostics() + "\nFree memory = " + Runtime.getRuntime().freeMemory());
                            return;
                        }
                        SourcePositions positions = ci.getTrees().getSourcePositions();
                        CompilationUnitTree compUnit = ci.getCompilationUnit();
                        TreeUtilities treeUtils = ci.getTreeUtilities();
                        Tree outerTree = null;
                        Tree execTree = null;
                        TreePath outerTreePath = null;
                        TreePath execTreePath = null;
                        Tree lastTree = null;
                        long execTreeStartOffs = 0L;
                        long execTreeEndOffs = 0L;
                        for (int index = rowStartOffset; index <= rowEndOffset; ++index) {
                            TreePath path = treeUtils.pathFor(index);
                            Tree tree = path.getLeaf();
                            if (tree.equals(lastTree)) continue;
                            long startOffs = positions.getStartPosition(compUnit, tree);
                            long endOffs = positions.getEndPosition(compUnit, tree);
                            if (outerTree == null && startOffs < (long)rowStartOffset) {
                                outerTree = tree;
                                outerTreePath = path;
                                lastTree = tree;
                                continue;
                            }
                            if (startOffs >= (long)rowStartOffset) {
                                if (execTree == null || execTreeStartOffs >= startOffs && execTreeEndOffs <= endOffs) {
                                    execTree = tree;
                                    execTreePath = path;
                                    execTreeStartOffs = startOffs;
                                    execTreeEndOffs = endOffs;
                                    if (execTree instanceof VariableTree && ToggleBreakpointActionProvider.isBreakable(execTreePath)) {
                                        break;
                                    }
                                } else if (startOffs > execTreeEndOffs) {
                                    if (ToggleBreakpointActionProvider.isBreakable(execTreePath)) break;
                                    execTree = tree;
                                    execTreePath = path;
                                    execTreeStartOffs = startOffs;
                                    execTreeEndOffs = endOffs;
                                    if (execTree instanceof VariableTree && ToggleBreakpointActionProvider.isBreakable(execTreePath)) break;
                                }
                            }
                            lastTree = tree;
                        }
                        if (execTree == null || !ToggleBreakpointActionProvider.isBreakable(execTreePath)) {
                            if (outerTree != null && ToggleBreakpointActionProvider.isBreakable(outerTreePath)) {
                                long offs = positions.getStartPosition(compUnit, outerTree);
                                result[0] = Utilities.getLineOffset((BaseDocument)doc, (int)((int)offs)) + 1;
                            } else {
                                long endOffs;
                                Tree pTree;
                                if (outerTree != null && outerTree instanceof BlockTree && (pTree = outerTreePath.getParentPath().getLeaf()) instanceof MethodTree && (endOffs = positions.getEndPosition(compUnit, pTree)) <= (long)rowEndOffset) {
                                    return;
                                }
                                result[0] = -1;
                            }
                        }
                    }
                }, true);
                if (scanFinished.isDone()) break block23;
                if (EventQueue.isDispatchThread()) {
                    return lineNumber;
                }
                try {
                    scanFinished.get();
                }
                catch (InterruptedException iex) {
                    return lineNumber;
                }
                catch (ExecutionException eex) {
                    ErrorManager.getDefault().notify((Throwable)eex);
                    return lineNumber;
                }
            }
            catch (IOException ioex) {
                ErrorManager.getDefault().notify((Throwable)ioex);
                return lineNumber;
            }
        }
        return result[0];
    }

    private static boolean isBreakable(TreePath path) {
        Tree tree = path.getLeaf();
        switch (tree.getKind()) {
            case BLOCK: 
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: 
            case COMPILATION_UNIT: 
            case IMPORT: 
            case MODIFIERS: 
            case EMPTY_STATEMENT: {
                return false;
            }
        }
        while (path != null) {
            VariableTree varTree;
            tree = path.getLeaf();
            Tree.Kind kind = tree.getKind();
            if (kind == Tree.Kind.IMPORT) {
                return false;
            }
            if (kind == Tree.Kind.VARIABLE && (varTree = (VariableTree)tree).getInitializer() == null) {
                return false;
            }
            path = path.getParentPath();
        }
        return true;
    }

    static LineBreakpoint findBreakpoint(String url, int lineNumber) {
        Breakpoint[] breakpoints = DebuggerManager.getDebuggerManager().getBreakpoints();
        for (int i = 0; i < breakpoints.length; ++i) {
            LineBreakpoint lb;
            if (!(breakpoints[i] instanceof LineBreakpoint) || !(lb = (LineBreakpoint)breakpoints[i]).getURL().equals(url) || lb.getLineNumber() != lineNumber) continue;
            return lb;
        }
        return null;
    }
}

