/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.breakpoints;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ActionsPanel;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ClassBreakpointPanel;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ConditionsPanel;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Pair;

public class MethodBreakpointPanel
extends JPanel
implements Controller,
HelpCtx.Provider {
    private static final String HELP_ID = "debug.add.breakpoint.java.method";
    private ConditionsPanel conditionsPanel;
    private ActionsPanel actionsPanel;
    private MethodBreakpoint breakpoint;
    private boolean createBreakpoint = false;
    private JEditorPane epClassName;
    private JScrollPane spClassName;
    private JEditorPane epMethodName;
    private JScrollPane spMethodName;
    private JPanel cPanel;
    private JCheckBox cbAllMethods;
    private JComboBox cbBreakpointType;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel pActions;
    private JPanel pSettings;
    private JPanel panelClassName;
    private JLabel stopOnLabel;

    private static MethodBreakpoint createBreakpoint() {
        String methodName;
        String className;
        try {
            className = EditorContextBridge.getMostRecentClassName();
        }
        catch (IllegalComponentStateException icsex) {
            className = "";
        }
        try {
            methodName = EditorContextBridge.getMostRecentMethodName();
        }
        catch (IllegalComponentStateException icsex) {
            methodName = "";
        }
        MethodBreakpoint mb = MethodBreakpoint.create((String)className, (String)methodName);
        try {
            mb.setMethodSignature(EditorContextBridge.getMostRecentMethodSignature());
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
        mb.setPrintText(NbBundle.getBundle(MethodBreakpointPanel.class).getString("CTL_Method_Breakpoint_Print_Text"));
        return mb;
    }

    public MethodBreakpointPanel() {
        this(MethodBreakpointPanel.createBreakpoint());
        this.createBreakpoint = true;
    }

    public MethodBreakpointPanel(MethodBreakpoint b) {
        this.breakpoint = b;
        this.initComponents();
        String className = "";
        String[] cf = b.getClassFilters();
        className = ClassBreakpointPanel.concatClassFilters(cf);
        String tooltipText = NbBundle.getMessage(MethodBreakpointPanel.class, (String)"TTT_TF_Field_Breakpoint_Class_Name");
        Pair<JScrollPane, JEditorPane> editorCC = ClassBreakpointPanel.addClassNameEditorCC("text/x-java-nbdebug-class", null, className, tooltipText);
        this.spClassName = (JScrollPane)editorCC.first();
        this.epClassName = (JEditorPane)editorCC.second();
        this.epClassName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MethodBreakpointPanel.class, (String)"ACSN_Method_Breakpoint_ClassName"));
        this.epClassName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MethodBreakpointPanel.class, (String)"ACSD_Method_Breakpoint_ClassName"));
        this.jLabel3.setLabelFor(this.spClassName);
        HelpCtx.setHelpIDString((JComponent)this.epClassName, (String)HELP_ID);
        this.panelClassName.add("Center", this.spClassName);
        editorCC = ClassBreakpointPanel.addClassNameEditorCC("text/x-java-nbdebug-class-method", null, className, NbBundle.getMessage(MethodBreakpointPanel.class, (String)"TTT_TF_Method_Breakpoint_Method_Name"));
        this.spMethodName = (JScrollPane)editorCC.first();
        this.epMethodName = (JEditorPane)editorCC.second();
        this.jLabel1.setLabelFor(this.spMethodName);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.spMethodName, gridBagConstraints);
        this.epMethodName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MethodBreakpointPanel.class, (String)"ACSD_TF_Method_Breakpoint_Method_Name"));
        this.epMethodName.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                MethodBreakpointPanel.this.epMethodName.getDocument().putProperty("class-name", MethodBreakpointPanel.this.epClassName.getText());
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        if ("".equals(b.getMethodName())) {
            this.epMethodName.setText(NbBundle.getMessage(MethodBreakpointPanel.class, (String)"Method_Breakpoint_ALL_METHODS"));
            this.cbAllMethods.setSelected(true);
            this.epMethodName.setEnabled(false);
        } else {
            this.epMethodName.setText(b.getMethodName() + " " + MethodBreakpointPanel.createParamTypesFromSignature(b.getMethodSignature()));
        }
        this.cbBreakpointType.addItem(NbBundle.getMessage(MethodBreakpointPanel.class, (String)"LBL_Method_Breakpoint_Type_Entry"));
        this.cbBreakpointType.addItem(NbBundle.getMessage(MethodBreakpointPanel.class, (String)"LBL_Method_Breakpoint_Type_Exit"));
        this.cbBreakpointType.addItem(NbBundle.getMessage(MethodBreakpointPanel.class, (String)"LBL_Method_Breakpoint_Type_Entry_or_Exit"));
        switch (b.getBreakpointType()) {
            case 1: {
                this.cbBreakpointType.setSelectedIndex(0);
                break;
            }
            case 2: {
                this.cbBreakpointType.setSelectedIndex(1);
                break;
            }
            case 3: {
                this.cbBreakpointType.setSelectedIndex(2);
            }
        }
        this.conditionsPanel = new ConditionsPanel(HELP_ID);
        this.conditionsPanel.setupConditionPaneContext();
        this.conditionsPanel.showClassFilter(false);
        this.conditionsPanel.setCondition(b.getCondition());
        this.conditionsPanel.setHitCountFilteringStyle(b.getHitCountFilteringStyle());
        this.conditionsPanel.setHitCount(b.getHitCountFilter());
        this.cPanel.add((Component)this.conditionsPanel, "Center");
        this.actionsPanel = new ActionsPanel((JPDABreakpoint)b);
        this.pActions.add((Component)this.actionsPanel, "Center");
        this.putClientProperty("HelpID_AddBreakpointPanel", HELP_ID);
    }

    private static String createParamTypesFromSignature(String signature) {
        if (signature == null || signature.length() == 0) {
            return "";
        }
        int end = signature.lastIndexOf(")");
        if (end < 0) {
            ErrorManager.getDefault().notify((Throwable)new IllegalArgumentException("Bad signature: " + signature));
            return "";
        }
        StringBuilder paramTypes = new StringBuilder("(");
        int[] s = new int[]{1};
        while (s[0] < signature.length() && signature.charAt(s[0]) != ')') {
            if (s[0] > 1) {
                paramTypes.append(',');
            }
            paramTypes.append(MethodBreakpointPanel.getType(signature, s));
        }
        paramTypes.append(')');
        return paramTypes.toString();
    }

    private static String createSignatureFromParamTypes(String paramTypes) {
        StringBuilder signature = new StringBuilder("(");
        int s = 0;
        while (s < paramTypes.length()) {
            int e = paramTypes.indexOf(44, s);
            if (e < 0) {
                e = paramTypes.length();
            }
            String type = paramTypes.substring(s, e);
            signature.append(MethodBreakpointPanel.getSignature(type.trim()));
            s = e + 1;
        }
        signature.append(')');
        return signature.toString();
    }

    private static String getSignature(String javaType) {
        if (javaType.equals("boolean")) {
            return "Z";
        }
        if (javaType.equals("byte")) {
            return "B";
        }
        if (javaType.equals("char")) {
            return "C";
        }
        if (javaType.equals("short")) {
            return "S";
        }
        if (javaType.equals("int")) {
            return "I";
        }
        if (javaType.equals("long")) {
            return "J";
        }
        if (javaType.equals("float")) {
            return "F";
        }
        if (javaType.equals("double")) {
            return "D";
        }
        if (javaType.endsWith("[]")) {
            return "[" + MethodBreakpointPanel.getSignature(javaType.substring(0, javaType.length() - 2));
        }
        return "L" + javaType.replace('.', '/') + ";";
    }

    private static String getType(String signature, int[] pos) throws IllegalArgumentException {
        char c = signature.charAt(pos[0]);
        if (c == 'Z') {
            pos[0] = pos[0] + 1;
            return "boolean";
        }
        if (c == 'B') {
            pos[0] = pos[0] + 1;
            return "byte";
        }
        if (c == 'C') {
            pos[0] = pos[0] + 1;
            return "char";
        }
        if (c == 'S') {
            pos[0] = pos[0] + 1;
            return "short";
        }
        if (c == 'I') {
            pos[0] = pos[0] + 1;
            return "int";
        }
        if (c == 'J') {
            pos[0] = pos[0] + 1;
            return "long";
        }
        if (c == 'F') {
            pos[0] = pos[0] + 1;
            return "float";
        }
        if (c == 'D') {
            pos[0] = pos[0] + 1;
            return "double";
        }
        if (c == 'L') {
            pos[0] = pos[0] + 1;
            int typeEnd = signature.indexOf(";", pos[0]);
            if (typeEnd < 0) {
                throw new IllegalArgumentException("Bad signature: '" + signature + "', 'L' not followed by ';' at position " + pos[0]);
            }
            String type = signature.substring(pos[0], typeEnd);
            type = type.replace('/', '.');
            pos[0] = typeEnd + 1;
            return type;
        }
        if (c == '[') {
            pos[0] = pos[0] + 1;
            String type = MethodBreakpointPanel.getType(signature, pos);
            return type + "[]";
        }
        throw new IllegalArgumentException("Bad signature: '" + signature + "', unrecognized element '" + c + "' at position " + pos[0]);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerBreakpointMethodJPDA");
    }

    private void initComponents() {
        this.pSettings = new JPanel();
        this.jLabel3 = new JLabel();
        this.cbAllMethods = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.panelClassName = new JPanel();
        this.stopOnLabel = new JLabel();
        this.cbBreakpointType = new JComboBox();
        this.cPanel = new JPanel();
        this.pActions = new JPanel();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.pSettings.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(MethodBreakpointPanel.class, (String)"L_Method_Breakpoint_BorderTitle")));
        this.pSettings.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(MethodBreakpointPanel.class, (String)"L_Method_Breakpoint_Class_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MethodBreakpointPanel.class, (String)"ACSD_L_Method_Breakpoint_Class_Name"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbAllMethods, (String)NbBundle.getMessage(MethodBreakpointPanel.class, (String)"CB_Method_Breakpoint_All_Methods"));
        this.cbAllMethods.setToolTipText(NbBundle.getMessage(MethodBreakpointPanel.class, (String)"TTT_CB_Method_Breakpoint_All_Methods"));
        this.cbAllMethods.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbAllMethods.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MethodBreakpointPanel.this.cbAllMethodsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.cbAllMethods, gridBagConstraints);
        this.cbAllMethods.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MethodBreakpointPanel.class, (String)"ACSD_CB_Method_Breakpoint_All_Methods"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(MethodBreakpointPanel.class, (String)"L_Method_Breakpoint_Method_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MethodBreakpointPanel.class, (String)"ACSD_L_Method_Breakpoint_Method_Name"));
        this.panelClassName.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.panelClassName, gridBagConstraints);
        this.stopOnLabel.setLabelFor(this.cbBreakpointType);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.stopOnLabel, (String)bundle.getString("L_Method_Breakpoint_Type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.stopOnLabel, gridBagConstraints);
        this.stopOnLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MethodBreakpointPanel.class, (String)"ACSD_StopOn_LBL"));
        this.cbBreakpointType.setToolTipText(bundle.getString("TTT_CB_Class_Breakpoint_Type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.cbBreakpointType, gridBagConstraints);
        this.cbBreakpointType.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MethodBreakpointPanel.class, (String)"ACSN_CB_Method_Breakpoint_Type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pSettings, gridBagConstraints);
        this.cPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.cPanel, gridBagConstraints);
        this.pActions.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pActions, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MethodBreakpointPanel.class, (String)"ACSN_MethodBreakpointPanel"));
    }

    private void cbAllMethodsActionPerformed(ActionEvent evt) {
        if (this.cbAllMethods.isSelected()) {
            this.epMethodName.setText(NbBundle.getMessage(MethodBreakpointPanel.class, (String)"Method_Breakpoint_ALL_METHODS"));
            this.epMethodName.setEnabled(false);
        } else {
            this.epMethodName.setText("");
            this.epMethodName.setEnabled(true);
        }
    }

    public boolean ok() {
        String msg = this.valiadateMsg();
        if (msg == null) {
            msg = this.conditionsPanel.valiadateMsg();
        }
        if (msg != null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg));
            return false;
        }
        this.actionsPanel.ok();
        String className = this.epClassName.getText().trim();
        this.breakpoint.setClassFilters(new String[]{className});
        if (!this.cbAllMethods.isSelected()) {
            String signature;
            String methodName;
            String methodAndSignature = this.epMethodName.getText().trim();
            int index = methodAndSignature.indexOf("(");
            if (index < 0) {
                methodName = methodAndSignature;
                signature = null;
            } else {
                methodName = methodAndSignature.substring(0, index).trim();
                int end = methodAndSignature.indexOf(")", index);
                if (end < 0) {
                    end = methodAndSignature.length();
                }
                signature = methodAndSignature.substring(index + 1, end);
                signature = MethodBreakpointPanel.createSignatureFromParamTypes(signature);
            }
            this.breakpoint.setMethodName(methodName);
            this.breakpoint.setMethodSignature(signature);
        } else {
            this.breakpoint.setMethodName("");
        }
        switch (this.cbBreakpointType.getSelectedIndex()) {
            case 0: {
                this.breakpoint.setBreakpointType(1);
                break;
            }
            case 1: {
                this.breakpoint.setBreakpointType(2);
                break;
            }
            case 2: {
                this.breakpoint.setBreakpointType(3);
            }
        }
        this.breakpoint.setCondition(this.conditionsPanel.getCondition());
        this.breakpoint.setHitCountFilter(this.conditionsPanel.getHitCount(), this.conditionsPanel.getHitCountFilteringStyle());
        if (this.createBreakpoint) {
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)this.breakpoint);
        }
        return true;
    }

    public boolean cancel() {
        return true;
    }

    private String valiadateMsg() {
        if (this.epClassName.getText().trim().length() == 0 || this.epMethodName.getText().trim().length() == 0 && !this.cbAllMethods.isSelected()) {
            return NbBundle.getMessage(MethodBreakpointPanel.class, (String)"MSG_No_Class_or_Method_Name_Spec");
        }
        return null;
    }
}

