/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.JPDAWatch;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.ui.models.VariablesTableModel;
import org.netbeans.modules.debugger.jpda.ui.models.VariablesTreeModelFilter;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public class NumericDisplayFilter
implements TableModelFilter,
NodeActionsProviderFilter,
Constants {
    private final Map<Variable, NumericDisplaySettings> variableToDisplaySettings = new HashMap<Variable, NumericDisplaySettings>();
    private HashSet listeners;

    public Object getValueAt(TableModel original, Object node, String columnID) throws UnknownTypeException {
        if ((columnID == "WatchValue" || columnID == "WatchToString" || columnID == "LocalsValue" || columnID == "LocalsToString") && node instanceof Variable && this.isIntegralType((Variable)node)) {
            Variable var;
            NumericDisplaySettings nds;
            JPDAWatch w;
            String e;
            if (node instanceof JPDAWatch && (e = (w = (JPDAWatch)node).getExceptionDescription()) == null) {
                if (columnID == "WatchValue" || columnID == "LocalsValue") {
                    VariablesTableModel.setErrorValueMsg((Variable)w, null);
                } else {
                    VariablesTableModel.setErrorToStringMsg((Variable)w, null);
                }
            }
            if ((nds = this.variableToDisplaySettings.get(var = (Variable)node)) == null && var instanceof Field) {
                Variable parent = null;
                try {
                    Method pvm = var.getClass().getMethod("getParentVariable", new Class[0]);
                    pvm.setAccessible(true);
                    parent = (Variable)pvm.invoke((Object)var, new Object[0]);
                }
                catch (IllegalAccessException ex) {
                }
                catch (IllegalArgumentException ex) {
                }
                catch (InvocationTargetException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (NoSuchMethodException ex) {
                }
                catch (SecurityException ex) {
                    // empty catch block
                }
                nds = this.variableToDisplaySettings.get(parent);
            }
            return this.getValue(var, nds);
        }
        return original.getValueAt(node, columnID);
    }

    public boolean isReadOnly(TableModel original, Object node, String columnID) throws UnknownTypeException {
        return original.isReadOnly(node, columnID);
    }

    public void setValueAt(TableModel original, Object node, String columnID, Object value) throws UnknownTypeException {
        if ((columnID == "WatchValue" || columnID == "WatchToString" || columnID == "LocalsValue" || columnID == "LocalsToString") && node instanceof Variable && this.isIntegralType((Variable)node) && value instanceof String) {
            Variable var = (Variable)node;
            value = this.setValue(var, this.variableToDisplaySettings.get(var), (String)value);
        }
        original.setValueAt(node, columnID, value);
    }

    public void addModelListener(ModelListener l) {
        HashSet newListeners = this.listeners == null ? new HashSet() : (HashSet)this.listeners.clone();
        newListeners.add(l);
        this.listeners = newListeners;
    }

    public void removeModelListener(ModelListener l) {
        if (this.listeners == null) {
            return;
        }
        HashSet newListeners = (HashSet)this.listeners.clone();
        newListeners.remove(l);
        this.listeners = newListeners;
    }

    public void performDefaultAction(NodeActionsProvider original, Object node) throws UnknownTypeException {
        original.performDefaultAction(node);
    }

    public Action[] getActions(NodeActionsProvider original, Object node) throws UnknownTypeException {
        Variable var;
        Action[] actions;
        if (!(node instanceof Variable)) {
            return original.getActions(node);
        }
        try {
            actions = original.getActions(node);
        }
        catch (UnknownTypeException e) {
            actions = new Action[]{};
        }
        ArrayList<Action> myActions = new ArrayList<Action>();
        if (node instanceof Variable && this.isIntegralTypeOrArray(var = (Variable)node)) {
            myActions.add(new DisplayAsAction((Variable)node));
        }
        myActions.addAll(Arrays.asList(actions));
        return myActions.toArray(new Action[myActions.size()]);
    }

    private static int getChar(String toString) {
        toString = toString.substring(1, toString.length() - 1);
        char c = toString.charAt(0);
        return c & 0xFFFF;
    }

    private Object getValue(Variable var, NumericDisplaySettings settings) {
        if (settings == null) {
            return var.getValue();
        }
        String type = var.getType();
        try {
            switch (settings) {
                case DECIMAL: {
                    if ("char".equals(type)) {
                        int c = NumericDisplayFilter.getChar(var.getValue());
                        return Integer.toString(c);
                    }
                    return var.getValue();
                }
                case HEXADECIMAL: {
                    if ("int".equals(type)) {
                        return "0x" + Integer.toHexString(Integer.parseInt(var.getValue()));
                    }
                    if ("short".equals(type)) {
                        String rv = Integer.toHexString(Short.parseShort(var.getValue()));
                        if (rv.length() > 4) {
                            rv = rv.substring(rv.length() - 4, rv.length());
                        }
                        return "0x" + rv;
                    }
                    if ("byte".equals(type)) {
                        String rv = Integer.toHexString(Byte.parseByte(var.getValue()));
                        if (rv.length() > 2) {
                            rv = rv.substring(rv.length() - 2, rv.length());
                        }
                        return "0x" + rv;
                    }
                    if ("char".equals(type)) {
                        int c = NumericDisplayFilter.getChar(var.getValue());
                        return "0x" + Integer.toHexString(c);
                    }
                    return "0x" + Long.toHexString(Long.parseLong(var.getValue()));
                }
                case OCTAL: {
                    if ("int".equals(type)) {
                        return "0" + Integer.toOctalString(Integer.parseInt(var.getValue()));
                    }
                    if ("short".equals(type)) {
                        String rv = Integer.toOctalString(Short.parseShort(var.getValue()));
                        if (rv.length() > 5) {
                            rv = rv.substring(rv.length() - 5, rv.length());
                        }
                        return "0" + (rv.charAt(0) == '0' ? "1" : "") + rv;
                    }
                    if ("byte".equals(type)) {
                        String rv = Integer.toOctalString(Byte.parseByte(var.getValue()));
                        if (rv.length() > 3) {
                            rv = "1" + rv.substring(rv.length() - 2, rv.length());
                        }
                        return "0" + rv;
                    }
                    if ("char".equals(type)) {
                        int c = NumericDisplayFilter.getChar(var.getValue());
                        return "0" + Integer.toOctalString(c);
                    }
                    return "0" + Long.toOctalString(Long.parseLong(var.getValue()));
                }
                case BINARY: {
                    if ("int".equals(type)) {
                        return Integer.toBinaryString(Integer.parseInt(var.getValue()));
                    }
                    if ("short".equals(type)) {
                        String rv = Integer.toBinaryString(Short.parseShort(var.getValue()));
                        if (rv.length() > 16) {
                            rv = rv.substring(rv.length() - 16, rv.length());
                        }
                        return rv;
                    }
                    if ("byte".equals(type)) {
                        String rv = Integer.toBinaryString(Byte.parseByte(var.getValue()));
                        if (rv.length() > 8) {
                            rv = rv.substring(rv.length() - 8, rv.length());
                        }
                        return rv;
                    }
                    if ("char".equals(type)) {
                        int c = NumericDisplayFilter.getChar(var.getValue());
                        return Integer.toBinaryString(c);
                    }
                    return Long.toBinaryString(Long.parseLong(var.getValue()));
                }
                case CHAR: {
                    if ("char".equals(type)) {
                        return var.getValue();
                    }
                    return "'" + new Character((char)Integer.parseInt(var.getValue())) + "'";
                }
                case TIME: {
                    if (!"long".equals(type)) break;
                    return new Date(Long.parseLong(var.getValue())).toString();
                }
            }
            return var.getValue();
        }
        catch (NumberFormatException nfex) {
            return nfex.getLocalizedMessage();
        }
    }

    private Object setValue(Variable var, NumericDisplaySettings settings, String origValue) {
        if (settings == null) {
            return origValue;
        }
        String type = var.getType();
        try {
            switch (settings) {
                case BINARY: {
                    if ("int".equals(type)) {
                        return Integer.toString(Integer.parseInt(origValue, 2));
                    }
                    if ("short".equals(type)) {
                        return Short.toString(Short.parseShort(origValue, 2));
                    }
                    if ("byte".equals(type)) {
                        return Byte.toString(Byte.parseByte(origValue, 2));
                    }
                    if ("char".equals(type)) {
                        return "'" + Character.toString((char)Integer.parseInt(origValue, 2)) + "'";
                    }
                    return Long.toString(Long.parseLong(origValue, 2)) + "l";
                }
            }
            return origValue;
        }
        catch (NumberFormatException nfex) {
            return nfex.getLocalizedMessage();
        }
    }

    private boolean isIntegralType(Variable v) {
        if (!VariablesTreeModelFilter.isEvaluated(v)) {
            return false;
        }
        String type = v.getType();
        return "int".equals(type) || "char".equals(type) || "byte".equals(type) || "long".equals(type) || "short".equals(type);
    }

    private boolean isIntegralTypeOrArray(Variable v) {
        if (!VariablesTreeModelFilter.isEvaluated(v)) {
            return false;
        }
        String type = NumericDisplayFilter.removeArray(v.getType());
        return "int".equals(type) || "char".equals(type) || "byte".equals(type) || "long".equals(type) || "short".equals(type);
    }

    private static String removeArray(String type) {
        if (type.length() > 0 && type.endsWith("[]")) {
            return type.substring(0, type.length() - 2);
        }
        return type;
    }

    private class DisplayAsAction
    extends AbstractAction
    implements Presenter.Popup {
        private Variable variable;
        private String type;

        public DisplayAsAction(Variable variable) {
            this.variable = variable;
            this.type = NumericDisplayFilter.removeArray(variable.getType());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        public JMenuItem getPopupPresenter() {
            JMenu displayAsPopup = new JMenu(NbBundle.getMessage(NumericDisplayFilter.class, (String)"CTL_Variable_DisplayAs_Popup"));
            DisplayAsMenuItem decimalItem = new DisplayAsMenuItem("CTL_Variable_DisplayAs_Decimal", NumericDisplaySettings.DECIMAL);
            DisplayAsMenuItem hexadecimalItem = new DisplayAsMenuItem("CTL_Variable_DisplayAs_Hexadecimal", NumericDisplaySettings.HEXADECIMAL);
            DisplayAsMenuItem octalItem = new DisplayAsMenuItem("CTL_Variable_DisplayAs_Octal", NumericDisplaySettings.OCTAL);
            DisplayAsMenuItem binaryItem = new DisplayAsMenuItem("CTL_Variable_DisplayAs_Binary", NumericDisplaySettings.BINARY);
            DisplayAsMenuItem charItem = new DisplayAsMenuItem("CTL_Variable_DisplayAs_Character", NumericDisplaySettings.CHAR);
            DisplayAsMenuItem timeItem = new DisplayAsMenuItem("CTL_Variable_DisplayAs_Time", NumericDisplaySettings.TIME);
            NumericDisplaySettings lds = (NumericDisplaySettings)((Object)NumericDisplayFilter.this.variableToDisplaySettings.get(this.variable));
            if (lds != null) {
                switch (lds) {
                    case DECIMAL: {
                        decimalItem.setSelected(true);
                        break;
                    }
                    case HEXADECIMAL: {
                        hexadecimalItem.setSelected(true);
                        break;
                    }
                    case OCTAL: {
                        octalItem.setSelected(true);
                        break;
                    }
                    case BINARY: {
                        binaryItem.setSelected(true);
                        break;
                    }
                    case CHAR: {
                        charItem.setSelected(true);
                        break;
                    }
                    case TIME: {
                        timeItem.setSelected(true);
                    }
                }
            } else if ("char".equals(this.type)) {
                charItem.setSelected(true);
            } else {
                decimalItem.setSelected(true);
            }
            displayAsPopup.add(decimalItem);
            displayAsPopup.add(hexadecimalItem);
            displayAsPopup.add(octalItem);
            displayAsPopup.add(binaryItem);
            displayAsPopup.add(charItem);
            if ("long".equals(this.type)) {
                displayAsPopup.add(timeItem);
            }
            return displayAsPopup;
        }

        private void onDisplayAs(NumericDisplaySettings how) {
            NumericDisplaySettings lds = (NumericDisplaySettings)((Object)NumericDisplayFilter.this.variableToDisplaySettings.get(this.variable));
            if (lds == null) {
                lds = "char".equals(this.type) ? NumericDisplaySettings.CHAR : NumericDisplaySettings.DECIMAL;
            }
            if (lds == how) {
                return;
            }
            NumericDisplayFilter.this.variableToDisplaySettings.put(this.variable, how);
            this.fireModelChanged();
        }

        private void fireModelChanged() {
            if (NumericDisplayFilter.this.listeners == null) {
                return;
            }
            ModelEvent.TableValueChanged evt = new ModelEvent.TableValueChanged((Object)this, (Object)this.variable, null);
            for (ModelListener listener : NumericDisplayFilter.this.listeners) {
                listener.modelChanged((ModelEvent)evt);
            }
        }

        private class DisplayAsMenuItem
        extends JRadioButtonMenuItem {
            public DisplayAsMenuItem(String message, final NumericDisplaySettings as) {
                super(new AbstractAction(NbBundle.getMessage(NumericDisplayFilter.class, (String)message)){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DisplayAsAction.this.onDisplayAs(as);
                    }
                });
            }
        }
    }

    static enum NumericDisplaySettings {
        DECIMAL,
        HEXADECIMAL,
        OCTAL,
        BINARY,
        CHAR,
        TIME;

    }
}

