/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.security.auth.RefreshFailedException;
import javax.security.auth.Refreshable;
import javax.swing.Action;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.ui.views.VariablesViewButtons;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.VariablesFilter;
import org.netbeans.spi.debugger.ui.CodeEvaluator;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ExtendedNodeModelFilter;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.datatransfer.PasteType;

public class VariablesTreeModelFilter
implements TreeModelFilter,
ExtendedNodeModelFilter,
TableModelFilter,
NodeActionsProviderFilter,
Runnable {
    private ContextProvider lookupProvider;
    private final Collection modelListeners = new HashSet();
    private RequestProcessor evaluationRP;
    private RequestProcessor.Task evaluationTask;
    private final LinkedList evaluationQueue = new LinkedList();
    private final CodeEvaluator.Result<Variable, CodeEvaluator.Result.DefaultHistoryItem> result;
    private EvaluatorListener evalListener;
    private VariablesPreferenceChangeListener prefListener;
    private Preferences preferences = NbPreferences.forModule(VariablesViewButtons.class).node("variables_view");
    private final Object filtersLock = new Object();
    private HashMap typeToFilter;
    private HashMap ancestorToFilter;

    public VariablesTreeModelFilter(ContextProvider lookupProvider) {
        this.lookupProvider = lookupProvider;
        this.evaluationRP = (RequestProcessor)lookupProvider.lookupFirst(null, RequestProcessor.class);
        this.evalListener = new EvaluatorListener();
        this.result = CodeEvaluator.Result.get((DebuggerEngine)((DebuggerEngine)lookupProvider.lookupFirst(null, DebuggerEngine.class)));
        this.result.addListener((CodeEvaluator.Result.Listener)this.evalListener);
        this.prefListener = new VariablesPreferenceChangeListener();
        this.preferences.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this.prefListener, (Object)this.preferences));
        Properties properties = Properties.getDefault().getProperties("debugger.options.JPDA");
        properties.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.prefListener, (Object)properties));
    }

    public Object getRoot(TreeModel original) {
        return original.getRoot();
    }

    public static boolean isEvaluated(Object o) {
        if (o instanceof Refreshable) {
            return ((Refreshable)o).isCurrent();
        }
        return true;
    }

    private static void waitToEvaluate(Object o) {
        if (o instanceof Refreshable) {
            try {
                ((Refreshable)o).refresh();
            }
            catch (RefreshFailedException exc) {
                Thread.currentThread().interrupt();
            }
        }
        VariablesTreeModelFilter.loadAllTypes(o);
    }

    private static boolean hasAllTypes(Object o) {
        boolean hasAllInterfaces;
        if (!(o instanceof ObjectVariable)) {
            return true;
        }
        ObjectVariable ov = (ObjectVariable)o;
        try {
            Method hasAllInterfacesMethod = ov.getClass().getMethod("hasAllTypes", new Class[0]);
            hasAllInterfacesMethod.setAccessible(true);
            hasAllInterfaces = (Boolean)hasAllInterfacesMethod.invoke((Object)ov, new Object[0]);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            hasAllInterfaces = true;
        }
        return hasAllInterfaces;
    }

    private static void loadAllTypes(Object o) {
        if (!(o instanceof ObjectVariable)) {
            return;
        }
        ObjectVariable ov = (ObjectVariable)o;
        try {
            Method loadAllTypesMethod = ov.getClass().getMethod("loadAllTypes", new Class[0]);
            loadAllTypesMethod.setAccessible(true);
            loadAllTypesMethod.invoke((Object)ov, new Object[0]);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static List<JPDAClassType> getAllInterfaces(Object o) {
        List allInterfaces;
        if (!(o instanceof ObjectVariable)) {
            return null;
        }
        ObjectVariable ov = (ObjectVariable)o;
        try {
            Method allInterfacesMethod = ov.getClass().getMethod("getAllInterfaces", new Class[0]);
            allInterfacesMethod.setAccessible(true);
            allInterfaces = (List)allInterfacesMethod.invoke((Object)ov, new Object[0]);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            allInterfaces = null;
        }
        return allInterfaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postEvaluationMonitor(Object o, Runnable whenEvaluated) {
        LinkedList linkedList = this.evaluationQueue;
        synchronized (linkedList) {
            if (this.evaluationQueue.contains(o) && this.evaluationQueue.contains(whenEvaluated)) {
                return;
            }
            if (this.evaluationTask == null) {
                this.evaluationTask = this.evaluationRP.create((Runnable)this);
            }
            this.evaluationQueue.add(o);
            this.evaluationQueue.add(whenEvaluated);
            this.evaluationTask.schedule(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object node;
        do {
            node = null;
            Runnable whenEvaluated = null;
            LinkedList linkedList = this.evaluationQueue;
            synchronized (linkedList) {
                if (!this.evaluationQueue.isEmpty()) {
                    node = this.evaluationQueue.removeFirst();
                    whenEvaluated = (Runnable)this.evaluationQueue.removeFirst();
                }
            }
            if (node == null) continue;
            VariablesTreeModelFilter.waitToEvaluate(node);
            if (whenEvaluated != null) {
                whenEvaluated.run();
                continue;
            }
            this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)this, node));
        } while (node != null);
        LinkedList linkedList = this.evaluationQueue;
        synchronized (linkedList) {
            this.evaluationTask = null;
        }
    }

    public Object[] getChildren(TreeModel original, final Object parent, int from, int to) throws UnknownTypeException {
        VariablesFilter vf = this.getFilter(parent, true, new Runnable(){

            @Override
            public void run() {
                VariablesTreeModelFilter.this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)VariablesTreeModelFilter.this, parent, 8));
            }
        });
        Object[] ch = vf == null ? original.getChildren(parent, from, to) : vf.getChildren(original, (Variable)parent, from, to);
        return ch;
    }

    public int getChildrenCount(TreeModel original, final Object parent) throws UnknownTypeException {
        VariablesFilter vf = this.getFilter(parent, true, new Runnable(){

            @Override
            public void run() {
                VariablesTreeModelFilter.this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)VariablesTreeModelFilter.this, parent, 8));
            }
        });
        int count = vf == null ? original.getChildrenCount(parent) : vf.getChildrenCount(original, (Variable)parent);
        return count;
    }

    public boolean isLeaf(final TreeModel original, final Object node) throws UnknownTypeException {
        final boolean[] unfilteredIsLeaf = new boolean[]{false};
        VariablesFilter vf = this.getFilter(node, true, new Runnable(){

            @Override
            public void run() {
                VariablesFilter vf = VariablesTreeModelFilter.this.getFilter(node, false, null);
                if (vf == null) {
                    return;
                }
                try {
                    boolean filteredIsLeaf = vf.isLeaf(original, (Variable)node);
                    if (filteredIsLeaf != unfilteredIsLeaf[0]) {
                        VariablesTreeModelFilter.this.fireChildrenChange(node);
                    }
                }
                catch (UnknownTypeException unknownTypeException) {
                    // empty catch block
                }
            }
        });
        if (vf == null) {
            boolean isLeaf;
            unfilteredIsLeaf[0] = isLeaf = original.isLeaf(node);
            return isLeaf;
        }
        return vf.isLeaf(original, (Variable)node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener l) {
        Collection collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener l) {
        Collection collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireModelChange(ModelEvent me) {
        Object[] listeners;
        Collection collection = this.modelListeners;
        synchronized (collection) {
            listeners = this.modelListeners.toArray();
        }
        for (int i = 0; i < listeners.length; ++i) {
            ((ModelListener)listeners[i]).modelChanged(me);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireChildrenChange(Object row) {
        Object[] listeners;
        Collection collection = this.modelListeners;
        synchronized (collection) {
            listeners = this.modelListeners.toArray();
        }
        for (int i = 0; i < listeners.length; ++i) {
            ((ModelListener)listeners[i]).modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, row, 8));
        }
    }

    public String getDisplayName(final NodeModel original, final Object node) throws UnknownTypeException {
        final String[] unfilteredDisplayName = new String[]{null};
        VariablesFilter vf = this.getFilter(node, true, new Runnable(){

            @Override
            public void run() {
                String filteredDisplayName;
                VariablesFilter vf = VariablesTreeModelFilter.this.getFilter(node, false, null);
                if (vf == null) {
                    return;
                }
                try {
                    filteredDisplayName = vf.getDisplayName(original, (Variable)node);
                }
                catch (UnknownTypeException utex) {
                    filteredDisplayName = utex.toString();
                }
                if (!filteredDisplayName.equals(unfilteredDisplayName[0])) {
                    VariablesTreeModelFilter.this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)VariablesTreeModelFilter.this, node, 1));
                }
            }
        });
        if (vf == null) {
            String displayName;
            unfilteredDisplayName[0] = displayName = original.getDisplayName(node);
            return displayName;
        }
        return vf.getDisplayName(original, (Variable)node);
    }

    public String getIconBase(final NodeModel original, final Object node) throws UnknownTypeException {
        Logger.getLogger(VariablesTreeModelFilter.class.getName()).log(Level.CONFIG, "Obsolete getIconBase() method was called!", new IllegalStateException("getIconBaseWithExtension() should be called!"));
        final String[] unfilteredIconBase = new String[]{null};
        VariablesFilter vf = this.getFilter(node, true, new Runnable(){

            @Override
            public void run() {
                String filteredIconBase;
                VariablesFilter vf = VariablesTreeModelFilter.this.getFilter(node, false, null);
                if (vf == null) {
                    return;
                }
                try {
                    filteredIconBase = vf.getIconBase(original, (Variable)node);
                }
                catch (UnknownTypeException utex) {
                    filteredIconBase = utex.toString();
                }
                if (!filteredIconBase.equals(unfilteredIconBase[0])) {
                    VariablesTreeModelFilter.this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)VariablesTreeModelFilter.this, node, 2));
                }
            }
        });
        if (vf == null) {
            String iconBase;
            unfilteredIconBase[0] = iconBase = original.getIconBase(node);
            return iconBase;
        }
        return vf.getIconBase(original, (Variable)node);
    }

    public String getShortDescription(final NodeModel original, final Object node) throws UnknownTypeException {
        final String[] unfilteredShortDescription = new String[]{null};
        VariablesFilter vf = this.getFilter(node, true, new Runnable(){

            @Override
            public void run() {
                String filteredShortDescription;
                VariablesFilter vf = VariablesTreeModelFilter.this.getFilter(node, false, null);
                if (vf == null) {
                    return;
                }
                try {
                    filteredShortDescription = vf.getShortDescription(original, (Variable)node);
                }
                catch (UnknownTypeException utex) {
                    filteredShortDescription = utex.toString();
                }
                if (!filteredShortDescription.equals(unfilteredShortDescription[0])) {
                    VariablesTreeModelFilter.this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)VariablesTreeModelFilter.this, node, 4));
                }
            }
        });
        if (vf == null) {
            return original.getShortDescription(node);
        }
        return vf.getShortDescription(original, (Variable)node);
    }

    public Action[] getActions(NodeActionsProvider original, Object node) throws UnknownTypeException {
        VariablesFilter vf = this.getFilter(node, true, null);
        if (vf == null) {
            return original.getActions(node);
        }
        return vf.getActions(original, (Variable)node);
    }

    public void performDefaultAction(NodeActionsProvider original, Object node) throws UnknownTypeException {
        VariablesFilter vf = this.getFilter(node, true, null);
        if (vf == null) {
            original.performDefaultAction(node);
        } else {
            vf.performDefaultAction(original, (Variable)node);
        }
    }

    public Object getValueAt(TableModel original, Object row, String columnID) throws UnknownTypeException {
        VariablesFilter vf = this.getFilter(row, false, null);
        Object value = vf == null ? original.getValueAt(row, columnID) : vf.getValueAt(original, (Variable)row, columnID);
        return value;
    }

    public boolean isReadOnly(TableModel original, Object row, String columnID) throws UnknownTypeException {
        VariablesFilter vf = this.getFilter(row, true, null);
        if (vf == null) {
            return original.isReadOnly(row, columnID);
        }
        return vf.isReadOnly(original, (Variable)row, columnID);
    }

    public void setValueAt(TableModel original, Object row, String columnID, Object value) throws UnknownTypeException {
        VariablesFilter vf = this.getFilter(row, false, null);
        if (vf == null) {
            original.setValueAt(row, columnID, value);
        } else {
            vf.setValueAt(original, (Variable)row, columnID, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VariablesFilter getFilter(Object o, boolean checkEvaluated, Runnable whenEvaluated) {
        VariablesFilter vf;
        HashMap ancestorToFilterL;
        HashMap typeToFilterL;
        Object object = this.filtersLock;
        synchronized (object) {
            if (this.typeToFilter == null) {
                this.typeToFilter = new HashMap();
                this.ancestorToFilter = new HashMap();
                List l = this.lookupProvider.lookup(null, VariablesFilter.class);
                int k = l.size();
                for (int i = 0; i < k; ++i) {
                    int j;
                    VariablesFilter f = (VariablesFilter)l.get(i);
                    String[] types = f.getSupportedAncestors();
                    int jj = types.length;
                    for (j = 0; j < jj; ++j) {
                        this.ancestorToFilter.put(types[j], f);
                    }
                    types = f.getSupportedTypes();
                    jj = types.length;
                    for (j = 0; j < jj; ++j) {
                        this.typeToFilter.put(types[j], f);
                    }
                }
            }
            if (this.typeToFilter.isEmpty() && this.ancestorToFilter.isEmpty()) {
                return null;
            }
            typeToFilterL = this.typeToFilter;
            ancestorToFilterL = this.ancestorToFilter;
        }
        if (!(o instanceof Variable)) {
            return null;
        }
        Variable v = (Variable)o;
        String type = null;
        if (checkEvaluated) {
            boolean evaluated = true;
            if (!VariablesTreeModelFilter.hasAllTypes(v)) {
                evaluated = false;
            }
            if (v instanceof Refreshable) {
                Variable k = v;
                synchronized (k) {
                    evaluated = ((Refreshable)v).isCurrent();
                    if (evaluated) {
                        type = v.getType();
                    }
                }
            }
            if (!evaluated) {
                if (whenEvaluated != null) {
                    this.postEvaluationMonitor(o, whenEvaluated);
                }
                return null;
            }
        }
        if (type == null) {
            type = v.getType();
        }
        if ((vf = (VariablesFilter)typeToFilterL.get(type)) != null) {
            return vf;
        }
        if (!(o instanceof ObjectVariable)) {
            return null;
        }
        ObjectVariable ov = (ObjectVariable)o;
        List<JPDAClassType> allInterfaces = VariablesTreeModelFilter.getAllInterfaces(o);
        if (allInterfaces != null) {
            for (JPDAClassType ct : allInterfaces) {
                type = ct.getName();
                vf = (VariablesFilter)ancestorToFilterL.get(type);
                if (vf == null) continue;
                return vf;
            }
        }
        while ((ov = ov.getSuper()) != null) {
            type = null;
            if (checkEvaluated) {
                boolean evaluated;
                if (ov instanceof Refreshable) {
                    ObjectVariable objectVariable = ov;
                    synchronized (objectVariable) {
                        evaluated = ((Refreshable)ov).isCurrent();
                        type = evaluated ? ov.getType() : null;
                    }
                } else {
                    evaluated = true;
                    type = ov.getType();
                }
                if (!evaluated) {
                    return null;
                }
            } else {
                type = ov.getType();
            }
            if (type == null) break;
            vf = (VariablesFilter)ancestorToFilterL.get(type);
            if (vf == null) continue;
            return vf;
        }
        return null;
    }

    public boolean canRename(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        VariablesFilter vf = this.getFilter(node, true, null);
        if (!(vf instanceof ExtendedNodeModelFilter)) {
            return original.canRename(node);
        }
        return ((ExtendedNodeModelFilter)vf).canRename(original, node);
    }

    public boolean canCopy(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        VariablesFilter vf = this.getFilter(node, true, null);
        if (!(vf instanceof ExtendedNodeModelFilter)) {
            return original.canCopy(node);
        }
        return ((ExtendedNodeModelFilter)vf).canCopy(original, node);
    }

    public boolean canCut(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        VariablesFilter vf = this.getFilter(node, true, null);
        if (!(vf instanceof ExtendedNodeModelFilter)) {
            return original.canCut(node);
        }
        return ((ExtendedNodeModelFilter)vf).canCut(original, node);
    }

    public Transferable clipboardCopy(ExtendedNodeModel original, Object node) throws IOException, UnknownTypeException {
        VariablesFilter vf = this.getFilter(node, true, null);
        if (!(vf instanceof ExtendedNodeModelFilter)) {
            return original.clipboardCopy(node);
        }
        return ((ExtendedNodeModelFilter)vf).clipboardCopy(original, node);
    }

    public Transferable clipboardCut(ExtendedNodeModel original, Object node) throws IOException, UnknownTypeException {
        VariablesFilter vf = this.getFilter(node, true, null);
        if (!(vf instanceof ExtendedNodeModelFilter)) {
            return original.clipboardCut(node);
        }
        return ((ExtendedNodeModelFilter)vf).clipboardCut(original, node);
    }

    public PasteType[] getPasteTypes(ExtendedNodeModel original, Object node, Transferable t) throws UnknownTypeException {
        VariablesFilter vf = this.getFilter(node, true, null);
        if (!(vf instanceof ExtendedNodeModelFilter)) {
            return original.getPasteTypes(node, t);
        }
        return ((ExtendedNodeModelFilter)vf).getPasteTypes(original, node, t);
    }

    public void setName(ExtendedNodeModel original, Object node, String name) throws UnknownTypeException {
        VariablesFilter vf = this.getFilter(node, true, null);
        if (!(vf instanceof ExtendedNodeModelFilter)) {
            original.setName(node, name);
        } else {
            ((ExtendedNodeModelFilter)vf).setName(original, node, name);
        }
    }

    public String getIconBaseWithExtension(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        VariablesFilter vf = this.getFilter(node, true, null);
        if (!(vf instanceof ExtendedNodeModelFilter)) {
            return original.getIconBaseWithExtension(node);
        }
        return ((ExtendedNodeModelFilter)vf).getIconBaseWithExtension(original, node);
    }

    private class EvaluatorListener
    implements CodeEvaluator.Result.Listener<Variable> {
        private EvaluatorListener() {
        }

        public void resultChanged(Variable o) {
            try {
                VariablesTreeModelFilter.this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)"Root"));
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                Exceptions.printStackTrace((Throwable)t);
            }
        }
    }

    private class VariablesPreferenceChangeListener
    implements PreferenceChangeListener,
    PropertyChangeListener {
        private VariablesPreferenceChangeListener() {
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            String key = evt.getKey();
            if ("show_value_property_editors".equals(key)) {
                this.refresh();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("VariableFormatters".equals(evt.getPropertyName())) {
                Object object = VariablesTreeModelFilter.this.filtersLock;
                synchronized (object) {
                    VariablesTreeModelFilter.this.typeToFilter = null;
                    VariablesTreeModelFilter.this.ancestorToFilter = null;
                }
                this.refresh();
            }
        }

        private void refresh() {
            try {
                VariablesTreeModelFilter.this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)"Root"));
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                Exceptions.printStackTrace((Throwable)t);
            }
        }
    }
}

