/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import org.clank.java.std;
import org.llvm.adt.DenseMapInfo;

public class DenseMapInfoPair<T, U>
implements DenseMapInfo<std.pair<T, U>> {
    private final DenseMapInfo<T> FirstInfo;
    private final DenseMapInfo<U> SecondInfo;
    private final std.pair<T, U> emptyKey;
    private final std.pair<T, U> tombstoneKey;

    public DenseMapInfoPair(DenseMapInfo<T> FirstInfo, DenseMapInfo<U> SecondInfo) {
        this.FirstInfo = FirstInfo;
        this.SecondInfo = SecondInfo;
        this.emptyKey = std.make_pair(FirstInfo.getEmptyKey(), SecondInfo.getEmptyKey());
        this.tombstoneKey = std.make_pair(FirstInfo.getTombstoneKey(), SecondInfo.getTombstoneKey());
    }

    @Override
    public std.pair<T, U> getEmptyKey() {
        return this.emptyKey;
    }

    @Override
    public std.pair<T, U> getTombstoneKey() {
        return this.tombstoneKey;
    }

    @Override
    public long getHashValue(Object PairVal) {
        assert (PairVal != this.emptyKey) : "must not be called for emptyKey";
        assert (PairVal != this.tombstoneKey) : "must not be called for tombstoneKey";
        long key = this.FirstInfo.getHashValue(((std.pair)PairVal).first) << 32 | this.SecondInfo.getHashValue(((std.pair)PairVal).second);
        key += key << 32 ^ 0xFFFFFFFFFFFFFFFFL;
        key ^= key >> 22;
        key += key << 13 ^ 0xFFFFFFFFFFFFFFFFL;
        key ^= key >> 8;
        key += key << 3;
        key ^= key >> 15;
        key += key << 27 ^ 0xFFFFFFFFFFFFFFFFL;
        key ^= key >> 31;
        return key;
    }

    @Override
    public boolean isEqual(Object LHS, Object RHS) {
        assert (LHS != this.emptyKey) : "LHS: must not be called for emptyKey";
        assert (LHS != this.tombstoneKey) : "LHS: must not be called for tombstoneKey";
        return this.FirstInfo.isEqual(((std.pair)LHS).first, ((std.pair)RHS).first) && this.SecondInfo.isEqual(((std.pair)LHS).second, ((std.pair)RHS).second);
    }

    @Override
    public boolean isKeyPointerLike() {
        return false;
    }
}

