/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import org.clank.java.std;
import org.clank.support.NativeMemory;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.char;
import org.llvm.adt.StringMapEntryBase;

public abstract class StringMapEntryBaseCharArray
extends StringMapEntryBase {
    private static final int IDENTIFIER_HAS_LEN_BITS = Integer.MIN_VALUE;
    private static final int IDENTIFIER_HAS_LEN_MASK = Integer.MAX_VALUE;
    private static final int IDENTIFIER_LEN_SHIFT_BITS;
    private static final int MAX_IDENTIFIER_SLAB_SIZE;
    private static final int IDENTIFIER_LEN_MAX;
    private static final int IDENTIFIER_INDEX_MASK;
    private final byte[] StrArray;
    private final int ArrayStartIndex;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static int MaxSlabSize() {
        return MAX_IDENTIFIER_SLAB_SIZE;
    }

    static int get_index(int value) {
        int unmasked = value & Integer.MAX_VALUE;
        if (value == unmasked) {
            return 0;
        }
        return unmasked & IDENTIFIER_INDEX_MASK;
    }

    static boolean no_length(int value) {
        return (value & Integer.MIN_VALUE) == 0;
    }

    static int get_length(int value) {
        int unmasked = value & Integer.MAX_VALUE;
        if (value == unmasked) {
            return 0;
        }
        return unmasked >> IDENTIFIER_LEN_SHIFT_BITS;
    }

    static int wrap_length_index_pair(int Len, int Index) {
        if (!$assertionsDisabled && Index >= MAX_IDENTIFIER_SLAB_SIZE) {
            throw new AssertionError((Object)("allocator used incorrect MaxSlabSize?" + MAX_IDENTIFIER_SLAB_SIZE + " vs. " + Index));
        }
        if (Len <= IDENTIFIER_LEN_MAX) {
            int out = Integer.MIN_VALUE | Len << IDENTIFIER_LEN_SHIFT_BITS | Index;
            if (!$assertionsDisabled && StringMapEntryBaseCharArray.get_length(out) != Len) {
                throw new AssertionError((Object)("incorrectly cached Len:" + Len + " vs. " + StringMapEntryBaseCharArray.get_length(out)));
            }
            if (!$assertionsDisabled && StringMapEntryBaseCharArray.get_index(out) != Index) {
                throw new AssertionError((Object)("incorrectly cached Index:" + Index + " vs. " + StringMapEntryBaseCharArray.get_index(out)));
            }
            return out;
        }
        if (!$assertionsDisabled && StringMapEntryBaseCharArray.get_length(Index) != 0) {
            throw new AssertionError((Object)("must be not cached " + StringMapEntryBaseCharArray.get_length(Index) + " vs. " + Index));
        }
        if (!$assertionsDisabled && StringMapEntryBaseCharArray.get_index(Index) != Index) {
            throw new AssertionError((Object)("must be not cached " + StringMapEntryBaseCharArray.get_index(Index) + " vs. " + Index));
        }
        return Index;
    }

    public StringMapEntryBaseCharArray(long Len) {
        this(StringMapEntryBaseCharArray.createDummyCharPtr(Len), Len);
    }

    public StringMapEntryBaseCharArray(char.ptr Str, long Len) {
        super(Str, Len);
        if (!$assertionsDisabled && !(Str instanceof char.ptr.array)) {
            throw new AssertionError((Object)("unexpected class " + Str));
        }
        this.StrArray = Str.$array();
        this.ArrayStartIndex = StringMapEntryBaseCharArray.wrap_length_index_pair((int)Len, Str.$index());
        if (!$assertionsDisabled && (long)this.getKeyLength() != Len) {
            throw new AssertionError((Object)(Len + " vs. " + this.getKeyLength()));
        }
    }

    public StringMapEntryBaseCharArray(byte[] Str, int fromIdx, int Len) {
        super(Str, fromIdx, Len);
        this.StrArray = Str;
        this.ArrayStartIndex = StringMapEntryBaseCharArray.wrap_length_index_pair(Len, fromIdx);
        if (!$assertionsDisabled && this.getKeyLength() != Len) {
            throw new AssertionError((Object)(Len + " vs. " + this.getKeyLength()));
        }
    }

    public StringMapEntryBaseCharArray(byte[] Str, int fromIdx, int Len, int FullHashValue) {
        super(Str, fromIdx, Len, FullHashValue);
        this.StrArray = Str;
        this.ArrayStartIndex = StringMapEntryBaseCharArray.wrap_length_index_pair(Len, fromIdx);
        if (!$assertionsDisabled && this.getKeyLength() != Len) {
            throw new AssertionError((Object)(Len + " vs. " + this.getKeyLength()));
        }
    }

    public StringMapEntryBaseCharArray(StringMapEntryBaseCharArray other) {
        super(other);
        this.StrArray = other.StrArray;
        this.ArrayStartIndex = other.ArrayStartIndex;
    }

    @Override
    public final int getKeyLength() {
        if (StringMapEntryBaseCharArray.no_length(this.ArrayStartIndex)) {
            return std.strlen((byte[])this.StrArray, (int)this.ArrayStartIndex);
        }
        return StringMapEntryBaseCharArray.get_length(this.ArrayStartIndex);
    }

    @Override
    public final char.ptr getKeyStr() {
        return NativePointer.create_const_char$ptr((byte[])this.StrArray, (long)this.getKeyArrayIndex());
    }

    @Override
    public byte[] getKeyArray() {
        return this.StrArray;
    }

    @Override
    public int getKeyArrayIndex() {
        return StringMapEntryBaseCharArray.get_index(this.ArrayStartIndex);
    }

    protected static int $sizeof_StringMapEntryBaseCharArray_Fields() {
        return 12 + StringMapEntryBaseCharArray.$sizeof_StringMapEntryBase_Fields();
    }

    static {
        boolean bl = $assertionsDisabled = !StringMapEntryBaseCharArray.class.desiredAssertionStatus();
        if (!$assertionsDisabled && (NativeMemory.Allocator.MaxPageSize & NativeMemory.Allocator.MaxPageSize - 1) != 0) {
            throw new AssertionError((Object)("Must be power of two " + NativeTrace.formatNumber((long)NativeMemory.Allocator.MaxPageSize)));
        }
        int numberOfLeadingZeros = Integer.numberOfLeadingZeros(NativeMemory.Allocator.MaxPageSize - 1);
        if (numberOfLeadingZeros < 8) {
            numberOfLeadingZeros = 8;
        }
        IDENTIFIER_LEN_SHIFT_BITS = 32 - numberOfLeadingZeros;
        MAX_IDENTIFIER_SLAB_SIZE = 1 << IDENTIFIER_LEN_SHIFT_BITS;
        IDENTIFIER_LEN_MAX = (1 << numberOfLeadingZeros - 1) - 1;
        IDENTIFIER_INDEX_MASK = MAX_IDENTIFIER_SLAB_SIZE - 1;
        if (!$assertionsDisabled && Integer.numberOfLeadingZeros(IDENTIFIER_INDEX_MASK) != numberOfLeadingZeros) {
            throw new AssertionError((Object)(numberOfLeadingZeros + " vs. " + Integer.numberOfLeadingZeros(IDENTIFIER_INDEX_MASK)));
        }
        if (NativeTrace.STATISTICS) {
            System.err.printf("IdentifierInfo constants: 1-High-Bit+%d empty bits (%d max len); %d shift; %s B MaxSlab (%s B MaxPage); index %s mask (%d leading zeros) %n", numberOfLeadingZeros - 1, IDENTIFIER_LEN_MAX, IDENTIFIER_LEN_SHIFT_BITS, NativeTrace.formatNumber((long)MAX_IDENTIFIER_SLAB_SIZE), NativeTrace.formatNumber((long)NativeMemory.Allocator.MaxPageSize), Integer.toBinaryString(IDENTIFIER_INDEX_MASK), Integer.numberOfLeadingZeros(IDENTIFIER_INDEX_MASK));
        }
    }
}

