/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.clank.support.aliases.uint;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitch;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.support.impl.StringRefStatics;
import org.llvm.support.impl.TripleStatics;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;

public class Triple
implements Destructors.ClassWithDestructor {
    private std.string Data;
    private ArchType Arch;
    private SubArchType SubArch;
    private VendorType Vendor;
    private OSType OS;
    private EnvironmentType Environment;
    private ObjectFormatType ObjectFormat;

    public Triple() {
        this.Data = new std.string();
        this.Arch = ArchType.UnknownArch;
        this.Vendor = VendorType.UnknownVendor;
        this.OS = OSType.UnknownOS;
        this.Environment = EnvironmentType.UnknownEnvironment;
        this.ObjectFormat = ObjectFormatType.UnknownObjectFormat;
    }

    public Triple(Twine Str) {
        this.Data = new std.string(Str.str());
        this.Arch = TripleStatics.parseArch(this.getArchName());
        this.SubArch = TripleStatics.parseSubArch(this.getArchName());
        this.Vendor = TripleStatics.parseVendor(this.getVendorName());
        this.OS = TripleStatics.parseOS(this.getOSName());
        this.Environment = TripleStatics.parseEnvironment(this.getEnvironmentName());
        this.ObjectFormat = TripleStatics.parseFormat(this.getEnvironmentName());
        if (this.ObjectFormat == ObjectFormatType.UnknownObjectFormat) {
            this.ObjectFormat = TripleStatics.getDefaultFormat(this);
        }
    }

    public Triple(Twine ArchStr, Twine VendorStr, Twine OSStr) {
        this.Data = new std.string(llvm.$plus_Twine(llvm.$plus_Twine(llvm.$plus_Twine(llvm.$plus_Twine(ArchStr, new Twine(JavaDifferentiators.Char.INSTANCE, NativePointer.$((char)'-'))), VendorStr), new Twine(JavaDifferentiators.Char.INSTANCE, NativePointer.$((char)'-'))), OSStr).str());
        this.Arch = TripleStatics.parseArch(new StringRef(ArchStr.str()));
        this.SubArch = TripleStatics.parseSubArch(new StringRef(ArchStr.str()));
        this.Vendor = TripleStatics.parseVendor(new StringRef(VendorStr.str()));
        this.OS = TripleStatics.parseOS(new StringRef(OSStr.str()));
        this.Environment = EnvironmentType.UnknownEnvironment;
        this.ObjectFormat = ObjectFormatType.UnknownObjectFormat;
        this.ObjectFormat = TripleStatics.getDefaultFormat(this);
    }

    public Triple(Twine ArchStr, Twine VendorStr, Twine OSStr, Twine EnvironmentStr) {
        this.Data = new std.string(llvm.$plus_Twine(llvm.$plus_Twine(llvm.$plus_Twine(llvm.$plus_Twine(llvm.$plus_Twine(llvm.$plus_Twine(ArchStr, new Twine(JavaDifferentiators.Char.INSTANCE, NativePointer.$((char)'-'))), VendorStr), new Twine(JavaDifferentiators.Char.INSTANCE, NativePointer.$((char)'-'))), OSStr), new Twine(JavaDifferentiators.Char.INSTANCE, NativePointer.$((char)'-'))), EnvironmentStr).str());
        this.Arch = TripleStatics.parseArch(new StringRef(ArchStr.str()));
        this.SubArch = TripleStatics.parseSubArch(new StringRef(ArchStr.str()));
        this.Vendor = TripleStatics.parseVendor(new StringRef(VendorStr.str()));
        this.OS = TripleStatics.parseOS(new StringRef(OSStr.str()));
        this.Environment = TripleStatics.parseEnvironment(new StringRef(EnvironmentStr.str()));
        this.ObjectFormat = TripleStatics.parseFormat(new StringRef(EnvironmentStr.str()));
        if (this.ObjectFormat == ObjectFormatType.UnknownObjectFormat) {
            this.ObjectFormat = TripleStatics.getDefaultFormat(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std.string normalize(StringRef Str) {
        SmallVector<StringRef> Components = null;
        std.string Normalized = null;
        try {
            boolean IsMinGW32 = false;
            boolean IsCygwin = false;
            Components = new SmallVector<StringRef>(4, new StringRef());
            Str.split(Components, StringRef.MINUS);
            ArchType Arch = ArchType.UnknownArch;
            if (Components.size() > 0) {
                Arch = TripleStatics.parseArch((StringRef)Components.$at(0));
            }
            VendorType Vendor = VendorType.UnknownVendor;
            if (Components.size() > 1) {
                Vendor = TripleStatics.parseVendor((StringRef)Components.$at(1));
            }
            OSType OS = OSType.UnknownOS;
            if (Components.size() > 2) {
                OS = TripleStatics.parseOS((StringRef)Components.$at(2));
                IsCygwin = ((StringRef)Components.$at(2)).startswith("cygwin");
                IsMinGW32 = ((StringRef)Components.$at(2)).startswith("mingw");
            }
            EnvironmentType Environment2 = EnvironmentType.UnknownEnvironment;
            if (Components.size() > 3) {
                Environment2 = TripleStatics.parseEnvironment((StringRef)Components.$at(3));
            }
            ObjectFormatType ObjectFormat = ObjectFormatType.UnknownObjectFormat;
            if (Components.size() > 4) {
                ObjectFormat = TripleStatics.parseFormat((StringRef)Components.$at(4));
            }
            boolean[] Found = NativePointer.new$bool((int)4);
            Found[0] = Arch != ArchType.UnknownArch;
            Found[1] = Vendor != VendorType.UnknownVendor;
            Found[2] = OS != OSType.UnknownOS;
            Found[3] = Environment2 != EnvironmentType.UnknownEnvironment;
            block9: for (long Pos = 0L; Pos != (long)llvm.array_lengthof(Found); ++Pos) {
                if (Found[(int)Pos]) continue;
                for (long Idx = 0L; Idx != (long)Components.size(); ++Idx) {
                    long i;
                    StringRef CurrentComponent;
                    if (Idx < (long)llvm.array_lengthof(Found) && Found[(int)Idx]) continue;
                    boolean Valid = false;
                    StringRef Comp = new StringRef((StringRef)Components.$at(Idx));
                    switch ((int)Pos) {
                        default: {
                            throw new llvm_unreachable((CharSequence)"unexpected component type!");
                        }
                        case 0: {
                            Arch = TripleStatics.parseArch(Comp);
                            Valid = Arch != ArchType.UnknownArch;
                            break;
                        }
                        case 1: {
                            Vendor = TripleStatics.parseVendor(Comp);
                            Valid = Vendor != VendorType.UnknownVendor;
                            break;
                        }
                        case 2: {
                            OS = TripleStatics.parseOS(Comp);
                            IsCygwin = Comp.startswith("cygwin");
                            IsMinGW32 = Comp.startswith("mingw");
                            Valid = OS != OSType.UnknownOS || IsCygwin || IsMinGW32;
                            break;
                        }
                        case 3: {
                            Environment2 = TripleStatics.parseEnvironment(Comp);
                            boolean bl = Valid = Environment2 != EnvironmentType.UnknownEnvironment;
                            if (Valid) break;
                            ObjectFormat = TripleStatics.parseFormat(Comp);
                            boolean bl2 = Valid = ObjectFormat != ObjectFormatType.UnknownObjectFormat;
                        }
                    }
                    if (!Valid) continue;
                    if (Pos < Idx) {
                        CurrentComponent = new StringRef(StringRef.EMPTY);
                        StringRefStatics.swap(CurrentComponent, (StringRef)Components.$at(Idx));
                        i = Pos;
                        while (!CurrentComponent.empty()) {
                            while (i < (long)llvm.array_lengthof(Found) && Found[(int)i]) {
                                ++i;
                            }
                            StringRefStatics.swap(CurrentComponent, (StringRef)Components.$at(i));
                            ++i;
                        }
                    } else if (Pos > Idx) {
                        do {
                            CurrentComponent = new StringRef(StringRef.EMPTY);
                            i = Idx;
                            while (i < (long)Components.size()) {
                                StringRefStatics.swap(CurrentComponent, (StringRef)Components.$at(i));
                                if (CurrentComponent.empty()) break;
                                while (++i < (long)llvm.array_lengthof(Found) && Found[(int)i]) {
                                }
                            }
                            if (!CurrentComponent.empty()) {
                                Components.push_back(CurrentComponent);
                            }
                            while (++Idx < (long)llvm.array_lengthof(Found) && Found[(int)Idx]) {
                            }
                        } while (Idx < Pos);
                    }
                    assert (Pos < (long)Components.size() && llvm.$eq_StringRef((StringRef)Components.$at(Pos), Comp)) : "Component moved wrong!";
                    Found[(int)Pos] = true;
                    continue block9;
                }
            }
            if (OS == OSType.Win32) {
                Components.resize(4);
                ((StringRef)Components.$at(2)).$assign(NativePointer.$((String)"windows"));
                if (Environment2 == EnvironmentType.UnknownEnvironment) {
                    if (ObjectFormat == ObjectFormatType.UnknownObjectFormat || ObjectFormat == ObjectFormatType.COFF) {
                        ((StringRef)Components.$at(3)).$assign(NativePointer.$((String)"msvc"));
                    } else {
                        ((StringRef)Components.$at(3)).$assign(TripleStatics.getObjectFormatTypeName(ObjectFormat));
                    }
                }
            } else if (IsMinGW32) {
                Components.resize(4);
                ((StringRef)Components.$at(2)).$assign(NativePointer.$((String)"windows"));
                ((StringRef)Components.$at(3)).$assign(NativePointer.$((String)"gnu"));
            } else if (IsCygwin) {
                Components.resize(4);
                ((StringRef)Components.$at(2)).$assign(NativePointer.$((String)"windows"));
                ((StringRef)Components.$at(3)).$assign(NativePointer.$((String)"cygnus"));
            }
            if ((IsMinGW32 || IsCygwin || OS == OSType.Win32 && Environment2 != EnvironmentType.UnknownEnvironment) && ObjectFormat != ObjectFormatType.UnknownObjectFormat && ObjectFormat != ObjectFormatType.COFF) {
                Components.resize(5);
                ((StringRef)Components.$at(4)).$assign(TripleStatics.getObjectFormatTypeName(ObjectFormat));
            }
            Normalized = new std.string();
            long e = Components.size();
            for (long i = 0L; i != e; ++i) {
                if (i != 0L) {
                    Normalized.$addassign(NativePointer.$((char)'-'));
                }
                llvm.$addassign_str_StringRef(Normalized, (StringRef)Components.$at(i));
            }
            std.string string2 = new std.string(Normalized);
            return string2;
        }
        finally {
            if (Normalized != null) {
                Normalized.$destroy();
            }
            if (Components != null) {
                Components.$destroy();
            }
        }
    }

    public ArchType getArch() {
        return this.Arch;
    }

    public SubArchType getSubArch() {
        return this.SubArch;
    }

    public VendorType getVendor() {
        return this.Vendor;
    }

    public OSType getOS() {
        return this.OS;
    }

    public boolean hasEnvironment() {
        return llvm.$noteq_StringRef(this.getEnvironmentName(), StringRef.EMPTY);
    }

    public EnvironmentType getEnvironment() {
        return this.Environment;
    }

    public ObjectFormatType getObjectFormat() {
        return this.ObjectFormat;
    }

    public void getOSVersion(uint.ref Major, uint.ref Minor, uint.ref Micro) {
        StringRef OSTypeName;
        StringRef OSName = this.getOSName();
        if (OSName.startswith(OSTypeName = new StringRef(Triple.getOSTypeName(this.getOS())))) {
            OSName.$assign$substr(OSTypeName.size());
        }
        Major.$set(Minor.$set(Micro.$set(0L)));
        uint.ref[] Components = new uint.ref[]{Major, Minor, Micro};
        for (long i = 0L; i != 3L && !OSName.empty() && OSName.$at(0) >= NativePointer.$((char)'0') && OSName.$at(0) <= NativePointer.$((char)'9'); ++i) {
            Components[(int)i].$set(TripleStatics.EatNumber(OSName));
            if (!OSName.startswith(StringRef.DOT)) continue;
            OSName.$assign$substr(1);
        }
    }

    public long getOSMajorVersion() {
        uint.ref Maj = NativePointer.create_uint$ref();
        uint.ref Min = NativePointer.create_uint$ref();
        uint.ref Micro = NativePointer.create_uint$ref();
        this.getOSVersion(Maj, Min, Micro);
        return Maj.$deref();
    }

    public boolean getMacOSXVersion(uint.ref Major, uint.ref Minor, uint.ref Micro) {
        this.getOSVersion(Major, Minor, Micro);
        switch (this.getOS()) {
            default: {
                throw new llvm_unreachable((CharSequence)"unexpected OS for Darwin triple");
            }
            case Darwin: {
                if (Major.$deref() == 0L) {
                    Major.$set(8L);
                }
                if (Major.$deref() < 4L) {
                    return false;
                }
                Micro.$set(0L);
                Minor.$set(Major.$deref() - 4L);
                Major.$set(10L);
                break;
            }
            case MacOSX: {
                if (Major.$deref() == 0L) {
                    Major.$set(10L);
                    Minor.$set(4L);
                }
                if (Major.$deref() == 10L) break;
                return false;
            }
            case IOS: {
                Major.$set(10L);
                Minor.$set(4L);
                Micro.$set(0L);
            }
        }
        return true;
    }

    public void getiOSVersion(uint.ref Major, uint.ref Minor, uint.ref Micro) {
        switch (this.getOS()) {
            default: {
                throw new llvm_unreachable((CharSequence)"unexpected OS for Darwin triple");
            }
            case Darwin: 
            case MacOSX: {
                Major.$set(5L);
                Minor.$set(0L);
                Micro.$set(0L);
                break;
            }
            case IOS: {
                this.getOSVersion(Major, Minor, Micro);
                if (Major.$deref() != 0L) break;
                Major.$set(this.getArch() == ArchType.aarch64 ? 7L : 5L);
            }
        }
    }

    public std.string str() {
        return this.Data;
    }

    public std.string getTriple() {
        return this.Data;
    }

    public StringRef getArchName() {
        return (StringRef)new StringRef((std.string)this.Data).split((byte)NativePointer.$((char)'-')).first;
    }

    public StringRef getVendorName() {
        StringRef Tmp = (StringRef)new StringRef((std.string)this.Data).split((byte)NativePointer.$((char)'-')).second;
        return (StringRef)Tmp.split((byte)NativePointer.$((char)'-')).first;
    }

    public StringRef getOSName() {
        StringRef Tmp = (StringRef)new StringRef((std.string)this.Data).split((byte)NativePointer.$((char)'-')).second;
        Tmp.$assign((StringRef)Tmp.split((byte)NativePointer.$((char)'-')).second);
        return (StringRef)Tmp.split((byte)NativePointer.$((char)'-')).first;
    }

    public StringRef getEnvironmentName() {
        StringRef Tmp = (StringRef)new StringRef((std.string)this.Data).split((byte)NativePointer.$((char)'-')).second;
        Tmp.$assign((StringRef)Tmp.split((byte)NativePointer.$((char)'-')).second);
        return (StringRef)Tmp.split((byte)NativePointer.$((char)'-')).second;
    }

    public StringRef getOSAndEnvironmentName() {
        StringRef Tmp = (StringRef)new StringRef((std.string)this.Data).split((byte)NativePointer.$((char)'-')).second;
        return (StringRef)Tmp.split((byte)NativePointer.$((char)'-')).second;
    }

    public boolean isArch64Bit() {
        return TripleStatics.getArchPointerBitWidth(this.getArch()) == 64L;
    }

    public boolean isArch32Bit() {
        return TripleStatics.getArchPointerBitWidth(this.getArch()) == 32L;
    }

    public boolean isArch16Bit() {
        return TripleStatics.getArchPointerBitWidth(this.getArch()) == 16L;
    }

    public boolean isOSVersionLT(long Major) {
        return this.isOSVersionLT(Major, 0L, 0L);
    }

    public boolean isOSVersionLT(long Major, long Minor) {
        return this.isOSVersionLT(Major, Minor, 0L);
    }

    public boolean isOSVersionLT(long Major, long Minor, long Micro) {
        long[] LHS = NativePointer.new$long((int)3, (int[])new int[0]);
        this.getOSVersion(NativePointer.create_uint$ref((long[])LHS, (long)0L), NativePointer.create_uint$ref((long[])LHS, (long)1L), NativePointer.create_uint$ref((long[])LHS, (long)2L));
        if (LHS[0] != Major) {
            return LHS[0] < Major;
        }
        if (LHS[1] != Minor) {
            return LHS[1] < Minor;
        }
        if (LHS[2] != Micro) {
            return LHS[1] < Micro;
        }
        return false;
    }

    public long isMacOSXVersionLT(long Major) {
        return this.isMacOSXVersionLT(Major, 0L, 0L);
    }

    public long isMacOSXVersionLT(long Major, long Minor) {
        return this.isMacOSXVersionLT(Major, Minor, 0L);
    }

    public long isMacOSXVersionLT(long Major, long Minor, long Micro) {
        assert (this.isMacOSX()) : "Not an OS X triple!";
        if (this.getOS() == OSType.MacOSX) {
            return this.isOSVersionLT(Major, Minor, Micro) ? 1 : 0;
        }
        assert (Major == 10L) : "Unexpected major version";
        return this.isOSVersionLT(Minor + 4L, Micro, 0L) ? 1 : 0;
    }

    public boolean isMacOSX() {
        return this.getOS() == OSType.Darwin || this.getOS() == OSType.MacOSX;
    }

    public boolean isiOS() {
        return this.getOS() == OSType.IOS;
    }

    public boolean isOSDarwin() {
        return this.isMacOSX() || this.isiOS();
    }

    public boolean isOSNetBSD() {
        return this.getOS() == OSType.NetBSD;
    }

    public boolean isOSOpenBSD() {
        return this.getOS() == OSType.OpenBSD;
    }

    public boolean isOSFreeBSD() {
        return this.getOS() == OSType.FreeBSD;
    }

    public boolean isOSDragonFly() {
        return this.getOS() == OSType.DragonFly;
    }

    public boolean isOSSolaris() {
        return this.getOS() == OSType.Solaris;
    }

    public boolean isOSBitrig() {
        return this.getOS() == OSType.Bitrig;
    }

    public boolean isWindowsMSVCEnvironment() {
        return this.getOS() == OSType.Win32 && (this.getEnvironment() == EnvironmentType.UnknownEnvironment || this.getEnvironment() == EnvironmentType.MSVC);
    }

    public boolean isKnownWindowsMSVCEnvironment() {
        return this.getOS() == OSType.Win32 && this.getEnvironment() == EnvironmentType.MSVC;
    }

    public boolean isWindowsItaniumEnvironment() {
        return this.getOS() == OSType.Win32 && this.getEnvironment() == EnvironmentType.Itanium;
    }

    public boolean isWindowsCygwinEnvironment() {
        return this.getOS() == OSType.Win32 && this.getEnvironment() == EnvironmentType.Cygnus;
    }

    public boolean isWindowsGNUEnvironment() {
        return this.getOS() == OSType.Win32 && this.getEnvironment() == EnvironmentType.GNU;
    }

    public boolean isOSCygMing() {
        return this.isWindowsCygwinEnvironment() || this.isWindowsGNUEnvironment();
    }

    public boolean isOSMSVCRT() {
        return this.isWindowsMSVCEnvironment() || this.isWindowsGNUEnvironment() || this.isWindowsItaniumEnvironment();
    }

    public boolean isOSWindows() {
        return this.getOS() == OSType.Win32 || this.isOSCygMing();
    }

    public boolean isOSNaCl() {
        return this.getOS() == OSType.NaCl;
    }

    public boolean isOSLinux() {
        return this.getOS() == OSType.Linux;
    }

    public boolean isOSBinFormatELF() {
        return this.getObjectFormat() == ObjectFormatType.ELF;
    }

    public boolean isOSBinFormatCOFF() {
        return this.getObjectFormat() == ObjectFormatType.COFF;
    }

    public boolean isOSBinFormatMachO() {
        return this.getObjectFormat() == ObjectFormatType.MachO;
    }

    public void setArch(ArchType Kind2) {
        this.setArchName(new StringRef(Triple.getArchTypeName(Kind2)));
    }

    public void setVendor(VendorType Kind2) {
        this.setVendorName(new StringRef(Triple.getVendorTypeName(Kind2)));
    }

    public void setOS(OSType Kind2) {
        this.setOSName(new StringRef(Triple.getOSTypeName(Kind2)));
    }

    public void setEnvironment(EnvironmentType Kind2) {
        this.setEnvironmentName(new StringRef(Triple.getEnvironmentTypeName(Kind2)));
    }

    public void setObjectFormat(ObjectFormatType Kind2) {
        if (this.Environment == EnvironmentType.UnknownEnvironment) {
            this.setEnvironmentName(new StringRef(TripleStatics.getObjectFormatTypeName(Kind2)));
            return;
        }
        this.setEnvironmentName(new StringRef(llvm.$plus_Twine(llvm.$plus_Twine(new Twine(Triple.getEnvironmentTypeName(this.Environment)), new Twine(NativePointer.$((String)"-"))), new Twine(TripleStatics.getObjectFormatTypeName(Kind2))).str()));
    }

    public void setTriple(Twine Str) {
        this.$assign(new Triple(Str));
    }

    public void setArchName(StringRef Str) {
        SmallString Triple2 = null;
        try {
            Triple2 = new SmallString(64);
            Triple2.$addassign(Str);
            Triple2.$addassign(StringRef.MINUS);
            Triple2.$addassign(this.getVendorName());
            Triple2.$addassign(StringRef.MINUS);
            Triple2.$addassign(this.getOSAndEnvironmentName());
            this.setTriple(new Twine(Triple2.str()));
        }
        finally {
            if (Triple2 != null) {
                Triple2.$destroy();
            }
        }
    }

    public void setVendorName(StringRef Str) {
        this.setTriple(llvm.$plus_Twine(llvm.$plus_Twine(llvm.$plus_Twine(llvm.$plus_StringRef_T(this.getArchName(), NativePointer.$((String)"-")), new Twine(Str)), new Twine(NativePointer.$((String)"-"))), new Twine(this.getOSAndEnvironmentName())));
    }

    public void setOSName(StringRef Str) {
        if (this.hasEnvironment()) {
            this.setTriple(llvm.$plus_Twine(llvm.$plus_Twine(llvm.$plus_Twine(llvm.$plus_Twine(llvm.$plus_Twine(llvm.$plus_StringRef_T(this.getArchName(), NativePointer.$((String)"-")), new Twine(this.getVendorName())), new Twine(NativePointer.$((String)"-"))), new Twine(Str)), new Twine(NativePointer.$((String)"-"))), new Twine(this.getEnvironmentName())));
        } else {
            this.setTriple(llvm.$plus_Twine(llvm.$plus_Twine(llvm.$plus_Twine(llvm.$plus_StringRef_T(this.getArchName(), NativePointer.$((String)"-")), new Twine(this.getVendorName())), new Twine(NativePointer.$((String)"-"))), new Twine(Str)));
        }
    }

    public void setEnvironmentName(StringRef Str) {
        this.setTriple(llvm.$plus_Twine(llvm.$plus_Twine(llvm.$plus_Twine(llvm.$plus_Twine(llvm.$plus_Twine(llvm.$plus_StringRef_T(this.getArchName(), NativePointer.$((String)"-")), new Twine(this.getVendorName())), new Twine(NativePointer.$((String)"-"))), new Twine(this.getOSName())), new Twine(NativePointer.$((String)"-"))), new Twine(Str)));
    }

    public void setOSAndEnvironmentName(StringRef Str) {
        this.setTriple(llvm.$plus_Twine(llvm.$plus_Twine(llvm.$plus_Twine(llvm.$plus_StringRef_T(this.getArchName(), NativePointer.$((String)"-")), new Twine(this.getVendorName())), new Twine(NativePointer.$((String)"-"))), new Twine(Str)));
    }

    public Triple get32BitArchVariant() {
        Triple T = null;
        try {
            T = new Triple(this);
            switch (this.getArch()) {
                case UnknownArch: 
                case aarch64: 
                case aarch64_be: 
                case amdgcn: 
                case msp430: 
                case systemz: 
                case ppc64le: {
                    T.setArch(ArchType.UnknownArch);
                    break;
                }
                case amdil: 
                case hsail: 
                case spir: 
                case arm: 
                case armeb: 
                case hexagon: 
                case kalimba: 
                case le32: 
                case mips: 
                case mipsel: 
                case nvptx: 
                case ppc: 
                case r600: 
                case sparc: 
                case tce: 
                case thumb: 
                case thumbeb: 
                case x86: 
                case xcore: {
                    break;
                }
                case le64: {
                    T.setArch(ArchType.le32);
                    break;
                }
                case mips64: {
                    T.setArch(ArchType.mips);
                    break;
                }
                case mips64el: {
                    T.setArch(ArchType.mipsel);
                    break;
                }
                case nvptx64: {
                    T.setArch(ArchType.nvptx);
                    break;
                }
                case ppc64: {
                    T.setArch(ArchType.ppc);
                    break;
                }
                case sparcv9: {
                    T.setArch(ArchType.sparc);
                    break;
                }
                case x86_64: {
                    T.setArch(ArchType.x86);
                    break;
                }
                case amdil64: {
                    T.setArch(ArchType.amdil);
                    break;
                }
                case hsail64: {
                    T.setArch(ArchType.hsail);
                    break;
                }
                case spir64: {
                    T.setArch(ArchType.spir);
                }
            }
            Triple triple = new Triple(T);
            return triple;
        }
        finally {
            if (T != null) {
                T.$destroy();
            }
        }
    }

    public Triple get64BitArchVariant() {
        Triple T = null;
        try {
            T = new Triple(this);
            switch (this.getArch()) {
                case UnknownArch: 
                case msp430: 
                case arm: 
                case armeb: 
                case hexagon: 
                case kalimba: 
                case r600: 
                case tce: 
                case thumb: 
                case thumbeb: 
                case xcore: {
                    T.setArch(ArchType.UnknownArch);
                    break;
                }
                case aarch64: 
                case aarch64_be: 
                case amdgcn: 
                case systemz: 
                case ppc64le: 
                case le64: 
                case mips64: 
                case mips64el: 
                case nvptx64: 
                case ppc64: 
                case sparcv9: 
                case x86_64: 
                case amdil64: 
                case hsail64: 
                case spir64: {
                    break;
                }
                case le32: {
                    T.setArch(ArchType.le64);
                    break;
                }
                case mips: {
                    T.setArch(ArchType.mips64);
                    break;
                }
                case mipsel: {
                    T.setArch(ArchType.mips64el);
                    break;
                }
                case nvptx: {
                    T.setArch(ArchType.nvptx64);
                    break;
                }
                case ppc: {
                    T.setArch(ArchType.ppc64);
                    break;
                }
                case sparc: {
                    T.setArch(ArchType.sparcv9);
                    break;
                }
                case x86: {
                    T.setArch(ArchType.x86_64);
                    break;
                }
                case amdil: {
                    T.setArch(ArchType.amdil64);
                    break;
                }
                case hsail: {
                    T.setArch(ArchType.hsail64);
                    break;
                }
                case spir: {
                    T.setArch(ArchType.spir64);
                }
            }
            Triple triple = new Triple(T);
            return triple;
        }
        finally {
            if (T != null) {
                T.$destroy();
            }
        }
    }

    public char.ptr getARMCPUForArch() {
        return this.getARMCPUForArch(new StringRef());
    }

    public char.ptr getARMCPUForArch(StringRef MArch) {
        if (MArch.empty()) {
            MArch.$assign(this.getArchName());
        }
        switch (this.getOS()) {
            case FreeBSD: 
            case NetBSD: {
                if (!llvm.$eq_StringRef(MArch, new StringRef(NativePointer.$((String)"armv6")))) break;
                return NativePointer.$((String)"arm1176jzf-s");
            }
            case Win32: {
                return NativePointer.$((String)"cortex-a9");
            }
        }
        char.ptr result = null;
        int offset = StringRef.npos;
        if (MArch.startswith("arm")) {
            offset = 3;
        }
        if (MArch.startswith("thumb")) {
            offset = 5;
        }
        if (offset != StringRef.npos && llvm.$eq_StringRef(MArch.substr(offset, 2), new StringRef(NativePointer.$((String)"eb")))) {
            offset += 2;
        }
        if (MArch.endswith("eb")) {
            MArch.$assign$substr(0, MArch.size() - 2);
        }
        if ((result = offset != StringRef.npos ? Native.$tryClone((char.ptr)new StringSwitch<char.ptr>(MArch.substr(offset)).Cases("v2", "v2a", NativePointer.$((String)"arm2")).Case("v3", NativePointer.$((String)"arm6")).Case("v3m", NativePointer.$((String)"arm7m")).Case("v4", NativePointer.$((String)"strongarm")).Case("v4t", NativePointer.$((String)"arm7tdmi")).Cases("v5", "v5t", NativePointer.$((String)"arm10tdmi")).Cases("v5e", "v5te", NativePointer.$((String)"arm1022e")).Case("v5tej", NativePointer.$((String)"arm926ej-s")).Cases("v6", "v6k", NativePointer.$((String)"arm1136jf-s")).Case("v6j", NativePointer.$((String)"arm1136j-s")).Cases("v6z", "v6zk", NativePointer.$((String)"arm1176jzf-s")).Case("v6t2", NativePointer.$((String)"arm1156t2-s")).Cases("v6m", "v6-m", NativePointer.$((String)"cortex-m0")).Cases("v7", "v7a", "v7-a", "v7l", "v7-l", NativePointer.$((String)"cortex-a8")).Cases("v7s", "v7-s", NativePointer.$((String)"swift")).Cases("v7r", "v7-r", NativePointer.$((String)"cortex-r4")).Cases("v7m", "v7-m", NativePointer.$((String)"cortex-m3")).Cases("v7em", "v7e-m", NativePointer.$((String)"cortex-m4")).Cases("v8", "v8a", "v8-a", NativePointer.$((String)"cortex-a53")).Default(null)) : Native.$tryClone((char.ptr)new StringSwitch<char.ptr>(MArch).Case("ep9312", NativePointer.$((String)"ep9312")).Case("iwmmxt", NativePointer.$((String)"iwmmxt")).Case("xscale", NativePointer.$((String)"xscale")).Default(null))) != null) {
            return result;
        }
        switch (this.getOS()) {
            case NetBSD: {
                switch (this.getEnvironment()) {
                    case GNUEABIHF: 
                    case GNUEABI: 
                    case EABIHF: 
                    case EABI: {
                        return NativePointer.$((String)"arm926ej-s");
                    }
                }
                return NativePointer.$((String)"strongarm");
            }
        }
        switch (this.getEnvironment()) {
            case GNUEABIHF: 
            case EABIHF: {
                return NativePointer.$((String)"arm1176jzf-s");
            }
        }
        return NativePointer.$((String)"arm7tdmi");
    }

    public static char.ptr getArchTypeName(ArchType Kind2) {
        switch (Kind2) {
            case UnknownArch: {
                return NativePointer.$((String)"unknown");
            }
            case aarch64: {
                return NativePointer.$((String)"aarch64");
            }
            case aarch64_be: {
                return NativePointer.$((String)"aarch64_be");
            }
            case arm: {
                return NativePointer.$((String)"arm");
            }
            case armeb: {
                return NativePointer.$((String)"armeb");
            }
            case hexagon: {
                return NativePointer.$((String)"hexagon");
            }
            case mips: {
                return NativePointer.$((String)"mips");
            }
            case mipsel: {
                return NativePointer.$((String)"mipsel");
            }
            case mips64: {
                return NativePointer.$((String)"mips64");
            }
            case mips64el: {
                return NativePointer.$((String)"mips64el");
            }
            case msp430: {
                return NativePointer.$((String)"msp430");
            }
            case ppc64: {
                return NativePointer.$((String)"powerpc64");
            }
            case ppc64le: {
                return NativePointer.$((String)"powerpc64le");
            }
            case ppc: {
                return NativePointer.$((String)"powerpc");
            }
            case r600: {
                return NativePointer.$((String)"r600");
            }
            case amdgcn: {
                return NativePointer.$((String)"amdgcn");
            }
            case sparc: {
                return NativePointer.$((String)"sparc");
            }
            case sparcv9: {
                return NativePointer.$((String)"sparcv9");
            }
            case systemz: {
                return NativePointer.$((String)"s390x");
            }
            case tce: {
                return NativePointer.$((String)"tce");
            }
            case thumb: {
                return NativePointer.$((String)"thumb");
            }
            case thumbeb: {
                return NativePointer.$((String)"thumbeb");
            }
            case x86: {
                return NativePointer.$((String)"i386");
            }
            case x86_64: {
                return NativePointer.$((String)"x86_64");
            }
            case xcore: {
                return NativePointer.$((String)"xcore");
            }
            case nvptx: {
                return NativePointer.$((String)"nvptx");
            }
            case nvptx64: {
                return NativePointer.$((String)"nvptx64");
            }
            case le32: {
                return NativePointer.$((String)"le32");
            }
            case le64: {
                return NativePointer.$((String)"le64");
            }
            case amdil: {
                return NativePointer.$((String)"amdil");
            }
            case amdil64: {
                return NativePointer.$((String)"amdil64");
            }
            case hsail: {
                return NativePointer.$((String)"hsail");
            }
            case hsail64: {
                return NativePointer.$((String)"hsail64");
            }
            case spir: {
                return NativePointer.$((String)"spir");
            }
            case spir64: {
                return NativePointer.$((String)"spir64");
            }
            case kalimba: {
                return NativePointer.$((String)"kalimba");
            }
        }
        throw new llvm_unreachable((CharSequence)"Invalid ArchType!");
    }

    public static char.ptr getArchTypePrefix(ArchType Kind2) {
        switch (Kind2) {
            default: {
                return null;
            }
            case aarch64: 
            case aarch64_be: {
                return NativePointer.$((String)"aarch64");
            }
            case arm: 
            case armeb: 
            case thumb: 
            case thumbeb: {
                return NativePointer.$((String)"arm");
            }
            case ppc64le: 
            case ppc: 
            case ppc64: {
                return NativePointer.$((String)"ppc");
            }
            case mips: 
            case mipsel: 
            case mips64: 
            case mips64el: {
                return NativePointer.$((String)"mips");
            }
            case hexagon: {
                return NativePointer.$((String)"hexagon");
            }
            case amdgcn: 
            case r600: {
                return NativePointer.$((String)"amdgpu");
            }
            case sparc: 
            case sparcv9: {
                return NativePointer.$((String)"sparc");
            }
            case systemz: {
                return NativePointer.$((String)"systemz");
            }
            case x86: 
            case x86_64: {
                return NativePointer.$((String)"x86");
            }
            case xcore: {
                return NativePointer.$((String)"xcore");
            }
            case nvptx: {
                return NativePointer.$((String)"nvptx");
            }
            case nvptx64: {
                return NativePointer.$((String)"nvptx");
            }
            case le32: {
                return NativePointer.$((String)"le32");
            }
            case le64: {
                return NativePointer.$((String)"le64");
            }
            case amdil: 
            case amdil64: {
                return NativePointer.$((String)"amdil");
            }
            case hsail: 
            case hsail64: {
                return NativePointer.$((String)"hsail");
            }
            case spir: 
            case spir64: {
                return NativePointer.$((String)"spir");
            }
            case kalimba: 
        }
        return NativePointer.$((String)"kalimba");
    }

    public static char.ptr getVendorTypeName(VendorType Kind2) {
        switch (Kind2) {
            case UnknownVendor: {
                return NativePointer.$((String)"unknown");
            }
            case Apple: {
                return NativePointer.$((String)"apple");
            }
            case PC: {
                return NativePointer.$((String)"pc");
            }
            case SCEI: {
                return NativePointer.$((String)"scei");
            }
            case BGP: {
                return NativePointer.$((String)"bgp");
            }
            case BGQ: {
                return NativePointer.$((String)"bgq");
            }
            case Freescale: {
                return NativePointer.$((String)"fsl");
            }
            case IBM: {
                return NativePointer.$((String)"ibm");
            }
            case ImaginationTechnologies: {
                return NativePointer.$((String)"img");
            }
            case MipsTechnologies: {
                return NativePointer.$((String)"mti");
            }
            case NVIDIA: {
                return NativePointer.$((String)"nvidia");
            }
            case CSR: {
                return NativePointer.$((String)"csr");
            }
        }
        throw new llvm_unreachable((CharSequence)"Invalid VendorType!");
    }

    public static char.ptr getOSTypeName(OSType Kind2) {
        switch (Kind2) {
            case UnknownOS: {
                return NativePointer.$((String)"unknown");
            }
            case Darwin: {
                return NativePointer.$((String)"darwin");
            }
            case DragonFly: {
                return NativePointer.$((String)"dragonfly");
            }
            case FreeBSD: {
                return NativePointer.$((String)"freebsd");
            }
            case IOS: {
                return NativePointer.$((String)"ios");
            }
            case KFreeBSD: {
                return NativePointer.$((String)"kfreebsd");
            }
            case Linux: {
                return NativePointer.$((String)"linux");
            }
            case Lv2: {
                return NativePointer.$((String)"lv2");
            }
            case MacOSX: {
                return NativePointer.$((String)"macosx");
            }
            case NetBSD: {
                return NativePointer.$((String)"netbsd");
            }
            case OpenBSD: {
                return NativePointer.$((String)"openbsd");
            }
            case Solaris: {
                return NativePointer.$((String)"solaris");
            }
            case Win32: {
                return NativePointer.$((String)"windows");
            }
            case Haiku: {
                return NativePointer.$((String)"haiku");
            }
            case Minix: {
                return NativePointer.$((String)"minix");
            }
            case RTEMS: {
                return NativePointer.$((String)"rtems");
            }
            case NaCl: {
                return NativePointer.$((String)"nacl");
            }
            case CNK: {
                return NativePointer.$((String)"cnk");
            }
            case Bitrig: {
                return NativePointer.$((String)"bitrig");
            }
            case AIX: {
                return NativePointer.$((String)"aix");
            }
            case CUDA: {
                return NativePointer.$((String)"cuda");
            }
            case NVCL: {
                return NativePointer.$((String)"nvcl");
            }
            case AMDHSA: {
                return NativePointer.$((String)"amdhsa");
            }
        }
        throw new llvm_unreachable((CharSequence)"Invalid OSType");
    }

    public static char.ptr getEnvironmentTypeName(EnvironmentType Kind2) {
        switch (Kind2) {
            case UnknownEnvironment: {
                return NativePointer.$((String)"unknown");
            }
            case GNU: {
                return NativePointer.$((String)"gnu");
            }
            case GNUEABIHF: {
                return NativePointer.$((String)"gnueabihf");
            }
            case GNUEABI: {
                return NativePointer.$((String)"gnueabi");
            }
            case GNUX32: {
                return NativePointer.$((String)"gnux32");
            }
            case CODE16: {
                return NativePointer.$((String)"code16");
            }
            case EABI: {
                return NativePointer.$((String)"eabi");
            }
            case EABIHF: {
                return NativePointer.$((String)"eabihf");
            }
            case Android: {
                return NativePointer.$((String)"android");
            }
            case MSVC: {
                return NativePointer.$((String)"msvc");
            }
            case Itanium: {
                return NativePointer.$((String)"itanium");
            }
            case Cygnus: {
                return NativePointer.$((String)"cygnus");
            }
        }
        throw new llvm_unreachable((CharSequence)"Invalid EnvironmentType!");
    }

    public static ArchType getArchTypeForLLVMName(StringRef Name) {
        return new StringSwitch<ArchType>(Name).Case("aarch64", ArchType.aarch64).Case("aarch64_be", ArchType.aarch64_be).Case("arm64", ArchType.aarch64).Case("arm", ArchType.arm).Case("armeb", ArchType.armeb).Case("mips", ArchType.mips).Case("mipsel", ArchType.mipsel).Case("mips64", ArchType.mips64).Case("mips64el", ArchType.mips64el).Case("msp430", ArchType.msp430).Case("ppc64", ArchType.ppc64).Case("ppc32", ArchType.ppc).Case("ppc", ArchType.ppc).Case("ppc64le", ArchType.ppc64le).Case("r600", ArchType.r600).Case("amdgcn", ArchType.amdgcn).Case("hexagon", ArchType.hexagon).Case("sparc", ArchType.sparc).Case("sparcv9", ArchType.sparcv9).Case("systemz", ArchType.systemz).Case("tce", ArchType.tce).Case("thumb", ArchType.thumb).Case("thumbeb", ArchType.thumbeb).Case("x86", ArchType.x86).Case("x86-64", ArchType.x86_64).Case("xcore", ArchType.xcore).Case("nvptx", ArchType.nvptx).Case("nvptx64", ArchType.nvptx64).Case("le32", ArchType.le32).Case("le64", ArchType.le64).Case("amdil", ArchType.amdil).Case("amdil64", ArchType.amdil64).Case("hsail", ArchType.hsail).Case("hsail64", ArchType.hsail64).Case("spir", ArchType.spir).Case("spir64", ArchType.spir64).Case("kalimba", ArchType.kalimba).Default(ArchType.UnknownArch);
    }

    public Triple(Triple $Prm0) {
        this.Data = new std.string($Prm0.Data);
        this.Arch = $Prm0.Arch;
        this.SubArch = $Prm0.SubArch;
        this.Vendor = $Prm0.Vendor;
        this.OS = $Prm0.OS;
        this.Environment = $Prm0.Environment;
        this.ObjectFormat = $Prm0.ObjectFormat;
    }

    public Triple $assign(Triple $Prm0) {
        this.Data.$assign($Prm0.Data);
        this.Arch = $Prm0.Arch;
        this.SubArch = $Prm0.SubArch;
        this.Vendor = $Prm0.Vendor;
        this.OS = $Prm0.OS;
        this.Environment = $Prm0.Environment;
        this.ObjectFormat = $Prm0.ObjectFormat;
        return this;
    }

    public void $destroy() {
        this.Data.$destroy();
    }

    public String toString() {
        return "Data=" + this.Data + ", Arch=" + (Object)((Object)this.Arch) + ", SubArch=" + (Object)((Object)this.SubArch) + ", Vendor=" + (Object)((Object)this.Vendor) + ", OS=" + (Object)((Object)this.OS) + ", Environment=" + (Object)((Object)this.Environment) + ", ObjectFormat=" + (Object)((Object)this.ObjectFormat);
    }

    public static final class ObjectFormatType
    extends Enum<ObjectFormatType> {
        public static final /* enum */ ObjectFormatType UnknownObjectFormat = new ObjectFormatType(0L);
        public static final /* enum */ ObjectFormatType COFF = new ObjectFormatType(UnknownObjectFormat.getValue() + 1);
        public static final /* enum */ ObjectFormatType ELF = new ObjectFormatType(COFF.getValue() + 1);
        public static final /* enum */ ObjectFormatType MachO = new ObjectFormatType(ELF.getValue() + 1);
        private final int value;
        private static final /* synthetic */ ObjectFormatType[] $VALUES;

        public static ObjectFormatType[] values() {
            return (ObjectFormatType[])$VALUES.clone();
        }

        public static ObjectFormatType valueOf(String name) {
            return Enum.valueOf(ObjectFormatType.class, name);
        }

        public static ObjectFormatType valueOf(int val) {
            ObjectFormatType out;
            ObjectFormatType objectFormatType = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private ObjectFormatType(long val) {
            this.value = (int)val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new ObjectFormatType[]{UnknownObjectFormat, COFF, ELF, MachO};
        }

        private static final class Values {
            private static final ObjectFormatType[] VALUES;
            private static final ObjectFormatType[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (ObjectFormatType kind : ObjectFormatType.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new ObjectFormatType[min < 0 ? 1 - min : 0];
                VALUES = new ObjectFormatType[max >= 0 ? 1 + max : 0];
                for (ObjectFormatType kind : ObjectFormatType.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((ObjectFormatType)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((ObjectFormatType)kind).value] = kind;
                }
            }
        }
    }

    public static final class EnvironmentType
    extends Enum<EnvironmentType> {
        public static final /* enum */ EnvironmentType UnknownEnvironment = new EnvironmentType(0L);
        public static final /* enum */ EnvironmentType GNU = new EnvironmentType(UnknownEnvironment.getValue() + 1);
        public static final /* enum */ EnvironmentType GNUEABI = new EnvironmentType(GNU.getValue() + 1);
        public static final /* enum */ EnvironmentType GNUEABIHF = new EnvironmentType(GNUEABI.getValue() + 1);
        public static final /* enum */ EnvironmentType GNUX32 = new EnvironmentType(GNUEABIHF.getValue() + 1);
        public static final /* enum */ EnvironmentType CODE16 = new EnvironmentType(GNUX32.getValue() + 1);
        public static final /* enum */ EnvironmentType EABI = new EnvironmentType(CODE16.getValue() + 1);
        public static final /* enum */ EnvironmentType EABIHF = new EnvironmentType(EABI.getValue() + 1);
        public static final /* enum */ EnvironmentType Android = new EnvironmentType(EABIHF.getValue() + 1);
        public static final /* enum */ EnvironmentType MSVC = new EnvironmentType(Android.getValue() + 1);
        public static final /* enum */ EnvironmentType Itanium = new EnvironmentType(MSVC.getValue() + 1);
        public static final /* enum */ EnvironmentType Cygnus = new EnvironmentType(Itanium.getValue() + 1);
        private final int value;
        private static final /* synthetic */ EnvironmentType[] $VALUES;

        public static EnvironmentType[] values() {
            return (EnvironmentType[])$VALUES.clone();
        }

        public static EnvironmentType valueOf(String name) {
            return Enum.valueOf(EnvironmentType.class, name);
        }

        public static EnvironmentType valueOf(int val) {
            EnvironmentType out;
            EnvironmentType environmentType = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private EnvironmentType(long val) {
            this.value = (int)val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new EnvironmentType[]{UnknownEnvironment, GNU, GNUEABI, GNUEABIHF, GNUX32, CODE16, EABI, EABIHF, Android, MSVC, Itanium, Cygnus};
        }

        private static final class Values {
            private static final EnvironmentType[] VALUES;
            private static final EnvironmentType[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (EnvironmentType kind : EnvironmentType.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new EnvironmentType[min < 0 ? 1 - min : 0];
                VALUES = new EnvironmentType[max >= 0 ? 1 + max : 0];
                for (EnvironmentType kind : EnvironmentType.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((EnvironmentType)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((EnvironmentType)kind).value] = kind;
                }
            }
        }
    }

    public static final class OSType
    extends Enum<OSType> {
        public static final /* enum */ OSType UnknownOS = new OSType(0L);
        public static final /* enum */ OSType Darwin = new OSType(UnknownOS.getValue() + 1);
        public static final /* enum */ OSType DragonFly = new OSType(Darwin.getValue() + 1);
        public static final /* enum */ OSType FreeBSD = new OSType(DragonFly.getValue() + 1);
        public static final /* enum */ OSType IOS = new OSType(FreeBSD.getValue() + 1);
        public static final /* enum */ OSType KFreeBSD = new OSType(IOS.getValue() + 1);
        public static final /* enum */ OSType Linux = new OSType(KFreeBSD.getValue() + 1);
        public static final /* enum */ OSType Lv2 = new OSType(Linux.getValue() + 1);
        public static final /* enum */ OSType MacOSX = new OSType(Lv2.getValue() + 1);
        public static final /* enum */ OSType NetBSD = new OSType(MacOSX.getValue() + 1);
        public static final /* enum */ OSType OpenBSD = new OSType(NetBSD.getValue() + 1);
        public static final /* enum */ OSType Solaris = new OSType(OpenBSD.getValue() + 1);
        public static final /* enum */ OSType Win32 = new OSType(Solaris.getValue() + 1);
        public static final /* enum */ OSType Haiku = new OSType(Win32.getValue() + 1);
        public static final /* enum */ OSType Minix = new OSType(Haiku.getValue() + 1);
        public static final /* enum */ OSType RTEMS = new OSType(Minix.getValue() + 1);
        public static final /* enum */ OSType NaCl = new OSType(RTEMS.getValue() + 1);
        public static final /* enum */ OSType CNK = new OSType(NaCl.getValue() + 1);
        public static final /* enum */ OSType Bitrig = new OSType(CNK.getValue() + 1);
        public static final /* enum */ OSType AIX = new OSType(Bitrig.getValue() + 1);
        public static final /* enum */ OSType CUDA = new OSType(AIX.getValue() + 1);
        public static final /* enum */ OSType NVCL = new OSType(CUDA.getValue() + 1);
        public static final /* enum */ OSType AMDHSA = new OSType(NVCL.getValue() + 1);
        private final int value;
        private static final /* synthetic */ OSType[] $VALUES;

        public static OSType[] values() {
            return (OSType[])$VALUES.clone();
        }

        public static OSType valueOf(String name) {
            return Enum.valueOf(OSType.class, name);
        }

        public static OSType valueOf(int val) {
            OSType out;
            OSType oSType = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private OSType(long val) {
            this.value = (int)val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new OSType[]{UnknownOS, Darwin, DragonFly, FreeBSD, IOS, KFreeBSD, Linux, Lv2, MacOSX, NetBSD, OpenBSD, Solaris, Win32, Haiku, Minix, RTEMS, NaCl, CNK, Bitrig, AIX, CUDA, NVCL, AMDHSA};
        }

        private static final class Values {
            private static final OSType[] VALUES;
            private static final OSType[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (OSType kind : OSType.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new OSType[min < 0 ? 1 - min : 0];
                VALUES = new OSType[max >= 0 ? 1 + max : 0];
                for (OSType kind : OSType.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((OSType)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((OSType)kind).value] = kind;
                }
            }
        }
    }

    public static final class VendorType
    extends Enum<VendorType> {
        public static final /* enum */ VendorType UnknownVendor = new VendorType(0L);
        public static final /* enum */ VendorType Apple = new VendorType(UnknownVendor.getValue() + 1);
        public static final /* enum */ VendorType PC = new VendorType(Apple.getValue() + 1);
        public static final /* enum */ VendorType SCEI = new VendorType(PC.getValue() + 1);
        public static final /* enum */ VendorType BGP = new VendorType(SCEI.getValue() + 1);
        public static final /* enum */ VendorType BGQ = new VendorType(BGP.getValue() + 1);
        public static final /* enum */ VendorType Freescale = new VendorType(BGQ.getValue() + 1);
        public static final /* enum */ VendorType IBM = new VendorType(Freescale.getValue() + 1);
        public static final /* enum */ VendorType ImaginationTechnologies = new VendorType(IBM.getValue() + 1);
        public static final /* enum */ VendorType MipsTechnologies = new VendorType(ImaginationTechnologies.getValue() + 1);
        public static final /* enum */ VendorType NVIDIA = new VendorType(MipsTechnologies.getValue() + 1);
        public static final /* enum */ VendorType CSR = new VendorType(NVIDIA.getValue() + 1);
        private final int value;
        private static final /* synthetic */ VendorType[] $VALUES;

        public static VendorType[] values() {
            return (VendorType[])$VALUES.clone();
        }

        public static VendorType valueOf(String name) {
            return Enum.valueOf(VendorType.class, name);
        }

        public static VendorType valueOf(int val) {
            VendorType out;
            VendorType vendorType = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private VendorType(long val) {
            this.value = (int)val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new VendorType[]{UnknownVendor, Apple, PC, SCEI, BGP, BGQ, Freescale, IBM, ImaginationTechnologies, MipsTechnologies, NVIDIA, CSR};
        }

        private static final class Values {
            private static final VendorType[] VALUES;
            private static final VendorType[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (VendorType kind : VendorType.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new VendorType[min < 0 ? 1 - min : 0];
                VALUES = new VendorType[max >= 0 ? 1 + max : 0];
                for (VendorType kind : VendorType.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((VendorType)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((VendorType)kind).value] = kind;
                }
            }
        }
    }

    public static final class SubArchType
    extends Enum<SubArchType> {
        public static final /* enum */ SubArchType NoSubArch = new SubArchType(0L);
        public static final /* enum */ SubArchType ARMSubArch_v8 = new SubArchType(NoSubArch.getValue() + 1);
        public static final /* enum */ SubArchType ARMSubArch_v7 = new SubArchType(ARMSubArch_v8.getValue() + 1);
        public static final /* enum */ SubArchType ARMSubArch_v7em = new SubArchType(ARMSubArch_v7.getValue() + 1);
        public static final /* enum */ SubArchType ARMSubArch_v7m = new SubArchType(ARMSubArch_v7em.getValue() + 1);
        public static final /* enum */ SubArchType ARMSubArch_v7s = new SubArchType(ARMSubArch_v7m.getValue() + 1);
        public static final /* enum */ SubArchType ARMSubArch_v6 = new SubArchType(ARMSubArch_v7s.getValue() + 1);
        public static final /* enum */ SubArchType ARMSubArch_v6m = new SubArchType(ARMSubArch_v6.getValue() + 1);
        public static final /* enum */ SubArchType ARMSubArch_v6t2 = new SubArchType(ARMSubArch_v6m.getValue() + 1);
        public static final /* enum */ SubArchType ARMSubArch_v5 = new SubArchType(ARMSubArch_v6t2.getValue() + 1);
        public static final /* enum */ SubArchType ARMSubArch_v5te = new SubArchType(ARMSubArch_v5.getValue() + 1);
        public static final /* enum */ SubArchType ARMSubArch_v4t = new SubArchType(ARMSubArch_v5te.getValue() + 1);
        public static final /* enum */ SubArchType KalimbaSubArch_v3 = new SubArchType(ARMSubArch_v4t.getValue() + 1);
        public static final /* enum */ SubArchType KalimbaSubArch_v4 = new SubArchType(KalimbaSubArch_v3.getValue() + 1);
        public static final /* enum */ SubArchType KalimbaSubArch_v5 = new SubArchType(KalimbaSubArch_v4.getValue() + 1);
        private final int value;
        private static final /* synthetic */ SubArchType[] $VALUES;

        public static SubArchType[] values() {
            return (SubArchType[])$VALUES.clone();
        }

        public static SubArchType valueOf(String name) {
            return Enum.valueOf(SubArchType.class, name);
        }

        public static SubArchType valueOf(int val) {
            SubArchType out;
            SubArchType subArchType = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private SubArchType(long val) {
            this.value = (int)val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new SubArchType[]{NoSubArch, ARMSubArch_v8, ARMSubArch_v7, ARMSubArch_v7em, ARMSubArch_v7m, ARMSubArch_v7s, ARMSubArch_v6, ARMSubArch_v6m, ARMSubArch_v6t2, ARMSubArch_v5, ARMSubArch_v5te, ARMSubArch_v4t, KalimbaSubArch_v3, KalimbaSubArch_v4, KalimbaSubArch_v5};
        }

        private static final class Values {
            private static final SubArchType[] VALUES;
            private static final SubArchType[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (SubArchType kind : SubArchType.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new SubArchType[min < 0 ? 1 - min : 0];
                VALUES = new SubArchType[max >= 0 ? 1 + max : 0];
                for (SubArchType kind : SubArchType.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((SubArchType)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((SubArchType)kind).value] = kind;
                }
            }
        }
    }

    public static final class ArchType
    extends Enum<ArchType> {
        public static final /* enum */ ArchType UnknownArch = new ArchType(0L);
        public static final /* enum */ ArchType arm = new ArchType(UnknownArch.getValue() + 1);
        public static final /* enum */ ArchType armeb = new ArchType(arm.getValue() + 1);
        public static final /* enum */ ArchType aarch64 = new ArchType(armeb.getValue() + 1);
        public static final /* enum */ ArchType aarch64_be = new ArchType(aarch64.getValue() + 1);
        public static final /* enum */ ArchType hexagon = new ArchType(aarch64_be.getValue() + 1);
        public static final /* enum */ ArchType mips = new ArchType(hexagon.getValue() + 1);
        public static final /* enum */ ArchType mipsel = new ArchType(mips.getValue() + 1);
        public static final /* enum */ ArchType mips64 = new ArchType(mipsel.getValue() + 1);
        public static final /* enum */ ArchType mips64el = new ArchType(mips64.getValue() + 1);
        public static final /* enum */ ArchType msp430 = new ArchType(mips64el.getValue() + 1);
        public static final /* enum */ ArchType ppc = new ArchType(msp430.getValue() + 1);
        public static final /* enum */ ArchType ppc64 = new ArchType(ppc.getValue() + 1);
        public static final /* enum */ ArchType ppc64le = new ArchType(ppc64.getValue() + 1);
        public static final /* enum */ ArchType r600 = new ArchType(ppc64le.getValue() + 1);
        public static final /* enum */ ArchType amdgcn = new ArchType(r600.getValue() + 1);
        public static final /* enum */ ArchType sparc = new ArchType(amdgcn.getValue() + 1);
        public static final /* enum */ ArchType sparcv9 = new ArchType(sparc.getValue() + 1);
        public static final /* enum */ ArchType systemz = new ArchType(sparcv9.getValue() + 1);
        public static final /* enum */ ArchType tce = new ArchType(systemz.getValue() + 1);
        public static final /* enum */ ArchType thumb = new ArchType(tce.getValue() + 1);
        public static final /* enum */ ArchType thumbeb = new ArchType(thumb.getValue() + 1);
        public static final /* enum */ ArchType x86 = new ArchType(thumbeb.getValue() + 1);
        public static final /* enum */ ArchType x86_64 = new ArchType(x86.getValue() + 1);
        public static final /* enum */ ArchType xcore = new ArchType(x86_64.getValue() + 1);
        public static final /* enum */ ArchType nvptx = new ArchType(xcore.getValue() + 1);
        public static final /* enum */ ArchType nvptx64 = new ArchType(nvptx.getValue() + 1);
        public static final /* enum */ ArchType le32 = new ArchType(nvptx64.getValue() + 1);
        public static final /* enum */ ArchType le64 = new ArchType(le32.getValue() + 1);
        public static final /* enum */ ArchType amdil = new ArchType(le64.getValue() + 1);
        public static final /* enum */ ArchType amdil64 = new ArchType(amdil.getValue() + 1);
        public static final /* enum */ ArchType hsail = new ArchType(amdil64.getValue() + 1);
        public static final /* enum */ ArchType hsail64 = new ArchType(hsail.getValue() + 1);
        public static final /* enum */ ArchType spir = new ArchType(hsail64.getValue() + 1);
        public static final /* enum */ ArchType spir64 = new ArchType(spir.getValue() + 1);
        public static final /* enum */ ArchType kalimba = new ArchType(spir64.getValue() + 1);
        private final int value;
        private static final /* synthetic */ ArchType[] $VALUES;

        public static ArchType[] values() {
            return (ArchType[])$VALUES.clone();
        }

        public static ArchType valueOf(String name) {
            return Enum.valueOf(ArchType.class, name);
        }

        public static ArchType valueOf(int val) {
            ArchType out;
            ArchType archType = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private ArchType(long val) {
            this.value = (int)val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new ArchType[]{UnknownArch, arm, armeb, aarch64, aarch64_be, hexagon, mips, mipsel, mips64, mips64el, msp430, ppc, ppc64, ppc64le, r600, amdgcn, sparc, sparcv9, systemz, tce, thumb, thumbeb, x86, x86_64, xcore, nvptx, nvptx64, le32, le64, amdil, amdil64, hsail, hsail64, spir, spir64, kalimba};
        }

        private static final class Values {
            private static final ArchType[] VALUES;
            private static final ArchType[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (ArchType kind : ArchType.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new ArchType[min < 0 ? 1 - min : 0];
                VALUES = new ArchType[max >= 0 ? 1 + max : 0];
                for (ArchType kind : ArchType.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((ArchType)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((ArchType)kind).value] = kind;
                }
            }
        }
    }
}

