/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import java.util.Objects;
import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.char;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;
import org.llvm.support.raw_svector_ostream;

public final class Twine
implements Native.NativePOD<Twine> {
    public static final Twine EMPTY = new Twine();
    public static final Twine SPACE = new Twine(StringRef.SPACE);
    public static final Twine MINUS = new Twine(StringRef.MINUS);
    public static final Twine PLUS = new Twine(StringRef.PLUS);
    public static final Twine DOT = new Twine(StringRef.DOT);
    public static final Twine ZERO = new Twine(StringRef.ZERO);
    public static final Twine ONE = new Twine(StringRef.ONE);
    public static final Twine TWO = new Twine(StringRef.TWO);
    public static final Twine THREE = new Twine(StringRef.THREE);
    public static final Twine SLASH = new Twine(StringRef.SLASH);
    public static final Twine DOT_DOT = new Twine(StringRef.DOT_DOT);
    public static final Twine TWINE_SCRATCH_SPACE = new Twine(StringRef.SCRATCH_SPACE);
    private static final Child DUMMY_CHILD = NativeTrace.isDebugMode() ? new DummyChild() : new Child();
    private final Child LHS;
    private final Child RHS;
    private final short LHSKind;
    private final short RHSKind;
    private static final Twine NullKindTwine = new Twine(true);

    public static Twine $new(StringRef stringRef) {
        return new Twine(stringRef);
    }

    private Twine(boolean nodeKindFlag) {
        this.LHS = DUMMY_CHILD;
        this.RHS = DUMMY_CHILD;
        this.LHSKind = 0;
        this.RHSKind = 1;
        assert (this.isNullary()) : "Invalid kind!";
    }

    private Twine(Twine _LHS, Twine _RHS) {
        this.LHS = new Child();
        this.RHS = new Child();
        this.LHSKind = (short)2;
        this.RHSKind = (short)2;
        this.LHS.setTwine(_LHS);
        this.RHS.setTwine(_RHS);
        assert (this.isValid()) : "Invalid twine!";
    }

    private Twine(Child _LHS, short _LHSKind, Child _RHS, short _RHSKind) {
        this.LHS = new Child(_LHS);
        this.RHS = new Child(_RHS);
        this.LHSKind = _LHSKind;
        this.RHSKind = _RHSKind;
        assert (this.isValid()) : "Invalid twine!";
    }

    private boolean isNull() {
        return this.getLHSKind() == 0;
    }

    private boolean isEmpty() {
        return this.getLHSKind() == 1;
    }

    private boolean isNullary() {
        return this.isNull() || this.isEmpty();
    }

    private boolean isUnary() {
        return this.getRHSKind() == 1 && !this.isNullary();
    }

    private boolean isBinary() {
        return this.getLHSKind() != 0 && this.getRHSKind() != 1;
    }

    private boolean isValid() {
        if (this.isNullary() && this.getRHSKind() != 1) {
            return false;
        }
        if (this.getRHSKind() == 0) {
            return false;
        }
        if (this.getRHSKind() != 1 && this.getLHSKind() == 1) {
            return false;
        }
        if (this.getLHSKind() == 2 && !this.LHS.getTwine().isBinary()) {
            return false;
        }
        return this.getRHSKind() != 2 || this.RHS.getTwine().isBinary();
    }

    private short getLHSKind() {
        return this.LHSKind;
    }

    private short getRHSKind() {
        return this.RHSKind;
    }

    private void printOneChild(raw_ostream OS, Child Ptr, short Kind2) {
        switch (Kind2) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                Ptr.getTwine().print(OS);
                break;
            }
            case 3: {
                OS.$out(Ptr.getCString());
                break;
            }
            case 4: {
                OS.$out(Ptr.getStdString());
                break;
            }
            case 5: {
                OS.$out(Ptr.getStringRef());
                break;
            }
            case 6: {
                OS.$out(Ptr.getCharacter());
                break;
            }
            case 7: {
                OS.$out(Ptr.getDecUI());
                break;
            }
            case 8: {
                OS.$out(Ptr.getDecI());
                break;
            }
            case 9: {
                OS.$out(Ptr.getDecUL());
                break;
            }
            case 10: {
                OS.$out(Ptr.getDecL());
                break;
            }
            case 11: {
                OS.$out(Ptr.getDecULL());
                break;
            }
            case 12: {
                OS.$out(Ptr.getDecLL());
                break;
            }
            case 13: {
                OS.write_hex(Ptr.getUHex());
            }
        }
    }

    private void printOneChildRepr(raw_ostream OS, Child Ptr, short Kind2) {
        switch (Kind2) {
            case 0: {
                OS.$out("null");
                break;
            }
            case 1: {
                OS.$out("empty");
                break;
            }
            case 2: {
                OS.$out("rope:");
                Ptr.getTwine().printRepr(OS);
                break;
            }
            case 3: {
                OS.$out("cstring:\"").$out(Ptr.getCString()).$out("\"");
                break;
            }
            case 4: {
                OS.$out("std::string:\"").$out(Ptr.getStdString()).$out("\"");
                break;
            }
            case 5: {
                OS.$out("stringref:\"").$out(Ptr.getStringRef()).$out("\"");
                break;
            }
            case 6: {
                OS.$out("char:\"").$out(Ptr.getCharacter()).$out("\"");
                break;
            }
            case 7: {
                OS.$out("decUI:\"").$out(Ptr.getDecUI()).$out("\"");
                break;
            }
            case 8: {
                OS.$out("decI:\"").$out(Ptr.getDecI()).$out("\"");
                break;
            }
            case 9: {
                OS.$out("decUL:\"").$out(Ptr.getDecUL()).$out("\"");
                break;
            }
            case 10: {
                OS.$out("decL:\"").$out(Ptr.getDecL()).$out("\"");
                break;
            }
            case 11: {
                OS.$out("decULL:\"").$out(Ptr.getDecULL()).$out("\"");
                break;
            }
            case 12: {
                OS.$out("decLL:\"").$out(Ptr.getDecLL()).$out("\"");
                break;
            }
            case 13: {
                OS.$out("uhex:\"").$out(Ptr.getUHex()).$out("\"");
            }
        }
    }

    public Twine() {
        this.LHS = DUMMY_CHILD;
        this.RHS = DUMMY_CHILD;
        this.LHSKind = 1;
        this.RHSKind = 1;
        assert (this.isValid()) : "Invalid twine!";
    }

    public Twine(char.ptr Str) {
        this.RHS = DUMMY_CHILD;
        this.RHSKind = 1;
        if (Str.$at(0) != 0) {
            this.LHS = new Child();
            this.LHS.setCString(Str);
            this.LHSKind = (short)3;
        } else {
            this.LHS = DUMMY_CHILD;
            this.LHSKind = 1;
        }
        assert (this.isValid()) : "Invalid twine!";
    }

    public Twine(char.iterator<?> Str) {
        this(Str.star$ref().deref$ptr());
    }

    public Twine(byte[] Str) {
        this(NativePointer.create_char$ptr((byte[])Str));
    }

    public Twine(std.string Str) {
        this.LHS = new Child();
        this.RHS = DUMMY_CHILD;
        this.LHSKind = (short)4;
        this.RHSKind = 1;
        this.LHS.setStdString(Str);
        assert (this.isValid()) : "Invalid twine!";
    }

    public Twine(StringRef Str) {
        this.LHS = new Child();
        this.RHS = DUMMY_CHILD;
        this.LHSKind = (short)5;
        this.RHSKind = 1;
        this.LHS.setStringRef(Str);
        assert (this.isValid()) : "Invalid twine!";
    }

    public Twine(CharSequence Str) {
        this(NativePointer.create_char$ptr((CharSequence)Str));
    }

    public Twine(char.ptr _LHS, StringRef _RHS) {
        this.LHS = new Child();
        this.RHS = new Child();
        this.LHSKind = (short)3;
        this.RHSKind = (short)5;
        this.LHS.setCString(_LHS);
        this.RHS.setStringRef(_RHS);
        assert (this.isValid()) : "Invalid twine!";
    }

    public Twine(CharSequence _LHS, StringRef _RHS) {
        this(NativePointer.create_char$ptr((CharSequence)_LHS), _RHS);
    }

    public Twine(StringRef _LHS, char.ptr _RHS) {
        this.LHS = new Child();
        this.RHS = new Child();
        this.LHSKind = (short)5;
        this.RHSKind = (short)3;
        this.LHS.setStringRef(_LHS);
        this.RHS.setCString(_RHS);
        assert (this.isValid()) : "Invalid twine!";
    }

    public Twine(StringRef _LHS, CharSequence _RHS) {
        this(_LHS, NativePointer.create_char$ptr((CharSequence)_RHS));
    }

    public Twine(JavaDifferentiators.Char _dparam, byte Val) {
        this.LHS = new Child();
        this.RHS = DUMMY_CHILD;
        this.LHSKind = (short)6;
        this.RHSKind = 1;
        this.LHS.setCharacter(Val);
    }

    public Twine(JavaDifferentiators.Schar _dparam, byte Val) {
        this.LHS = new Child();
        this.RHS = DUMMY_CHILD;
        this.LHSKind = (short)6;
        this.RHSKind = 1;
        this.LHS.setCharacter(Val);
    }

    public Twine(JavaDifferentiators.Uchar _dparam, short Val) {
        this.LHS = new Child();
        this.RHS = DUMMY_CHILD;
        this.LHSKind = (short)6;
        this.RHSKind = 1;
        this.LHS.setCharacter((byte)Val);
    }

    public Twine(JavaDifferentiators.Uint _dparam, long Val) {
        this.LHS = new Child();
        this.RHS = DUMMY_CHILD;
        this.LHSKind = (short)7;
        this.RHSKind = 1;
        assert (Val >= 0L) : "forgot about unsigned conversion?";
        this.LHS.setDecUI(Val);
    }

    public Twine(JavaDifferentiators.Int _dparam, int Val) {
        this.LHS = new Child();
        this.RHS = DUMMY_CHILD;
        this.LHSKind = (short)8;
        this.RHSKind = 1;
        this.LHS.setDecI(Val);
    }

    public Twine(JavaDifferentiators.Ulong _dparam, long Val) {
        this.LHS = new Child();
        this.RHS = DUMMY_CHILD;
        this.LHSKind = (short)9;
        this.RHSKind = 1;
        this.LHS.setDecUL(Val);
    }

    public Twine(JavaDifferentiators.Long _dparam, long Val) {
        this.LHS = new Child();
        this.RHS = DUMMY_CHILD;
        this.LHSKind = (short)10;
        this.RHSKind = 1;
        this.LHS.setDecL(Val);
    }

    public Twine(JavaDifferentiators.Ullong _dparam, long Val) {
        this.LHS = new Child();
        this.RHS = DUMMY_CHILD;
        this.LHSKind = (short)11;
        this.RHSKind = 1;
        this.LHS.setDecULL(Val);
    }

    public Twine(JavaDifferentiators.Llong _dparam, long Val) {
        this.LHS = new Child();
        this.RHS = DUMMY_CHILD;
        this.LHSKind = (short)12;
        this.RHSKind = 1;
        this.LHS.setDecLL(Val);
    }

    public static Twine createNull() {
        return NullKindTwine;
    }

    public static Twine utohexstr(long Val) {
        Child LHS = new Child();
        Child RHS = DUMMY_CHILD;
        LHS.setUHex(Val);
        return new Twine(LHS, 13, RHS, 1);
    }

    public boolean isTriviallyEmpty() {
        return this.isNullary();
    }

    public boolean isSingleStringRef() {
        if (this.getRHSKind() != 1) {
            return false;
        }
        switch (this.getLHSKind()) {
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public Twine concat(Twine Suffix) {
        if (this.isNull() || Suffix.isNull()) {
            return NullKindTwine;
        }
        if (this.isEmpty()) {
            return Suffix;
        }
        if (Suffix.isEmpty()) {
            return this;
        }
        Child NewLHS = new Child();
        Child NewRHS = new Child();
        NewLHS.setTwine(this);
        NewRHS.setTwine(Suffix);
        short NewLHSKind = 2;
        short NewRHSKind = 2;
        if (this.isUnary()) {
            NewLHS.$assign(this.LHS);
            NewLHSKind = this.getLHSKind();
        }
        if (Suffix.isUnary()) {
            NewRHS.$assign(Suffix.LHS);
            NewRHSKind = Suffix.getLHSKind();
        }
        return new Twine(NewLHS, NewLHSKind, NewRHS, NewRHSKind);
    }

    public std.string str() {
        if (this.LHSKind == 4 && this.RHSKind == 1) {
            return this.LHS.getStdString();
        }
        SmallString Vec = new SmallString(256);
        return this.toStringRef(Vec).str();
    }

    public void toVector(SmallString Out) {
        raw_svector_ostream OS = null;
        try {
            OS = new raw_svector_ostream(Out);
            this.print(OS);
        }
        finally {
            if (OS != null) {
                OS.$destroy();
            }
        }
    }

    public StringRef getSingleStringRef() {
        assert (this.isSingleStringRef()) : "This cannot be had as a single stringref!";
        switch (this.getLHSKind()) {
            default: {
                llvm.llvm_unreachable_internal("Out of sync with isSingleStringRef", "${LLVM_SRC}/llvm/include/llvm/ADT/Twine.h", 429L);
            }
            case 1: {
                return StringRef.EMPTY;
            }
            case 3: {
                return new StringRef(this.LHS.getCString());
            }
            case 4: {
                return new StringRef(this.LHS.getStdString());
            }
            case 5: 
        }
        return this.LHS.getStringRef();
    }

    public StringRef toStringRef(SmallString Out) {
        if (this.isSingleStringRef()) {
            return this.getSingleStringRef();
        }
        this.toVector(Out);
        return new StringRef(Out.data(), Out.size());
    }

    public StringRef toStringRef(SmallString Out, StringRef OutStrRef) {
        if (this.isSingleStringRef()) {
            return this.getSingleStringRef();
        }
        this.toVector(Out);
        return OutStrRef.$assign(Out.data(), Out.size());
    }

    public StringRef toNullTerminatedStringRef(SmallString Out) {
        if (this.isUnary()) {
            switch (this.getLHSKind()) {
                case 3: {
                    return new StringRef(this.LHS.getCString());
                }
                case 4: {
                    std.string str = this.LHS.getStdString();
                    return new StringRef(str.c_str(), str.size());
                }
            }
        }
        this.toVector(Out);
        Out.push_back((byte)0);
        Out.pop_back();
        return new StringRef(Out.data(), Out.size());
    }

    public void print(raw_ostream OS) {
        this.printOneChild(OS, this.LHS, this.getLHSKind());
        this.printOneChild(OS, this.RHS, this.getRHSKind());
    }

    public void dump() {
        this.print(llvm.dbgs());
    }

    public void printRepr(raw_ostream OS) {
        OS.$out("(Twine ");
        this.printOneChildRepr(OS, this.LHS, this.getLHSKind());
        OS.$out(" ");
        this.printOneChildRepr(OS, this.RHS, this.getRHSKind());
        OS.$out(")");
    }

    public void dumpRepr() {
        this.printRepr(llvm.dbgs());
    }

    public Twine(Twine $Prm0) {
        this.LHS = new Child($Prm0.LHS);
        this.RHS = new Child($Prm0.RHS);
        this.LHSKind = $Prm0.LHSKind;
        this.RHSKind = $Prm0.RHSKind;
    }

    public Twine $assign(Twine value) {
        throw new UnsupportedOperationException();
    }

    public Twine clone() {
        return new Twine(this);
    }

    public boolean $noteq(Twine other) {
        return !this.$eq(other);
    }

    public boolean $eq(Twine other) {
        if (this.LHSKind != other.LHSKind) {
            return false;
        }
        if (this.RHSKind != other.RHSKind) {
            return false;
        }
        if (!Objects.equals(this.LHS, other.LHS)) {
            return false;
        }
        return Objects.equals(this.RHS, other.RHS);
    }

    public String toString() {
        return "Twine{[" + this.str() + "]LHSKind=" + this.getLHSKind() + ", RHSKind=" + this.getRHSKind() + '}';
    }

    private static final class DummyChild
    extends Child {
        private DummyChild() {
        }

        @Override
        public Child $assign(Child $Prm0) {
            throw new UnsupportedOperationException("Dummy Child Can not be modified");
        }

        @Override
        public void setUHex(long Val) {
            throw new UnsupportedOperationException("Dummy Child Can not be modified");
        }

        @Override
        public void setDecLL(long Val) {
            throw new UnsupportedOperationException("Dummy Child Can not be modified");
        }

        @Override
        public void setDecULL(long Val) {
            throw new UnsupportedOperationException("Dummy Child Can not be modified");
        }

        @Override
        public void setDecL(long Val) {
            throw new UnsupportedOperationException("Dummy Child Can not be modified");
        }

        @Override
        public void setDecUL(long Val) {
            throw new UnsupportedOperationException("Dummy Child Can not be modified");
        }

        @Override
        public void setDecI(long Val) {
            throw new UnsupportedOperationException("Dummy Child Can not be modified");
        }

        @Override
        public void setDecUI(long Val) {
            throw new UnsupportedOperationException("Dummy Child Can not be modified");
        }

        @Override
        public void setCharacter(byte Val) {
            throw new UnsupportedOperationException("Dummy Child Can not be modified");
        }

        @Override
        public void setStringRef(StringRef stringRef) {
            throw new UnsupportedOperationException("Dummy Child Can not be modified");
        }

        @Override
        public void setStdString(std.string stdString) {
            throw new UnsupportedOperationException("Dummy Child Can not be modified");
        }

        @Override
        public void setCString(char.ptr cString) {
            throw new UnsupportedOperationException("Dummy Child Can not be modified");
        }

        @Override
        public void setTwine(Twine twine) {
            throw new UnsupportedOperationException("Dummy Child Can not be modified");
        }
    }

    private static class Child {
        private Object refVal;
        private long numVal;

        public Child() {
        }

        public Child(Child $Prm0) {
            this.$assign($Prm0);
        }

        public Child $assign(Child $Prm0) {
            this.numVal = $Prm0.numVal;
            this.refVal = $Prm0.refVal;
            return this;
        }

        public Twine getTwine() {
            return (Twine)this.refVal;
        }

        public void setTwine(Twine twine) {
            this.refVal = twine;
        }

        public char.ptr getCString() {
            return (char.ptr)this.refVal;
        }

        public void setCString(char.ptr cString) {
            this.refVal = cString;
        }

        public std.string getStdString() {
            return (std.string)this.refVal;
        }

        public void setStdString(std.string stdString) {
            this.refVal = stdString;
        }

        public StringRef getStringRef() {
            return (StringRef)this.refVal;
        }

        public void setStringRef(StringRef stringRef) {
            this.refVal = stringRef;
        }

        public byte getCharacter() {
            return (byte)this.numVal;
        }

        public void setCharacter(byte Val) {
            this.numVal = Val;
        }

        public long getDecUI() {
            return this.numVal;
        }

        public void setDecUI(long Val) {
            this.numVal = Val;
        }

        public int getDecI() {
            return (int)this.numVal;
        }

        public void setDecI(long Val) {
            this.numVal = Val;
        }

        public long getDecUL() {
            return this.numVal;
        }

        public void setDecUL(long Val) {
            this.numVal = Val;
        }

        public long getDecL() {
            return this.numVal;
        }

        public void setDecL(long Val) {
            this.numVal = Val;
        }

        public long getDecULL() {
            return this.numVal;
        }

        public void setDecULL(long Val) {
            this.numVal = Val;
        }

        public long getDecLL() {
            return this.numVal;
        }

        public void setDecLL(long Val) {
            this.numVal = Val;
        }

        public long getUHex() {
            return this.numVal;
        }

        public void setUHex(long Val) {
            this.numVal = Val;
        }
    }

    private static final class NodeKind {
        public static final short NullKind = 0;
        public static final short EmptyKind = 1;
        public static final short TwineKind = 2;
        public static final short CStringKind = 3;
        public static final short StdStringKind = 4;
        public static final short StringRefKind = 5;
        public static final short CharKind = 6;
        public static final short DecUIKind = 7;
        public static final short DecIKind = 8;
        public static final short DecULKind = 9;
        public static final short DecLKind = 10;
        public static final short DecULLKind = 11;
        public static final short DecLLKind = 12;
        public static final short UHexKind = 13;

        private NodeKind() {
        }
    }
}

