/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Arrays;
import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.Native;
import org.clank.support.NativeMemory;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.llvm.adt.NoneType;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.support.llvm;

public class ArrayRef<T>
implements Iterable<T> {
    private static final ArrayRef NONE;
    private type.ptr<T> Data;
    private int Length;
    private final boolean isDataPointerLike;

    public static <T> ArrayRef<T> None() {
        return NONE;
    }

    public ArrayRef() {
        this.Data = NativePointer.create_type$ptr((Object[])null);
        this.Length = 0;
        this.isDataPointerLike = false;
    }

    public ArrayRef(NoneType $Prm0) {
        this.Data = NativePointer.create_type$ptr((Object[])null);
        this.Length = 0;
        this.isDataPointerLike = false;
        if (NONE != null) {
            new Exception("use ArrayRef.None() instead").printStackTrace(System.err);
        }
    }

    public ArrayRef(T OneElt) {
        this(OneElt, false);
    }

    public ArrayRef(T OneElt, boolean isDataPointerLike) {
        this.Data = NativePointer.create_type$ptr((Object[])Arrays.asList(OneElt).toArray());
        this.Length = 1;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRef(T[] data, long length) {
        this(data, length, false);
    }

    public ArrayRef(T[] data, long length, boolean isDataPointerLike) {
        this(NativePointer.create_type$ptr((Object[])data), length, isDataPointerLike);
    }

    public ArrayRef(T[] data, int length) {
        this(data, length, false);
    }

    public ArrayRef(T[] data, int length, boolean isDataPointerLike) {
        this(NativePointer.create_type$ptr((Object[])data), length, isDataPointerLike);
    }

    public ArrayRef(type.ptr<T> data, long length) {
        this(data, length, false);
    }

    public ArrayRef(type.ptr<T> data, long length, boolean isDataPointerLike) {
        this(data, Unsigned.long2uint((long)length), isDataPointerLike);
    }

    public ArrayRef(type.ptr<T> data, int length) {
        this(data, length, false);
    }

    public ArrayRef(type.ptr<T> data, int length, boolean isDataPointerLike) {
        this.Data = (type.ptr)data.clone();
        this.Length = length;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRef(type.ptr<T> begin, type.ptr<T> end) {
        this(begin, end, false);
    }

    public ArrayRef(type.ptr<T> begin, type.ptr<T> end, boolean isDataPointerLike) {
        this.Data = (type.ptr)begin.clone();
        this.Length = end.$sub(begin);
        this.isDataPointerLike = isDataPointerLike;
    }

    public <U> ArrayRef(SmallVectorImpl<T> Vec) {
        this.Data = (type.ptr)Vec.data().clone();
        this.Length = Vec.size();
        this.isDataPointerLike = Vec.isDataPointerLike();
    }

    public <A> ArrayRef(std.vector<T> Vec) {
        this.Data = Vec.data();
        this.Length = Vec.size();
        this.isDataPointerLike = Vec.isDataPointerLike();
    }

    public ArrayRef(std.vectorString Vec) {
        this.Data = Vec.data();
        this.Length = Vec.size();
        this.isDataPointerLike = Vec.isDataPointerLike();
    }

    public ArrayRef(T[] Arr) {
        this(Arr, false);
    }

    public ArrayRef(T[] Arr, boolean isDataPointerLike) {
        this.Data = NativePointer.create_type$ptr((Object[])Arr);
        this.Length = Arr.length;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRef(ArrayRef<T> other) {
        this.Data = (type.ptr)Native.$tryClone(other.data());
        this.Length = other.size();
        this.isDataPointerLike = other.isDataPointerLike;
    }

    public type.ptr<T> begin() {
        return this.Data;
    }

    public type.ptr<T> end() {
        return (type.ptr)this.Data.$add(this.Length);
    }

    public std.reverse_iterator<T> rbegin() {
        return new std.reverse_iterator(this.end());
    }

    public std.reverse_iterator<T> rend() {
        return new std.reverse_iterator(this.begin());
    }

    public boolean empty() {
        return this.Length == 0;
    }

    public type.ptr<T> data() {
        return this.Data;
    }

    public int size() {
        return this.Length;
    }

    public T front() {
        return (T)this.Data.$at(0);
    }

    public T back() {
        return (T)this.Data.$at(this.Length - 1);
    }

    public ArrayRef<T> copy(Class<T> cls, NativeMemory.Allocator A) {
        type.ptr Buff = (type.ptr)A.Allocate(cls, this.Length);
        std.copy(this.begin(), this.end(), (type.iterator)Buff);
        return new ArrayRef<T>(Buff, this.Length, this.isDataPointerLike);
    }

    public boolean equals(ArrayRef<T> RHS) {
        if (Native.$noteq((int)this.Length, (int)RHS.Length)) {
            return false;
        }
        type.ptr<T> L = this.begin();
        type.ptr<T> LE = this.end();
        type.ptr<T> R = RHS.begin();
        while (L.$noteq(LE)) {
            if (!Native.$eq((Object)L.$star(), (Object)R.$star(), (boolean)this.isDataPointerLike)) {
                return false;
            }
            L.$preInc();
            R.$preInc();
        }
        return true;
    }

    public ArrayRef<T> slice(int N) {
        return new ArrayRef<T>((type.ptr)this.data().$add(N), this.size() - N);
    }

    public ArrayRef<T> slice(int N, int M) {
        return new ArrayRef<T>((type.ptr)this.data().$add(N), M);
    }

    public ArrayRef<T> drop_back() {
        return this.drop_back(1);
    }

    public ArrayRef<T> drop_back(int N) {
        assert (this.size() >= N) : "Dropping more elements than exist";
        return this.slice(0, this.size() - N);
    }

    public T $at(int Index) {
        return (T)this.Data.$at(Index);
    }

    public std.vector<T> vec() {
        return new std.vector(this.Data, (type.iterator)this.Data.$add(this.Length), null);
    }

    public std.vector<T> $vector() {
        return new std.vector(this.Data, (type.iterator)this.Data.$add(this.Length), null);
    }

    public boolean equals(TRefOrNothing ... Args) {
        if (Args.length > 16) {
            throw new IllegalArgumentException("Too many arguments passed!");
        }
        if (this.size() != llvm.array_lengthof(Args)) {
            return false;
        }
        int e = this.size();
        for (int i = 0; i != e; ++i) {
            if (!Native.$noteq(this.$at(i), (Object)Args[i].TPtr, (boolean)this.isDataPointerLike)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.Length == 0) {
            return "<Empty>";
        }
        StringBuilder out = new StringBuilder("\nArRef{");
        String fmt = "%" + (int)Math.ceil(Math.log10(this.Length + 1)) + "d";
        for (int i = 0; i < this.Length; ++i) {
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append("{").append(this.$at(i)).append("}\n");
        }
        out.append("}ArRef\n");
        return out.toString();
    }

    public void $assign(ArrayRef<T> other) {
        this.Data = other.Data;
        this.Length = other.Length;
    }

    @Override
    public Iterator<T> iterator() {
        return new ArrayRefIterator<T>(this.Data, this.Length);
    }

    static {
        ArrayRef obj;
        NONE = obj = new ArrayRef(NoneType.None);
    }

    private static final class ArrayRefIterator<T>
    implements Iterator<T> {
        private final type.ptr<T> localData;
        private final int localLength;
        private int pos = 0;

        public ArrayRefIterator(type.ptr<T> Data, int Length) {
            this.localData = (type.ptr)Native.$tryClone(Data);
            this.localLength = Length;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.localLength;
        }

        @Override
        public T next() {
            Object val = this.localData.$star();
            this.localData.$preInc();
            ++this.pos;
            return (T)val;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    public static class TRefOrNothing {
        public Object TPtr;

        public TRefOrNothing() {
            this.TPtr = null;
        }

        public TRefOrNothing(Object TRef) {
            this.TPtr = TRef;
        }

        public String toString() {
            return "TPtr=" + this.TPtr;
        }
    }
}

