/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.Native;
import org.clank.support.NativeMemory;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.llvm.adt.NoneType;
import org.llvm.adt.aliases.SmallVectorImplChar;
import org.llvm.support.llvm;

public class ArrayRefChar
implements Iterable<Byte> {
    private static final ArrayRefChar NONE;
    private char.ptr Data;
    private int Length;
    private final boolean isDataPointerLike;

    public static ArrayRefChar None() {
        return NONE;
    }

    public ArrayRefChar() {
        this.Data = NativePointer.create_char$ptr((byte[])null);
        this.Length = 0;
        this.isDataPointerLike = false;
    }

    public ArrayRefChar(NoneType $Prm0) {
        this.Data = NativePointer.create_char$ptr((byte[])null);
        this.Length = 0;
        this.isDataPointerLike = false;
        if (NONE != null) {
            new Exception("use ArrayRefChar.None() instead").printStackTrace(System.err);
        }
    }

    public ArrayRefChar(byte OneElt) {
        this(OneElt, false);
    }

    public ArrayRefChar(byte OneElt, boolean isDataPointerLike) {
        this.Data = NativePointer.create_char$ptr((byte[])NativePointer.new$char$elem((byte)OneElt));
        this.Length = 1;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefChar(byte[] data, long length) {
        this(data, length, false);
    }

    public ArrayRefChar(byte[] data, long length, boolean isDataPointerLike) {
        this(NativePointer.create_char$ptr((byte[])data), length, isDataPointerLike);
    }

    public ArrayRefChar(byte[] data, int length) {
        this(data, length, false);
    }

    public ArrayRefChar(byte[] data, int length, boolean isDataPointerLike) {
        this(NativePointer.create_char$ptr((byte[])data), length, isDataPointerLike);
    }

    public ArrayRefChar(char.ptr data, long length) {
        this(data, length, false);
    }

    public ArrayRefChar(char.ptr data, long length, boolean isDataPointerLike) {
        this(data, Unsigned.long2uint((long)length), isDataPointerLike);
    }

    public ArrayRefChar(char.ptr data, int length) {
        this(data, length, false);
    }

    public ArrayRefChar(char.ptr data, int length, boolean isDataPointerLike) {
        this.Data = (char.ptr)data.clone();
        this.Length = length;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefChar(char.ptr begin, char.ptr end) {
        this(begin, end, false);
    }

    public ArrayRefChar(char.ptr begin, char.ptr end, boolean isDataPointerLike) {
        this.Data = (char.ptr)begin.clone();
        this.Length = end.$sub((abstract_iterator)begin);
        this.isDataPointerLike = isDataPointerLike;
    }

    public <U> ArrayRefChar(SmallVectorImplChar Vec) {
        this.Data = (char.ptr)Vec.data().clone();
        this.Length = Vec.size();
        this.isDataPointerLike = Vec.isDataPointerLike();
    }

    public <A> ArrayRefChar(std.vectorChar Vec) {
        this.Data = Vec.data();
        this.Length = Vec.size();
        this.isDataPointerLike = Vec.isDataPointerLike();
    }

    public ArrayRefChar(std.vectorString Vec) {
        this.Data = (char.ptr)Vec.data();
        this.Length = Vec.size();
        this.isDataPointerLike = Vec.isDataPointerLike();
    }

    public ArrayRefChar(byte[] Arr) {
        this(Arr, false);
    }

    public ArrayRefChar(byte[] Arr, boolean isDataPointerLike) {
        this.Data = NativePointer.create_char$ptr((byte[])Arr);
        this.Length = Arr.length;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefChar(ArrayRefChar other) {
        this.Data = Native.$tryClone((char.ptr)other.data());
        this.Length = other.size();
        this.isDataPointerLike = other.isDataPointerLike;
    }

    public char.ptr begin() {
        return this.Data;
    }

    public char.ptr end() {
        return (char.ptr)this.Data.$add(this.Length);
    }

    public std.reverse_iteratorChar rbegin() {
        return new std.reverse_iteratorChar((char.iterator)this.end());
    }

    public std.reverse_iteratorChar rend() {
        return new std.reverse_iteratorChar((char.iterator)this.begin());
    }

    public boolean empty() {
        return this.Length == 0;
    }

    public char.ptr data() {
        return this.Data;
    }

    public int size() {
        return this.Length;
    }

    public byte front() {
        return this.Data.$at(0);
    }

    public byte back() {
        return this.Data.$at(this.Length - 1);
    }

    public ArrayRefChar copy(Class<Byte> cls, NativeMemory.Allocator A) {
        char.ptr Buff = (char.ptr)A.Allocate(cls, this.Length);
        std.copy((char.iterator)this.begin(), (char.iterator)this.end(), (char.iterator)Buff);
        return new ArrayRefChar(Buff, this.Length, this.isDataPointerLike);
    }

    public boolean equals(ArrayRefChar RHS) {
        if (Native.$noteq((int)this.Length, (int)RHS.Length)) {
            return false;
        }
        char.ptr L = this.begin();
        char.ptr LE = this.end();
        char.ptr R = RHS.begin();
        while (L.$noteq((Object)LE)) {
            if (!Native.$eq((byte)L.$star(), (byte)R.$star(), (boolean)this.isDataPointerLike)) {
                return false;
            }
            L.$preInc();
            R.$preInc();
        }
        return true;
    }

    public ArrayRefChar slice(int N) {
        return new ArrayRefChar((char.ptr)this.data().$add(N), this.size() - N);
    }

    public ArrayRefChar slice(int N, int M) {
        return new ArrayRefChar((char.ptr)this.data().$add(N), M);
    }

    public ArrayRefChar drop_back() {
        return this.drop_back(1);
    }

    public ArrayRefChar drop_back(int N) {
        assert (this.size() >= N) : "Dropping more elements than exist";
        return this.slice(0, this.size() - N);
    }

    public byte $at(int Index) {
        return this.Data.$at(Index);
    }

    public std.vectorChar vec() {
        return new std.vectorChar((char.iterator)this.Data, (char.iterator)this.Data.$add(this.Length), 0);
    }

    public std.vectorChar $vector() {
        return new std.vectorChar((char.iterator)this.Data, (char.iterator)this.Data.$add(this.Length), 0);
    }

    public boolean equals(TRefOrNothing ... Args) {
        if (Args.length > 16) {
            throw new IllegalArgumentException("Too many arguments passed!");
        }
        if (this.size() != llvm.array_lengthof(Args)) {
            return false;
        }
        int e = this.size();
        for (int i = 0; i != e; ++i) {
            if (!Native.$noteq((byte)this.$at(i), (byte)Args[i].TPtr, (boolean)this.isDataPointerLike)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.Length == 0) {
            return "<Empty>";
        }
        StringBuilder out = new StringBuilder("\nArRef{");
        String fmt = "%" + (int)Math.ceil(Math.log10(this.Length + 1)) + "d";
        for (int i = 0; i < this.Length; ++i) {
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append("{").append(this.$at(i)).append("}\n");
        }
        out.append("}ArRef\n");
        return out.toString();
    }

    public void $assign(ArrayRefChar other) {
        this.Data = other.Data;
        this.Length = other.Length;
    }

    @Override
    public Iterator<Byte> iterator() {
        return new ArrayRefIterator(this.Data, this.Length);
    }

    static {
        ArrayRefChar obj;
        NONE = obj = new ArrayRefChar(NoneType.None);
    }

    private static final class ArrayRefIterator
    implements Iterator<Byte> {
        private final char.ptr localData;
        private final int localLength;
        private int pos = 0;

        public ArrayRefIterator(char.ptr Data, int Length) {
            this.localData = Native.$tryClone((char.ptr)Data);
            this.localLength = Length;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.localLength;
        }

        @Override
        public Byte next() {
            Byte val = this.localData.$star();
            this.localData.$preInc();
            ++this.pos;
            return val;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    public static class TRefOrNothing {
        public byte TPtr;

        public TRefOrNothing() {
            this.TPtr = 0;
        }

        public TRefOrNothing(byte TRef) {
            this.TPtr = TRef;
        }

        public String toString() {
            return "TPtr=" + this.TPtr;
        }
    }
}

