/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativeMemory;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.int;
import org.llvm.adt.NoneType;
import org.llvm.adt.aliases.SmallVectorImplInt;
import org.llvm.support.llvm;

public class ArrayRefInt
implements Iterable<Integer> {
    private static final ArrayRefInt NONE;
    private int.ptr Data;
    private int Length;
    private final boolean isDataPointerLike;

    public static ArrayRefInt None() {
        return NONE;
    }

    public ArrayRefInt() {
        this.Data = NativePointer.create_int$ptr((int[])null);
        this.Length = 0;
        this.isDataPointerLike = false;
    }

    public ArrayRefInt(NoneType $Prm0) {
        this.Data = NativePointer.create_int$ptr((int[])null);
        this.Length = 0;
        this.isDataPointerLike = false;
        if (NONE != null) {
            new Exception("use ArrayRefInt.None() instead").printStackTrace(System.err);
        }
    }

    public ArrayRefInt(int OneElt) {
        this(OneElt, false);
    }

    public ArrayRefInt(int OneElt, boolean isDataPointerLike) {
        this.Data = NativePointer.create_int$ptr((int[])NativePointer.new$int$elem((int)OneElt));
        this.Length = 1;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefInt(int[] data, long length) {
        this(data, length, false);
    }

    public ArrayRefInt(int[] data, long length, boolean isDataPointerLike) {
        this(NativePointer.create_int$ptr((int[])data), length, isDataPointerLike);
    }

    public ArrayRefInt(int[] data, int length) {
        this(data, length, false);
    }

    public ArrayRefInt(int[] data, int length, boolean isDataPointerLike) {
        this(NativePointer.create_int$ptr((int[])data), length, isDataPointerLike);
    }

    public ArrayRefInt(int.ptr data, long length) {
        this(data, length, false);
    }

    public ArrayRefInt(int.ptr data, long length, boolean isDataPointerLike) {
        this(data, Unsigned.long2uint((long)length), isDataPointerLike);
    }

    public ArrayRefInt(int.ptr data, int length) {
        this(data, length, false);
    }

    public ArrayRefInt(int.ptr data, int length, boolean isDataPointerLike) {
        this.Data = (int.ptr)data.clone();
        this.Length = length;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefInt(int.ptr begin, int.ptr end) {
        this(begin, end, false);
    }

    public ArrayRefInt(int.ptr begin, int.ptr end, boolean isDataPointerLike) {
        this.Data = (int.ptr)begin.clone();
        this.Length = end.$sub((abstract_iterator)begin);
        this.isDataPointerLike = isDataPointerLike;
    }

    public <U> ArrayRefInt(SmallVectorImplInt Vec) {
        this.Data = (int.ptr)Vec.data().clone();
        this.Length = Vec.size();
        this.isDataPointerLike = Vec.isDataPointerLike();
    }

    public <A> ArrayRefInt(std.vectorInt Vec) {
        this.Data = Vec.data();
        this.Length = Vec.size();
        this.isDataPointerLike = Vec.isDataPointerLike();
    }

    public ArrayRefInt(std.vectorString Vec) {
        this.Data = (int.ptr)Vec.data();
        this.Length = Vec.size();
        this.isDataPointerLike = Vec.isDataPointerLike();
    }

    public ArrayRefInt(int[] Arr) {
        this(Arr, false);
    }

    public ArrayRefInt(int[] Arr, boolean isDataPointerLike) {
        this.Data = NativePointer.create_int$ptr((int[])Arr);
        this.Length = Arr.length;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefInt(ArrayRefInt other) {
        this.Data = (int.ptr)Native.$tryClone((NativeCloneable)other.data());
        this.Length = other.size();
        this.isDataPointerLike = other.isDataPointerLike;
    }

    public int.ptr begin() {
        return this.Data;
    }

    public int.ptr end() {
        return (int.ptr)this.Data.$add(this.Length);
    }

    public std.reverse_iteratorInt rbegin() {
        return new std.reverse_iteratorInt((int.iterator)this.end());
    }

    public std.reverse_iteratorInt rend() {
        return new std.reverse_iteratorInt((int.iterator)this.begin());
    }

    public boolean empty() {
        return this.Length == 0;
    }

    public int.ptr data() {
        return this.Data;
    }

    public int size() {
        return this.Length;
    }

    public int front() {
        return this.Data.$at(0);
    }

    public int back() {
        return this.Data.$at(this.Length - 1);
    }

    public ArrayRefInt copy(Class<Integer> cls, NativeMemory.Allocator A) {
        int.ptr Buff = (int.ptr)A.Allocate(cls, this.Length);
        std.copy((int.iterator)this.begin(), (int.iterator)this.end(), (int.iterator)Buff);
        return new ArrayRefInt(Buff, this.Length, this.isDataPointerLike);
    }

    public boolean equals(ArrayRefInt RHS) {
        if (Native.$noteq((int)this.Length, (int)RHS.Length)) {
            return false;
        }
        int.ptr L = this.begin();
        int.ptr LE = this.end();
        int.ptr R = RHS.begin();
        while (L.$noteq((Object)LE)) {
            if (!Native.$eq((int)L.$star(), (int)R.$star(), (boolean)this.isDataPointerLike)) {
                return false;
            }
            L.$preInc();
            R.$preInc();
        }
        return true;
    }

    public ArrayRefInt slice(int N) {
        return new ArrayRefInt((int.ptr)this.data().$add(N), this.size() - N);
    }

    public ArrayRefInt slice(int N, int M) {
        return new ArrayRefInt((int.ptr)this.data().$add(N), M);
    }

    public ArrayRefInt drop_back() {
        return this.drop_back(1);
    }

    public ArrayRefInt drop_back(int N) {
        assert (this.size() >= N) : "Dropping more elements than exist";
        return this.slice(0, this.size() - N);
    }

    public int $at(int Index) {
        return this.Data.$at(Index);
    }

    public std.vectorInt vec() {
        return new std.vectorInt((int.iterator)this.Data, (int.iterator)this.Data.$add(this.Length), 0);
    }

    public std.vectorInt $vector() {
        return new std.vectorInt((int.iterator)this.Data, (int.iterator)this.Data.$add(this.Length), 0);
    }

    public boolean equals(TRefOrNothing ... Args) {
        if (Args.length > 16) {
            throw new IllegalArgumentException("Too many arguments passed!");
        }
        if (this.size() != llvm.array_lengthof(Args)) {
            return false;
        }
        int e = this.size();
        for (int i = 0; i != e; ++i) {
            if (!Native.$noteq((int)this.$at(i), (int)Args[i].TPtr, (boolean)this.isDataPointerLike)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.Length == 0) {
            return "<Empty>";
        }
        StringBuilder out = new StringBuilder("\nArRef{");
        String fmt = "%" + (int)Math.ceil(Math.log10(this.Length + 1)) + "d";
        for (int i = 0; i < this.Length; ++i) {
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append("{").append(this.$at(i)).append("}\n");
        }
        out.append("}ArRef\n");
        return out.toString();
    }

    public void $assign(ArrayRefInt other) {
        this.Data = other.Data;
        this.Length = other.Length;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new ArrayRefIterator(this.Data, this.Length);
    }

    static {
        ArrayRefInt obj;
        NONE = obj = new ArrayRefInt(NoneType.None);
    }

    private static final class ArrayRefIterator
    implements Iterator<Integer> {
        private final int.ptr localData;
        private final int localLength;
        private int pos = 0;

        public ArrayRefIterator(int.ptr Data, int Length) {
            this.localData = (int.ptr)Native.$tryClone((NativeCloneable)Data);
            this.localLength = Length;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.localLength;
        }

        @Override
        public Integer next() {
            Integer val = this.localData.$star();
            this.localData.$preInc();
            ++this.pos;
            return val;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    public static class TRefOrNothing {
        public int TPtr;

        public TRefOrNothing() {
            this.TPtr = 0;
        }

        public TRefOrNothing(int TRef) {
            this.TPtr = TRef;
        }

        public String toString() {
            return "TPtr=" + this.TPtr;
        }
    }
}

