/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeMemory;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.llvm.adt.StringMapEntryBase;
import org.llvm.adt.StringMapImpl;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.StringMapEntryChar;
import org.llvm.adt.aliases.StringMapIteratorChar;
import org.llvm.support.StringMapBumpPtrAllocator;
import org.llvm.support.llvm;

public class StringMapChar<AllocatorTy extends NativeMemory.Allocator>
extends StringMapImpl
implements Destructors.ClassWithDestructor {
    private AllocatorTy Allocator;
    private final byte defaultValue;

    public StringMapChar(byte defaultValue) {
        super(StringMapEntryChar.$sizeof_StringMapEntryChar());
        this.defaultValue = defaultValue;
        this.Allocator = new StringMapBumpPtrAllocator();
    }

    public StringMapChar(long InitialSize, byte defaultValue) {
        super(InitialSize, StringMapEntryChar.$sizeof_StringMapEntryChar());
        this.defaultValue = defaultValue;
        this.Allocator = new StringMapBumpPtrAllocator();
    }

    public StringMapChar(AllocatorTy A, byte defaultValue) {
        super(StringMapEntryChar.$sizeof_StringMapEntryChar());
        assert (A != null);
        this.Allocator = A;
        this.defaultValue = defaultValue;
    }

    public StringMapChar(long InitialSize, AllocatorTy A, byte defaultValue) {
        super(InitialSize, StringMapEntryChar.$sizeof_StringMapEntryChar());
        assert (A != null);
        this.Allocator = A;
        this.defaultValue = defaultValue;
    }

    public StringMapChar(StringMapChar<AllocatorTy> RHS, byte defaultValue) {
        super(StringMapEntryChar.$sizeof_StringMapEntryChar());
        this.defaultValue = defaultValue;
        if (!RHS.empty()) {
            throw new AssertionError((Object)"Copy ctor from non-empty stringmap not implemented yet!");
        }
        this.Allocator = new StringMapBumpPtrAllocator();
    }

    public StringMapChar(JavaDifferentiators.Move _dparam, StringMapChar<AllocatorTy> RHS) {
        super((StringMapImpl)std.move(RHS));
        this.Allocator = RHS.Allocator;
        this.defaultValue = RHS.defaultValue;
    }

    public StringMapChar<AllocatorTy> $assign(StringMapChar<AllocatorTy> RHS) {
        super.swap(RHS);
        AllocatorTy tmp = this.Allocator;
        this.Allocator = RHS.Allocator;
        RHS.Allocator = tmp;
        return this;
    }

    public AllocatorTy getAllocator() {
        return this.Allocator;
    }

    public StringMapIteratorChar begin() {
        return new StringMapIteratorChar(this.TheTable, 0, this.NumBuckets == 0);
    }

    public StringMapIteratorChar end() {
        return new StringMapIteratorChar(this.TheTable, this.NumBuckets, true);
    }

    public StringMapIteratorChar find(StringRef Key) {
        int Bucket = this.FindKey(Key);
        if (Bucket == -1) {
            return this.end();
        }
        return new StringMapIteratorChar(this.TheTable, Bucket, true);
    }

    public byte lookup(StringRef Key) {
        return this.lookup(Key.data(), Key.size());
    }

    public byte lookup(char.ptr Key, int KeyLen) {
        int Bucket = this.FindKey(Key, KeyLen);
        if (Bucket != -1) {
            return ((StringMapEntryChar)this.TheTable[Bucket]).getValue();
        }
        return Native.$tryClone((byte)this.defaultValue);
    }

    public byte $at(StringRef Key) {
        return this.GetOrCreateValue(Key).getValue();
    }

    public char.ref ref$at(StringRef Key) {
        return this.GetOrCreateValue(Key).getValue$Ref();
    }

    public int count(StringRef Key) {
        return this.FindKey(Key) == -1 ? 0 : 1;
    }

    public std.pairTypeBool<StringMapIteratorChar> insert(std.pairTypeChar<StringRef> KV) {
        int FullHashValue;
        int keyLength;
        char.ptr keyData = ((StringRef)KV.first).data();
        int BucketNo = this.LookupBucketFor(keyData, keyLength = ((StringRef)KV.first).size(), FullHashValue = llvm.HashString(keyData, keyLength));
        StringMapEntryBase Bucket = this.TheTable[BucketNo];
        if (Bucket != null && Bucket != StringMapChar.getTombstoneVal()) {
            return std.make_pair((Object)new StringMapIteratorChar(this.TheTable, BucketNo, false), (boolean)false);
        }
        if (Bucket == StringMapChar.getTombstoneVal()) {
            --this.NumTombstones;
        }
        this.TheTable[BucketNo] = Bucket = StringMapEntryChar.Create(keyData, keyLength, FullHashValue, this.Allocator, (Byte)std.move((Object)KV.second));
        ++this.NumItems;
        assert (this.NumItems + this.NumTombstones <= this.NumBuckets);
        BucketNo = this.RehashTable(BucketNo);
        return std.make_pair((Object)new StringMapIteratorChar(this.TheTable, BucketNo, false), (boolean)true);
    }

    public boolean insert(StringMapEntryChar KeyValue) {
        int FullHashValue;
        int keyLength;
        char.ptr keyData = KeyValue.getKeyData();
        int BucketNo = this.LookupBucketFor(keyData, keyLength = KeyValue.getKeyLength(), FullHashValue = llvm.HashString(keyData, keyLength));
        StringMapEntryBase Bucket = this.TheTable[BucketNo];
        if (Bucket != null && Bucket != StringMapChar.getTombstoneVal()) {
            return false;
        }
        if (Bucket == StringMapChar.getTombstoneVal()) {
            --this.NumTombstones;
        }
        this.TheTable[BucketNo] = Bucket = KeyValue;
        ++this.NumItems;
        assert (this.NumItems + this.NumTombstones <= this.NumBuckets);
        this.RehashTable();
        return true;
    }

    public void clear() {
        if (this.empty()) {
            return;
        }
        int E = this.NumBuckets;
        for (int I = 0; I != E; ++I) {
            StringMapEntryBase Bucket = this.TheTable[I];
            this.TheTable[I] = null;
        }
        this.NumItems = 0;
        this.NumTombstones = 0;
        this.Allocator.Reset();
    }

    public StringMapEntryChar GetOrCreateValue(StringRef Key, byte Val) {
        return this.GetOrCreateValue(Key.data(), Key.size(), Val);
    }

    public StringMapEntryChar GetOrCreateValue(char.ptr Key, int Len, byte Val) {
        int FullHashValue = llvm.HashString(Key, Len);
        int BucketNo = this.LookupBucketFor(Key, Len, FullHashValue);
        StringMapEntryBase Bucket = this.TheTable[BucketNo];
        if (Bucket != null && Bucket != StringMapChar.getTombstoneVal()) {
            return (StringMapEntryChar)Bucket;
        }
        if (Val == this.defaultValue) {
            Val = Native.$tryClone((byte)Val);
        }
        StringMapEntryChar NewItem = StringMapEntryChar.Create(Key, Len, FullHashValue, this.Allocator, Val);
        if (Bucket == StringMapChar.getTombstoneVal()) {
            --this.NumTombstones;
        }
        ++this.NumItems;
        assert (this.NumItems + this.NumTombstones <= this.NumBuckets);
        this.TheTable[BucketNo] = Bucket = NewItem;
        this.RehashTable();
        return (StringMapEntryChar)Bucket;
    }

    private StringMapEntryChar GetOrCreateValue(byte[] Key, int KeyStIndex, int Len, byte Val) {
        int FullHashValue = llvm.HashString(Key, KeyStIndex, Len);
        int BucketNo = this.LookupBucketFor(Key, KeyStIndex, Len, FullHashValue);
        StringMapEntryBase Bucket = this.TheTable[BucketNo];
        if (Bucket != null && Bucket != StringMapChar.getTombstoneVal()) {
            return (StringMapEntryChar)Bucket;
        }
        if (Val == this.defaultValue) {
            Val = Native.$tryClone((byte)Val);
        }
        StringMapEntryChar NewItem = StringMapEntryChar.Create(Key, KeyStIndex, Len, FullHashValue, this.Allocator, Val);
        if (Bucket == StringMapChar.getTombstoneVal()) {
            --this.NumTombstones;
        }
        ++this.NumItems;
        assert (this.NumItems + this.NumTombstones <= this.NumBuckets);
        this.TheTable[BucketNo] = Bucket = NewItem;
        this.RehashTable();
        return (StringMapEntryChar)Bucket;
    }

    public StringMapEntryChar GetOrCreateValue(StringRef Key) {
        return this.GetOrCreateValue(Key, this.defaultValue);
    }

    public StringMapEntryChar GetOrCreateValue(char.ptr Key, int Len) {
        return this.GetOrCreateValue(Key, Len, this.defaultValue);
    }

    public StringMapEntryChar GetOrCreateValue(byte[] Key, int KeyStIndex, int Len) {
        return this.GetOrCreateValue(Key, KeyStIndex, Len, this.defaultValue);
    }

    public void remove(StringMapEntryChar KeyValue) {
        this.RemoveKey(KeyValue);
    }

    public void erase(StringMapIteratorChar I) {
        StringMapEntryChar V = I.$star();
        this.remove(V);
        V.Destroy(this.Allocator);
    }

    public boolean erase(StringRef Key) {
        StringMapIteratorChar I = this.find(Key);
        if (Native.$eq((abstract_iterator)I, (abstract_iterator)this.end())) {
            return false;
        }
        this.erase(I);
        return true;
    }

    public void $destroy() {
        this.clear();
        std.free((Object)this.TheTable);
        Destructors.$destroy(this.Allocator);
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        StringMapIteratorChar B = this.begin();
        StringMapIteratorChar E = this.end();
        while (B.$noteq(E)) {
            out.append("{").append(B.$star().first()).append("=>").append(B.$star().getValue()).append("}\n");
            B.$preInc();
        }
        return out.toString();
    }
}

