/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.cl;

import org.clank.java.std;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.int;
import org.clank.support.aliases.type;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.aliases.StringMap;
import org.llvm.adt.aliases.StringMapIterator;
import org.llvm.cl.FormattingFlags;
import org.llvm.cl.LocationClass;
import org.llvm.cl.NumOccurrencesFlag;
import org.llvm.cl.Option;
import org.llvm.cl.OptionCategory;
import org.llvm.cl.OptionValue;
import org.llvm.cl.StringSaver;
import org.llvm.cl.ValuesClass;
import org.llvm.cl.basic_parser;
import org.llvm.cl.generic_parser_base;
import org.llvm.cl.impl.CommandLineStatics;
import org.llvm.cl.impl.StrDupSaver;
import org.llvm.cl.initializer;
import org.llvm.support.MallocAllocator;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.sys.path;

public final class ClGlobals {
    public static final TokenizerCallback TokenizeGNUCommandLineCallback = new TokenizerCallback(){

        @Override
        public void $call(StringRef Source, StringSaver Saver, SmallVectorImpl<char.ptr> NewArgv, boolean MarkEOLs) {
            ClGlobals.TokenizeGNUCommandLine(Source, Saver, NewArgv);
        }
    };
    public static final TokenizerCallback TokenizeWindowsCommandLineCallback = new TokenizerCallback(){

        @Override
        public void $call(StringRef Source, StringSaver Saver, SmallVectorImpl<char.ptr> NewArgv, boolean MarkEOLs) {
            ClGlobals.TokenizeWindowsCommandLine(Source, Saver, NewArgv);
        }
    };
    public static final OptionCategory GeneralCategory = new OptionCategory("General options");

    public static void ParseCommandLineOptions(int argc, type.ptr<char.ptr> argv) {
        ClGlobals.ParseCommandLineOptions(argc, argv, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ParseCommandLineOptions(int argc, type.ptr<char.ptr> argv, char.ptr Overview) {
        SmallVector<Object> PositionalOpts = null;
        SmallVector<Object> SinkOpts = null;
        StringMap Opts = null;
        SmallVector<Object> newArgv = null;
        StrDupSaver Saver = null;
        SmallVector<std.pairTypeUInt> PositionalVals = null;
        try {
            PositionalOpts = new SmallVector<Object>(4, null);
            SinkOpts = new SmallVector<Object>(4, null);
            Opts = new StringMap(null);
            CommandLineStatics.GetOptionInfo(PositionalOpts, SinkOpts, Opts);
            assert (!Opts.empty() || !PositionalOpts.empty()) : "No options specified!";
            newArgv = new SmallVector<Object>(20, null);
            for (int i = 0; i != argc; ++i) {
                newArgv.push_back(argv.$at(i));
            }
            Saver = new StrDupSaver();
            ClGlobals.ExpandResponseFiles(Saver, TokenizeGNUCommandLineCallback, newArgv);
            argv = (type.ptr)Native.$tryClone((NativeCloneable)((char.ptr)newArgv.$at(0)).$addr());
            argc = newArgv.size();
            std.string ProgName = path.filename(new StringRef((char.ptr)argv.$at(0))).$basic_string();
            int Len = std.min((int)ProgName.size(), (int)79);
            std.memcpy((char.ptr)CommandLineStatics.ProgramName, (char.ptr)ProgName.data(), (int)Len);
            CommandLineStatics.ProgramName.$set(Len, NativePointer.$((char)'\u0000'));
            CommandLineStatics.ProgramOverview = Native.$tryClone((char.ptr)Overview);
            boolean ErrorParsing = false;
            long NumPositionalRequired = 0L;
            boolean HasUnlimitedPositionals = false;
            Option ConsumeAfterOpt = null;
            if (!PositionalOpts.empty()) {
                if (((Option)PositionalOpts.$at(0)).getNumOccurrencesFlag() == NumOccurrencesFlag.ConsumeAfter) {
                    assert (PositionalOpts.size() > 1) : "Cannot specify cl::ConsumeAfter without a positional argument!";
                    ConsumeAfterOpt = (Option)PositionalOpts.$at(0);
                }
                boolean UnboundedFound = false;
                long e = PositionalOpts.size();
                for (long i = (long)(ConsumeAfterOpt != null ? 1 : 0); i != e; ++i) {
                    Option Opt = (Option)PositionalOpts.$at(i);
                    if (CommandLineStatics.RequiresValue(Opt)) {
                        ++NumPositionalRequired;
                    } else if (ConsumeAfterOpt != null) {
                        if (PositionalOpts.size() > 2) {
                            ErrorParsing |= Opt.error(new Twine("error - this positional option will never be matched, because it does not Require a value, and a cl::ConsumeAfter option is active!"));
                        }
                    } else if (UnboundedFound && Opt.ArgStr.$at(0) == 0) {
                        ErrorParsing |= Opt.error(new Twine("error - option can never match, because another positional argument will match an unbounded number of values, and this option does not require a value!"));
                    }
                    UnboundedFound |= CommandLineStatics.EatsUnboundedNumberOfValues(Opt);
                }
                HasUnlimitedPositionals = UnboundedFound || ConsumeAfterOpt != null;
            }
            PositionalVals = new SmallVector<std.pairTypeUInt>(4, new std.pairTypeUInt((Object)new StringRef(), 0L));
            Option ActivePositionalArg = null;
            boolean DashDashFound = false;
            for (int i = 1; i < argc; ++i) {
                std.string NearestHandlerString = null;
                try {
                    Option Handler = null;
                    Option NearestHandler = null;
                    NearestHandlerString = new std.string();
                    StringRef Value = new StringRef();
                    StringRef ArgName = StringRef.EMPTY;
                    if (CommandLineStatics.OptionListChanged) {
                        PositionalOpts.clear();
                        SinkOpts.clear();
                        Opts.clear();
                        CommandLineStatics.GetOptionInfo(PositionalOpts, SinkOpts, Opts);
                        CommandLineStatics.OptionListChanged = false;
                    }
                    if (((char.ptr)argv.$at(i)).$at(0) != NativePointer.$((char)'-') || ((char.ptr)argv.$at(i)).$at(1) == 0 || DashDashFound) {
                        if (ActivePositionalArg != null) {
                            CommandLineStatics.ProvidePositionalOption(ActivePositionalArg, new StringRef((char.ptr)argv.$at(i)), i);
                            continue;
                        }
                        if (!PositionalOpts.empty()) {
                            PositionalVals.push_back(new std.pairTypeUInt(std.make_pair_T_UInt((Object)argv.$at(i), (long)i)));
                            if ((long)PositionalVals.size() < NumPositionalRequired || ConsumeAfterOpt == null) continue;
                            ++i;
                            while (i < argc) {
                                PositionalVals.push_back(new std.pairTypeUInt(std.make_pair_T_UInt((Object)argv.$at(i), (long)i)));
                                ++i;
                            }
                            break;
                        }
                    } else {
                        if (((char.ptr)argv.$at(i)).$at(0) == NativePointer.$((char)'-') && ((char.ptr)argv.$at(i)).$at(1) == NativePointer.$((char)'-') && ((char.ptr)argv.$at(i)).$at(2) == 0 && !DashDashFound) {
                            DashDashFound = true;
                            continue;
                        }
                        if (ActivePositionalArg != null && (ActivePositionalArg.getMiscFlags() & 2L) != 0L) {
                            ArgName.$assign(new StringRef((char.ptr)((char.ptr)argv.$at(i)).$add(1)));
                            while (!ArgName.empty() && ArgName.$at(0) == NativePointer.$((char)'-')) {
                                ArgName.$assign$substr(1);
                            }
                            Handler = CommandLineStatics.LookupOption(ArgName, Value, Opts);
                            if (Handler == null || Handler.getFormattingFlag() != FormattingFlags.Positional) {
                                CommandLineStatics.ProvidePositionalOption(ActivePositionalArg, new StringRef((char.ptr)argv.$at(i)), i);
                                continue;
                            }
                        } else {
                            ArgName.$assign(new StringRef((char.ptr)((char.ptr)argv.$at(i)).$add(1)));
                            while (!ArgName.empty() && ArgName.$at(0) == NativePointer.$((char)'-')) {
                                ArgName.$assign$substr(1);
                            }
                            Handler = CommandLineStatics.LookupOption(ArgName, Value, Opts);
                            if (Handler == null) {
                                bool.ref ErrorParsingRef = NativePointer.create_bool$ref((boolean)ErrorParsing);
                                Handler = CommandLineStatics.HandlePrefixedOrGroupedOption(ArgName, Value, ErrorParsingRef, Opts);
                                ErrorParsing = ErrorParsingRef.$deref();
                            }
                            if (Handler == null && SinkOpts.empty()) {
                                NearestHandler = CommandLineStatics.LookupNearestOption(ArgName, Opts, NearestHandlerString);
                            }
                        }
                    }
                    if (Handler == null) {
                        if (SinkOpts.empty()) {
                            llvm.errs().$out(CommandLineStatics.ProgramName).$out(": Unknown command line argument '").$out((char.ptr)argv.$at(i)).$out("'.  Try: '").$out((char.ptr)argv.$at(0)).$out(" -help'\n");
                            if (NearestHandler != null) {
                                llvm.errs().$out(CommandLineStatics.ProgramName).$out(": Did you mean '-").$out(NearestHandlerString).$out("'?\n");
                            }
                            ErrorParsing = true;
                            continue;
                        }
                        SmallVectorImpl.iterator I = (SmallVectorImpl.iterator)Native.$tryClone(SinkOpts.begin());
                        SmallVectorImpl.iterator E = (SmallVectorImpl.iterator)Native.$tryClone(SinkOpts.end());
                        while (I.$noteq(E)) {
                            ((Option)I.$star()).addOccurrence(i, StringRef.EMPTY, new StringRef((char.ptr)argv.$at(i)));
                            I.$preInc();
                        }
                        continue;
                    }
                    if (Handler.getFormattingFlag() == FormattingFlags.Positional) {
                        ActivePositionalArg = Handler;
                        continue;
                    }
                    int.ref iRef = NativePointer.create_int$ref((int)i);
                    ErrorParsing |= CommandLineStatics.ProvideOption(Handler, ArgName, Value, argc, (type.ptr<char.ptr>)argv, iRef);
                    i = iRef.$deref();
                    continue;
                }
                finally {
                    if (NearestHandlerString != null) {
                        NearestHandlerString.$destroy();
                    }
                }
            }
            if (NumPositionalRequired > (long)PositionalVals.size()) {
                llvm.errs().$out(CommandLineStatics.ProgramName).$out(": Not enough positional command line arguments specified!\n").$out("Must specify at least ").$out(NumPositionalRequired).$out(" positional arguments: See: ").$out((char.ptr)argv.$at(0)).$out(" -help\n");
                ErrorParsing = true;
            } else if (!HasUnlimitedPositionals && PositionalVals.size() > PositionalOpts.size()) {
                llvm.errs().$out(CommandLineStatics.ProgramName).$out(": Too many positional arguments specified!\n").$out("Can specify at most ").$out(PositionalOpts.size()).$out(" positional arguments: See: ").$out((char.ptr)argv.$at(0)).$out(" -help\n");
                ErrorParsing = true;
            } else if (ConsumeAfterOpt == null) {
                long ValNo = 0L;
                long NumVals = PositionalVals.size();
                long e = PositionalOpts.size();
                for (long i = 0L; i != e; ++i) {
                    boolean Done;
                    if (CommandLineStatics.RequiresValue((Option)PositionalOpts.$at(i))) {
                        CommandLineStatics.ProvidePositionalOption((Option)PositionalOpts.$at(i), (StringRef)((std.pairTypeUInt)PositionalVals.$at((long)ValNo)).first, ((std.pairTypeUInt)PositionalVals.$at((long)ValNo)).second);
                        ++ValNo;
                        --NumPositionalRequired;
                    }
                    boolean bl = Done = ((Option)PositionalOpts.$at(i)).getNumOccurrencesFlag() == NumOccurrencesFlag.Required;
                    block26: while (NumVals - ValNo > NumPositionalRequired && !Done) {
                        switch (((Option)PositionalOpts.$at(i)).getNumOccurrencesFlag()) {
                            case Optional: {
                                Done = true;
                            }
                            case ZeroOrMore: 
                            case OneOrMore: {
                                CommandLineStatics.ProvidePositionalOption((Option)PositionalOpts.$at(i), (StringRef)((std.pairTypeUInt)PositionalVals.$at((long)ValNo)).first, ((std.pairTypeUInt)PositionalVals.$at((long)ValNo)).second);
                                ++ValNo;
                                continue block26;
                            }
                        }
                        throw new llvm_unreachable((CharSequence)"Internal error, unexpected NumOccurrences flag in positional argument processing!");
                    }
                }
            } else {
                assert (ConsumeAfterOpt != null && NumPositionalRequired <= (long)PositionalVals.size());
                long ValNo = 0L;
                long e = PositionalOpts.size();
                for (long j = 1L; j != e; ++j) {
                    if (!CommandLineStatics.RequiresValue((Option)PositionalOpts.$at(j))) continue;
                    ErrorParsing |= CommandLineStatics.ProvidePositionalOption((Option)PositionalOpts.$at(j), (StringRef)((std.pairTypeUInt)PositionalVals.$at((long)ValNo)).first, ((std.pairTypeUInt)PositionalVals.$at((long)ValNo)).second);
                    ++ValNo;
                }
                if (PositionalOpts.size() == 2 && ValNo == 0L && !PositionalVals.empty()) {
                    ErrorParsing |= CommandLineStatics.ProvidePositionalOption((Option)PositionalOpts.$at(1), (StringRef)((std.pairTypeUInt)PositionalVals.$at((long)ValNo)).first, ((std.pairTypeUInt)PositionalVals.$at((long)ValNo)).second);
                    ++ValNo;
                }
                while (ValNo != (long)PositionalVals.size()) {
                    ErrorParsing |= CommandLineStatics.ProvidePositionalOption(ConsumeAfterOpt, (StringRef)((std.pairTypeUInt)PositionalVals.$at((long)ValNo)).first, ((std.pairTypeUInt)PositionalVals.$at((long)ValNo)).second);
                    ++ValNo;
                }
            }
            StringMapIterator I = (StringMapIterator)Native.$tryClone(Opts.begin());
            StringMapIterator E = (StringMapIterator)Native.$tryClone(Opts.end());
            while (I.$noteq(E)) {
                switch (((Option)I.$arrow().second).getNumOccurrencesFlag()) {
                    case OneOrMore: 
                    case Required: {
                        if (((Option)I.$arrow().second).getNumOccurrences() != 0) break;
                        ((Option)I.$arrow().second).error(new Twine("must be specified at least once!"));
                        ErrorParsing = true;
                    }
                }
                I.$preInc();
            }
            Opts.clear();
            PositionalOpts.clear();
            CommandLineStatics.MoreHelp.$arrow().clear();
            if (ErrorParsing) {
                std.exit((int)1);
            }
        }
        finally {
            if (PositionalVals != null) {
                PositionalVals.$destroy();
            }
            if (Saver != null) {
                Saver.$destroy();
            }
            if (newArgv != null) {
                newArgv.$destroy();
            }
            if (Opts != null) {
                Opts.$destroy();
            }
            if (SinkOpts != null) {
                SinkOpts.$destroy();
            }
            if (PositionalOpts != null) {
                PositionalOpts.$destroy();
            }
        }
    }

    public static void ParseEnvironmentOptions(char.ptr progName, char.ptr envVar) {
        ClGlobals.ParseEnvironmentOptions(progName, envVar, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ParseEnvironmentOptions(char.ptr progName, char.ptr envVar, char.ptr Overview) {
        SmallVector<Object> newArgv = null;
        StrDupSaver Saver = null;
        try {
            assert (progName != null) : "Program name not specified";
            assert (envVar != null) : "Environment variable name missing";
            char.ptr envValue = Native.$tryClone((char.ptr)std.getenv((char.ptr)envVar));
            if (envValue == null) {
                return;
            }
            newArgv = new SmallVector<Object>(20, null);
            Saver = new StrDupSaver();
            newArgv.push_back(Saver.SaveString(progName));
            ClGlobals.TokenizeGNUCommandLine(new StringRef(envValue), Saver, newArgv);
            int newArgc = newArgv.size();
            ClGlobals.ParseCommandLineOptions(newArgc, (type.ptr<char.ptr>)((char.ptr)newArgv.$at(0)).$addr(), Overview);
        }
        finally {
            if (Saver != null) {
                Saver.$destroy();
            }
            if (newArgv != null) {
                newArgv.$destroy();
            }
        }
    }

    public static void SetVersionPrinter(NativeCallback.Void2Void func) {
        CommandLineStatics.OverrideVersionPrinter = (NativeCallback.Void2Void)Native.$tryClone((Object)func);
    }

    public static void AddExtraVersionPrinter(NativeCallback.Void2Void func) {
        if (CommandLineStatics.ExtraVersionPrinters == null) {
            CommandLineStatics.ExtraVersionPrinters = new std.vector((Object)null);
        }
        CommandLineStatics.ExtraVersionPrinters.push_back((Object)func);
    }

    public static void PrintOptionValues() {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static void MarkOptionsChanged() {
        CommandLineStatics.OptionListChanged = true;
    }

    public static <Ty> initializer<Ty> init(Ty Val) {
        return new initializer<Ty>(Val);
    }

    public static <Ty> LocationClass<Ty> location(type.ref<Ty> L) {
        return new LocationClass<Ty>(L);
    }

    public static LocationClass<std.string> location(std.string L) {
        llvm.errs().$out("location(std.string) should be replaced\n");
        return new LocationClass<std.string>(NativePointer.create_type$ref((Object)L));
    }

    public static <DataType> ValuesClass<DataType> values(char.ptr Arg, DataType Val, char.ptr Desc, Object ... Other) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <ParserClass, DT> void printOptionDiff(Option O, generic_parser_base P, DT V, OptionValue<DT> Default, long GlobalWidth) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <ParserClassDataType, ValDT> void printOptionDiff(Option O, basic_parser<ParserClassDataType> P, ValDT V, OptionValue<ValDT> Default, long GlobalWidth) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <Mod, Opt> void apply(Mod M, Opt O) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static void PrintVersionMessage() {
        CommandLineStatics.VersionPrinterInstance.print();
    }

    public static void PrintHelpMessage() {
        ClGlobals.PrintHelpMessage(false, false);
    }

    public static void PrintHelpMessage(boolean Hidden) {
        ClGlobals.PrintHelpMessage(Hidden, false);
    }

    public static void PrintHelpMessage(boolean Hidden, boolean Categorized) {
        if (!Hidden && !Categorized) {
            CommandLineStatics.UncategorizedNormalPrinter.$assign(true);
        } else if (!Hidden && Categorized) {
            CommandLineStatics.CategorizedNormalPrinter.$assign(true);
        } else if (Hidden && !Categorized) {
            CommandLineStatics.UncategorizedHiddenPrinter.$assign(true);
        } else {
            CommandLineStatics.CategorizedHiddenPrinter.$assign(true);
        }
    }

    public static void getRegisteredOptions(StringMap<Option, MallocAllocator> Map2) {
        SmallVector<Object> PositionalOpts = null;
        SmallVector<Object> SinkOpts = null;
        try {
            PositionalOpts = new SmallVector<Object>(4, null);
            SinkOpts = new SmallVector<Object>(4, null);
            assert (Map2.size() == 0) : "StringMap must be empty";
            CommandLineStatics.GetOptionInfo(PositionalOpts, SinkOpts, Map2);
            return;
        }
        finally {
            if (SinkOpts != null) {
                SinkOpts.$destroy();
            }
            if (PositionalOpts != null) {
                PositionalOpts.$destroy();
            }
        }
    }

    public static void TokenizeGNUCommandLine(StringRef Src, StringSaver Saver, SmallVectorImpl<char.ptr> NewArgv) {
        SmallString Token = new SmallString(128);
        long E = Src.size();
        for (long I = 0L; I != E; ++I) {
            if (Token.empty()) {
                while (I != E && CommandLineStatics.isWhitespace(Src.$at(I))) {
                    ++I;
                }
                if (I == E) break;
            }
            if (I + 1L < E && Src.$at(I) == 92 && CommandLineStatics.isGNUSpecial(Src.$at(I + 1L))) {
                Token.push_back(Src.$at(++I));
                continue;
            }
            if (CommandLineStatics.isQuote(Src.$at(I))) {
                byte Quote = Src.$at(I++);
                while (I != E && Src.$at(I) != Quote) {
                    if (Src.$at(I) == 92 && I + 1L != E && CommandLineStatics.isGNUSpecial(Src.$at(I + 1L))) {
                        ++I;
                    }
                    Token.push_back(Src.$at(I));
                    ++I;
                }
                if (I != E) continue;
                break;
            }
            if (CommandLineStatics.isWhitespace(Src.$at(I))) {
                if (!Token.empty()) {
                    NewArgv.push_back(Saver.SaveString(Token.c_str()));
                }
                Token.clear();
                continue;
            }
            Token.push_back(Src.$at(I));
        }
        if (!Token.empty()) {
            NewArgv.push_back(Saver.SaveString(Token.c_str()));
        }
    }

    public static void TokenizeWindowsCommandLine(StringRef Src, StringSaver Saver, SmallVectorImpl<char.ptr> NewArgv) {
        SmallString Token = new SmallString(128);
        Unnamed_enum State = Unnamed_enum.INIT;
        long E = Src.size();
        for (long I = 0L; I != E; ++I) {
            if (State == Unnamed_enum.INIT) {
                if (CommandLineStatics.isWhitespace(Src.$at(I))) continue;
                if (Src.$at(I) == NativePointer.$((char)'\"')) {
                    State = Unnamed_enum.QUOTED;
                    continue;
                }
                if (Src.$at(I) == 92) {
                    I = CommandLineStatics.parseBackslash(Src, I, Token);
                    State = Unnamed_enum.UNQUOTED;
                    continue;
                }
                Token.push_back(Src.$at(I));
                State = Unnamed_enum.UNQUOTED;
                continue;
            }
            if (State == Unnamed_enum.UNQUOTED) {
                if (CommandLineStatics.isWhitespace(Src.$at(I))) {
                    NewArgv.push_back(Saver.SaveString(Token.c_str()));
                    Token.clear();
                    State = Unnamed_enum.INIT;
                    continue;
                }
                if (Src.$at(I) == NativePointer.$((char)'\"')) {
                    State = Unnamed_enum.QUOTED;
                    continue;
                }
                if (Src.$at(I) == 92) {
                    I = CommandLineStatics.parseBackslash(Src, I, Token);
                    continue;
                }
                Token.push_back(Src.$at(I));
                continue;
            }
            if (State != Unnamed_enum.QUOTED) continue;
            if (Src.$at(I) == NativePointer.$((char)'\"')) {
                State = Unnamed_enum.UNQUOTED;
                continue;
            }
            if (Src.$at(I) == 92) {
                I = CommandLineStatics.parseBackslash(Src, I, Token);
                continue;
            }
            Token.push_back(Src.$at(I));
        }
        if (!Token.empty()) {
            NewArgv.push_back(Saver.SaveString(Token.c_str()));
        }
    }

    public static boolean ExpandResponseFiles(StringSaver Saver, TokenizerCallback Tokenizer, SmallVectorImpl<char.ptr> Argv) {
        return ClGlobals.ExpandResponseFiles(Saver, Tokenizer, Argv, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean ExpandResponseFiles(StringSaver Saver, TokenizerCallback Tokenizer, SmallVectorImpl<char.ptr> Argv, boolean MarkEOLs) {
        long RspFiles = 0L;
        boolean AllExpanded = true;
        long I = 0L;
        while (I != (long)Argv.size()) {
            SmallVector<Object> ExpandedArgv = null;
            try {
                char.ptr Arg = Native.$tryClone((char.ptr)Argv.$at(I));
                if (Arg == null) {
                    ++I;
                    continue;
                }
                if (Arg.$at(0) != NativePointer.$((char)'@')) {
                    ++I;
                    continue;
                }
                if (RspFiles++ > 20L) {
                    boolean bl = false;
                    return bl;
                }
                ExpandedArgv = new SmallVector<Object>(0, null);
                if (!CommandLineStatics.ExpandResponseFile((char.ptr)Arg.$add(1), Saver, Tokenizer, ExpandedArgv, MarkEOLs)) {
                    AllExpanded = false;
                    ++I;
                    continue;
                }
                Argv.erase(Argv.begin().$add(I));
                Argv.insert(Argv.begin().$add(I), ExpandedArgv.begin(), ExpandedArgv.end());
            }
            finally {
                if (ExpandedArgv == null) continue;
                ExpandedArgv.$destroy();
            }
        }
        return AllExpanded;
    }

    public static interface TokenizerCallback {
        public void $call(StringRef var1, StringSaver var2, SmallVectorImpl<char.ptr> var3, boolean var4);
    }

    private static final class Unnamed_enum
    extends Enum<Unnamed_enum> {
        public static final /* enum */ Unnamed_enum INIT = new Unnamed_enum(0L);
        public static final /* enum */ Unnamed_enum UNQUOTED = new Unnamed_enum(1L);
        public static final /* enum */ Unnamed_enum QUOTED = new Unnamed_enum(2L);
        private final int value;
        private static final /* synthetic */ Unnamed_enum[] $VALUES;

        public static Unnamed_enum[] values() {
            return (Unnamed_enum[])$VALUES.clone();
        }

        public static Unnamed_enum valueOf(String name) {
            return Enum.valueOf(Unnamed_enum.class, name);
        }

        public static Unnamed_enum valueOf(int val) {
            Unnamed_enum out;
            Unnamed_enum unnamed_enum = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private Unnamed_enum(long val) {
            this.value = (int)val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new Unnamed_enum[]{INIT, UNQUOTED, QUOTED};
        }

        private static final class Values {
            private static final Unnamed_enum[] VALUES;
            private static final Unnamed_enum[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (Unnamed_enum kind : Unnamed_enum.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new Unnamed_enum[min < 0 ? 1 - min : 0];
                VALUES = new Unnamed_enum[max >= 0 ? 1 + max : 0];
                for (Unnamed_enum kind : Unnamed_enum.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((Unnamed_enum)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((Unnamed_enum)kind).value] = kind;
                }
            }
        }
    }
}

