/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.sys;

import java.io.File;
import java.util.concurrent.atomic.AtomicLong;
import org.clank.java.built_in;
import org.clank.java.io;
import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativePointer;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImplChar;
import org.llvm.adt.aliases.StringMapBool;
import org.llvm.support.ErrorOr;
import org.llvm.support.ManagedStaticInfo;
import org.llvm.support.llvm;
import org.llvm.support.sys.ManagedStaticInfoImpl;
import org.llvm.support.sys.SmartMutex;
import org.llvm.support.sys.SmartScopedLock;
import org.llvm.support.sys.TimeValue;
import org.llvm.support.sys.UnicodeCharRange;
import org.llvm.support.sys.WindowsEncodingMethod;
import org.llvm.support.sys.fs;
import org.llvm.support.sys.impl.ProgramSysGlobals;
import org.llvm.support.sys.path;
import org.llvm.support.unix.impl.HostStatics;
import org.llvm.support.unix.impl.SignalsStatics;

public final class sys {
    public static final char EnvPathSeparator = File.pathSeparatorChar;
    public static boolean IsBigEndianHost = false;
    public static boolean IsLittleEndianHost = !IsBigEndianHost;
    public static final ManagedStaticInfo<SmartMutex> StaticSmartMutexTrue = new ManagedStaticInfoImpl<SmartMutex>(){

        @Override
        protected SmartMutex create() {
            return new SmartMutex(true);
        }
    };
    public static final ManagedStaticInfo<std.string> StaticStdString = new ManagedStaticInfoImpl<std.string>(){

        @Override
        protected std.string create() {
            return new std.string();
        }
    };
    public static final ManagedStaticInfo<std.vectorCharPtr> StaticStdVectorCharPtr = new ManagedStaticInfoImpl<std.vectorCharPtr>(){

        @Override
        protected std.vectorCharPtr create() {
            return new std.vectorCharPtr();
        }
    };

    public static long AtomicIncrement(AtomicLong Value) {
        return Value.incrementAndGet();
    }

    public static long AtomicDecrement(AtomicLong Value) {
        return Value.decrementAndGet();
    }

    public static long AtomicAdd(AtomicLong Value, long add) {
        return Value.addAndGet(add);
    }

    public static long AtomicMul(AtomicLong Value, long V) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static void AtomicDiv(AtomicLong Value, long V) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static void RunInterruptHandlers() {
        SmartScopedLock Guard = null;
        try {
            Guard = new SmartScopedLock(true, SignalsStatics.SignalsMutex);
            SignalsStatics.RemoveFilesToRemove();
        }
        finally {
            if (Guard != null) {
                Guard.$destroy();
            }
        }
    }

    public static boolean RemoveFileOnSignal(StringRef Filename) {
        return sys.RemoveFileOnSignal(Filename, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean RemoveFileOnSignal(StringRef Filename, std.string ErrMsg) {
        SmartScopedLock Guard = null;
        try {
            Guard = new SmartScopedLock(true, SignalsStatics.SignalsMutex);
            std.vectorString FilesToRemoveRef = SignalsStatics.FilesToRemove;
            std.string OldPtr = FilesToRemoveRef.empty() ? null : FilesToRemoveRef.$at(0);
            FilesToRemoveRef.push_back(Filename.$basic_string());
            if (OldPtr == FilesToRemoveRef.$at(0)) {
                FilesToRemoveRef.back().c_str();
            } else {
                long e = FilesToRemoveRef.size();
                for (long i = 0L; i != e; ++i) {
                    FilesToRemoveRef.$at(i).c_str();
                }
            }
        }
        finally {
            if (Guard != null) {
                Guard.$destroy();
            }
        }
        SignalsStatics.RegisterHandlers();
        return false;
    }

    public static void DontRemoveFileOnSignal(StringRef Filename) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static void PrintStackTraceOnErrorSignal() {
        sys.AddSignalHandler(SignalsStatics.PrintStackTraceSignalHandlerCallback, null);
    }

    public static void PrintStackTrace(io.FILE FD) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static void AddSignalHandler(NativeCallback.VoidPtr2Void FnPtr, void.ptr Cookie) {
        SignalsStatics.CallBacksToRun.push_back((Object)std.make_pair((Object)FnPtr, (Object)Cookie));
        SignalsStatics.RegisterHandlers();
    }

    public static void SetInterruptFunction(NativeCallback.Void2Void IF) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static std.string StrError() {
        return sys.StrError(std.errno());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std.string StrError(int errnum) {
        std.string str = null;
        try {
            if (errnum == 0) {
                std.string string2 = std.string.EMPTY;
                return string2;
            }
            int MaxErrStrLen = 2000;
            char.ptr buffer = NativePointer.create_char$ptr((byte[])NativePointer.new$char((int)2000, (byte[])new byte[0]));
            buffer.$set(0, NativePointer.$((char)'\u0000'));
            str = new std.string();
            std.strerror_r((int)errnum, (char.ptr)buffer, (long)(MaxErrStrLen - 1));
            str.$assign(buffer);
            std.string string3 = str;
            return string3;
        }
        finally {
            if (str != null) {
                str.$destroy();
            }
        }
    }

    public static ErrorOr<std.string> findProgramByName(StringRef Name) {
        return sys.findProgramByName(Name, new ArrayRef<StringRef>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ErrorOr<std.string> findProgramByName(StringRef Name, ArrayRef<StringRef> Paths) {
        SmallVector<StringRef> EnvironmentPaths = null;
        try {
            char.ptr PathEnv;
            assert (!Name.empty()) : "Must have a name!";
            if (Name.find(NativePointer.$((char)'/')) != StringRef.npos) {
                ErrorOr<std.string> errorOr = new ErrorOr<std.string>(Name.$basic_string());
                return errorOr;
            }
            EnvironmentPaths = new SmallVector<StringRef>(16, new StringRef());
            if (Paths.empty() && (PathEnv = Native.$tryClone((char.ptr)std.getenv((char.ptr)NativePointer.$((String)"PATH")))) != null) {
                llvm.SplitString(new StringRef(PathEnv), EnvironmentPaths, new StringRef(NativePointer.$((String)":")));
                Paths.$assign(new ArrayRef<StringRef>(EnvironmentPaths));
            }
            for (StringRef Path2 : Paths) {
                SmallVectorImplChar FilePath = null;
                try {
                    if (Path2.empty()) continue;
                    FilePath = new SmallString(new StringRef(Path2), 128);
                    path.append((SmallString)FilePath, Name);
                    if (!fs.can_execute(new Twine(((SmallString)FilePath).c_str()))) continue;
                    ErrorOr<std.string> errorOr = new ErrorOr<std.string>(((SmallString)FilePath).str().$basic_string());
                    return errorOr;
                }
                finally {
                    if (FilePath == null) continue;
                    FilePath.$destroy();
                }
            }
            ErrorOr<std_errors.errc> errorOr = new ErrorOr<std_errors.errc>(std_errors.errc.no_such_file_or_directory);
            return errorOr;
        }
        finally {
            if (EnvironmentPaths != null) {
                EnvironmentPaths.$destroy();
            }
        }
    }

    public static std.string FindProgramByName(std.string progName) {
        if (progName.length() == 0) {
            return new std.string((CharSequence)"");
        }
        std.string temp = progName;
        if (progName.find('/') != std.string.npos) {
            return temp;
        }
        char.ptr PathStr = Native.$tryClone((char.ptr)std.getenv((String)"PATH"));
        if (PathStr == null) {
            return new std.string((CharSequence)"");
        }
        long PathLen = std.strlen((char.ptr)PathStr);
        while (PathLen != 0L) {
            char.ptr Colon = Native.$tryClone((char.ptr)std.find((char.ptr)PathStr, (char.ptr)((char.ptr)PathStr.$add(PathLen)), (char)':'));
            SmallString FilePath = new SmallString(PathStr, Colon, 128);
            path.append(FilePath, progName);
            if (fs.can_execute(new Twine(FilePath.$StringRef()))) {
                return FilePath.str().$basic_string();
            }
            PathLen -= (long)Colon.$sub((abstract_iterator)PathStr);
            PathStr = Native.$tryClone((char.ptr)Colon);
            while (PathStr.$star() == NativePointer.$((char)':')) {
                PathStr.$preInc();
                --PathLen;
            }
        }
        return new std.string((CharSequence)"");
    }

    public static std.string FindProgramByName(char.ptr progName) {
        return sys.FindProgramByName(new std.string(progName));
    }

    public static std.string FindProgramByName(CharSequence progName) {
        return sys.FindProgramByName(new std.string(progName));
    }

    private static int getPageSize() {
        return std.getpagesize();
    }

    public static std_errors.error_code ChangeStdinToBinary() {
        return std_errors.error_code.success();
    }

    public static std_errors.error_code ChangeStdoutToBinary() {
        return std_errors.error_code.success();
    }

    public static std_errors.error_code ChangeStderrToBinary() {
        return std_errors.error_code.success();
    }

    public static int ExecuteAndWait(StringRef Program, type.ptr<char.ptr> args) {
        return sys.ExecuteAndWait(Program, args, (type.ptr<char.ptr>)((type.ptr)null), (type.ptr<StringRef>)((type.ptr)null), 0L, 0L, null, null);
    }

    public static int ExecuteAndWait(StringRef Program, type.ptr<char.ptr> args, type.ptr<char.ptr> envp) {
        return sys.ExecuteAndWait(Program, args, envp, (type.ptr<StringRef>)((type.ptr)null), 0L, 0L, null, null);
    }

    public static int ExecuteAndWait(StringRef Program, type.ptr<char.ptr> args, type.ptr<char.ptr> envp, type.ptr<StringRef> redirects) {
        return sys.ExecuteAndWait(Program, args, envp, redirects, 0L, 0L, null, null);
    }

    public static int ExecuteAndWait(StringRef Program, type.ptr<char.ptr> args, type.ptr<char.ptr> envp, type.ptr<StringRef> redirects, long secondsToWait) {
        return sys.ExecuteAndWait(Program, args, envp, redirects, secondsToWait, 0L, null, null);
    }

    public static int ExecuteAndWait(StringRef Program, type.ptr<char.ptr> args, type.ptr<char.ptr> envp, type.ptr<StringRef> redirects, long secondsToWait, long memoryLimit) {
        return sys.ExecuteAndWait(Program, args, envp, redirects, secondsToWait, memoryLimit, null, null);
    }

    public static int ExecuteAndWait(StringRef Program, type.ptr<char.ptr> args, type.ptr<char.ptr> envp, type.ptr<StringRef> redirects, long secondsToWait, long memoryLimit, std.string ErrMsg) {
        return sys.ExecuteAndWait(Program, args, envp, redirects, secondsToWait, memoryLimit, ErrMsg, null);
    }

    public static int ExecuteAndWait(StringRef Program, type.ptr<char.ptr> args, type.ptr<char.ptr> envp, type.ptr<StringRef> redirects, long secondsToWait, long memoryLimit, std.string ErrMsg, bool.ptr ExecutionFailed) {
        return ProgramSysGlobals.ExecuteAndWait(Program, args, envp, redirects, secondsToWait, memoryLimit, ErrMsg, ExecutionFailed);
    }

    public static boolean argumentsFitWithinSystemLimits(ArrayRef<char.ptr> Args) {
        return ProgramSysGlobals.argumentsFitWithinSystemLimits(Args);
    }

    public static std_errors.error_code writeFileWithEncoding(StringRef FileName, StringRef Contents) {
        return ProgramSysGlobals.writeFileWithEncoding(FileName, Contents);
    }

    public static std_errors.error_code writeFileWithEncoding(StringRef FileName, StringRef Contents, WindowsEncodingMethod Encoding) {
        return ProgramSysGlobals.writeFileWithEncoding(FileName, Contents, Encoding);
    }

    public static char SwapByteOrder_16(char value) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static long SwapByteOrder_32(long value) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static long SwapByteOrder_64(long value) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static byte SwapByteOrder(byte C) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static char SwapByteOrder(char C) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static short SwapByteOrder(short C) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int SwapByteOrder(int C) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static long SwapByteOrder(long C) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <T> T SwapByteOrder(T C) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static TimeValue $plus_TimeValue(TimeValue tv1, TimeValue tv2) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static TimeValue $minus_TimeValue(TimeValue tv1, TimeValue tv2) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static std.string getDefaultTargetTriple() {
        return HostStatics.getDefaultTargetTriple();
    }

    public static std.string getProcessTriple() {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static StringRef getHostCPUName() {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static boolean getHostCPUFeatures(StringMapBool Features) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static boolean $less_uint32_t_UnicodeCharRange(long Value, UnicodeCharRange Range) {
        return Value < Range.Lower;
    }

    public static boolean $less_UnicodeCharRange_uint32_t(UnicodeCharRange Range, long Value) {
        return Range.Upper < Value;
    }

    public static void MemoryFence() {
        built_in.__sync_synchronize();
    }

    static /* synthetic */ int access$100() {
        return sys.getPageSize();
    }

    public static class Watchdog
    implements Destructors.ClassWithDestructor {
        public Watchdog(long seconds) {
            std.alarm((long)seconds);
        }

        public void $destroy() {
            std.alarm((long)0L);
        }

        private Watchdog(Watchdog other) {
            throw new UnsupportedOperationException("LLVM_DELETED_FUNCTION");
        }

        private Watchdog $assign(Watchdog other) {
            throw new UnsupportedOperationException("LLVM_DELETED_FUNCTION");
        }
    }

    public static class ThreadLocal<T>
    extends ThreadLocalImpl
    implements Destructors.ClassWithDestructor {
        public T get() {
            return (T)this.getInstance();
        }

        public void set(T d) {
            this.setInstance(d);
        }

        public void erase() {
            this.removeInstance();
        }
    }

    public static class ThreadLocalImpl
    implements Destructors.ClassWithDestructor {
        private Unnamed_union1 Unnamed_field = new Unnamed_union1();
        private final java.lang.ThreadLocal<Object> data = new java.lang.ThreadLocal();

        public ThreadLocalImpl() {
            this.Unnamed_field.data = new byte[8];
        }

        public void $destroy() {
            this.data.remove();
        }

        public void setInstance(Object d) {
            this.data.set(d);
        }

        public Object getInstance() {
            return this.data.get();
        }

        public void removeInstance() {
            this.setInstance(null);
        }

        private static class Unnamed_union1 {
            public byte[] data = new byte[8];
            public long align_data;

            private Unnamed_union1() {
            }
        }
    }

    public final class ScopedLock
    extends SmartScopedLock {
        public ScopedLock(SmartMutex m) {
            super(false, m);
            assert (!m.mt_only());
        }
    }

    public static final class Mutex
    extends SmartMutex {
        public Mutex() {
            this(true);
        }

        public Mutex(boolean rec) {
            super(false, rec);
        }
    }

    public static class self_process
    extends process
    implements Destructors.ClassWithDestructor {
        private final long PageSize = sys.access$100();

        @Override
        public void $destroy() {
            llvm.llvm_unreachable_internal("This destructor must never be executed!");
            super.$destroy();
        }

        @Override
        public int get_id() {
            throw new UnsupportedOperationException("EmptyBody");
        }

        @Override
        public TimeValue get_user_time() {
            throw new UnsupportedOperationException("EmptyBody");
        }

        @Override
        public TimeValue get_system_time() {
            throw new UnsupportedOperationException("EmptyBody");
        }

        @Override
        public TimeValue get_wall_time() {
            throw new UnsupportedOperationException("EmptyBody");
        }

        public long page_size() {
            return this.PageSize;
        }

        private self_process() {
        }
    }

    public static abstract class process
    implements Destructors.ClassWithDestructor {
        private static final self_process SP = new self_process();

        public void $destroy() {
        }

        public abstract int get_id();

        public abstract TimeValue get_user_time();

        public abstract TimeValue get_system_time();

        public abstract TimeValue get_wall_time();

        public static self_process get_self() {
            return SP;
        }
    }

    public static class DynamicLibrary {
        private static void.ptr Invalid = NativePointer.$((String)"\u0000");
        private void.ptr Data;

        private DynamicLibrary() {
            this(Invalid);
        }

        private DynamicLibrary(void.ptr data) {
            throw new UnsupportedOperationException("EmptyBody");
        }

        public boolean isValid() {
            throw new UnsupportedOperationException("EmptyBody");
        }

        public void.ptr getAddressOfSymbol(char.ptr symbolName) {
            throw new UnsupportedOperationException("EmptyBody");
        }

        public static DynamicLibrary getPermanentLibrary(char.ptr filename) {
            return DynamicLibrary.getPermanentLibrary(filename, null);
        }

        public static DynamicLibrary getPermanentLibrary(char.ptr filename, std.string errMsg) {
            throw new UnsupportedOperationException("EmptyBody");
        }

        public static boolean LoadLibraryPermanently(char.ptr Filename) {
            return DynamicLibrary.LoadLibraryPermanently(Filename, null);
        }

        public static boolean LoadLibraryPermanently(char.ptr Filename, std.string ErrMsg) {
            throw new UnsupportedOperationException("EmptyBody");
        }

        public static void.ptr SearchForAddressOfSymbol(char.ptr symbolName) {
            throw new UnsupportedOperationException("EmptyBody");
        }

        public static void.ptr SearchForAddressOfSymbol(std.string symbolName) {
            throw new UnsupportedOperationException("EmptyBody");
        }

        public static void AddSymbol(StringRef symbolName, void.ptr symbolValue) {
            throw new UnsupportedOperationException("EmptyBody");
        }

        public DynamicLibrary(DynamicLibrary $Prm0) {
            throw new UnsupportedOperationException("EmptyBody");
        }
    }
}

