/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.netbeans.nbbuild.JarWithModuleAttributes;
import org.netbeans.nbbuild.VerifyClassLinkage;
import org.netbeans.nbbuild.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class MakeOSGi
extends Task {
    private File destdir;
    private List<ResourceCollection> modules = new ArrayList<ResourceCollection>();
    private static final Set<String> JAVA_PLATFORM_PACKAGES = new TreeSet<String>(Arrays.asList("javax.accessibility", "javax.activation", "javax.activity", "javax.annotation", "javax.annotation.processing", "javax.crypto", "javax.crypto.interfaces", "javax.crypto.spec", "javax.imageio", "javax.imageio.event", "javax.imageio.metadata", "javax.imageio.plugins.bmp", "javax.imageio.plugins.jpeg", "javax.imageio.spi", "javax.imageio.stream", "javax.jws", "javax.jws.soap", "javax.lang.model", "javax.lang.model.element", "javax.lang.model.type", "javax.lang.model.util", "javax.management", "javax.management.loading", "javax.management.modelmbean", "javax.management.monitor", "javax.management.openmbean", "javax.management.relation", "javax.management.remote", "javax.management.remote.rmi", "javax.management.timer", "javax.naming", "javax.naming.directory", "javax.naming.event", "javax.naming.ldap", "javax.naming.spi", "javax.net", "javax.net.ssl", "javax.print", "javax.print.attribute", "javax.print.attribute.standard", "javax.print.event", "javax.rmi", "javax.rmi.CORBA", "javax.rmi.ssl", "javax.script", "javax.security.auth", "javax.security.auth.callback", "javax.security.auth.kerberos", "javax.security.auth.login", "javax.security.auth.spi", "javax.security.auth.x500", "javax.security.cert", "javax.security.sasl", "javax.sound.midi", "javax.sound.midi.spi", "javax.sound.sampled", "javax.sound.sampled.spi", "javax.sql", "javax.sql.rowset", "javax.sql.rowset.serial", "javax.sql.rowset.spi", "javax.swing", "javax.swing.border", "javax.swing.colorchooser", "javax.swing.event", "javax.swing.filechooser", "javax.swing.plaf", "javax.swing.plaf.basic", "javax.swing.plaf.metal", "javax.swing.plaf.multi", "javax.swing.plaf.synth", "javax.swing.table", "javax.swing.text", "javax.swing.text.html", "javax.swing.text.html.parser", "javax.swing.text.rtf", "javax.swing.tree", "javax.swing.undo", "javax.tools", "javax.transaction", "javax.transaction.xa", "javax.xml", "javax.xml.bind", "javax.xml.bind.annotation", "javax.xml.bind.annotation.adapters", "javax.xml.bind.attachment", "javax.xml.bind.helpers", "javax.xml.bind.util", "javax.xml.crypto", "javax.xml.crypto.dom", "javax.xml.crypto.dsig", "javax.xml.crypto.dsig.dom", "javax.xml.crypto.dsig.keyinfo", "javax.xml.crypto.dsig.spec", "javax.xml.datatype", "javax.xml.namespace", "javax.xml.parsers", "javax.xml.soap", "javax.xml.stream", "javax.xml.stream.events", "javax.xml.stream.util", "javax.xml.transform", "javax.xml.transform.dom", "javax.xml.transform.sax", "javax.xml.transform.stax", "javax.xml.transform.stream", "javax.xml.validation", "javax.xml.ws", "javax.xml.ws.handler", "javax.xml.ws.handler.soap", "javax.xml.ws.http", "javax.xml.ws.soap", "javax.xml.ws.spi", "javax.xml.ws.wsaddressing", "javax.xml.xpath", "org.ietf.jgss", "org.omg.CORBA", "org.omg.CORBA.DynAnyPackage", "org.omg.CORBA.ORBPackage", "org.omg.CORBA.TypeCodePackage", "org.omg.CORBA.portable", "org.omg.CORBA_2_3", "org.omg.CORBA_2_3.portable", "org.omg.CosNaming", "org.omg.CosNaming.NamingContextExtPackage", "org.omg.CosNaming.NamingContextPackage", "org.omg.Dynamic", "org.omg.DynamicAny", "org.omg.DynamicAny.DynAnyFactoryPackage", "org.omg.DynamicAny.DynAnyPackage", "org.omg.IOP", "org.omg.IOP.CodecFactoryPackage", "org.omg.IOP.CodecPackage", "org.omg.Messaging", "org.omg.PortableInterceptor", "org.omg.PortableInterceptor.ORBInitInfoPackage", "org.omg.PortableServer", "org.omg.PortableServer.CurrentPackage", "org.omg.PortableServer.POAManagerPackage", "org.omg.PortableServer.POAPackage", "org.omg.PortableServer.ServantLocatorPackage", "org.omg.PortableServer.portable", "org.omg.SendingContext", "org.omg.stub.java.rmi", "org.w3c.dom", "org.w3c.dom.bootstrap", "org.w3c.dom.events", "org.w3c.dom.ls", "org.xml.sax", "org.xml.sax.ext", "org.xml.sax.helpers"));
    private static final Set<String> SKIPPED_PSEUDO_MODULES = new HashSet<String>(Arrays.asList("org.eclipse.osgi", "org.netbeans.core.netigso", "org.netbeans.modules.netbinox", "org.netbeans.libs.osgi", "org.netbeans.libs.felix"));
    private static final Set<String> STARTUP_PSEUDO_MODULES = new HashSet<String>(Arrays.asList("org.openide.util.lookup", "org.openide.util.ui", "org.openide.util", "org.openide.modules", "org.netbeans.bootstrap", "org.openide.filesystems", "org.openide.filesystems.compat8", "org.netbeans.core.startup", "org.netbeans.core.startup.base", "org.netbeans.core.osgi", "org.eclipse.osgi"));

    public void setDestdir(File destdir) {
        this.destdir = destdir;
    }

    public void add(ResourceCollection modules) {
        this.modules.add(modules);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.destdir == null) {
            throw new BuildException("missing destdir");
        }
        ArrayList<File> jars = new ArrayList<File>();
        ArrayList<File> fragments = new ArrayList<File>();
        HashMap<String, Info> infos = new HashMap<String, Info>();
        this.log("Prescanning JARs...");
        for (ResourceCollection rc : this.modules) {
            Iterator it = rc.iterator();
            while (it.hasNext()) {
                File jar = ((FileResource)it.next()).getFile();
                this.log("Prescanning " + jar, 3);
                if (jar.getParentFile().getName().equals("locale")) {
                    fragments.add(jar);
                    continue;
                }
                try (JarFile jf = new JarFile(jar);){
                    Info info = new Info();
                    String cnb = MakeOSGi.prescan(jf, info, this);
                    if (cnb == null) {
                        this.log(jar + " does not appear to be either a module or a bundle; skipping", 1);
                        continue;
                    }
                    if (SKIPPED_PSEUDO_MODULES.contains(cnb)) {
                        this.log("Skipping " + jar);
                        continue;
                    }
                    if (infos.containsKey(cnb)) {
                        this.log(jar + " appears to not be the only module named " + cnb, 1);
                        continue;
                    }
                    infos.put(cnb, info);
                    jars.add(jar);
                }
                catch (Exception x) {
                    throw new BuildException("Could not prescan " + jar + ": " + x, (Throwable)x, this.getLocation());
                }
            }
        }
        for (File jar : jars) {
            try {
                this.process(jar, infos);
            }
            catch (Exception x) {
                throw new BuildException("Could not process " + jar + ": " + x, (Throwable)x, this.getLocation());
            }
        }
        for (File jar : fragments) {
            try {
                this.processFragment(jar);
            }
            catch (Exception x) {
                throw new BuildException("Could not process " + jar + ": " + x, (Throwable)x, this.getLocation());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String prescan(JarFile module, Info info, Task task) throws Exception {
        String cnb;
        block21: {
            Attributes attr;
            block20: {
                Manifest manifest = module.getManifest();
                if (manifest == null) {
                    return null;
                }
                attr = manifest.getMainAttributes();
                cnb = attr.getValue("OpenIDE-Module");
                if ("org.netbeans.libs.osgi".equals(cnb)) {
                    return cnb;
                }
                TreeSet<String> availablePackages = new TreeSet<String>();
                MakeOSGi.scanClasses(module, info.importedPackages, availablePackages, task);
                File antlib = new File(module.getName().replaceFirst("([/\\\\])modules([/\\\\][^/\\\\]+)", "$1ant$1nblib$2"));
                if (antlib.isFile()) {
                    HashSet<String> antlibPackages = new HashSet<String>();
                    try (JarFile antlibJF = new JarFile(antlib);){
                        MakeOSGi.scanClasses(antlibJF, antlibPackages, new HashSet<String>(), task);
                    }
                    for (String antlibImport : antlibPackages) {
                        if (antlibImport.startsWith("org.apache.tools.") || availablePackages.contains(antlibImport)) continue;
                        info.importedPackages.add(antlibImport);
                    }
                }
                if (cnb == null) break block20;
                cnb = cnb.replaceFirst("/\\d+$", "");
                String hide = attr.getValue("OpenIDE-Module-Hide-Classpath-Packages");
                if (hide != null) {
                    for (String piece : hide.split("[, ]+")) {
                        if (piece.isEmpty()) continue;
                        if (piece.endsWith(".*")) {
                            info.hiddenPackages.add(piece.substring(0, piece.length() - ".*".length()));
                            continue;
                        }
                        if (piece.endsWith(".**")) {
                            info.hiddenSubpackages.add(piece.substring(0, piece.length() - ".**".length()));
                            continue;
                        }
                        throw new IOException("Bad OpenIDE-Module-Hide-Classpath-Packages piece: " + piece);
                    }
                }
                String pp = attr.getValue("OpenIDE-Module-Public-Packages");
                String implVersion = attr.getValue("OpenIDE-Module-Implementation-Version");
                if (implVersion != null && implVersion.matches("\\d+") && attr.getValue("OpenIDE-Module-Build-Version") != null) {
                    info.exportedPackages.addAll(availablePackages);
                    pp = null;
                }
                if (pp == null || pp.equals("-")) break block21;
                for (String p : pp.split("[, ]+")) {
                    if (p.isEmpty()) continue;
                    if (p.endsWith(".*")) {
                        info.exportedPackages.add(p.substring(0, p.length() - ".*".length()));
                        continue;
                    }
                    if (!p.endsWith(".**")) {
                        throw new IllegalArgumentException("Invalid package export: " + p);
                    }
                    for (String actual : availablePackages) {
                        if (!actual.equals(p.substring(0, p.length() - ".**".length())) && !actual.startsWith(p.substring(0, p.length() - "**".length()))) continue;
                        info.exportedPackages.add(actual);
                    }
                }
                break block21;
            }
            cnb = JarWithModuleAttributes.extractCodeName(attr);
            if (cnb == null) {
                return null;
            }
            String exportPackage = attr.getValue("Export-Package");
            if (exportPackage != null) {
                for (String piece : exportPackage.split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)")) {
                    info.exportedPackages.add(piece.trim().replaceFirst(";.+", ""));
                }
            }
        }
        return cnb;
    }

    private File findDestFile(String bundleName, String bundleVersion) throws IOException {
        File destFile = new File(this.destdir, bundleName + (bundleVersion != null ? "-" + bundleVersion : "") + ".jar");
        for (File stale : this.destdir.listFiles()) {
            if (!stale.getName().matches("\\Q" + bundleName + "\\E(-.+)?[.]jar") || stale.equals(destFile)) continue;
            this.log("Deleting copy under old name: " + stale);
            if (stale.delete()) continue;
            throw new IOException("Could not delete: " + stale);
        }
        return destFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(File module, Map<String, Info> infos) throws Exception {
        try (JarFile jar = new JarFile(module);){
            Manifest netbeans = jar.getManifest();
            Attributes netbeansAttr = netbeans.getMainAttributes();
            if (netbeansAttr.getValue("Bundle-SymbolicName") != null) {
                File bundleFile = this.findDestFile(JarWithModuleAttributes.extractCodeName(netbeansAttr), netbeansAttr.getValue("Bundle-Version"));
                if (bundleFile.lastModified() > module.lastModified()) {
                    this.log("Skipping " + module + " since " + bundleFile + " is newer", 3);
                    return;
                }
                Copy copy = new Copy();
                copy.setProject(this.getProject());
                copy.setOwningTarget(this.getOwningTarget());
                copy.setFile(module);
                copy.setTofile(bundleFile);
                copy.setVerbose(true);
                copy.execute();
                return;
            }
            Manifest osgi = new Manifest();
            Attributes osgiAttr = osgi.getMainAttributes();
            this.translate(netbeansAttr, osgiAttr, infos);
            String cnb = osgiAttr.getValue("Bundle-SymbolicName").replaceFirst(";.+", "");
            File bundleFile = this.findDestFile(cnb, osgiAttr.getValue("Bundle-Version"));
            if (bundleFile.lastModified() > module.lastModified()) {
                this.log("Skipping " + module + " since " + bundleFile + " is newer", 3);
                return;
            }
            this.log("Processing " + module + " into " + bundleFile);
            String dynamicImports = osgiAttr.getValue("DynamicImport-Package");
            if (dynamicImports != null) {
                this.log(cnb + " has imports of no known origin: " + dynamicImports, 1);
                this.log("(you may need to define org.osgi.framework.system.packages.extra in your OSGi container)");
            }
            Properties localizedStrings = new Properties();
            String locbundle = netbeansAttr.getValue("OpenIDE-Module-Localizing-Bundle");
            if (locbundle != null) {
                try (InputStream is = jar.getInputStream(jar.getEntry(locbundle));){
                    localizedStrings.load(is);
                }
                osgiAttr.putValue("Bundle-Localization", locbundle.replaceFirst("[.]properties$", ""));
            }
            this.handleDisplayAttribute(localizedStrings, netbeansAttr, osgiAttr, "OpenIDE-Module-Name", "Bundle-Name");
            this.handleDisplayAttribute(localizedStrings, netbeansAttr, osgiAttr, "OpenIDE-Module-Display-Category", "Bundle-Category");
            this.handleDisplayAttribute(localizedStrings, netbeansAttr, osgiAttr, "OpenIDE-Module-Short-Description", "Bundle-Description");
            Map<String, File> bundledFiles = this.findBundledFiles(module, cnb);
            String classPath = netbeansAttr.getValue("Class-Path");
            if (classPath != null) {
                StringBuilder bundleCP = new StringBuilder();
                for (String entry : classPath.split("[, ]+")) {
                    if (entry.startsWith("${java.home}")) continue;
                    String clusterPath = new URI(module.getParentFile().getName() + "/" + entry).normalize().toString();
                    if (bundledFiles.containsKey(clusterPath)) {
                        bundleCP.append("/OSGI-INF/files/").append(clusterPath).append(",");
                        continue;
                    }
                    this.log("Class-Path entry " + entry + " from " + module + " does not correspond to any apparent cluster file", 1);
                }
                osgiAttr.putValue("Bundle-Classpath", bundleCP + ".");
            }
            StringBuilder execFiles = null;
            for (Map.Entry<String, File> bundledFile : bundledFiles.entrySet()) {
                if (!bundledFile.getValue().canExecute()) continue;
                String name = bundledFile.getKey();
                if (execFiles == null) {
                    execFiles = new StringBuilder(name);
                    continue;
                }
                execFiles.append(',').append(name);
            }
            if (execFiles != null) {
                osgiAttr.putValue("NetBeans-Executable-Files", execFiles.toString());
            }
            try (FileOutputStream bundle = new FileOutputStream(bundleFile);){
                InputStream is;
                JarOutputStream zos = new JarOutputStream((OutputStream)bundle, osgi);
                HashSet<String> parents = new HashSet<String>();
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String path = entry.getName();
                    if (path.endsWith("/") || path.equals("META-INF/MANIFEST.MF")) continue;
                    is = jar.getInputStream(entry);
                    try {
                        MakeOSGi.writeEntry((ZipOutputStream)zos, path, is, parents);
                    }
                    finally {
                        is.close();
                    }
                }
                for (Map.Entry<String, File> bundledFile : bundledFiles.entrySet()) {
                    is = new FileInputStream(bundledFile.getValue());
                    try {
                        MakeOSGi.writeEntry((ZipOutputStream)zos, "OSGI-INF/files/" + bundledFile.getKey(), is, parents);
                    }
                    finally {
                        is.close();
                    }
                }
                zos.finish();
                zos.close();
            }
        }
    }

    void translate(Attributes netbeans, Attributes osgi, Map<String, Info> infos) throws Exception {
        Matcher m;
        String javaDeps;
        osgi.putValue("Manifest-Version", "1.0");
        osgi.putValue("Bundle-ManifestVersion", "2");
        String codename = netbeans.getValue("OpenIDE-Module");
        if (codename == null) {
            throw new IllegalArgumentException("Does not appear to be a NetBeans module");
        }
        String cnb = codename.replaceFirst("/\\d+$", "");
        osgi.putValue("Bundle-SymbolicName", cnb);
        if (cnb.equals("org.netbeans.core.osgi")) {
            osgi.putValue("Bundle-Activator", "org.netbeans.core.osgi.Activator");
        }
        Info myInfo = infos.get(cnb);
        String spec = netbeans.getValue("OpenIDE-Module-Specification-Version");
        String bundleVersion = null;
        if (spec != null) {
            bundleVersion = MakeOSGi.threeDotsWithMajor(spec, codename);
            String buildVersion = netbeans.getValue("OpenIDE-Module-Build-Version");
            if (buildVersion == null) {
                buildVersion = netbeans.getValue("OpenIDE-Module-Implementation-Version");
            }
            if (buildVersion != null) {
                bundleVersion = bundleVersion + "." + buildVersion.replaceAll("[^a-zA-Z0-9_-]", "_");
            }
            osgi.putValue("Bundle-Version", bundleVersion);
        }
        if (!myInfo.exportedPackages.isEmpty()) {
            StringBuilder b = new StringBuilder();
            for (String p : myInfo.exportedPackages) {
                if (b.length() > 0) {
                    b.append(", ");
                }
                b.append(p);
            }
            osgi.putValue("Export-Package", b.toString());
        }
        for (String attrToCopy : new String[]{"OpenIDE-Module-Layer", "OpenIDE-Module-Install"}) {
            String val = netbeans.getValue(attrToCopy);
            if (val == null) continue;
            osgi.putValue(attrToCopy, val);
        }
        StringBuilder requireBundles = new StringBuilder();
        if (!STARTUP_PSEUDO_MODULES.contains(cnb)) {
            requireBundles.append("org.netbeans.core.osgi");
        }
        TreeSet<String> imports = new TreeSet<String>(myInfo.importedPackages);
        MakeOSGi.hideImports(imports, myInfo);
        String dependencies = netbeans.getValue("OpenIDE-Module-Module-Dependencies");
        if (dependencies != null) {
            for (String dependency : dependencies.split(" *, *")) {
                String depCnb = MakeOSGi.translateDependency(requireBundles, dependency);
                if (depCnb == null) continue;
                Info imported = infos.get(depCnb);
                if (imported != null) {
                    imports.removeAll(imported.exportedPackages);
                    MakeOSGi.hideImports(imports, imported);
                    continue;
                }
                this.log("dependency " + depCnb + " of " + cnb + " not found in batch; imports may not be correct", 1);
            }
        }
        if (requireBundles.length() > 0) {
            osgi.putValue("Require-Bundle", requireBundles.toString());
        }
        StringBuilder staticImports = new StringBuilder();
        StringBuilder dynamicImports = new StringBuilder();
        for (String pkg : imports) {
            StringBuilder b;
            StringBuilder stringBuilder = b = this.isOSGiOrJavaPlatform(pkg) ? staticImports : dynamicImports;
            if (b.length() > 0) {
                b.append(", ");
            }
            b.append(pkg);
        }
        if (staticImports.length() > 0) {
            osgi.putValue("Import-Package", staticImports.toString());
        }
        if (dynamicImports.length() > 0) {
            osgi.putValue("DynamicImport-Package", dynamicImports.toString());
        }
        if ((javaDeps = netbeans.getValue("OpenIDE-Module-Java-Dependencies")) != null && (m = Pattern.compile("Java > (1.[6-9])").matcher(javaDeps)).matches()) {
            osgi.putValue("Bundle-RequiredExecutionEnvironment", "JavaSE-" + m.group(1));
        }
        for (String tokenAttr : new String[]{"OpenIDE-Module-Provides", "OpenIDE-Module-Needs"}) {
            String v = netbeans.getValue(tokenAttr);
            if (v == null) continue;
            osgi.putValue(tokenAttr, v);
        }
        String v = netbeans.getValue("OpenIDE-Module-Requires");
        if (v != null) {
            StringBuilder b = null;
            for (String tok : v.split("[, ]+")) {
                if (tok.matches("org.openide.modules.ModuleFormat\\d+")) continue;
                if (b == null) {
                    b = new StringBuilder(tok);
                    continue;
                }
                b.append(", ").append(tok);
            }
            if (b != null) {
                osgi.putValue("OpenIDE-Module-Requires", b.toString());
            }
        }
    }

    private boolean isOSGiOrJavaPlatform(String pkg) {
        if (pkg.startsWith("org.osgi.")) {
            return true;
        }
        return JAVA_PLATFORM_PACKAGES.contains(pkg);
    }

    private static void hideImports(Set<String> imports, Info info) {
        imports.removeAll(info.hiddenPackages);
        Iterator<String> it = imports.iterator();
        block0: while (it.hasNext()) {
            String p = it.next();
            for (String prefix : info.hiddenSubpackages) {
                if (!p.equals(prefix) && !p.startsWith(prefix + ".")) continue;
                it.remove();
                continue block0;
            }
        }
    }

    private static void writeEntry(ZipOutputStream zos, String path, InputStream data, Set<String> parents) throws IOException {
        int read;
        int size = Math.max(data.available(), 100);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(size);
        byte[] buf = new byte[size];
        while ((read = data.read(buf)) != -1) {
            baos.write(buf, 0, read);
        }
        MakeOSGi.writeEntry(zos, path, baos.toByteArray(), parents);
    }

    private static void writeEntry(ZipOutputStream zos, String path, byte[] data, Set<String> parents) throws IOException {
        assert (path.length() > 0 && !path.endsWith("/") && !path.startsWith("/") && path.indexOf("//") == -1) : path;
        for (int i = 0; i < path.length(); ++i) {
            String parent;
            if (path.charAt(i) != '/' || !parents.add(parent = path.substring(0, i + 1))) continue;
            ZipEntry ze = new ZipEntry(parent);
            ze.setMethod(0);
            ze.setSize(0L);
            ze.setCrc(0L);
            zos.putNextEntry(ze);
            zos.closeEntry();
        }
        ZipEntry ze = new ZipEntry(path);
        ze.setMethod(0);
        ze.setSize(data.length);
        CRC32 crc = new CRC32();
        crc.update(data);
        ze.setCrc(crc.getValue());
        zos.putNextEntry(ze);
        zos.write(data, 0, data.length);
        zos.closeEntry();
    }

    private static String threeDotsWithMajor(String version, String withMajor) {
        int indx = withMajor.indexOf(47);
        int major = 0;
        if (indx > 0) {
            major = Integer.parseInt(withMajor.substring(indx + 1));
        }
        String[] segments = (version + ".0.0.0").split("\\.");
        assert (segments.length >= 3 && segments[0].length() > 0);
        return Integer.parseInt(segments[0]) + major * 100 + "." + segments[1] + "." + segments[2];
    }

    static String translateDependency(StringBuilder b, String dependency) throws IllegalArgumentException {
        Matcher m = Pattern.compile("([^/ >=]+)(?:/(\\d+)(?:-(\\d+))?)? *(?:(=|>) *(.+))?").matcher(dependency);
        if (!m.matches()) {
            throw new IllegalArgumentException("bad dep: " + dependency);
        }
        String depCnb = m.group(1);
        if (SKIPPED_PSEUDO_MODULES.contains(depCnb)) {
            return null;
        }
        String depMajLo = m.group(2);
        String depMajHi = m.group(3);
        String comparison = m.group(4);
        String version = m.group(5);
        if (b.length() > 0) {
            b.append(", ");
        }
        b.append(depCnb);
        if (!"=".equals(comparison)) {
            if (version == null) {
                version = "0";
            }
            String targetVersion = MakeOSGi.threeDotsWithMajor(version, depMajLo == null ? "" : "x/" + depMajLo);
            b.append(";bundle-version=\"[").append(targetVersion).append(",");
            b.append(100 * ((depMajHi != null ? Integer.parseInt(depMajHi) : (depMajLo != null ? Integer.parseInt(depMajLo) : 0)) + 1));
            b.append(")\"");
        }
        return depCnb;
    }

    private void handleDisplayAttribute(Properties props, Attributes netbeans, Attributes osgi, String netbeansHeader, String osgiHeader) throws IOException {
        String val = netbeans.getValue(netbeansHeader);
        if (val != null) {
            osgi.putValue(osgiHeader, val);
        } else if (props.containsKey(netbeansHeader)) {
            osgi.putValue(osgiHeader, "%" + netbeansHeader);
        }
    }

    private Map<String, File> findBundledFiles(File module, String cnb) throws Exception {
        HashMap<String, File> result = new HashMap<String, File>();
        if (module.getParentFile().getName().matches("modules|core|lib")) {
            File cluster = module.getParentFile().getParentFile();
            File updateTracking = new File(new File(cluster, "update_tracking"), cnb.replace('.', '-') + ".xml");
            if (updateTracking.isFile()) {
                Document doc = XMLUtil.parse(new InputSource(updateTracking.toURI().toString()), false, false, null, null);
                NodeList nl = doc.getElementsByTagName("file");
                for (int i = 0; i < nl.getLength(); ++i) {
                    File f;
                    String path = ((Element)nl.item(i)).getAttribute("name");
                    if (path.matches("config/(Modules|ModuleAutoDeps)/.+[.]xml|lib/nbexec.*") || (f = new File(cluster, path)).equals(module)) continue;
                    if (f.isFile()) {
                        result.put(path, f);
                        continue;
                    }
                    this.log("did not find " + f + " specified in " + updateTracking, 1);
                }
            } else {
                this.log("did not find expected " + updateTracking, 1);
            }
        } else {
            this.log("JAR " + module + " not found in expected cluster layout", 1);
        }
        return result;
    }

    private static void scanClasses(JarFile module, Set<String> importedPackages, Set<String> availablePackages, Task task) throws Exception {
        TreeMap<String, byte[]> classfiles = new TreeMap<String, byte[]>();
        VerifyClassLinkage.read(module, classfiles, new HashSet<File>(Collections.singleton(new File(module.getName()))), task, null);
        for (Map.Entry entry : classfiles.entrySet()) {
            String available = (String)entry.getKey();
            int idx = available.lastIndexOf(46);
            if (idx != -1) {
                availablePackages.add(available.substring(0, idx));
            }
            for (String clazz : VerifyClassLinkage.dependencies((byte[])entry.getValue())) {
                if (classfiles.containsKey(clazz) || clazz.startsWith("java.") || (idx = clazz.lastIndexOf(46)) == -1) continue;
                importedPackages.add(clazz.substring(0, idx));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFragment(File fragment) throws Exception {
        String cnb = MakeOSGi.findFragmentHost(fragment);
        File bundleFile = new File(this.destdir, fragment.getName());
        if (bundleFile.lastModified() > fragment.lastModified()) {
            this.log("Skipping " + fragment + " since " + bundleFile + " is newer", 3);
            return;
        }
        this.log("Processing " + fragment + " into " + bundleFile);
        Manifest mf = new Manifest();
        Attributes attr = mf.getMainAttributes();
        attr.putValue("Manifest-Version", "1.0");
        attr.putValue("Bundle-ManifestVersion", "2");
        attr.putValue("Bundle-SymbolicName", cnb + "-branding");
        attr.putValue("Fragment-Host", cnb);
        try (JarFile jar = new JarFile(fragment);
             FileOutputStream bundle = new FileOutputStream(bundleFile);){
            JarOutputStream zos = new JarOutputStream((OutputStream)bundle, mf);
            HashSet<String> parents = new HashSet<String>();
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String path = entry.getName();
                if (path.endsWith("/") || path.equals("META-INF/MANIFEST.MF")) continue;
                try (InputStream is = jar.getInputStream(entry);){
                    MakeOSGi.writeEntry((ZipOutputStream)zos, path, is, parents);
                }
            }
            zos.finish();
            zos.close();
        }
    }

    static String findFragmentHost(File jar) {
        String cnb = jar.getName().replaceFirst("(_[a-z][a-z0-9]*)*[.]jar$", "").replace('-', '.');
        if (cnb.equals("core") && jar.getParentFile().getParentFile().getName().equals("core")) {
            return "org.netbeans.core.startup";
        }
        if (cnb.equals("boot") && jar.getParentFile().getParentFile().getName().equals("lib")) {
            return "org.netbeans.bootstrap";
        }
        return cnb;
    }

    static class Info {
        final Set<String> importedPackages = new TreeSet<String>();
        final Set<String> exportedPackages = new TreeSet<String>();
        final Set<String> hiddenPackages = new TreeSet<String>();
        final Set<String> hiddenSubpackages = new TreeSet<String>();

        Info() {
        }
    }
}

