/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.ui;

import java.util.Arrays;
import java.util.prefs.Preferences;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import org.openide.util.lookup.Lookups;

public abstract class NamedOption {
    public static final String HIGHLIGTING_CATEGORY = "CND/options/highlighting";
    public static final String MAKE_PROJECT_CATEGORY = "CND/options/makeProject";
    public static final String HINTS_CATEGORY = "CND/options/hints";
    public static final String OTHER_CATEGORY = "CND/options/other";
    public static final String EXTRA_OPTIONS_FLAG = "cnd.options.project.extra";
    private static final Accessor accessor = new Accessor();

    public abstract String getName();

    public abstract String getDisplayName();

    public abstract String getDescription();

    public abstract OptionKind getKind();

    public abstract Object getDefaultValue();

    public boolean isVisible() {
        return true;
    }

    public static Accessor getAccessor() {
        return accessor;
    }

    public static final class Accessor {
        private final Preferences preferences = NbPreferences.forModule(NamedOption.class);

        public final boolean getBoolean(String name) {
            NamedOption option = this.findOption(name);
            if (option.getKind() == OptionKind.Boolean) {
                return this.preferences.getBoolean(option.getName(), (Boolean)option.getDefaultValue());
            }
            throw new IllegalArgumentException("Option " + option.getName() + " is not boolean");
        }

        public final void setBoolean(String name, boolean value) {
            NamedOption option = this.findOption(name);
            if (option.getKind() == OptionKind.Boolean) {
                this.preferences.putBoolean(option.getName(), value);
                return;
            }
            throw new IllegalArgumentException("Option " + option.getName() + " is not boolean");
        }

        public final int getInteger(String name) {
            NamedOption option = this.findOption(name);
            if (option.getKind() == OptionKind.Integer) {
                return this.preferences.getInt(option.getName(), (Integer)option.getDefaultValue());
            }
            throw new IllegalArgumentException("Option " + option.getName() + " is not integer");
        }

        public final void setInteger(String name, int value) {
            NamedOption option = this.findOption(name);
            if (option.getKind() == OptionKind.Integer) {
                this.preferences.putInt(option.getName(), value);
                return;
            }
            throw new IllegalArgumentException("Option " + option.getName() + " is not integer");
        }

        public final String getString(String name) {
            NamedOption option = this.findOption(name);
            if (option.getKind() == OptionKind.String) {
                return this.preferences.get(option.getName(), (String)option.getDefaultValue());
            }
            throw new IllegalArgumentException("Option " + option.getName() + " is not string");
        }

        public final void setString(String name, String value) {
            NamedOption option = this.findOption(name);
            if (option.getKind() == OptionKind.String) {
                this.preferences.get(option.getName(), value);
                return;
            }
            throw new IllegalArgumentException("Option " + option.getName() + " is not string");
        }

        private NamedOption findOption(String name) {
            for (String category : Arrays.asList(NamedOption.HIGHLIGTING_CATEGORY, NamedOption.HINTS_CATEGORY, NamedOption.MAKE_PROJECT_CATEGORY, NamedOption.OTHER_CATEGORY)) {
                for (NamedOption option : Lookups.forPath((String)category).lookupAll(NamedOption.class)) {
                    if (!name.equals(option.getName())) continue;
                    return option;
                }
            }
            for (NamedOption option : Lookup.getDefault().lookupAll(NamedOption.class)) {
                if (!name.equals(option.getName())) continue;
                return option;
            }
            throw new IllegalArgumentException("Not found option " + name);
        }
    }

    public static enum OptionKind {
        Boolean,
        Integer,
        String;

    }
}

